/*
 * Iko.travel
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our platform.  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.platform-v`1`+json.  ## Release history - 2021-07-01: v1 - Initial release   # Booking Engine API Welcome to the Booking Engine API - A programmer-friendly way to search for bespoke travel inventory and create bookings for you or your customers. We take great care in only working with properties that have quality, curated content and ways to upsell and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive platform-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with iko.travel. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: v1.0.0
 * Contact: bjorn@iko.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.engine.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import travel.wink.sdk.booking.engine.model.RoomConfigurationPrice;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Best-priced room types
 */
@ApiModel(description = "Best-priced room types")
@JsonPropertyOrder({
  RoomTypeBestPrice.JSON_PROPERTY_ROOM_TYPE_IDENTIFIER,
  RoomTypeBestPrice.JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER,
  RoomTypeBestPrice.JSON_PROPERTY_PRICE,
  RoomTypeBestPrice.JSON_PROPERTY_PERK_VALUE,
  RoomTypeBestPrice.JSON_PROPERTY_AVAILABLE,
  RoomTypeBestPrice.JSON_PROPERTY_SORT
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-27T09:28:43.464694+07:00[Asia/Bangkok]")
public class RoomTypeBestPrice {
  public static final String JSON_PROPERTY_ROOM_TYPE_IDENTIFIER = "roomTypeIdentifier";
  private String roomTypeIdentifier;

  public static final String JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER = "channelInventoryIdentifier";
  private String channelInventoryIdentifier;

  public static final String JSON_PROPERTY_PRICE = "price";
  private RoomConfigurationPrice price;

  public static final String JSON_PROPERTY_PERK_VALUE = "perkValue";
  private Integer perkValue;

  public static final String JSON_PROPERTY_AVAILABLE = "available";
  private Boolean available;

  public static final String JSON_PROPERTY_SORT = "sort";
  private Integer sort;

  public RoomTypeBestPrice() { 
  }

  public RoomTypeBestPrice roomTypeIdentifier(String roomTypeIdentifier) {
    
    this.roomTypeIdentifier = roomTypeIdentifier;
    return this;
  }

   /**
   * Room type identifier.
   * @return roomTypeIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Room type identifier.")
  @JsonProperty(JSON_PROPERTY_ROOM_TYPE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRoomTypeIdentifier() {
    return roomTypeIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_TYPE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomTypeIdentifier(String roomTypeIdentifier) {
    this.roomTypeIdentifier = roomTypeIdentifier;
  }


  public RoomTypeBestPrice channelInventoryIdentifier(String channelInventoryIdentifier) {
    
    this.channelInventoryIdentifier = channelInventoryIdentifier;
    return this;
  }

   /**
   * Channel inventory identifier.
   * @return channelInventoryIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Channel inventory identifier.")
  @JsonProperty(JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getChannelInventoryIdentifier() {
    return channelInventoryIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChannelInventoryIdentifier(String channelInventoryIdentifier) {
    this.channelInventoryIdentifier = channelInventoryIdentifier;
  }


  public RoomTypeBestPrice price(RoomConfigurationPrice price) {
    
    this.price = price;
    return this;
  }

   /**
   * Get price
   * @return price
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RoomConfigurationPrice getPrice() {
    return price;
  }


  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrice(RoomConfigurationPrice price) {
    this.price = price;
  }


  public RoomTypeBestPrice perkValue(Integer perkValue) {
    
    this.perkValue = perkValue;
    return this;
  }

   /**
   * The sum of all perks the master rate had made available.
   * @return perkValue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The sum of all perks the master rate had made available.")
  @JsonProperty(JSON_PROPERTY_PERK_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPerkValue() {
    return perkValue;
  }


  @JsonProperty(JSON_PROPERTY_PERK_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPerkValue(Integer perkValue) {
    this.perkValue = perkValue;
  }


  public RoomTypeBestPrice available(Boolean available) {
    
    this.available = available;
    return this;
  }

   /**
   * Whether this room type is available with this configuration
   * @return available
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Whether this room type is available with this configuration")
  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAvailable() {
    return available;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailable(Boolean available) {
    this.available = available;
  }


  public RoomTypeBestPrice sort(Integer sort) {
    
    this.sort = sort;
    return this;
  }

   /**
   * When this room type is displayed in conjunction with many others, this sort property will often times be populated to indicate how the room types should be sorted and displayed.
   * @return sort
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "When this room type is displayed in conjunction with many others, this sort property will often times be populated to indicate how the room types should be sorted and displayed.")
  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSort(Integer sort) {
    this.sort = sort;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RoomTypeBestPrice roomTypeBestPrice = (RoomTypeBestPrice) o;
    return Objects.equals(this.roomTypeIdentifier, roomTypeBestPrice.roomTypeIdentifier) &&
        Objects.equals(this.channelInventoryIdentifier, roomTypeBestPrice.channelInventoryIdentifier) &&
        Objects.equals(this.price, roomTypeBestPrice.price) &&
        Objects.equals(this.perkValue, roomTypeBestPrice.perkValue) &&
        Objects.equals(this.available, roomTypeBestPrice.available) &&
        Objects.equals(this.sort, roomTypeBestPrice.sort);
  }

  @Override
  public int hashCode() {
    return Objects.hash(roomTypeIdentifier, channelInventoryIdentifier, price, perkValue, available, sort);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RoomTypeBestPrice {\n");
    sb.append("    roomTypeIdentifier: ").append(toIndentedString(roomTypeIdentifier)).append("\n");
    sb.append("    channelInventoryIdentifier: ").append(toIndentedString(channelInventoryIdentifier)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    perkValue: ").append(toIndentedString(perkValue)).append("\n");
    sb.append("    available: ").append(toIndentedString(available)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

