/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.booking.engine.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.booking.engine.model.AncillaryRequest;
import travel.wink.sdk.booking.engine.model.BookingUserRequest;
import travel.wink.sdk.booking.engine.model.RoomConfiguration;

@ApiModel(description="List of room configuration booking requests. Each entry is a separately booked room.")
@JsonPropertyOrder(value={"hotelIdentifier", "startDate", "endDate", "roomConfiguration", "promotionalCodes", "roomRateIdentifier", "bedType", "packageOffers", "addOnOffers", "ancillaries", "specialRequests", "user", "externalSupplierBookingCode", "externalTransactionIdentifier"})
public class AgentBookingRequest {
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
    private String hotelIdentifier;
    public static final String JSON_PROPERTY_START_DATE = "startDate";
    private LocalDate startDate;
    public static final String JSON_PROPERTY_END_DATE = "endDate";
    private LocalDate endDate;
    public static final String JSON_PROPERTY_ROOM_CONFIGURATION = "roomConfiguration";
    private RoomConfiguration roomConfiguration;
    public static final String JSON_PROPERTY_PROMOTIONAL_CODES = "promotionalCodes";
    private List<String> promotionalCodes = null;
    public static final String JSON_PROPERTY_ROOM_RATE_IDENTIFIER = "roomRateIdentifier";
    private String roomRateIdentifier;
    public static final String JSON_PROPERTY_BED_TYPE = "bedType";
    private String bedType;
    public static final String JSON_PROPERTY_PACKAGE_OFFERS = "packageOffers";
    private List<String> packageOffers = null;
    public static final String JSON_PROPERTY_ADD_ON_OFFERS = "addOnOffers";
    private List<String> addOnOffers = null;
    public static final String JSON_PROPERTY_ANCILLARIES = "ancillaries";
    private List<AncillaryRequest> ancillaries = null;
    public static final String JSON_PROPERTY_SPECIAL_REQUESTS = "specialRequests";
    private String specialRequests;
    public static final String JSON_PROPERTY_USER = "user";
    private BookingUserRequest user;
    public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE = "externalSupplierBookingCode";
    private String externalSupplierBookingCode;
    public static final String JSON_PROPERTY_EXTERNAL_TRANSACTION_IDENTIFIER = "externalTransactionIdentifier";
    private String externalTransactionIdentifier;

    public AgentBookingRequest hotelIdentifier(String hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="hotel-1", required=true, value="Unique hotel record identifier.")
    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getHotelIdentifier() {
        return this.hotelIdentifier;
    }

    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHotelIdentifier(String hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
    }

    public AgentBookingRequest startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(example="Sun Jan 31 07:00:00 ICT 2021", required=true, value="Date when guest arrives on the premises.")
    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public AgentBookingRequest endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(example="Sun Feb 07 07:00:00 ICT 2021", required=true, value="Date when guest departs the premises.")
    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public AgentBookingRequest roomConfiguration(RoomConfiguration roomConfiguration) {
        this.roomConfiguration = roomConfiguration;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="roomConfiguration")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public RoomConfiguration getRoomConfiguration() {
        return this.roomConfiguration;
    }

    @JsonProperty(value="roomConfiguration")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomConfiguration(RoomConfiguration roomConfiguration) {
        this.roomConfiguration = roomConfiguration;
    }

    public AgentBookingRequest promotionalCodes(List<String> promotionalCodes) {
        this.promotionalCodes = promotionalCodes;
        return this;
    }

    public AgentBookingRequest addPromotionalCodesItem(String promotionalCodesItem) {
        if (this.promotionalCodes == null) {
            this.promotionalCodes = new ArrayList<String>();
        }
        this.promotionalCodes.add(promotionalCodesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"promo-1\",\"promo-2\"]", value="List of promotional codes the user entered to to activate a promotion.")
    @JsonProperty(value="promotionalCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getPromotionalCodes() {
        return this.promotionalCodes;
    }

    @JsonProperty(value="promotionalCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPromotionalCodes(List<String> promotionalCodes) {
        this.promotionalCodes = promotionalCodes;
    }

    public AgentBookingRequest roomRateIdentifier(String roomRateIdentifier) {
        this.roomRateIdentifier = roomRateIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="master-rate-1", required=true, value="The unique master rate that made the guest room / rate plan available for sale.")
    @JsonProperty(value="roomRateIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRoomRateIdentifier() {
        return this.roomRateIdentifier;
    }

    @JsonProperty(value="roomRateIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomRateIdentifier(String roomRateIdentifier) {
        this.roomRateIdentifier = roomRateIdentifier;
    }

    public AgentBookingRequest bedType(String bedType) {
        this.bedType = bedType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="9", value="Guest can optionally request a specific bed type if the room type is set up with multiple bed type choices. Example: 9 is a `Single`. Taken from the `BED` OTA specification.")
    @JsonProperty(value="bedType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBedType() {
        return this.bedType;
    }

    @JsonProperty(value="bedType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBedType(String bedType) {
        this.bedType = bedType;
    }

    public AgentBookingRequest packageOffers(List<String> packageOffers) {
        this.packageOffers = packageOffers;
        return this;
    }

    public AgentBookingRequest addPackageOffersItem(String packageOffersItem) {
        if (this.packageOffers == null) {
            this.packageOffers = new ArrayList<String>();
        }
        this.packageOffers.add(packageOffersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"package-1\"]", value="Unique package identifiers guest wants added to her booking. Note: these add-ons must be available as part of the room type to be able to add them to a booking.")
    @JsonProperty(value="packageOffers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getPackageOffers() {
        return this.packageOffers;
    }

    @JsonProperty(value="packageOffers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPackageOffers(List<String> packageOffers) {
        this.packageOffers = packageOffers;
    }

    public AgentBookingRequest addOnOffers(List<String> addOnOffers) {
        this.addOnOffers = addOnOffers;
        return this;
    }

    public AgentBookingRequest addAddOnOffersItem(String addOnOffersItem) {
        if (this.addOnOffers == null) {
            this.addOnOffers = new ArrayList<String>();
        }
        this.addOnOffers.add(addOnOffersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"add-on-1\"]", value="Unique add-on identifiers guest wants added to her booking. Note: these add-ons must be available as part of the room type to be able to add them to a booking.")
    @JsonProperty(value="addOnOffers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getAddOnOffers() {
        return this.addOnOffers;
    }

    @JsonProperty(value="addOnOffers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddOnOffers(List<String> addOnOffers) {
        this.addOnOffers = addOnOffers;
    }

    public AgentBookingRequest ancillaries(List<AncillaryRequest> ancillaries) {
        this.ancillaries = ancillaries;
        return this;
    }

    public AgentBookingRequest addAncillariesItem(AncillaryRequest ancillariesItem) {
        if (this.ancillaries == null) {
            this.ancillaries = new ArrayList<AncillaryRequest>();
        }
        this.ancillaries.add(ancillariesItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Extra reservations of spas, meeting rooms etc that should accompany the room type booking.")
    @JsonProperty(value="ancillaries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AncillaryRequest> getAncillaries() {
        return this.ancillaries;
    }

    @JsonProperty(value="ancillaries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAncillaries(List<AncillaryRequest> ancillaries) {
        this.ancillaries = ancillaries;
    }

    public AgentBookingRequest specialRequests(String specialRequests) {
        this.specialRequests = specialRequests;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Can I please have rose petals on my pillows when I arrive?", value="A guest can send a special request to the hotel in free-text here.")
    @JsonProperty(value="specialRequests")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSpecialRequests() {
        return this.specialRequests;
    }

    @JsonProperty(value="specialRequests")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSpecialRequests(String specialRequests) {
        this.specialRequests = specialRequests;
    }

    public AgentBookingRequest user(BookingUserRequest user) {
        this.user = user;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BookingUserRequest getUser() {
        return this.user;
    }

    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUser(BookingUserRequest user) {
        this.user = user;
    }

    public AgentBookingRequest externalSupplierBookingCode(String externalSupplierBookingCode) {
        this.externalSupplierBookingCode = externalSupplierBookingCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="external-booking-code-1", value="External booking code generated by the affiliate")
    @JsonProperty(value="externalSupplierBookingCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalSupplierBookingCode() {
        return this.externalSupplierBookingCode;
    }

    @JsonProperty(value="externalSupplierBookingCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalSupplierBookingCode(String externalSupplierBookingCode) {
        this.externalSupplierBookingCode = externalSupplierBookingCode;
    }

    public AgentBookingRequest externalTransactionIdentifier(String externalTransactionIdentifier) {
        this.externalTransactionIdentifier = externalTransactionIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="external-transaction-1", value="External transaction identifier populated when agent responsible for acquiring")
    @JsonProperty(value="externalTransactionIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalTransactionIdentifier() {
        return this.externalTransactionIdentifier;
    }

    @JsonProperty(value="externalTransactionIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalTransactionIdentifier(String externalTransactionIdentifier) {
        this.externalTransactionIdentifier = externalTransactionIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgentBookingRequest agentBookingRequest = (AgentBookingRequest)o;
        return Objects.equals(this.hotelIdentifier, agentBookingRequest.hotelIdentifier) && Objects.equals(this.startDate, agentBookingRequest.startDate) && Objects.equals(this.endDate, agentBookingRequest.endDate) && Objects.equals(this.roomConfiguration, agentBookingRequest.roomConfiguration) && Objects.equals(this.promotionalCodes, agentBookingRequest.promotionalCodes) && Objects.equals(this.roomRateIdentifier, agentBookingRequest.roomRateIdentifier) && Objects.equals(this.bedType, agentBookingRequest.bedType) && Objects.equals(this.packageOffers, agentBookingRequest.packageOffers) && Objects.equals(this.addOnOffers, agentBookingRequest.addOnOffers) && Objects.equals(this.ancillaries, agentBookingRequest.ancillaries) && Objects.equals(this.specialRequests, agentBookingRequest.specialRequests) && Objects.equals(this.user, agentBookingRequest.user) && Objects.equals(this.externalSupplierBookingCode, agentBookingRequest.externalSupplierBookingCode) && Objects.equals(this.externalTransactionIdentifier, agentBookingRequest.externalTransactionIdentifier);
    }

    public int hashCode() {
        return Objects.hash(this.hotelIdentifier, this.startDate, this.endDate, this.roomConfiguration, this.promotionalCodes, this.roomRateIdentifier, this.bedType, this.packageOffers, this.addOnOffers, this.ancillaries, this.specialRequests, this.user, this.externalSupplierBookingCode, this.externalTransactionIdentifier);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AgentBookingRequest {\n");
        sb.append("    hotelIdentifier: ").append(this.toIndentedString(this.hotelIdentifier)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    roomConfiguration: ").append(this.toIndentedString(this.roomConfiguration)).append("\n");
        sb.append("    promotionalCodes: ").append(this.toIndentedString(this.promotionalCodes)).append("\n");
        sb.append("    roomRateIdentifier: ").append(this.toIndentedString(this.roomRateIdentifier)).append("\n");
        sb.append("    bedType: ").append(this.toIndentedString(this.bedType)).append("\n");
        sb.append("    packageOffers: ").append(this.toIndentedString(this.packageOffers)).append("\n");
        sb.append("    addOnOffers: ").append(this.toIndentedString(this.addOnOffers)).append("\n");
        sb.append("    ancillaries: ").append(this.toIndentedString(this.ancillaries)).append("\n");
        sb.append("    specialRequests: ").append(this.toIndentedString(this.specialRequests)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    externalSupplierBookingCode: ").append(this.toIndentedString(this.externalSupplierBookingCode)).append("\n");
        sb.append("    externalTransactionIdentifier: ").append(this.toIndentedString(this.externalTransactionIdentifier)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

