package travel.wink.sdk.booking.engine.api;

import travel.wink.sdk.booking.engine.invoker.ApiClient;

import travel.wink.sdk.booking.engine.model.GenericErrorMessage;
import travel.wink.sdk.booking.engine.model.KeyValuePair;
import travel.wink.sdk.booking.engine.model.Oauth2SearchByGeoLocation400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-28T12:37:03.813612+07:00[Asia/Bangkok]")
public class ReferenceApi {
    private ApiClient apiClient;

    public ReferenceApi() {
        this(new ApiClient());
    }

    @Autowired
    public ReferenceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Show OTA codes
     * Shows payment-supported OTA codes based on given category.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param category Requested OTA code
     * @param accept The accept parameter
     * @return List&lt;KeyValuePair&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAvailableCodesForCategoryRequestCreation(String category, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'category' is set
        if (category == null) {
            throw new WebClientResponseException("Missing the required parameter 'category' when calling showAvailableCodesForCategory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("category", category);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>() {};
        return apiClient.invokeAPI("/api/refdata/ota/{category}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show OTA codes
     * Shows payment-supported OTA codes based on given category.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param category Requested OTA code
     * @param accept The accept parameter
     * @return List&lt;KeyValuePair&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<KeyValuePair> showAvailableCodesForCategory(String category, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>() {};
        return showAvailableCodesForCategoryRequestCreation(category, accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePair>>> showAvailableCodesForCategoryWithHttpInfo(String category, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>() {};
        return showAvailableCodesForCategoryRequestCreation(category, accept).toEntityList(localVarReturnType);
    }
    /**
     * Show OTA category codes
     * Shows payment-supported OTA categories.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param accept The accept parameter
     * @return List&lt;KeyValuePair&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAvailableOtaCategoriesRequestCreation(String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>() {};
        return apiClient.invokeAPI("/api/refdata/ota/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show OTA category codes
     * Shows payment-supported OTA categories.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param accept The accept parameter
     * @return List&lt;KeyValuePair&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<KeyValuePair> showAvailableOtaCategories(String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>() {};
        return showAvailableOtaCategoriesRequestCreation(accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePair>>> showAvailableOtaCategoriesWithHttpInfo(String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>() {};
        return showAvailableOtaCategoriesRequestCreation(accept).toEntityList(localVarReturnType);
    }
    /**
     * Show Lifestyles
     * Retrieve list of all supported lifestyles indicated by an array of key / value pairs.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param accept The accept parameter
     * @return List&lt;KeyValuePair&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showLifestylesRequestCreation(String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>() {};
        return apiClient.invokeAPI("/api/refdata/lifestyle/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Lifestyles
     * Retrieve list of all supported lifestyles indicated by an array of key / value pairs.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param accept The accept parameter
     * @return List&lt;KeyValuePair&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<KeyValuePair> showLifestyles(String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>() {};
        return showLifestylesRequestCreation(accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePair>>> showLifestylesWithHttpInfo(String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>() {};
        return showLifestylesRequestCreation(accept).toEntityList(localVarReturnType);
    }
    /**
     * Show Perks
     * Retrieve list of perks
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param accept The accept parameter
     * @return List&lt;KeyValuePair&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPerksRequestCreation(String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>() {};
        return apiClient.invokeAPI("/api/refdata/perk/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Perks
     * Retrieve list of perks
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param accept The accept parameter
     * @return List&lt;KeyValuePair&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<KeyValuePair> showPerks(String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>() {};
        return showPerksRequestCreation(accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePair>>> showPerksWithHttpInfo(String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>() {};
        return showPerksRequestCreation(accept).toEntityList(localVarReturnType);
    }
    /**
     * Show Social Networks
     * Retrieve list of all supported social networks
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param accept The accept parameter
     * @return List&lt;KeyValuePair&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showSocialNetworksRequestCreation(String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>() {};
        return apiClient.invokeAPI("/api/refdata/social/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Social Networks
     * Retrieve list of all supported social networks
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param accept The accept parameter
     * @return List&lt;KeyValuePair&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<KeyValuePair> showSocialNetworks(String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>() {};
        return showSocialNetworksRequestCreation(accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePair>>> showSocialNetworksWithHttpInfo(String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>() {};
        return showSocialNetworksRequestCreation(accept).toEntityList(localVarReturnType);
    }
}
