/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our payment.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2021-07-01: v1 - Initial release   # Booking Engine API Welcome to the Booking Engine API - A programmer-friendly way to search for bespoke travel inventory and create bookings for you or your customers. We take great care in only working with properties that have quality, curated content and ways to upsell and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 19.0.14-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.engine.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.booking.engine.model.GuestRoom;
import travel.wink.sdk.booking.engine.model.HotelOnMap;
import travel.wink.sdk.booking.engine.model.Quote;
import travel.wink.sdk.booking.engine.model.RoomTypeBestPrice;
import travel.wink.sdk.booking.engine.model.RoomTypeWithBestPrice;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * HotelWithBestPrice
 */
@JsonPropertyOrder({
  HotelWithBestPrice.JSON_PROPERTY_HOTEL,
  HotelWithBestPrice.JSON_PROPERTY_PRICE,
  HotelWithBestPrice.JSON_PROPERTY_ROOM_TYPE_LIST,
  HotelWithBestPrice.JSON_PROPERTY_PRICE_LIST,
  HotelWithBestPrice.JSON_PROPERTY_POTENTIAL_CHANNEL_DISCOUNT_PERCENT,
  HotelWithBestPrice.JSON_PROPERTY_DISTANCE,
  HotelWithBestPrice.JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE,
  HotelWithBestPrice.JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE,
  HotelWithBestPrice.JSON_PROPERTY_AVAILABLE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-28T12:37:03.813612+07:00[Asia/Bangkok]")
public class HotelWithBestPrice {
  public static final String JSON_PROPERTY_HOTEL = "hotel";
  private HotelOnMap hotel;

  public static final String JSON_PROPERTY_PRICE = "price";
  private RoomTypeWithBestPrice price;

  public static final String JSON_PROPERTY_ROOM_TYPE_LIST = "roomTypeList";
  private List<GuestRoom> roomTypeList = null;

  public static final String JSON_PROPERTY_PRICE_LIST = "priceList";
  private List<RoomTypeBestPrice> priceList = null;

  public static final String JSON_PROPERTY_POTENTIAL_CHANNEL_DISCOUNT_PERCENT = "potentialChannelDiscountPercent";
  private Float potentialChannelDiscountPercent;

  public static final String JSON_PROPERTY_DISTANCE = "distance";
  private Double distance;

  public static final String JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE = "sourceToUserCurrencyQuote";
  private Quote sourceToUserCurrencyQuote;

  public static final String JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE = "sourceToInternalCurrencyQuote";
  private Quote sourceToInternalCurrencyQuote;

  public static final String JSON_PROPERTY_AVAILABLE = "available";
  private Boolean available;

  public HotelWithBestPrice() { 
  }

  public HotelWithBestPrice hotel(HotelOnMap hotel) {
    
    this.hotel = hotel;
    return this;
  }

   /**
   * Get hotel
   * @return hotel
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_HOTEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public HotelOnMap getHotel() {
    return hotel;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotel(HotelOnMap hotel) {
    this.hotel = hotel;
  }


  public HotelWithBestPrice price(RoomTypeWithBestPrice price) {
    
    this.price = price;
    return this;
  }

   /**
   * Get price
   * @return price
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RoomTypeWithBestPrice getPrice() {
    return price;
  }


  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrice(RoomTypeWithBestPrice price) {
    this.price = price;
  }


  public HotelWithBestPrice roomTypeList(List<GuestRoom> roomTypeList) {
    
    this.roomTypeList = roomTypeList;
    return this;
  }

  public HotelWithBestPrice addRoomTypeListItem(GuestRoom roomTypeListItem) {
    if (this.roomTypeList == null) {
      this.roomTypeList = new ArrayList<>();
    }
    this.roomTypeList.add(roomTypeListItem);
    return this;
  }

   /**
   * Unique property room types
   * @return roomTypeList
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Unique property room types")
  @JsonProperty(JSON_PROPERTY_ROOM_TYPE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<GuestRoom> getRoomTypeList() {
    return roomTypeList;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_TYPE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomTypeList(List<GuestRoom> roomTypeList) {
    this.roomTypeList = roomTypeList;
  }


  public HotelWithBestPrice priceList(List<RoomTypeBestPrice> priceList) {
    
    this.priceList = priceList;
    return this;
  }

  public HotelWithBestPrice addPriceListItem(RoomTypeBestPrice priceListItem) {
    if (this.priceList == null) {
      this.priceList = new ArrayList<>();
    }
    this.priceList.add(priceListItem);
    return this;
  }

   /**
   * Best-priced room types
   * @return priceList
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Best-priced room types")
  @JsonProperty(JSON_PROPERTY_PRICE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<RoomTypeBestPrice> getPriceList() {
    return priceList;
  }


  @JsonProperty(JSON_PROPERTY_PRICE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPriceList(List<RoomTypeBestPrice> priceList) {
    this.priceList = priceList;
  }


  public HotelWithBestPrice potentialChannelDiscountPercent(Float potentialChannelDiscountPercent) {
    
    this.potentialChannelDiscountPercent = potentialChannelDiscountPercent;
    return this;
  }

   /**
   * The potential discount the user is entitled to if user is a member / authenticated.
   * @return potentialChannelDiscountPercent
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The potential discount the user is entitled to if user is a member / authenticated.")
  @JsonProperty(JSON_PROPERTY_POTENTIAL_CHANNEL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getPotentialChannelDiscountPercent() {
    return potentialChannelDiscountPercent;
  }


  @JsonProperty(JSON_PROPERTY_POTENTIAL_CHANNEL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPotentialChannelDiscountPercent(Float potentialChannelDiscountPercent) {
    this.potentialChannelDiscountPercent = potentialChannelDiscountPercent;
  }


  public HotelWithBestPrice distance(Double distance) {
    
    this.distance = distance;
    return this;
  }

   /**
   * If property is within certain geo data result set, distance will be included here to signify the distance the property is from a specific geo-location.
   * @return distance
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "If property is within certain geo data result set, distance will be included here to signify the distance the property is from a specific geo-location.")
  @JsonProperty(JSON_PROPERTY_DISTANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getDistance() {
    return distance;
  }


  @JsonProperty(JSON_PROPERTY_DISTANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDistance(Double distance) {
    this.distance = distance;
  }


  public HotelWithBestPrice sourceToUserCurrencyQuote(Quote sourceToUserCurrencyQuote) {
    
    this.sourceToUserCurrencyQuote = sourceToUserCurrencyQuote;
    return this;
  }

   /**
   * Get sourceToUserCurrencyQuote
   * @return sourceToUserCurrencyQuote
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Quote getSourceToUserCurrencyQuote() {
    return sourceToUserCurrencyQuote;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceToUserCurrencyQuote(Quote sourceToUserCurrencyQuote) {
    this.sourceToUserCurrencyQuote = sourceToUserCurrencyQuote;
  }


  public HotelWithBestPrice sourceToInternalCurrencyQuote(Quote sourceToInternalCurrencyQuote) {
    
    this.sourceToInternalCurrencyQuote = sourceToInternalCurrencyQuote;
    return this;
  }

   /**
   * Get sourceToInternalCurrencyQuote
   * @return sourceToInternalCurrencyQuote
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Quote getSourceToInternalCurrencyQuote() {
    return sourceToInternalCurrencyQuote;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceToInternalCurrencyQuote(Quote sourceToInternalCurrencyQuote) {
    this.sourceToInternalCurrencyQuote = sourceToInternalCurrencyQuote;
  }


  public HotelWithBestPrice available(Boolean available) {
    
    this.available = available;
    return this;
  }

   /**
   * Flag to indicate whether this inventory is available or not. This data point is identifier to the available flag on the &#x60;price&#x60; child data point.
   * @return available
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Flag to indicate whether this inventory is available or not. This data point is identifier to the available flag on the `price` child data point.")
  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAvailable() {
    return available;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailable(Boolean available) {
    this.available = available;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HotelWithBestPrice hotelWithBestPrice = (HotelWithBestPrice) o;
    return Objects.equals(this.hotel, hotelWithBestPrice.hotel) &&
        Objects.equals(this.price, hotelWithBestPrice.price) &&
        Objects.equals(this.roomTypeList, hotelWithBestPrice.roomTypeList) &&
        Objects.equals(this.priceList, hotelWithBestPrice.priceList) &&
        Objects.equals(this.potentialChannelDiscountPercent, hotelWithBestPrice.potentialChannelDiscountPercent) &&
        Objects.equals(this.distance, hotelWithBestPrice.distance) &&
        Objects.equals(this.sourceToUserCurrencyQuote, hotelWithBestPrice.sourceToUserCurrencyQuote) &&
        Objects.equals(this.sourceToInternalCurrencyQuote, hotelWithBestPrice.sourceToInternalCurrencyQuote) &&
        Objects.equals(this.available, hotelWithBestPrice.available);
  }

  @Override
  public int hashCode() {
    return Objects.hash(hotel, price, roomTypeList, priceList, potentialChannelDiscountPercent, distance, sourceToUserCurrencyQuote, sourceToInternalCurrencyQuote, available);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HotelWithBestPrice {\n");
    sb.append("    hotel: ").append(toIndentedString(hotel)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    roomTypeList: ").append(toIndentedString(roomTypeList)).append("\n");
    sb.append("    priceList: ").append(toIndentedString(priceList)).append("\n");
    sb.append("    potentialChannelDiscountPercent: ").append(toIndentedString(potentialChannelDiscountPercent)).append("\n");
    sb.append("    distance: ").append(toIndentedString(distance)).append("\n");
    sb.append("    sourceToUserCurrencyQuote: ").append(toIndentedString(sourceToUserCurrencyQuote)).append("\n");
    sb.append("    sourceToInternalCurrencyQuote: ").append(toIndentedString(sourceToInternalCurrencyQuote)).append("\n");
    sb.append("    available: ").append(toIndentedString(available)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

