/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our payment.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2021-07-01: v1 - Initial release   # Booking Engine API Welcome to the Booking Engine API - A programmer-friendly way to search for bespoke travel inventory and create bookings for you or your customers. We take great care in only working with properties that have quality, curated content and ways to upsell and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 19.0.14-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.engine.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import travel.wink.sdk.booking.engine.model.ReviewAnswerOption;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * ReviewAnswer
 */
@JsonPropertyOrder({
  ReviewAnswer.JSON_PROPERTY_IDENTIFIER,
  ReviewAnswer.JSON_PROPERTY_QUESTION_IDENTIFIER,
  ReviewAnswer.JSON_PROPERTY_CATEGORY,
  ReviewAnswer.JSON_PROPERTY_SORT,
  ReviewAnswer.JSON_PROPERTY_ANSWER
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-28T12:37:03.813612+07:00[Asia/Bangkok]")
public class ReviewAnswer {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private String identifier;

  public static final String JSON_PROPERTY_QUESTION_IDENTIFIER = "questionIdentifier";
  private String questionIdentifier;

  /**
   * Question category
   */
  public enum CategoryEnum {
    COMFORT("COMFORT"),
    
    CONDITION("CONDITION"),
    
    SERVICE("SERVICE"),
    
    ENVIRONMENT("ENVIRONMENT"),
    
    FACILITIES("FACILITIES"),
    
    LOCATION("LOCATION"),
    
    LIFESTYLE("LIFESTYLE"),
    
    VALUE("VALUE"),
    
    FOOD("FOOD");

    private String value;

    CategoryEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CategoryEnum fromValue(String value) {
      for (CategoryEnum b : CategoryEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CATEGORY = "category";
  private CategoryEnum category;

  public static final String JSON_PROPERTY_SORT = "sort";
  private Integer sort;

  public static final String JSON_PROPERTY_ANSWER = "answer";
  private ReviewAnswerOption answer;

  public ReviewAnswer() { 
  }

  public ReviewAnswer identifier(String identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Answer identifier
   * @return identifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Answer identifier")
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifier(String identifier) {
    this.identifier = identifier;
  }


  public ReviewAnswer questionIdentifier(String questionIdentifier) {
    
    this.questionIdentifier = questionIdentifier;
    return this;
  }

   /**
   * Question identifier
   * @return questionIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Question identifier")
  @JsonProperty(JSON_PROPERTY_QUESTION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getQuestionIdentifier() {
    return questionIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_QUESTION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setQuestionIdentifier(String questionIdentifier) {
    this.questionIdentifier = questionIdentifier;
  }


  public ReviewAnswer category(CategoryEnum category) {
    
    this.category = category;
    return this;
  }

   /**
   * Question category
   * @return category
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Question category")
  @JsonProperty(JSON_PROPERTY_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CategoryEnum getCategory() {
    return category;
  }


  @JsonProperty(JSON_PROPERTY_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCategory(CategoryEnum category) {
    this.category = category;
  }


  public ReviewAnswer sort(Integer sort) {
    
    this.sort = sort;
    return this;
  }

   /**
   * Sort key
   * @return sort
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Sort key")
  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSort(Integer sort) {
    this.sort = sort;
  }


  public ReviewAnswer answer(ReviewAnswerOption answer) {
    
    this.answer = answer;
    return this;
  }

   /**
   * Get answer
   * @return answer
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ANSWER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ReviewAnswerOption getAnswer() {
    return answer;
  }


  @JsonProperty(JSON_PROPERTY_ANSWER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAnswer(ReviewAnswerOption answer) {
    this.answer = answer;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ReviewAnswer reviewAnswer = (ReviewAnswer) o;
    return Objects.equals(this.identifier, reviewAnswer.identifier) &&
        Objects.equals(this.questionIdentifier, reviewAnswer.questionIdentifier) &&
        Objects.equals(this.category, reviewAnswer.category) &&
        Objects.equals(this.sort, reviewAnswer.sort) &&
        Objects.equals(this.answer, reviewAnswer.answer);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, questionIdentifier, category, sort, answer);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ReviewAnswer {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    questionIdentifier: ").append(toIndentedString(questionIdentifier)).append("\n");
    sb.append("    category: ").append(toIndentedString(category)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    answer: ").append(toIndentedString(answer)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

