/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.booking.engine;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.reactive.function.client.WebClient;
import travel.wink.sdk.booking.engine.api.BookingApi;
import travel.wink.sdk.booking.engine.api.InventoryApi;
import travel.wink.sdk.booking.engine.api.LookupApi;
import travel.wink.sdk.booking.engine.api.ReferenceApi;
import travel.wink.sdk.booking.engine.invoker.ApiClient;

@Configuration
public class BookingEngineSDKConfiguration {
    private final WebClient webClient;

    @Bean
    public ApiClient apiClient() {
        return new ApiClient(this.webClient);
    }

    @Bean
    public InventoryApi inventoryApi() {
        return new InventoryApi(this.apiClient());
    }

    @Bean
    public BookingApi bookingApi() {
        return new BookingApi(this.apiClient());
    }

    @Bean
    public ReferenceApi referenceApi() {
        return new ReferenceApi(this.apiClient());
    }

    @Bean
    public LookupApi lookupApi() {
        return new LookupApi(this.apiClient());
    }

    public BookingEngineSDKConfiguration(WebClient webClient) {
        this.webClient = webClient;
    }
}

