/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our payment.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2021-07-01: v1 - Initial release   # Booking Engine API Welcome to the Booking Engine API - A programmer-friendly way to search for bespoke travel inventory and create bookings for you or your customers. We take great care in only working with properties that have quality, curated content and ways to upsell and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 19.0.14-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.engine.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Review answer
 */
@ApiModel(description = "Review answer")
@JsonPropertyOrder({
  ReviewAnswerOption.JSON_PROPERTY_KEY,
  ReviewAnswerOption.JSON_PROPERTY_SORT,
  ReviewAnswerOption.JSON_PROPERTY_POINTS,
  ReviewAnswerOption.JSON_PROPERTY_HASHTAGS,
  ReviewAnswerOption.JSON_PROPERTY_ICONS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-28T12:57:01.511487+07:00[Asia/Bangkok]")
public class ReviewAnswerOption {
  public static final String JSON_PROPERTY_KEY = "key";
  private String key;

  public static final String JSON_PROPERTY_SORT = "sort";
  private Integer sort;

  public static final String JSON_PROPERTY_POINTS = "points";
  private Integer points;

  public static final String JSON_PROPERTY_HASHTAGS = "hashtags";
  private List<String> hashtags = null;

  public static final String JSON_PROPERTY_ICONS = "icons";
  private List<String> icons = null;

  public ReviewAnswerOption() { 
  }

  public ReviewAnswerOption key(String key) {
    
    this.key = key;
    return this;
  }

   /**
   * Get key
   * @return key
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getKey() {
    return key;
  }


  @JsonProperty(JSON_PROPERTY_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setKey(String key) {
    this.key = key;
  }


  public ReviewAnswerOption sort(Integer sort) {
    
    this.sort = sort;
    return this;
  }

   /**
   * Sort key
   * @return sort
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Sort key")
  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSort(Integer sort) {
    this.sort = sort;
  }


  public ReviewAnswerOption points(Integer points) {
    
    this.points = points;
    return this;
  }

   /**
   * Value of answer
   * @return points
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Value of answer")
  @JsonProperty(JSON_PROPERTY_POINTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPoints() {
    return points;
  }


  @JsonProperty(JSON_PROPERTY_POINTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPoints(Integer points) {
    this.points = points;
  }


  public ReviewAnswerOption hashtags(List<String> hashtags) {
    
    this.hashtags = hashtags;
    return this;
  }

  public ReviewAnswerOption addHashtagsItem(String hashtagsItem) {
    if (this.hashtags == null) {
      this.hashtags = new ArrayList<>();
    }
    this.hashtags.add(hashtagsItem);
    return this;
  }

   /**
   * Get hashtags
   * @return hashtags
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_HASHTAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getHashtags() {
    return hashtags;
  }


  @JsonProperty(JSON_PROPERTY_HASHTAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHashtags(List<String> hashtags) {
    this.hashtags = hashtags;
  }


  public ReviewAnswerOption icons(List<String> icons) {
    
    this.icons = icons;
    return this;
  }

  public ReviewAnswerOption addIconsItem(String iconsItem) {
    if (this.icons == null) {
      this.icons = new ArrayList<>();
    }
    this.icons.add(iconsItem);
    return this;
  }

   /**
   * Get icons
   * @return icons
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ICONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getIcons() {
    return icons;
  }


  @JsonProperty(JSON_PROPERTY_ICONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIcons(List<String> icons) {
    this.icons = icons;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ReviewAnswerOption reviewAnswerOption = (ReviewAnswerOption) o;
    return Objects.equals(this.key, reviewAnswerOption.key) &&
        Objects.equals(this.sort, reviewAnswerOption.sort) &&
        Objects.equals(this.points, reviewAnswerOption.points) &&
        Objects.equals(this.hashtags, reviewAnswerOption.hashtags) &&
        Objects.equals(this.icons, reviewAnswerOption.icons);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, sort, points, hashtags, icons);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ReviewAnswerOption {\n");
    sb.append("    key: ").append(toIndentedString(key)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    points: ").append(toIndentedString(points)).append("\n");
    sb.append("    hashtags: ").append(toIndentedString(hashtags)).append("\n");
    sb.append("    icons: ").append(toIndentedString(icons)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

