/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.booking.engine.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.booking.engine.model.UserSession;

@JsonPropertyOrder(value={"identifier", "engineConfigurationIdentifier", "userSession"})
public class AggregateHotelRequest {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private String identifier;
    public static final String JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER = "engineConfigurationIdentifier";
    private String engineConfigurationIdentifier;
    public static final String JSON_PROPERTY_USER_SESSION = "userSession";
    private UserSession userSession;

    public AggregateHotelRequest identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="Record identifier")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public AggregateHotelRequest engineConfigurationIdentifier(String engineConfigurationIdentifier) {
        this.engineConfigurationIdentifier = engineConfigurationIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The configuration identifier that was used during this call.")
    @JsonProperty(value="engineConfigurationIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEngineConfigurationIdentifier() {
        return this.engineConfigurationIdentifier;
    }

    @JsonProperty(value="engineConfigurationIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEngineConfigurationIdentifier(String engineConfigurationIdentifier) {
        this.engineConfigurationIdentifier = engineConfigurationIdentifier;
    }

    public AggregateHotelRequest userSession(UserSession userSession) {
        this.userSession = userSession;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="userSession")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UserSession getUserSession() {
        return this.userSession;
    }

    @JsonProperty(value="userSession")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUserSession(UserSession userSession) {
        this.userSession = userSession;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregateHotelRequest aggregateHotelRequest = (AggregateHotelRequest)o;
        return Objects.equals(this.identifier, aggregateHotelRequest.identifier) && Objects.equals(this.engineConfigurationIdentifier, aggregateHotelRequest.engineConfigurationIdentifier) && Objects.equals(this.userSession, aggregateHotelRequest.userSession);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.engineConfigurationIdentifier, this.userSession);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AggregateHotelRequest {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    engineConfigurationIdentifier: ").append(this.toIndentedString(this.engineConfigurationIdentifier)).append("\n");
        sb.append("    userSession: ").append(this.toIndentedString(this.userSession)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

