/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.booking.engine.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;
import travel.wink.sdk.booking.engine.model.ReviewAnswer;
import travel.wink.sdk.booking.engine.model.ReviewUser;

@ApiModel(description="List of property reviews")
@JsonPropertyOrder(value={"identifier", "bookingIdentifier", "hotelIdentifier", "user", "reviewDate", "averageScore", "answers", "messageFromGuest", "responseFromHotel", "imageIdentifier", "text", "approvedText", "approvedImage", "likes", "roomNumber", "roomRating", "completed", "responded"})
public class Review {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private String identifier;
    public static final String JSON_PROPERTY_BOOKING_IDENTIFIER = "bookingIdentifier";
    private String bookingIdentifier;
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
    private String hotelIdentifier;
    public static final String JSON_PROPERTY_USER = "user";
    private ReviewUser user;
    public static final String JSON_PROPERTY_REVIEW_DATE = "reviewDate";
    private OffsetDateTime reviewDate;
    public static final String JSON_PROPERTY_AVERAGE_SCORE = "averageScore";
    private Double averageScore;
    public static final String JSON_PROPERTY_ANSWERS = "answers";
    private List<ReviewAnswer> answers = null;
    public static final String JSON_PROPERTY_MESSAGE_FROM_GUEST = "messageFromGuest";
    private String messageFromGuest;
    public static final String JSON_PROPERTY_RESPONSE_FROM_HOTEL = "responseFromHotel";
    private String responseFromHotel;
    public static final String JSON_PROPERTY_IMAGE_IDENTIFIER = "imageIdentifier";
    private String imageIdentifier;
    public static final String JSON_PROPERTY_TEXT = "text";
    private String text;
    public static final String JSON_PROPERTY_APPROVED_TEXT = "approvedText";
    private Boolean approvedText;
    public static final String JSON_PROPERTY_APPROVED_IMAGE = "approvedImage";
    private Boolean approvedImage;
    public static final String JSON_PROPERTY_LIKES = "likes";
    private List<String> likes = null;
    public static final String JSON_PROPERTY_ROOM_NUMBER = "roomNumber";
    private String roomNumber;
    public static final String JSON_PROPERTY_ROOM_RATING = "roomRating";
    private Integer roomRating;
    public static final String JSON_PROPERTY_COMPLETED = "completed";
    private Boolean completed;
    public static final String JSON_PROPERTY_RESPONDED = "responded";
    private Boolean responded;

    public Review identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="review-1", value="Unique review identifier identifying this record.")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public Review bookingIdentifier(String bookingIdentifier) {
        this.bookingIdentifier = bookingIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="booking-1", value="Booking identifier identifier booking this review is associated with.")
    @JsonProperty(value="bookingIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBookingIdentifier() {
        return this.bookingIdentifier;
    }

    @JsonProperty(value="bookingIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBookingIdentifier(String bookingIdentifier) {
        this.bookingIdentifier = bookingIdentifier;
    }

    public Review hotelIdentifier(String hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="hotel-1", value="Hotel identifier this booking is associated with.")
    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHotelIdentifier() {
        return this.hotelIdentifier;
    }

    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHotelIdentifier(String hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
    }

    public Review user(ReviewUser user) {
        this.user = user;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ReviewUser getUser() {
        return this.user;
    }

    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUser(ReviewUser user) {
        this.user = user;
    }

    public Review reviewDate(OffsetDateTime reviewDate) {
        this.reviewDate = reviewDate;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Date of review.")
    @JsonProperty(value="reviewDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getReviewDate() {
        return this.reviewDate;
    }

    @JsonProperty(value="reviewDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReviewDate(OffsetDateTime reviewDate) {
        this.reviewDate = reviewDate;
    }

    public Review averageScore(Double averageScore) {
        this.averageScore = averageScore;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="8.7", value="Total points divided by number of questions.")
    @JsonProperty(value="averageScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getAverageScore() {
        return this.averageScore;
    }

    @JsonProperty(value="averageScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAverageScore(Double averageScore) {
        this.averageScore = averageScore;
    }

    public Review answers(List<ReviewAnswer> answers) {
        this.answers = answers;
        return this;
    }

    public Review addAnswersItem(ReviewAnswer answersItem) {
        if (this.answers == null) {
            this.answers = new ArrayList<ReviewAnswer>();
        }
        this.answers.add(answersItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="List of user review answers.")
    @JsonProperty(value="answers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ReviewAnswer> getAnswers() {
        return this.answers;
    }

    @JsonProperty(value="answers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAnswers(List<ReviewAnswer> answers) {
        this.answers = answers;
    }

    public Review messageFromGuest(String messageFromGuest) {
        this.messageFromGuest = messageFromGuest;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Dear GM, I would like to say thank you so much for taking the time to show my husband and I around the premises and the secret cave behind the property.", value="Private message from guest to the hotel. Is not displayed on property profile.")
    @JsonProperty(value="messageFromGuest")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessageFromGuest() {
        return this.messageFromGuest;
    }

    @JsonProperty(value="messageFromGuest")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMessageFromGuest(String messageFromGuest) {
        this.messageFromGuest = messageFromGuest;
    }

    public Review responseFromHotel(String responseFromHotel) {
        this.responseFromHotel = responseFromHotel;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="It was so great to have you at our hotel. Please recommend your friends and come again soon.", value="Property can response to traveler review. Response goes on public review profile and can be seen by others.")
    @JsonProperty(value="responseFromHotel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getResponseFromHotel() {
        return this.responseFromHotel;
    }

    @JsonProperty(value="responseFromHotel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResponseFromHotel(String responseFromHotel) {
        this.responseFromHotel = responseFromHotel;
    }

    public Review imageIdentifier(String imageIdentifier) {
        this.imageIdentifier = imageIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="cloudinary-image-1", value="Reviewer can upload her best picture from the property. Cloudinary image identifier.")
    @JsonProperty(value="imageIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getImageIdentifier() {
        return this.imageIdentifier;
    }

    @JsonProperty(value="imageIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setImageIdentifier(String imageIdentifier) {
        this.imageIdentifier = imageIdentifier;
    }

    public Review text(String text) {
        this.text = text;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Our stay was amazing! Can recommend highly to all. Felt like home.", value="Free text record created by traveler")
    @JsonProperty(value="text")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getText() {
        return this.text;
    }

    @JsonProperty(value="text")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setText(String text) {
        this.text = text;
    }

    public Review approvedText(Boolean approvedText) {
        this.approvedText = approvedText;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Hotel allows the review text to be displayed as part of their profile.")
    @JsonProperty(value="approvedText")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getApprovedText() {
        return this.approvedText;
    }

    @JsonProperty(value="approvedText")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApprovedText(Boolean approvedText) {
        this.approvedText = approvedText;
    }

    public Review approvedImage(Boolean approvedImage) {
        this.approvedImage = approvedImage;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Hotel allows the user-generated image to be displayed as part of their profile.")
    @JsonProperty(value="approvedImage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getApprovedImage() {
        return this.approvedImage;
    }

    @JsonProperty(value="approvedImage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApprovedImage(Boolean approvedImage) {
        this.approvedImage = approvedImage;
    }

    public Review likes(List<String> likes) {
        this.likes = likes;
        return this;
    }

    public Review addLikesItem(String likesItem) {
        if (this.likes == null) {
            this.likes = new ArrayList<String>();
        }
        this.likes.add(likesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="user-1,user-2", value="List of member identifiers who liked the textual review")
    @JsonProperty(value="likes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getLikes() {
        return this.likes;
    }

    @JsonProperty(value="likes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLikes(List<String> likes) {
        this.likes = likes;
    }

    public Review roomNumber(String roomNumber) {
        this.roomNumber = roomNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="501", value="Guest's room number during their stay.")
    @JsonProperty(value="roomNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRoomNumber() {
        return this.roomNumber;
    }

    @JsonProperty(value="roomNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoomNumber(String roomNumber) {
        this.roomNumber = roomNumber;
    }

    public Review roomRating(Integer roomRating) {
        this.roomRating = roomRating;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="7", value="Guest's room rating")
    @JsonProperty(value="roomRating")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getRoomRating() {
        return this.roomRating;
    }

    @JsonProperty(value="roomRating")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoomRating(Integer roomRating) {
        this.roomRating = roomRating;
    }

    public Review completed(Boolean completed) {
        this.completed = completed;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="When the guest has completed the first and second part of the review.")
    @JsonProperty(value="completed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCompleted() {
        return this.completed;
    }

    @JsonProperty(value="completed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCompleted(Boolean completed) {
        this.completed = completed;
    }

    public Review responded(Boolean responded) {
        this.responded = responded;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Returns true if property has responded to the review given gy the guest.")
    @JsonProperty(value="responded")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getResponded() {
        return this.responded;
    }

    @JsonProperty(value="responded")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResponded(Boolean responded) {
        this.responded = responded;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Review review = (Review)o;
        return Objects.equals(this.identifier, review.identifier) && Objects.equals(this.bookingIdentifier, review.bookingIdentifier) && Objects.equals(this.hotelIdentifier, review.hotelIdentifier) && Objects.equals(this.user, review.user) && Objects.equals(this.reviewDate, review.reviewDate) && Objects.equals(this.averageScore, review.averageScore) && Objects.equals(this.answers, review.answers) && Objects.equals(this.messageFromGuest, review.messageFromGuest) && Objects.equals(this.responseFromHotel, review.responseFromHotel) && Objects.equals(this.imageIdentifier, review.imageIdentifier) && Objects.equals(this.text, review.text) && Objects.equals(this.approvedText, review.approvedText) && Objects.equals(this.approvedImage, review.approvedImage) && Objects.equals(this.likes, review.likes) && Objects.equals(this.roomNumber, review.roomNumber) && Objects.equals(this.roomRating, review.roomRating) && Objects.equals(this.completed, review.completed) && Objects.equals(this.responded, review.responded);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.bookingIdentifier, this.hotelIdentifier, this.user, this.reviewDate, this.averageScore, this.answers, this.messageFromGuest, this.responseFromHotel, this.imageIdentifier, this.text, this.approvedText, this.approvedImage, this.likes, this.roomNumber, this.roomRating, this.completed, this.responded);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Review {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    bookingIdentifier: ").append(this.toIndentedString(this.bookingIdentifier)).append("\n");
        sb.append("    hotelIdentifier: ").append(this.toIndentedString(this.hotelIdentifier)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    reviewDate: ").append(this.toIndentedString(this.reviewDate)).append("\n");
        sb.append("    averageScore: ").append(this.toIndentedString(this.averageScore)).append("\n");
        sb.append("    answers: ").append(this.toIndentedString(this.answers)).append("\n");
        sb.append("    messageFromGuest: ").append(this.toIndentedString(this.messageFromGuest)).append("\n");
        sb.append("    responseFromHotel: ").append(this.toIndentedString(this.responseFromHotel)).append("\n");
        sb.append("    imageIdentifier: ").append(this.toIndentedString(this.imageIdentifier)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    approvedText: ").append(this.toIndentedString(this.approvedText)).append("\n");
        sb.append("    approvedImage: ").append(this.toIndentedString(this.approvedImage)).append("\n");
        sb.append("    likes: ").append(this.toIndentedString(this.likes)).append("\n");
        sb.append("    roomNumber: ").append(this.toIndentedString(this.roomNumber)).append("\n");
        sb.append("    roomRating: ").append(this.toIndentedString(this.roomRating)).append("\n");
        sb.append("    completed: ").append(this.toIndentedString(this.completed)).append("\n");
        sb.append("    responded: ").append(this.toIndentedString(this.responded)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

