/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our payment.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Booking Engine API Welcome to the Booking Engine API - A programmer-friendly way to search for bespoke travel inventory and create bookings for you or your customers. We take great care in only working with properties that have quality, curated content and ways to upsell and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 20.0.1-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.engine.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.booking.engine.model.AgentBookingRequest;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * CreateAgentBookingRequest
 */
@JsonPropertyOrder({
  CreateAgentBookingRequest.JSON_PROPERTY_ROOMS,
  CreateAgentBookingRequest.JSON_PROPERTY_DISPLAY_CURRENCY,
  CreateAgentBookingRequest.JSON_PROPERTY_DISPLAY_LANGUAGE,
  CreateAgentBookingRequest.JSON_PROPERTY_SOURCE_URL,
  CreateAgentBookingRequest.JSON_PROPERTY_TRACE_ID
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-06-03T12:25:10.444723+07:00[Asia/Bangkok]")
public class CreateAgentBookingRequest {
  public static final String JSON_PROPERTY_ROOMS = "rooms";
  private List<AgentBookingRequest> rooms = new ArrayList<>();

  public static final String JSON_PROPERTY_DISPLAY_CURRENCY = "displayCurrency";
  private String displayCurrency = "USD";

  public static final String JSON_PROPERTY_DISPLAY_LANGUAGE = "displayLanguage";
  private String displayLanguage = "en";

  public static final String JSON_PROPERTY_SOURCE_URL = "sourceUrl";
  private String sourceUrl;

  public static final String JSON_PROPERTY_TRACE_ID = "traceId";
  private String traceId;

  public CreateAgentBookingRequest() { 
  }

  public CreateAgentBookingRequest rooms(List<AgentBookingRequest> rooms) {
    
    this.rooms = rooms;
    return this;
  }

  public CreateAgentBookingRequest addRoomsItem(AgentBookingRequest roomsItem) {
    this.rooms.add(roomsItem);
    return this;
  }

   /**
   * List of room configuration booking requests. Each entry is a separately booked room.
   * @return rooms
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "List of room configuration booking requests. Each entry is a separately booked room.")
  @JsonProperty(JSON_PROPERTY_ROOMS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<AgentBookingRequest> getRooms() {
    return rooms;
  }


  @JsonProperty(JSON_PROPERTY_ROOMS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRooms(List<AgentBookingRequest> rooms) {
    this.rooms = rooms;
  }


  public CreateAgentBookingRequest displayCurrency(String displayCurrency) {
    
    this.displayCurrency = displayCurrency;
    return this;
  }

   /**
   * The desired currency
   * @return displayCurrency
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "USD", required = true, value = "The desired currency")
  @JsonProperty(JSON_PROPERTY_DISPLAY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDisplayCurrency() {
    return displayCurrency;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisplayCurrency(String displayCurrency) {
    this.displayCurrency = displayCurrency;
  }


  public CreateAgentBookingRequest displayLanguage(String displayLanguage) {
    
    this.displayLanguage = displayLanguage;
    return this;
  }

   /**
   * The desired language
   * @return displayLanguage
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "en", required = true, value = "The desired language")
  @JsonProperty(JSON_PROPERTY_DISPLAY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDisplayLanguage() {
    return displayLanguage;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisplayLanguage(String displayLanguage) {
    this.displayLanguage = displayLanguage;
  }


  public CreateAgentBookingRequest sourceUrl(String sourceUrl) {
    
    this.sourceUrl = sourceUrl;
    return this;
  }

   /**
   * Where did the booking occur
   * @return sourceUrl
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "https://www.traveliko.com", required = true, value = "Where did the booking occur")
  @JsonProperty(JSON_PROPERTY_SOURCE_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSourceUrl() {
    return sourceUrl;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceUrl(String sourceUrl) {
    this.sourceUrl = sourceUrl;
  }


  public CreateAgentBookingRequest traceId(String traceId) {
    
    this.traceId = traceId;
    return this;
  }

   /**
   * Integrator can choose to include a unique identifier to help identify the collection of bookings
   * @return traceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "integrator-booking-code-1", value = "Integrator can choose to include a unique identifier to help identify the collection of bookings")
  @JsonProperty(JSON_PROPERTY_TRACE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTraceId() {
    return traceId;
  }


  @JsonProperty(JSON_PROPERTY_TRACE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTraceId(String traceId) {
    this.traceId = traceId;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateAgentBookingRequest createAgentBookingRequest = (CreateAgentBookingRequest) o;
    return Objects.equals(this.rooms, createAgentBookingRequest.rooms) &&
        Objects.equals(this.displayCurrency, createAgentBookingRequest.displayCurrency) &&
        Objects.equals(this.displayLanguage, createAgentBookingRequest.displayLanguage) &&
        Objects.equals(this.sourceUrl, createAgentBookingRequest.sourceUrl) &&
        Objects.equals(this.traceId, createAgentBookingRequest.traceId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(rooms, displayCurrency, displayLanguage, sourceUrl, traceId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateAgentBookingRequest {\n");
    sb.append("    rooms: ").append(toIndentedString(rooms)).append("\n");
    sb.append("    displayCurrency: ").append(toIndentedString(displayCurrency)).append("\n");
    sb.append("    displayLanguage: ").append(toIndentedString(displayLanguage)).append("\n");
    sb.append("    sourceUrl: ").append(toIndentedString(sourceUrl)).append("\n");
    sb.append("    traceId: ").append(toIndentedString(traceId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

