/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our payment.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Booking Engine API Welcome to the Booking Engine API - A programmer-friendly way to search for bespoke travel inventory and create bookings for you or your customers. We take great care in only working with properties that have quality, curated content and ways to upsell and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 20.0.1-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.engine.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.booking.engine.model.SimpleDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Identifier inventory record
 */
@ApiModel(description = "Identifier inventory record")
@JsonPropertyOrder({
  SellerInventoryList.JSON_PROPERTY_IDENTIFIER,
  SellerInventoryList.JSON_PROPERTY_SELLER_IDENTIFIER,
  SellerInventoryList.JSON_PROPERTY_SELLER_INVENTORY_LIST_NAME,
  SellerInventoryList.JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER,
  SellerInventoryList.JSON_PROPERTY_DESCRIPTIONS,
  SellerInventoryList.JSON_PROPERTY_KEYWORDS,
  SellerInventoryList.JSON_PROPERTY_STATUS,
  SellerInventoryList.JSON_PROPERTY_LIST_TYPE,
  SellerInventoryList.JSON_PROPERTY_LIST_IDENTIFIER,
  SellerInventoryList.JSON_PROPERTY_ANIMATE,
  SellerInventoryList.JSON_PROPERTY_ANIMATE_DELAY,
  SellerInventoryList.JSON_PROPERTY_SORT,
  SellerInventoryList.JSON_PROPERTY_DISPLAY_TYPE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-06-03T12:25:10.444723+07:00[Asia/Bangkok]")
public class SellerInventoryList {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private String identifier;

  public static final String JSON_PROPERTY_SELLER_IDENTIFIER = "sellerIdentifier";
  private String sellerIdentifier;

  public static final String JSON_PROPERTY_SELLER_INVENTORY_LIST_NAME = "sellerInventoryListName";
  private String sellerInventoryListName;

  public static final String JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER = "engineConfigurationIdentifier";
  private String engineConfigurationIdentifier;

  public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
  private List<SimpleDescription> descriptions = new ArrayList<>();

  public static final String JSON_PROPERTY_KEYWORDS = "keywords";
  private List<String> keywords = new ArrayList<>();

  /**
   * Status
   */
  public enum StatusEnum {
    ACTIVE("ACTIVE"),
    
    INACTIVE("INACTIVE"),
    
    REMOVED("REMOVED");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status = StatusEnum.ACTIVE;

  /**
   * List type
   */
  public enum ListTypeEnum {
    SINGLE("SINGLE"),
    
    LIST("LIST"),
    
    SEARCH("SEARCH");

    private String value;

    ListTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ListTypeEnum fromValue(String value) {
      for (ListTypeEnum b : ListTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_LIST_TYPE = "listType";
  private ListTypeEnum listType;

  public static final String JSON_PROPERTY_LIST_IDENTIFIER = "listIdentifier";
  private String listIdentifier;

  public static final String JSON_PROPERTY_ANIMATE = "animate";
  private Boolean animate = false;

  public static final String JSON_PROPERTY_ANIMATE_DELAY = "animateDelay";
  private Integer animateDelay = -1;

  /**
   * Determines which badge to show on the Web Component. Is also used to sort properties for search grids.
   */
  public enum SortEnum {
    MEMBER("MEMBER"),
    
    PRICE_LOW_TO_HIGH("PRICE_LOW_TO_HIGH"),
    
    PRICE_HIGH_TO_LOW("PRICE_HIGH_TO_LOW"),
    
    PRICE("PRICE"),
    
    POPULARITY("POPULARITY"),
    
    ECO("ECO"),
    
    EXPERIENCE("EXPERIENCE"),
    
    PERK("PERK"),
    
    LOYALTY("LOYALTY"),
    
    PACKAGE("PACKAGE");

    private String value;

    SortEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SortEnum fromValue(String value) {
      for (SortEnum b : SortEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SORT = "sort";
  private SortEnum sort;

  /**
   * Indicate which initial values to display first on the front-facing card
   */
  public enum DisplayTypeEnum {
    NATIVE("NATIVE"),
    
    HOTEL("HOTEL"),
    
    ROOM("ROOM");

    private String value;

    DisplayTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DisplayTypeEnum fromValue(String value) {
      for (DisplayTypeEnum b : DisplayTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_DISPLAY_TYPE = "displayType";
  private DisplayTypeEnum displayType = DisplayTypeEnum.NATIVE;

  public SellerInventoryList() { 
  }

  public SellerInventoryList identifier(String identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique identifier
   * @return identifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "grid-1", value = "Unique identifier")
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifier(String identifier) {
    this.identifier = identifier;
  }


  public SellerInventoryList sellerIdentifier(String sellerIdentifier) {
    
    this.sellerIdentifier = sellerIdentifier;
    return this;
  }

   /**
   * Company identifier
   * @return sellerIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "company-1", value = "Company identifier")
  @JsonProperty(JSON_PROPERTY_SELLER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSellerIdentifier() {
    return sellerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_SELLER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSellerIdentifier(String sellerIdentifier) {
    this.sellerIdentifier = sellerIdentifier;
  }


  public SellerInventoryList sellerInventoryListName(String sellerInventoryListName) {
    
    this.sellerInventoryListName = sellerInventoryListName;
    return this;
  }

   /**
   * Descriptive name of this list for seller use only
   * @return sellerInventoryListName
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "My list", required = true, value = "Descriptive name of this list for seller use only")
  @JsonProperty(JSON_PROPERTY_SELLER_INVENTORY_LIST_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSellerInventoryListName() {
    return sellerInventoryListName;
  }


  @JsonProperty(JSON_PROPERTY_SELLER_INVENTORY_LIST_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSellerInventoryListName(String sellerInventoryListName) {
    this.sellerInventoryListName = sellerInventoryListName;
  }


  public SellerInventoryList engineConfigurationIdentifier(String engineConfigurationIdentifier) {
    
    this.engineConfigurationIdentifier = engineConfigurationIdentifier;
    return this;
  }

   /**
   * Customization identifier
   * @return engineConfigurationIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "customization-1", required = true, value = "Customization identifier")
  @JsonProperty(JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getEngineConfigurationIdentifier() {
    return engineConfigurationIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEngineConfigurationIdentifier(String engineConfigurationIdentifier) {
    this.engineConfigurationIdentifier = engineConfigurationIdentifier;
  }


  public SellerInventoryList descriptions(List<SimpleDescription> descriptions) {
    
    this.descriptions = descriptions;
    return this;
  }

  public SellerInventoryList addDescriptionsItem(SimpleDescription descriptionsItem) {
    this.descriptions.add(descriptionsItem);
    return this;
  }

   /**
   * Contains custom title and description of grid
   * @return descriptions
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1,max=2147483647)  @ApiModelProperty(required = true, value = "Contains custom title and description of grid")
  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<SimpleDescription> getDescriptions() {
    return descriptions;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescriptions(List<SimpleDescription> descriptions) {
    this.descriptions = descriptions;
  }


  public SellerInventoryList keywords(List<String> keywords) {
    
    this.keywords = keywords;
    return this;
  }

  public SellerInventoryList addKeywordsItem(String keywordsItem) {
    this.keywords.add(keywordsItem);
    return this;
  }

   /**
   * Keywords is meta data for the grid you created that can be used for SEO purposes.
   * @return keywords
  **/
  @javax.annotation.Nonnull
  @NotNull
 @Size(min=1,max=2147483647)  @ApiModelProperty(example = "[\"bali\"]", required = true, value = "Keywords is meta data for the grid you created that can be used for SEO purposes.")
  @JsonProperty(JSON_PROPERTY_KEYWORDS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getKeywords() {
    return keywords;
  }


  @JsonProperty(JSON_PROPERTY_KEYWORDS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setKeywords(List<String> keywords) {
    this.keywords = keywords;
  }


  public SellerInventoryList status(StatusEnum status) {
    
    this.status = status;
    return this;
  }

   /**
   * Status
   * @return status
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "ACTIVE", required = true, value = "Status")
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public StatusEnum getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  public SellerInventoryList listType(ListTypeEnum listType) {
    
    this.listType = listType;
    return this;
  }

   /**
   * List type
   * @return listType
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "LIST", required = true, value = "List type")
  @JsonProperty(JSON_PROPERTY_LIST_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ListTypeEnum getListType() {
    return listType;
  }


  @JsonProperty(JSON_PROPERTY_LIST_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setListType(ListTypeEnum listType) {
    this.listType = listType;
  }


  public SellerInventoryList listIdentifier(String listIdentifier) {
    
    this.listIdentifier = listIdentifier;
    return this;
  }

   /**
   * Depending on the &#x60;listType&#x60;, this is either the list / search / channel inventory identifier.
   * @return listIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(required = true, value = "Depending on the `listType`, this is either the list / search / channel inventory identifier.")
  @JsonProperty(JSON_PROPERTY_LIST_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getListIdentifier() {
    return listIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_LIST_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setListIdentifier(String listIdentifier) {
    this.listIdentifier = listIdentifier;
  }


  public SellerInventoryList animate(Boolean animate) {
    
    this.animate = animate;
    return this;
  }

   /**
   * Create an animated gif instead of a list of images
   * @return animate
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Create an animated gif instead of a list of images")
  @JsonProperty(JSON_PROPERTY_ANIMATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAnimate() {
    return animate;
  }


  @JsonProperty(JSON_PROPERTY_ANIMATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAnimate(Boolean animate) {
    this.animate = animate;
  }


  public SellerInventoryList animateDelay(Integer animateDelay) {
    
    this.animateDelay = animateDelay;
    return this;
  }

   /**
   * Controls animation delay in milliseconds. -1 is disabled
   * @return animateDelay
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Controls animation delay in milliseconds. -1 is disabled")
  @JsonProperty(JSON_PROPERTY_ANIMATE_DELAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAnimateDelay() {
    return animateDelay;
  }


  @JsonProperty(JSON_PROPERTY_ANIMATE_DELAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAnimateDelay(Integer animateDelay) {
    this.animateDelay = animateDelay;
  }


  public SellerInventoryList sort(SortEnum sort) {
    
    this.sort = sort;
    return this;
  }

   /**
   * Determines which badge to show on the Web Component. Is also used to sort properties for search grids.
   * @return sort
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "MEMBER", value = "Determines which badge to show on the Web Component. Is also used to sort properties for search grids.")
  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SortEnum getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSort(SortEnum sort) {
    this.sort = sort;
  }


  public SellerInventoryList displayType(DisplayTypeEnum displayType) {
    
    this.displayType = displayType;
    return this;
  }

   /**
   * Indicate which initial values to display first on the front-facing card
   * @return displayType
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "NATIVE", required = true, value = "Indicate which initial values to display first on the front-facing card")
  @JsonProperty(JSON_PROPERTY_DISPLAY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public DisplayTypeEnum getDisplayType() {
    return displayType;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisplayType(DisplayTypeEnum displayType) {
    this.displayType = displayType;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SellerInventoryList sellerInventoryList = (SellerInventoryList) o;
    return Objects.equals(this.identifier, sellerInventoryList.identifier) &&
        Objects.equals(this.sellerIdentifier, sellerInventoryList.sellerIdentifier) &&
        Objects.equals(this.sellerInventoryListName, sellerInventoryList.sellerInventoryListName) &&
        Objects.equals(this.engineConfigurationIdentifier, sellerInventoryList.engineConfigurationIdentifier) &&
        Objects.equals(this.descriptions, sellerInventoryList.descriptions) &&
        Objects.equals(this.keywords, sellerInventoryList.keywords) &&
        Objects.equals(this.status, sellerInventoryList.status) &&
        Objects.equals(this.listType, sellerInventoryList.listType) &&
        Objects.equals(this.listIdentifier, sellerInventoryList.listIdentifier) &&
        Objects.equals(this.animate, sellerInventoryList.animate) &&
        Objects.equals(this.animateDelay, sellerInventoryList.animateDelay) &&
        Objects.equals(this.sort, sellerInventoryList.sort) &&
        Objects.equals(this.displayType, sellerInventoryList.displayType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, sellerIdentifier, sellerInventoryListName, engineConfigurationIdentifier, descriptions, keywords, status, listType, listIdentifier, animate, animateDelay, sort, displayType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SellerInventoryList {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    sellerIdentifier: ").append(toIndentedString(sellerIdentifier)).append("\n");
    sb.append("    sellerInventoryListName: ").append(toIndentedString(sellerInventoryListName)).append("\n");
    sb.append("    engineConfigurationIdentifier: ").append(toIndentedString(engineConfigurationIdentifier)).append("\n");
    sb.append("    descriptions: ").append(toIndentedString(descriptions)).append("\n");
    sb.append("    keywords: ").append(toIndentedString(keywords)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    listType: ").append(toIndentedString(listType)).append("\n");
    sb.append("    listIdentifier: ").append(toIndentedString(listIdentifier)).append("\n");
    sb.append("    animate: ").append(toIndentedString(animate)).append("\n");
    sb.append("    animateDelay: ").append(toIndentedString(animateDelay)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    displayType: ").append(toIndentedString(displayType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

