/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.booking.engine.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.booking.engine.model.AddressDto;
import travel.wink.sdk.booking.engine.model.ContactDto;
import travel.wink.sdk.booking.engine.model.DowPatternGroup;
import travel.wink.sdk.booking.engine.model.GeoJsonPoint;
import travel.wink.sdk.booking.engine.model.GeoName;
import travel.wink.sdk.booking.engine.model.Moneys;
import travel.wink.sdk.booking.engine.model.Multimedia;
import travel.wink.sdk.booking.engine.model.SimpleDescription;
import travel.wink.sdk.booking.engine.model.Social;

@ApiModel(description="Inventory data object")
@JsonPropertyOrder(value={"identifier", "hotelIdentifier", "featuredInd", "lifestyleType", "location", "descriptions", "multimedias", "geoNameId", "city", "commissionable", "name", "proximityCode", "sort", "minAgeAppropriateCode", "bookable", "active", "disabilityFeatures", "securityFeatures", "applicableStart", "applicableEnd", "reservationRequiredInd", "opens", "closes", "fee", "percentDiscount", "contact", "address", "daysOfWeek", "socials", "irregular", "meetingRoomCapacity", "access", "meetingRoomTypeCode", "meetingRoomLevel", "dedicatedInd", "area", "height", "width", "length", "amenities", "pricingType"})
public class MeetingRoom {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private String identifier;
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
    private String hotelIdentifier;
    public static final String JSON_PROPERTY_FEATURED_IND = "featuredInd";
    private Boolean featuredInd;
    public static final String JSON_PROPERTY_LIFESTYLE_TYPE = "lifestyleType";
    private LifestyleTypeEnum lifestyleType;
    public static final String JSON_PROPERTY_LOCATION = "location";
    private GeoJsonPoint location;
    public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
    private List<SimpleDescription> descriptions = new ArrayList<SimpleDescription>();
    public static final String JSON_PROPERTY_MULTIMEDIAS = "multimedias";
    private List<Multimedia> multimedias = new ArrayList<Multimedia>();
    public static final String JSON_PROPERTY_GEO_NAME_ID = "geoNameId";
    private String geoNameId;
    public static final String JSON_PROPERTY_CITY = "city";
    private GeoName city;
    public static final String JSON_PROPERTY_COMMISSIONABLE = "commissionable";
    private Boolean commissionable = true;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PROXIMITY_CODE = "proximityCode";
    private String proximityCode;
    public static final String JSON_PROPERTY_SORT = "sort";
    private Integer sort;
    public static final String JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE = "minAgeAppropriateCode";
    private String minAgeAppropriateCode;
    public static final String JSON_PROPERTY_BOOKABLE = "bookable";
    private Boolean bookable = true;
    public static final String JSON_PROPERTY_ACTIVE = "active";
    private Boolean active = true;
    public static final String JSON_PROPERTY_DISABILITY_FEATURES = "disabilityFeatures";
    private List<String> disabilityFeatures = null;
    public static final String JSON_PROPERTY_SECURITY_FEATURES = "securityFeatures";
    private List<String> securityFeatures = null;
    public static final String JSON_PROPERTY_APPLICABLE_START = "applicableStart";
    private LocalDate applicableStart;
    public static final String JSON_PROPERTY_APPLICABLE_END = "applicableEnd";
    private LocalDate applicableEnd;
    public static final String JSON_PROPERTY_RESERVATION_REQUIRED_IND = "reservationRequiredInd";
    private Boolean reservationRequiredInd;
    public static final String JSON_PROPERTY_OPENS = "opens";
    private String opens;
    public static final String JSON_PROPERTY_CLOSES = "closes";
    private String closes;
    public static final String JSON_PROPERTY_FEE = "fee";
    private Moneys fee;
    public static final String JSON_PROPERTY_PERCENT_DISCOUNT = "percentDiscount";
    private Double percentDiscount;
    public static final String JSON_PROPERTY_CONTACT = "contact";
    private ContactDto contact;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private AddressDto address;
    public static final String JSON_PROPERTY_DAYS_OF_WEEK = "daysOfWeek";
    private DowPatternGroup daysOfWeek;
    public static final String JSON_PROPERTY_SOCIALS = "socials";
    private List<Social> socials = null;
    public static final String JSON_PROPERTY_IRREGULAR = "irregular";
    private Boolean irregular = false;
    public static final String JSON_PROPERTY_MEETING_ROOM_CAPACITY = "meetingRoomCapacity";
    private Integer meetingRoomCapacity = 0;
    public static final String JSON_PROPERTY_ACCESS = "access";
    private String access = "MEETING_ROOM_ACCESS_PRIVATE";
    public static final String JSON_PROPERTY_MEETING_ROOM_TYPE_CODE = "meetingRoomTypeCode";
    private String meetingRoomTypeCode;
    public static final String JSON_PROPERTY_MEETING_ROOM_LEVEL = "meetingRoomLevel";
    private String meetingRoomLevel;
    public static final String JSON_PROPERTY_DEDICATED_IND = "dedicatedInd";
    private Boolean dedicatedInd;
    public static final String JSON_PROPERTY_AREA = "area";
    private Float area;
    public static final String JSON_PROPERTY_HEIGHT = "height";
    private Float height;
    public static final String JSON_PROPERTY_WIDTH = "width";
    private Float width;
    public static final String JSON_PROPERTY_LENGTH = "length";
    private Float length;
    public static final String JSON_PROPERTY_AMENITIES = "amenities";
    private List<String> amenities = null;
    public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
    private PricingTypeEnum pricingType;

    public MeetingRoom identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="document-1", value="Unique record identifier")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public MeetingRoom hotelIdentifier(String hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="hotel-1", value="Hotel identifier.")
    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHotelIdentifier() {
        return this.hotelIdentifier;
    }

    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHotelIdentifier(String hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
    }

    public MeetingRoom featuredInd(Boolean featuredInd) {
        this.featuredInd = featuredInd;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="false", required=true, value="Indicates whether this inventory is featured. Use this flag as a way to signify that this inventory is special.")
    @JsonProperty(value="featuredInd")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getFeaturedInd() {
        return this.featuredInd;
    }

    @JsonProperty(value="featuredInd")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFeaturedInd(Boolean featuredInd) {
        this.featuredInd = featuredInd;
    }

    public MeetingRoom lifestyleType(LifestyleTypeEnum lifestyleType) {
        this.lifestyleType = lifestyleType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="LIFESTYLE_HEALTH_FITNESS", value="Indicate the type of lifestyle this inventory should be associated with.")
    @JsonProperty(value="lifestyleType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LifestyleTypeEnum getLifestyleType() {
        return this.lifestyleType;
    }

    @JsonProperty(value="lifestyleType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifestyleType(LifestyleTypeEnum lifestyleType) {
        this.lifestyleType = lifestyleType;
    }

    public MeetingRoom location(GeoJsonPoint location) {
        this.location = location;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public GeoJsonPoint getLocation() {
        return this.location;
    }

    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLocation(GeoJsonPoint location) {
        this.location = location;
    }

    public MeetingRoom descriptions(List<SimpleDescription> descriptions) {
        this.descriptions = descriptions;
        return this;
    }

    public MeetingRoom addDescriptionsItem(SimpleDescription descriptionsItem) {
        this.descriptions.add(descriptionsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Localized descriptions describing inventory.")
    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SimpleDescription> getDescriptions() {
        return this.descriptions;
    }

    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescriptions(List<SimpleDescription> descriptions) {
        this.descriptions = descriptions;
    }

    public MeetingRoom multimedias(List<Multimedia> multimedias) {
        this.multimedias = multimedias;
        return this;
    }

    public MeetingRoom addMultimediasItem(Multimedia multimediasItem) {
        this.multimedias.add(multimediasItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="List of images / videos of inventory.")
    @JsonProperty(value="multimedias")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<Multimedia> getMultimedias() {
        return this.multimedias;
    }

    @JsonProperty(value="multimedias")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMultimedias(List<Multimedia> multimedias) {
        this.multimedias = multimedias;
    }

    public MeetingRoom geoNameId(String geoNameId) {
        this.geoNameId = geoNameId;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="879798", required=true, value="Set this datapoint to control in which city this inventory is located. Defaults to city where property is located.")
    @JsonProperty(value="geoNameId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getGeoNameId() {
        return this.geoNameId;
    }

    @JsonProperty(value="geoNameId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setGeoNameId(String geoNameId) {
        this.geoNameId = geoNameId;
    }

    public MeetingRoom city(GeoName city) {
        this.city = city;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public GeoName getCity() {
        return this.city;
    }

    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCity(GeoName city) {
        this.city = city;
    }

    public MeetingRoom commissionable(Boolean commissionable) {
        this.commissionable = commissionable;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="Indicate whether sales channels receive commission for selling this inventory.")
    @JsonProperty(value="commissionable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getCommissionable() {
        return this.commissionable;
    }

    @JsonProperty(value="commissionable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCommissionable(Boolean commissionable) {
        this.commissionable = commissionable;
    }

    public MeetingRoom name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Archery lesson", required=true, value="Internal name of inventory.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public MeetingRoom proximityCode(String proximityCode) {
        this.proximityCode = proximityCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1", value="Supported OTA specification `PRX` code. See [OTA reference data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="proximityCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProximityCode() {
        return this.proximityCode;
    }

    @JsonProperty(value="proximityCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProximityCode(String proximityCode) {
        this.proximityCode = proximityCode;
    }

    public MeetingRoom sort(Integer sort) {
        this.sort = sort;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1", value="Use this property to sort an inventory in a list of activities.")
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSort() {
        return this.sort;
    }

    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public MeetingRoom minAgeAppropriateCode(String minAgeAppropriateCode) {
        this.minAgeAppropriateCode = minAgeAppropriateCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1", value="Supported OTA specification `AQC` code. See [OTA reference data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="minAgeAppropriateCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMinAgeAppropriateCode() {
        return this.minAgeAppropriateCode;
    }

    @JsonProperty(value="minAgeAppropriateCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMinAgeAppropriateCode(String minAgeAppropriateCode) {
        this.minAgeAppropriateCode = minAgeAppropriateCode;
    }

    public MeetingRoom bookable(Boolean bookable) {
        this.bookable = bookable;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="Indicates if this inventory can be added to a booking or if it is read-only marketing material only.")
    @JsonProperty(value="bookable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getBookable() {
        return this.bookable;
    }

    @JsonProperty(value="bookable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBookable(Boolean bookable) {
        this.bookable = bookable;
    }

    public MeetingRoom active(Boolean active) {
        this.active = active;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="Modify inventory availability with this flag.")
    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getActive() {
        return this.active;
    }

    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setActive(Boolean active) {
        this.active = active;
    }

    public MeetingRoom disabilityFeatures(List<String> disabilityFeatures) {
        this.disabilityFeatures = disabilityFeatures;
        return this;
    }

    public MeetingRoom addDisabilityFeaturesItem(String disabilityFeaturesItem) {
        if (this.disabilityFeatures == null) {
            this.disabilityFeatures = new ArrayList<String>();
        }
        this.disabilityFeatures.add(disabilityFeaturesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"1\"]", value="Supported OTA specification `PHY` code. See [OTA reference data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="disabilityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDisabilityFeatures() {
        return this.disabilityFeatures;
    }

    @JsonProperty(value="disabilityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisabilityFeatures(List<String> disabilityFeatures) {
        this.disabilityFeatures = disabilityFeatures;
    }

    public MeetingRoom securityFeatures(List<String> securityFeatures) {
        this.securityFeatures = securityFeatures;
        return this;
    }

    public MeetingRoom addSecurityFeaturesItem(String securityFeaturesItem) {
        if (this.securityFeatures == null) {
            this.securityFeatures = new ArrayList<String>();
        }
        this.securityFeatures.add(securityFeaturesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"1\"]", value="Supported OTA specification `SEC` code. See [OTA reference data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="securityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSecurityFeatures() {
        return this.securityFeatures;
    }

    @JsonProperty(value="securityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSecurityFeatures(List<String> securityFeatures) {
        this.securityFeatures = securityFeatures;
    }

    public MeetingRoom applicableStart(LocalDate applicableStart) {
        this.applicableStart = applicableStart;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(example="Thu Jan 01 07:00:00 ICT 1970", value="Start month and day or date for which the attraction (e.g. the start of a season) is available. This date property signifies that the inventory is recurring and / or seasonal. If the date is in the past, only day and month will be used to infer seasonality. If the date is a future date, it will be interpreted as a starting date.")
    @JsonProperty(value="applicableStart")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getApplicableStart() {
        return this.applicableStart;
    }

    @JsonProperty(value="applicableStart")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApplicableStart(LocalDate applicableStart) {
        this.applicableStart = applicableStart;
    }

    public MeetingRoom applicableEnd(LocalDate applicableEnd) {
        this.applicableEnd = applicableEnd;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(example="Tue Dec 01 07:00:00 ICT 1970", value="End month and day or date for which the attraction (e.g. the start of a season) is available. This date property signifies that the inventory is recurring and / or seasonal. If the date is in the past, only day and month will be used to infer seasonality. If the date is a future date, it will be interpreted as a ending date.")
    @JsonProperty(value="applicableEnd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getApplicableEnd() {
        return this.applicableEnd;
    }

    @JsonProperty(value="applicableEnd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApplicableEnd(LocalDate applicableEnd) {
        this.applicableEnd = applicableEnd;
    }

    public MeetingRoom reservationRequiredInd(Boolean reservationRequiredInd) {
        this.reservationRequiredInd = reservationRequiredInd;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Indicates whether a reservation is required to participate in this inventory.")
    @JsonProperty(value="reservationRequiredInd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getReservationRequiredInd() {
        return this.reservationRequiredInd;
    }

    @JsonProperty(value="reservationRequiredInd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReservationRequiredInd(Boolean reservationRequiredInd) {
        this.reservationRequiredInd = reservationRequiredInd;
    }

    public MeetingRoom opens(String opens) {
        this.opens = opens;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="09:00", value="Opening time of inventory (if applicable). Leave empty if inventory is always available.")
    @JsonProperty(value="opens")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOpens() {
        return this.opens;
    }

    @JsonProperty(value="opens")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOpens(String opens) {
        this.opens = opens;
    }

    public MeetingRoom closes(String closes) {
        this.closes = closes;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="17:30", value="Closing time of inventory (if applicable). Leave empty if inventory is always available.")
    @JsonProperty(value="closes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCloses() {
        return this.closes;
    }

    @JsonProperty(value="closes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCloses(String closes) {
        this.closes = closes;
    }

    public MeetingRoom fee(Moneys fee) {
        this.fee = fee;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="fee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Moneys getFee() {
        return this.fee;
    }

    @JsonProperty(value="fee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFee(Moneys fee) {
        this.fee = fee;
    }

    public MeetingRoom percentDiscount(Double percentDiscount) {
        this.percentDiscount = percentDiscount;
        return this;
    }

    @Nonnull
    @NotNull
    @DecimalMin(value="0.0")
    @DecimalMax(value="1.0")
    @ApiModelProperty(example="0.2", required=true, value="Expected savings. Indicate how much the traveler is [usually] saving by booking it through this payment. Example: 20% discount.")
    @JsonProperty(value="percentDiscount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @DecimalMin(value="0.0") @DecimalMax(value="1.0") Double getPercentDiscount() {
        return this.percentDiscount;
    }

    @JsonProperty(value="percentDiscount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPercentDiscount(Double percentDiscount) {
        this.percentDiscount = percentDiscount;
    }

    public MeetingRoom contact(ContactDto contact) {
        this.contact = contact;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="contact")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ContactDto getContact() {
        return this.contact;
    }

    @JsonProperty(value="contact")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContact(ContactDto contact) {
        this.contact = contact;
    }

    public MeetingRoom address(AddressDto address) {
        this.address = address;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AddressDto getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddress(AddressDto address) {
        this.address = address;
    }

    public MeetingRoom daysOfWeek(DowPatternGroup daysOfWeek) {
        this.daysOfWeek = daysOfWeek;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="daysOfWeek")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DowPatternGroup getDaysOfWeek() {
        return this.daysOfWeek;
    }

    @JsonProperty(value="daysOfWeek")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDaysOfWeek(DowPatternGroup daysOfWeek) {
        this.daysOfWeek = daysOfWeek;
    }

    public MeetingRoom socials(List<Social> socials) {
        this.socials = socials;
        return this;
    }

    public MeetingRoom addSocialsItem(Social socialsItem) {
        if (this.socials == null) {
            this.socials = new ArrayList<Social>();
        }
        this.socials.add(socialsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Social network accounts for inventory (if applicable).")
    @JsonProperty(value="socials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Social> getSocials() {
        return this.socials;
    }

    @JsonProperty(value="socials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSocials(List<Social> socials) {
        this.socials = socials;
    }

    public MeetingRoom irregular(Boolean irregular) {
        this.irregular = irregular;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="Room has an irregular shape. If true, the room would be of a traditional square or rectangular shape.")
    @JsonProperty(value="irregular")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getIrregular() {
        return this.irregular;
    }

    @JsonProperty(value="irregular")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIrregular(Boolean irregular) {
        this.irregular = irregular;
    }

    public MeetingRoom meetingRoomCapacity(Integer meetingRoomCapacity) {
        this.meetingRoomCapacity = meetingRoomCapacity;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @ApiModelProperty(example="100", required=true, value="The total number of people permitted in the meeting room.")
    @JsonProperty(value="meetingRoomCapacity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getMeetingRoomCapacity() {
        return this.meetingRoomCapacity;
    }

    @JsonProperty(value="meetingRoomCapacity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMeetingRoomCapacity(Integer meetingRoomCapacity) {
        this.meetingRoomCapacity = meetingRoomCapacity;
    }

    public MeetingRoom access(String access) {
        this.access = access;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="MEETING_ROOM_ACCESS_PUBLIC", value="The type of access to the meeting space.")
    @JsonProperty(value="access")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccess() {
        return this.access;
    }

    @JsonProperty(value="access")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccess(String access) {
        this.access = access;
    }

    public MeetingRoom meetingRoomTypeCode(String meetingRoomTypeCode) {
        this.meetingRoomTypeCode = meetingRoomTypeCode;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="[\"1\"]", required=true, value="Supported OTA specification `MRF` code. See [OTA reference data](#operation/showAvailableCodesForCategory).")
    @JsonProperty(value="meetingRoomTypeCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getMeetingRoomTypeCode() {
        return this.meetingRoomTypeCode;
    }

    @JsonProperty(value="meetingRoomTypeCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMeetingRoomTypeCode(String meetingRoomTypeCode) {
        this.meetingRoomTypeCode = meetingRoomTypeCode;
    }

    public MeetingRoom meetingRoomLevel(String meetingRoomLevel) {
        this.meetingRoomLevel = meetingRoomLevel;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="LOBBY", value="Defines the level in the facility where the meeting room is located.")
    @JsonProperty(value="meetingRoomLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMeetingRoomLevel() {
        return this.meetingRoomLevel;
    }

    @JsonProperty(value="meetingRoomLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMeetingRoomLevel(String meetingRoomLevel) {
        this.meetingRoomLevel = meetingRoomLevel;
    }

    public MeetingRoom dedicatedInd(Boolean dedicatedInd) {
        this.dedicatedInd = dedicatedInd;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="false", required=true, value="When true, the room is used for a single purpose as indicated by the MeetingRoomTypeCode attribute.")
    @JsonProperty(value="dedicatedInd")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getDedicatedInd() {
        return this.dedicatedInd;
    }

    @JsonProperty(value="dedicatedInd")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDedicatedInd(Boolean dedicatedInd) {
        this.dedicatedInd = dedicatedInd;
    }

    public MeetingRoom area(Float area) {
        this.area = area;
        return this;
    }

    @Nonnull
    @NotNull
    @DecimalMin(value="1.0")
    @ApiModelProperty(example="100", required=true, value="Area (in square meters) of this meeting room.")
    @JsonProperty(value="area")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @DecimalMin(value="1.0") Float getArea() {
        return this.area;
    }

    @JsonProperty(value="area")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setArea(Float area) {
        this.area = area;
    }

    public MeetingRoom height(Float height) {
        this.height = height;
        return this;
    }

    @Nonnull
    @NotNull
    @DecimalMin(value="1.0")
    @ApiModelProperty(example="4", required=true, value="Height (in meters) of this meeting room.")
    @JsonProperty(value="height")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @DecimalMin(value="1.0") Float getHeight() {
        return this.height;
    }

    @JsonProperty(value="height")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHeight(Float height) {
        this.height = height;
    }

    public MeetingRoom width(Float width) {
        this.width = width;
        return this;
    }

    @Nonnull
    @NotNull
    @DecimalMin(value="1.0")
    @ApiModelProperty(example="5", required=true, value="Width (in meters) of this meeting room.")
    @JsonProperty(value="width")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @DecimalMin(value="1.0") Float getWidth() {
        return this.width;
    }

    @JsonProperty(value="width")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setWidth(Float width) {
        this.width = width;
    }

    public MeetingRoom length(Float length) {
        this.length = length;
        return this;
    }

    @Nonnull
    @NotNull
    @DecimalMin(value="1.0")
    @ApiModelProperty(example="5", required=true, value="Length (in meters) of this meeting room.")
    @JsonProperty(value="length")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @DecimalMin(value="1.0") Float getLength() {
        return this.length;
    }

    @JsonProperty(value="length")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLength(Float length) {
        this.length = length;
    }

    public MeetingRoom amenities(List<String> amenities) {
        this.amenities = amenities;
        return this;
    }

    public MeetingRoom addAmenitiesItem(String amenitiesItem) {
        if (this.amenities == null) {
            this.amenities = new ArrayList<String>();
        }
        this.amenities.add(amenitiesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"1\"]", value="Supported OTA specification `MRC` code. See [OTA reference data](#operation/showAvailableCodesForCategory).")
    @JsonProperty(value="amenities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getAmenities() {
        return this.amenities;
    }

    @JsonProperty(value="amenities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmenities(List<String> amenities) {
        this.amenities = amenities;
    }

    public MeetingRoom pricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="How this inventory item should be priced.")
    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PricingTypeEnum getPricingType() {
        return this.pricingType;
    }

    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeetingRoom meetingRoom = (MeetingRoom)o;
        return Objects.equals(this.identifier, meetingRoom.identifier) && Objects.equals(this.hotelIdentifier, meetingRoom.hotelIdentifier) && Objects.equals(this.featuredInd, meetingRoom.featuredInd) && Objects.equals((Object)this.lifestyleType, (Object)meetingRoom.lifestyleType) && Objects.equals(this.location, meetingRoom.location) && Objects.equals(this.descriptions, meetingRoom.descriptions) && Objects.equals(this.multimedias, meetingRoom.multimedias) && Objects.equals(this.geoNameId, meetingRoom.geoNameId) && Objects.equals(this.city, meetingRoom.city) && Objects.equals(this.commissionable, meetingRoom.commissionable) && Objects.equals(this.name, meetingRoom.name) && Objects.equals(this.proximityCode, meetingRoom.proximityCode) && Objects.equals(this.sort, meetingRoom.sort) && Objects.equals(this.minAgeAppropriateCode, meetingRoom.minAgeAppropriateCode) && Objects.equals(this.bookable, meetingRoom.bookable) && Objects.equals(this.active, meetingRoom.active) && Objects.equals(this.disabilityFeatures, meetingRoom.disabilityFeatures) && Objects.equals(this.securityFeatures, meetingRoom.securityFeatures) && Objects.equals(this.applicableStart, meetingRoom.applicableStart) && Objects.equals(this.applicableEnd, meetingRoom.applicableEnd) && Objects.equals(this.reservationRequiredInd, meetingRoom.reservationRequiredInd) && Objects.equals(this.opens, meetingRoom.opens) && Objects.equals(this.closes, meetingRoom.closes) && Objects.equals(this.fee, meetingRoom.fee) && Objects.equals(this.percentDiscount, meetingRoom.percentDiscount) && Objects.equals(this.contact, meetingRoom.contact) && Objects.equals(this.address, meetingRoom.address) && Objects.equals(this.daysOfWeek, meetingRoom.daysOfWeek) && Objects.equals(this.socials, meetingRoom.socials) && Objects.equals(this.irregular, meetingRoom.irregular) && Objects.equals(this.meetingRoomCapacity, meetingRoom.meetingRoomCapacity) && Objects.equals(this.access, meetingRoom.access) && Objects.equals(this.meetingRoomTypeCode, meetingRoom.meetingRoomTypeCode) && Objects.equals(this.meetingRoomLevel, meetingRoom.meetingRoomLevel) && Objects.equals(this.dedicatedInd, meetingRoom.dedicatedInd) && Objects.equals(this.area, meetingRoom.area) && Objects.equals(this.height, meetingRoom.height) && Objects.equals(this.width, meetingRoom.width) && Objects.equals(this.length, meetingRoom.length) && Objects.equals(this.amenities, meetingRoom.amenities) && Objects.equals((Object)this.pricingType, (Object)meetingRoom.pricingType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.hotelIdentifier, this.featuredInd, this.lifestyleType, this.location, this.descriptions, this.multimedias, this.geoNameId, this.city, this.commissionable, this.name, this.proximityCode, this.sort, this.minAgeAppropriateCode, this.bookable, this.active, this.disabilityFeatures, this.securityFeatures, this.applicableStart, this.applicableEnd, this.reservationRequiredInd, this.opens, this.closes, this.fee, this.percentDiscount, this.contact, this.address, this.daysOfWeek, this.socials, this.irregular, this.meetingRoomCapacity, this.access, this.meetingRoomTypeCode, this.meetingRoomLevel, this.dedicatedInd, this.area, this.height, this.width, this.length, this.amenities, this.pricingType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MeetingRoom {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    hotelIdentifier: ").append(this.toIndentedString(this.hotelIdentifier)).append("\n");
        sb.append("    featuredInd: ").append(this.toIndentedString(this.featuredInd)).append("\n");
        sb.append("    lifestyleType: ").append(this.toIndentedString((Object)this.lifestyleType)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    descriptions: ").append(this.toIndentedString(this.descriptions)).append("\n");
        sb.append("    multimedias: ").append(this.toIndentedString(this.multimedias)).append("\n");
        sb.append("    geoNameId: ").append(this.toIndentedString(this.geoNameId)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    commissionable: ").append(this.toIndentedString(this.commissionable)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    proximityCode: ").append(this.toIndentedString(this.proximityCode)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    minAgeAppropriateCode: ").append(this.toIndentedString(this.minAgeAppropriateCode)).append("\n");
        sb.append("    bookable: ").append(this.toIndentedString(this.bookable)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    disabilityFeatures: ").append(this.toIndentedString(this.disabilityFeatures)).append("\n");
        sb.append("    securityFeatures: ").append(this.toIndentedString(this.securityFeatures)).append("\n");
        sb.append("    applicableStart: ").append(this.toIndentedString(this.applicableStart)).append("\n");
        sb.append("    applicableEnd: ").append(this.toIndentedString(this.applicableEnd)).append("\n");
        sb.append("    reservationRequiredInd: ").append(this.toIndentedString(this.reservationRequiredInd)).append("\n");
        sb.append("    opens: ").append(this.toIndentedString(this.opens)).append("\n");
        sb.append("    closes: ").append(this.toIndentedString(this.closes)).append("\n");
        sb.append("    fee: ").append(this.toIndentedString(this.fee)).append("\n");
        sb.append("    percentDiscount: ").append(this.toIndentedString(this.percentDiscount)).append("\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    daysOfWeek: ").append(this.toIndentedString(this.daysOfWeek)).append("\n");
        sb.append("    socials: ").append(this.toIndentedString(this.socials)).append("\n");
        sb.append("    irregular: ").append(this.toIndentedString(this.irregular)).append("\n");
        sb.append("    meetingRoomCapacity: ").append(this.toIndentedString(this.meetingRoomCapacity)).append("\n");
        sb.append("    access: ").append(this.toIndentedString(this.access)).append("\n");
        sb.append("    meetingRoomTypeCode: ").append(this.toIndentedString(this.meetingRoomTypeCode)).append("\n");
        sb.append("    meetingRoomLevel: ").append(this.toIndentedString(this.meetingRoomLevel)).append("\n");
        sb.append("    dedicatedInd: ").append(this.toIndentedString(this.dedicatedInd)).append("\n");
        sb.append("    area: ").append(this.toIndentedString(this.area)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    length: ").append(this.toIndentedString(this.length)).append("\n");
        sb.append("    amenities: ").append(this.toIndentedString(this.amenities)).append("\n");
        sb.append("    pricingType: ").append(this.toIndentedString((Object)this.pricingType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum LifestyleTypeEnum {
        HEALTH_FITNESS("LIFESTYLE_HEALTH_FITNESS"),
        RELAX("LIFESTYLE_RELAX"),
        ADULT_ONLY("LIFESTYLE_ADULT_ONLY"),
        ADVENTURE("LIFESTYLE_ADVENTURE"),
        BUSINESS("LIFESTYLE_BUSINESS"),
        LGBT("LIFESTYLE_LGBT"),
        SINGLE_PARENT("LIFESTYLE_SINGLE_PARENT"),
        SOLO_FEMALE("LIFESTYLE_SOLO_FEMALE"),
        BEAUTY("LIFESTYLE_BEAUTY"),
        FOODIE("LIFESTYLE_FOODIE"),
        FAMILY("LIFESTYLE_FAMILY"),
        ROMANCE("LIFESTYLE_ROMANCE"),
        COUPLE("LIFESTYLE_COUPLE"),
        SOLO("LIFESTYLE_SOLO"),
        BACKPACKER("LIFESTYLE_BACKPACKER"),
        SHOPPING("LIFESTYLE_SHOPPING"),
        SPORTS("LIFESTYLE_SPORTS"),
        MOUNTAIN("LIFESTYLE_MOUNTAIN"),
        BEACH("LIFESTYLE_BEACH"),
        CITY("LIFESTYLE_CITY"),
        COUNTRY("LIFESTYLE_COUNTRY"),
        CULTURE("LIFESTYLE_CULTURE"),
        ECO("LIFESTYLE_ECO");

        private String value;

        private LifestyleTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LifestyleTypeEnum fromValue(String value) {
            for (LifestyleTypeEnum b : LifestyleTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PricingTypeEnum {
        PERSON_PER_USE("PER_PERSON_PER_USE"),
        USE("PER_USE"),
        PERSON_PER_HOUR("PER_PERSON_PER_HOUR"),
        HOUR("PER_HOUR");

        private String value;

        private PricingTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PricingTypeEnum fromValue(String value) {
            for (PricingTypeEnum b : PricingTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

