/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.booking.engine.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;
import travel.wink.sdk.booking.engine.model.RoomConfigurationPrice;

@ApiModel(description="Best-priced room types")
@JsonPropertyOrder(value={"roomTypeIdentifier", "channelInventoryIdentifier", "price", "perkValue", "available", "sort"})
public class RoomTypeBestPrice {
    public static final String JSON_PROPERTY_ROOM_TYPE_IDENTIFIER = "roomTypeIdentifier";
    private String roomTypeIdentifier;
    public static final String JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER = "channelInventoryIdentifier";
    private String channelInventoryIdentifier;
    public static final String JSON_PROPERTY_PRICE = "price";
    private RoomConfigurationPrice price;
    public static final String JSON_PROPERTY_PERK_VALUE = "perkValue";
    private Integer perkValue;
    public static final String JSON_PROPERTY_AVAILABLE = "available";
    private Boolean available;
    public static final String JSON_PROPERTY_SORT = "sort";
    private Integer sort;

    public RoomTypeBestPrice roomTypeIdentifier(String roomTypeIdentifier) {
        this.roomTypeIdentifier = roomTypeIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Room type identifier.")
    @JsonProperty(value="roomTypeIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRoomTypeIdentifier() {
        return this.roomTypeIdentifier;
    }

    @JsonProperty(value="roomTypeIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoomTypeIdentifier(String roomTypeIdentifier) {
        this.roomTypeIdentifier = roomTypeIdentifier;
    }

    public RoomTypeBestPrice channelInventoryIdentifier(String channelInventoryIdentifier) {
        this.channelInventoryIdentifier = channelInventoryIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Channel inventory identifier.")
    @JsonProperty(value="channelInventoryIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getChannelInventoryIdentifier() {
        return this.channelInventoryIdentifier;
    }

    @JsonProperty(value="channelInventoryIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChannelInventoryIdentifier(String channelInventoryIdentifier) {
        this.channelInventoryIdentifier = channelInventoryIdentifier;
    }

    public RoomTypeBestPrice price(RoomConfigurationPrice price) {
        this.price = price;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RoomConfigurationPrice getPrice() {
        return this.price;
    }

    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrice(RoomConfigurationPrice price) {
        this.price = price;
    }

    public RoomTypeBestPrice perkValue(Integer perkValue) {
        this.perkValue = perkValue;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The sum of all perks the master rate had made available.")
    @JsonProperty(value="perkValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPerkValue() {
        return this.perkValue;
    }

    @JsonProperty(value="perkValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPerkValue(Integer perkValue) {
        this.perkValue = perkValue;
    }

    public RoomTypeBestPrice available(Boolean available) {
        this.available = available;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether this room type is available with this configuration")
    @JsonProperty(value="available")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAvailable() {
        return this.available;
    }

    @JsonProperty(value="available")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAvailable(Boolean available) {
        this.available = available;
    }

    public RoomTypeBestPrice sort(Integer sort) {
        this.sort = sort;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When this room type is displayed in conjunction with many others, this sort property will often times be populated to indicate how the room types should be sorted and displayed.")
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSort() {
        return this.sort;
    }

    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoomTypeBestPrice roomTypeBestPrice = (RoomTypeBestPrice)o;
        return Objects.equals(this.roomTypeIdentifier, roomTypeBestPrice.roomTypeIdentifier) && Objects.equals(this.channelInventoryIdentifier, roomTypeBestPrice.channelInventoryIdentifier) && Objects.equals(this.price, roomTypeBestPrice.price) && Objects.equals(this.perkValue, roomTypeBestPrice.perkValue) && Objects.equals(this.available, roomTypeBestPrice.available) && Objects.equals(this.sort, roomTypeBestPrice.sort);
    }

    public int hashCode() {
        return Objects.hash(this.roomTypeIdentifier, this.channelInventoryIdentifier, this.price, this.perkValue, this.available, this.sort);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RoomTypeBestPrice {\n");
        sb.append("    roomTypeIdentifier: ").append(this.toIndentedString(this.roomTypeIdentifier)).append("\n");
        sb.append("    channelInventoryIdentifier: ").append(this.toIndentedString(this.channelInventoryIdentifier)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    perkValue: ").append(this.toIndentedString(this.perkValue)).append("\n");
        sb.append("    available: ").append(this.toIndentedString(this.available)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

