package travel.wink.sdk.booking.engine.api;

import travel.wink.sdk.booking.engine.invoker.ApiClient;

import travel.wink.sdk.booking.engine.model.AggregateActivityRequest;
import travel.wink.sdk.booking.engine.model.AggregateAddOnRequest;
import travel.wink.sdk.booking.engine.model.AggregateAttractionRequest;
import travel.wink.sdk.booking.engine.model.AggregateGuestRoomRequest;
import travel.wink.sdk.booking.engine.model.AggregateHotelRequest;
import travel.wink.sdk.booking.engine.model.AggregateInventoryGridItemRequest;
import travel.wink.sdk.booking.engine.model.AggregateMeetingRoomRequest;
import travel.wink.sdk.booking.engine.model.AggregatePackageRequest;
import travel.wink.sdk.booking.engine.model.AggregatePlaceRequest;
import travel.wink.sdk.booking.engine.model.AggregateRestaurantRequest;
import travel.wink.sdk.booking.engine.model.AggregateSellerInventoryListRequest;
import travel.wink.sdk.booking.engine.model.AggregateSpaRequest;
import travel.wink.sdk.booking.engine.model.CityScoreRequest;
import travel.wink.sdk.booking.engine.model.CitySearchRequest;
import travel.wink.sdk.booking.engine.model.CountryScoreRequest;
import travel.wink.sdk.booking.engine.model.GenericErrorMessage;
import travel.wink.sdk.booking.engine.model.GlobalScoreRequest;
import travel.wink.sdk.booking.engine.model.HotelInventoryListRequest;
import travel.wink.sdk.booking.engine.model.HotelInventoryListResponse;
import travel.wink.sdk.booking.engine.model.HotelInventoryRequest;
import travel.wink.sdk.booking.engine.model.HotelInventoryResponse;
import travel.wink.sdk.booking.engine.model.InventoryGridItem;
import travel.wink.sdk.booking.engine.model.MapRequest;
import travel.wink.sdk.booking.engine.model.Oauth2SearchByGeoLocation400Response;
import travel.wink.sdk.booking.engine.model.PageHotelWithBestPrice;
import travel.wink.sdk.booking.engine.model.SellerInventoryActivity;
import travel.wink.sdk.booking.engine.model.SellerInventoryAddOn;
import travel.wink.sdk.booking.engine.model.SellerInventoryAttraction;
import travel.wink.sdk.booking.engine.model.SellerInventoryGuestRoom;
import travel.wink.sdk.booking.engine.model.SellerInventoryHotel;
import travel.wink.sdk.booking.engine.model.SellerInventoryListResponse;
import travel.wink.sdk.booking.engine.model.SellerInventoryMeetingRoom;
import travel.wink.sdk.booking.engine.model.SellerInventoryPackage;
import travel.wink.sdk.booking.engine.model.SellerInventoryPlace;
import travel.wink.sdk.booking.engine.model.SellerInventoryRankedListResponse;
import travel.wink.sdk.booking.engine.model.SellerInventoryRestaurant;
import travel.wink.sdk.booking.engine.model.SellerInventorySpa;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-06-05T13:54:07.858909+07:00[Asia/Bangkok]")
public class InventoryApi {
    private ApiClient apiClient;

    public InventoryApi() {
        this(new ApiClient());
    }

    @Autowired
    public InventoryApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Ranked City Search
     * Search for hotels in / around a city and order by scoring type
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param cityScoreRequest The cityScoreRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return PageHotelWithBestPrice
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ScoreInventoryByCityRequestCreation(CityScoreRequest cityScoreRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        Object postBody = cityScoreRequest;
        // verify the required parameter 'cityScoreRequest' is set
        if (cityScoreRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'cityScoreRequest' when calling oauth2ScoreInventoryByCity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<PageHotelWithBestPrice> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPrice>() {};
        return apiClient.invokeAPI("/api/ranked/search/city", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Ranked City Search
     * Search for hotels in / around a city and order by scoring type
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param cityScoreRequest The cityScoreRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return PageHotelWithBestPrice
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageHotelWithBestPrice> oauth2ScoreInventoryByCity(CityScoreRequest cityScoreRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPrice> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPrice>() {};
        return oauth2ScoreInventoryByCityRequestCreation(cityScoreRequest, engineConfigurationIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<PageHotelWithBestPrice>> oauth2ScoreInventoryByCityWithHttpInfo(CityScoreRequest cityScoreRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPrice> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPrice>() {};
        return oauth2ScoreInventoryByCityRequestCreation(cityScoreRequest, engineConfigurationIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * By Geo-Location
     * Search for properties near a point or within bounds. Populate either &#x60;request.userSession.location&#x60; OR &#x60;request.userSession.bounds&#x60;.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param mapRequest The mapRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return PageHotelWithBestPrice
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2SearchByGeoLocationRequestCreation(MapRequest mapRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        Object postBody = mapRequest;
        // verify the required parameter 'mapRequest' is set
        if (mapRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'mapRequest' when calling oauth2SearchByGeoLocation", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<PageHotelWithBestPrice> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPrice>() {};
        return apiClient.invokeAPI("/api/search/geo", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * By Geo-Location
     * Search for properties near a point or within bounds. Populate either &#x60;request.userSession.location&#x60; OR &#x60;request.userSession.bounds&#x60;.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param mapRequest The mapRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return PageHotelWithBestPrice
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageHotelWithBestPrice> oauth2SearchByGeoLocation(MapRequest mapRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPrice> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPrice>() {};
        return oauth2SearchByGeoLocationRequestCreation(mapRequest, engineConfigurationIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<PageHotelWithBestPrice>> oauth2SearchByGeoLocationWithHttpInfo(MapRequest mapRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPrice> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPrice>() {};
        return oauth2SearchByGeoLocationRequestCreation(mapRequest, engineConfigurationIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * City Search
     * Search for hotels in / around a city
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param citySearchRequest The citySearchRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return PageHotelWithBestPrice
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2SearchInventoryByCityRequestCreation(CitySearchRequest citySearchRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        Object postBody = citySearchRequest;
        // verify the required parameter 'citySearchRequest' is set
        if (citySearchRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'citySearchRequest' when calling oauth2SearchInventoryByCity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<PageHotelWithBestPrice> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPrice>() {};
        return apiClient.invokeAPI("/api/search/city", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * City Search
     * Search for hotels in / around a city
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param citySearchRequest The citySearchRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return PageHotelWithBestPrice
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageHotelWithBestPrice> oauth2SearchInventoryByCity(CitySearchRequest citySearchRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPrice> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPrice>() {};
        return oauth2SearchInventoryByCityRequestCreation(citySearchRequest, engineConfigurationIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<PageHotelWithBestPrice>> oauth2SearchInventoryByCityWithHttpInfo(CitySearchRequest citySearchRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPrice> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPrice>() {};
        return oauth2SearchInventoryByCityRequestCreation(citySearchRequest, engineConfigurationIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Ranked Country Search
     * Search for hotels in a country and order by scoring type
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param countryScoreRequest The countryScoreRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return PageHotelWithBestPrice
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2SearchScoreByCountryRequestCreation(CountryScoreRequest countryScoreRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        Object postBody = countryScoreRequest;
        // verify the required parameter 'countryScoreRequest' is set
        if (countryScoreRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'countryScoreRequest' when calling oauth2SearchScoreByCountry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<PageHotelWithBestPrice> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPrice>() {};
        return apiClient.invokeAPI("/api/ranked/search/country", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Ranked Country Search
     * Search for hotels in a country and order by scoring type
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param countryScoreRequest The countryScoreRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return PageHotelWithBestPrice
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageHotelWithBestPrice> oauth2SearchScoreByCountry(CountryScoreRequest countryScoreRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPrice> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPrice>() {};
        return oauth2SearchScoreByCountryRequestCreation(countryScoreRequest, engineConfigurationIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<PageHotelWithBestPrice>> oauth2SearchScoreByCountryWithHttpInfo(CountryScoreRequest countryScoreRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPrice> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPrice>() {};
        return oauth2SearchScoreByCountryRequestCreation(countryScoreRequest, engineConfigurationIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Ranked Global Search
     * Search best scoring hotels in the world and order by scoring type
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param globalScoreRequest The globalScoreRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return PageHotelWithBestPrice
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2SearchScoreByGlobalRequestCreation(GlobalScoreRequest globalScoreRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        Object postBody = globalScoreRequest;
        // verify the required parameter 'globalScoreRequest' is set
        if (globalScoreRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'globalScoreRequest' when calling oauth2SearchScoreByGlobal", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<PageHotelWithBestPrice> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPrice>() {};
        return apiClient.invokeAPI("/api/ranked/search/global", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Ranked Global Search
     * Search best scoring hotels in the world and order by scoring type
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param globalScoreRequest The globalScoreRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return PageHotelWithBestPrice
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageHotelWithBestPrice> oauth2SearchScoreByGlobal(GlobalScoreRequest globalScoreRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPrice> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPrice>() {};
        return oauth2SearchScoreByGlobalRequestCreation(globalScoreRequest, engineConfigurationIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<PageHotelWithBestPrice>> oauth2SearchScoreByGlobalWithHttpInfo(GlobalScoreRequest globalScoreRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPrice> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPrice>() {};
        return oauth2SearchScoreByGlobalRequestCreation(globalScoreRequest, engineConfigurationIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Inventory
     * Shows single grid based on channel inventory identifier 
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param aggregateInventoryGridItemRequest The aggregateInventoryGridItemRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return InventoryGridItem
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowInventoryGridItemRequestCreation(AggregateInventoryGridItemRequest aggregateInventoryGridItemRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        Object postBody = aggregateInventoryGridItemRequest;
        // verify the required parameter 'aggregateInventoryGridItemRequest' is set
        if (aggregateInventoryGridItemRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateInventoryGridItemRequest' when calling oauth2ShowInventoryGridItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<InventoryGridItem> localVarReturnType = new ParameterizedTypeReference<InventoryGridItem>() {};
        return apiClient.invokeAPI("/api/inventory/grid/item", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Inventory
     * Shows single grid based on channel inventory identifier 
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param aggregateInventoryGridItemRequest The aggregateInventoryGridItemRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return InventoryGridItem
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<InventoryGridItem> oauth2ShowInventoryGridItem(AggregateInventoryGridItemRequest aggregateInventoryGridItemRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryGridItem> localVarReturnType = new ParameterizedTypeReference<InventoryGridItem>() {};
        return oauth2ShowInventoryGridItemRequestCreation(aggregateInventoryGridItemRequest, engineConfigurationIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<InventoryGridItem>> oauth2ShowInventoryGridItemWithHttpInfo(AggregateInventoryGridItemRequest aggregateInventoryGridItemRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryGridItem> localVarReturnType = new ParameterizedTypeReference<InventoryGridItem>() {};
        return oauth2ShowInventoryGridItemRequestCreation(aggregateInventoryGridItemRequest, engineConfigurationIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Add-On
     * Show single add-on based on a channel inventory identifier
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param aggregateAddOnRequest The aggregateAddOnRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return SellerInventoryAddOn
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowPropertyAddOnRequestCreation(AggregateAddOnRequest aggregateAddOnRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        Object postBody = aggregateAddOnRequest;
        // verify the required parameter 'aggregateAddOnRequest' is set
        if (aggregateAddOnRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateAddOnRequest' when calling oauth2ShowPropertyAddOn", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<SellerInventoryAddOn> localVarReturnType = new ParameterizedTypeReference<SellerInventoryAddOn>() {};
        return apiClient.invokeAPI("/api/inventory/upgrade", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Add-On
     * Show single add-on based on a channel inventory identifier
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param aggregateAddOnRequest The aggregateAddOnRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return SellerInventoryAddOn
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryAddOn> oauth2ShowPropertyAddOn(AggregateAddOnRequest aggregateAddOnRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryAddOn> localVarReturnType = new ParameterizedTypeReference<SellerInventoryAddOn>() {};
        return oauth2ShowPropertyAddOnRequestCreation(aggregateAddOnRequest, engineConfigurationIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryAddOn>> oauth2ShowPropertyAddOnWithHttpInfo(AggregateAddOnRequest aggregateAddOnRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryAddOn> localVarReturnType = new ParameterizedTypeReference<SellerInventoryAddOn>() {};
        return oauth2ShowPropertyAddOnRequestCreation(aggregateAddOnRequest, engineConfigurationIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Property
     * Show single hotel card with price based on a given record identifier
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param aggregateHotelRequest The aggregateHotelRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return SellerInventoryHotel
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowPropertyAggregateRequestCreation(AggregateHotelRequest aggregateHotelRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        Object postBody = aggregateHotelRequest;
        // verify the required parameter 'aggregateHotelRequest' is set
        if (aggregateHotelRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateHotelRequest' when calling oauth2ShowPropertyAggregate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<SellerInventoryHotel> localVarReturnType = new ParameterizedTypeReference<SellerInventoryHotel>() {};
        return apiClient.invokeAPI("/api/inventory/property", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Property
     * Show single hotel card with price based on a given record identifier
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param aggregateHotelRequest The aggregateHotelRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return SellerInventoryHotel
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryHotel> oauth2ShowPropertyAggregate(AggregateHotelRequest aggregateHotelRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryHotel> localVarReturnType = new ParameterizedTypeReference<SellerInventoryHotel>() {};
        return oauth2ShowPropertyAggregateRequestCreation(aggregateHotelRequest, engineConfigurationIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryHotel>> oauth2ShowPropertyAggregateWithHttpInfo(AggregateHotelRequest aggregateHotelRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryHotel> localVarReturnType = new ParameterizedTypeReference<SellerInventoryHotel>() {};
        return oauth2ShowPropertyAggregateRequestCreation(aggregateHotelRequest, engineConfigurationIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Attraction
     * Show single attraction based on a channel inventory identifier
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param aggregateAttractionRequest The aggregateAttractionRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return SellerInventoryAttraction
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowPropertyAttractionRequestCreation(AggregateAttractionRequest aggregateAttractionRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        Object postBody = aggregateAttractionRequest;
        // verify the required parameter 'aggregateAttractionRequest' is set
        if (aggregateAttractionRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateAttractionRequest' when calling oauth2ShowPropertyAttraction", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<SellerInventoryAttraction> localVarReturnType = new ParameterizedTypeReference<SellerInventoryAttraction>() {};
        return apiClient.invokeAPI("/api/inventory/attraction", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Attraction
     * Show single attraction based on a channel inventory identifier
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param aggregateAttractionRequest The aggregateAttractionRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return SellerInventoryAttraction
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryAttraction> oauth2ShowPropertyAttraction(AggregateAttractionRequest aggregateAttractionRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryAttraction> localVarReturnType = new ParameterizedTypeReference<SellerInventoryAttraction>() {};
        return oauth2ShowPropertyAttractionRequestCreation(aggregateAttractionRequest, engineConfigurationIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryAttraction>> oauth2ShowPropertyAttractionWithHttpInfo(AggregateAttractionRequest aggregateAttractionRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryAttraction> localVarReturnType = new ParameterizedTypeReference<SellerInventoryAttraction>() {};
        return oauth2ShowPropertyAttractionRequestCreation(aggregateAttractionRequest, engineConfigurationIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show property
     * Show property content / availability / rate details.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param hotelInventoryRequest The hotelInventoryRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @return HotelInventoryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowPropertyInventoryRequestCreation(HotelInventoryRequest hotelInventoryRequest, String engineConfigurationIdentifier) throws WebClientResponseException {
        Object postBody = hotelInventoryRequest;
        // verify the required parameter 'hotelInventoryRequest' is set
        if (hotelInventoryRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelInventoryRequest' when calling oauth2ShowPropertyInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<HotelInventoryResponse> localVarReturnType = new ParameterizedTypeReference<HotelInventoryResponse>() {};
        return apiClient.invokeAPI("/api/inventory", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show property
     * Show property content / availability / rate details.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param hotelInventoryRequest The hotelInventoryRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @return HotelInventoryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<HotelInventoryResponse> oauth2ShowPropertyInventory(HotelInventoryRequest hotelInventoryRequest, String engineConfigurationIdentifier) throws WebClientResponseException {
        ParameterizedTypeReference<HotelInventoryResponse> localVarReturnType = new ParameterizedTypeReference<HotelInventoryResponse>() {};
        return oauth2ShowPropertyInventoryRequestCreation(hotelInventoryRequest, engineConfigurationIdentifier).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<HotelInventoryResponse>> oauth2ShowPropertyInventoryWithHttpInfo(HotelInventoryRequest hotelInventoryRequest, String engineConfigurationIdentifier) throws WebClientResponseException {
        ParameterizedTypeReference<HotelInventoryResponse> localVarReturnType = new ParameterizedTypeReference<HotelInventoryResponse>() {};
        return oauth2ShowPropertyInventoryRequestCreation(hotelInventoryRequest, engineConfigurationIdentifier).toEntity(localVarReturnType);
    }
    /**
     * Show Property List
     * Show property content / availability / rate details.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param hotelInventoryListRequest The hotelInventoryListRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @return HotelInventoryListResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowPropertyListRequestCreation(HotelInventoryListRequest hotelInventoryListRequest, String engineConfigurationIdentifier) throws WebClientResponseException {
        Object postBody = hotelInventoryListRequest;
        // verify the required parameter 'hotelInventoryListRequest' is set
        if (hotelInventoryListRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelInventoryListRequest' when calling oauth2ShowPropertyList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/vnd.platform-v1+json", "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<HotelInventoryListResponse> localVarReturnType = new ParameterizedTypeReference<HotelInventoryListResponse>() {};
        return apiClient.invokeAPI("/api/inventory/list", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Property List
     * Show property content / availability / rate details.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param hotelInventoryListRequest The hotelInventoryListRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @return HotelInventoryListResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<HotelInventoryListResponse> oauth2ShowPropertyList(HotelInventoryListRequest hotelInventoryListRequest, String engineConfigurationIdentifier) throws WebClientResponseException {
        ParameterizedTypeReference<HotelInventoryListResponse> localVarReturnType = new ParameterizedTypeReference<HotelInventoryListResponse>() {};
        return oauth2ShowPropertyListRequestCreation(hotelInventoryListRequest, engineConfigurationIdentifier).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<HotelInventoryListResponse>> oauth2ShowPropertyListWithHttpInfo(HotelInventoryListRequest hotelInventoryListRequest, String engineConfigurationIdentifier) throws WebClientResponseException {
        ParameterizedTypeReference<HotelInventoryListResponse> localVarReturnType = new ParameterizedTypeReference<HotelInventoryListResponse>() {};
        return oauth2ShowPropertyListRequestCreation(hotelInventoryListRequest, engineConfigurationIdentifier).toEntity(localVarReturnType);
    }
    /**
     * Show Meeting Room
     * Show single meeting room based on a channel inventory identifier
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param aggregateMeetingRoomRequest The aggregateMeetingRoomRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return SellerInventoryMeetingRoom
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowPropertyMeetingRoomRequestCreation(AggregateMeetingRoomRequest aggregateMeetingRoomRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        Object postBody = aggregateMeetingRoomRequest;
        // verify the required parameter 'aggregateMeetingRoomRequest' is set
        if (aggregateMeetingRoomRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateMeetingRoomRequest' when calling oauth2ShowPropertyMeetingRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<SellerInventoryMeetingRoom> localVarReturnType = new ParameterizedTypeReference<SellerInventoryMeetingRoom>() {};
        return apiClient.invokeAPI("/api/inventory/meetingroom", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Meeting Room
     * Show single meeting room based on a channel inventory identifier
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param aggregateMeetingRoomRequest The aggregateMeetingRoomRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return SellerInventoryMeetingRoom
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryMeetingRoom> oauth2ShowPropertyMeetingRoom(AggregateMeetingRoomRequest aggregateMeetingRoomRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryMeetingRoom> localVarReturnType = new ParameterizedTypeReference<SellerInventoryMeetingRoom>() {};
        return oauth2ShowPropertyMeetingRoomRequestCreation(aggregateMeetingRoomRequest, engineConfigurationIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryMeetingRoom>> oauth2ShowPropertyMeetingRoomWithHttpInfo(AggregateMeetingRoomRequest aggregateMeetingRoomRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryMeetingRoom> localVarReturnType = new ParameterizedTypeReference<SellerInventoryMeetingRoom>() {};
        return oauth2ShowPropertyMeetingRoomRequestCreation(aggregateMeetingRoomRequest, engineConfigurationIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Package
     * Show single package based on a channel inventory identifier
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param aggregatePackageRequest The aggregatePackageRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return SellerInventoryPackage
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowPropertyPackageRequestCreation(AggregatePackageRequest aggregatePackageRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        Object postBody = aggregatePackageRequest;
        // verify the required parameter 'aggregatePackageRequest' is set
        if (aggregatePackageRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregatePackageRequest' when calling oauth2ShowPropertyPackage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<SellerInventoryPackage> localVarReturnType = new ParameterizedTypeReference<SellerInventoryPackage>() {};
        return apiClient.invokeAPI("/api/inventory/bundle", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Package
     * Show single package based on a channel inventory identifier
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param aggregatePackageRequest The aggregatePackageRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return SellerInventoryPackage
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryPackage> oauth2ShowPropertyPackage(AggregatePackageRequest aggregatePackageRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryPackage> localVarReturnType = new ParameterizedTypeReference<SellerInventoryPackage>() {};
        return oauth2ShowPropertyPackageRequestCreation(aggregatePackageRequest, engineConfigurationIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryPackage>> oauth2ShowPropertyPackageWithHttpInfo(AggregatePackageRequest aggregatePackageRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryPackage> localVarReturnType = new ParameterizedTypeReference<SellerInventoryPackage>() {};
        return oauth2ShowPropertyPackageRequestCreation(aggregatePackageRequest, engineConfigurationIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Place
     * Show single place based on a channel inventory identifier
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param aggregatePlaceRequest The aggregatePlaceRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return SellerInventoryPlace
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowPropertyPlaceRequestCreation(AggregatePlaceRequest aggregatePlaceRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        Object postBody = aggregatePlaceRequest;
        // verify the required parameter 'aggregatePlaceRequest' is set
        if (aggregatePlaceRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregatePlaceRequest' when calling oauth2ShowPropertyPlace", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<SellerInventoryPlace> localVarReturnType = new ParameterizedTypeReference<SellerInventoryPlace>() {};
        return apiClient.invokeAPI("/api/inventory/place", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Place
     * Show single place based on a channel inventory identifier
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param aggregatePlaceRequest The aggregatePlaceRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return SellerInventoryPlace
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryPlace> oauth2ShowPropertyPlace(AggregatePlaceRequest aggregatePlaceRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryPlace> localVarReturnType = new ParameterizedTypeReference<SellerInventoryPlace>() {};
        return oauth2ShowPropertyPlaceRequestCreation(aggregatePlaceRequest, engineConfigurationIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryPlace>> oauth2ShowPropertyPlaceWithHttpInfo(AggregatePlaceRequest aggregatePlaceRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryPlace> localVarReturnType = new ParameterizedTypeReference<SellerInventoryPlace>() {};
        return oauth2ShowPropertyPlaceRequestCreation(aggregatePlaceRequest, engineConfigurationIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Activity
     * Show single activity based on a channel inventory identifier
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param aggregateActivityRequest The aggregateActivityRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return SellerInventoryActivity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowPropertyRecreationRequestCreation(AggregateActivityRequest aggregateActivityRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        Object postBody = aggregateActivityRequest;
        // verify the required parameter 'aggregateActivityRequest' is set
        if (aggregateActivityRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateActivityRequest' when calling oauth2ShowPropertyRecreation", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<SellerInventoryActivity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryActivity>() {};
        return apiClient.invokeAPI("/api/inventory/activity", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Activity
     * Show single activity based on a channel inventory identifier
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param aggregateActivityRequest The aggregateActivityRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return SellerInventoryActivity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryActivity> oauth2ShowPropertyRecreation(AggregateActivityRequest aggregateActivityRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryActivity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryActivity>() {};
        return oauth2ShowPropertyRecreationRequestCreation(aggregateActivityRequest, engineConfigurationIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryActivity>> oauth2ShowPropertyRecreationWithHttpInfo(AggregateActivityRequest aggregateActivityRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryActivity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryActivity>() {};
        return oauth2ShowPropertyRecreationRequestCreation(aggregateActivityRequest, engineConfigurationIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Restaurant
     * Show single restaurant based on a channel inventory identifier
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param aggregateRestaurantRequest The aggregateRestaurantRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return SellerInventoryRestaurant
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowPropertyRestaurantRequestCreation(AggregateRestaurantRequest aggregateRestaurantRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        Object postBody = aggregateRestaurantRequest;
        // verify the required parameter 'aggregateRestaurantRequest' is set
        if (aggregateRestaurantRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateRestaurantRequest' when calling oauth2ShowPropertyRestaurant", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<SellerInventoryRestaurant> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRestaurant>() {};
        return apiClient.invokeAPI("/api/inventory/restaurant", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Restaurant
     * Show single restaurant based on a channel inventory identifier
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param aggregateRestaurantRequest The aggregateRestaurantRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return SellerInventoryRestaurant
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryRestaurant> oauth2ShowPropertyRestaurant(AggregateRestaurantRequest aggregateRestaurantRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRestaurant> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRestaurant>() {};
        return oauth2ShowPropertyRestaurantRequestCreation(aggregateRestaurantRequest, engineConfigurationIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryRestaurant>> oauth2ShowPropertyRestaurantWithHttpInfo(AggregateRestaurantRequest aggregateRestaurantRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRestaurant> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRestaurant>() {};
        return oauth2ShowPropertyRestaurantRequestCreation(aggregateRestaurantRequest, engineConfigurationIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Guest Room
     * Show single guest room based on a channel inventory identifier
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param aggregateGuestRoomRequest The aggregateGuestRoomRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return SellerInventoryGuestRoom
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowPropertyRoomTypeRequestCreation(AggregateGuestRoomRequest aggregateGuestRoomRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        Object postBody = aggregateGuestRoomRequest;
        // verify the required parameter 'aggregateGuestRoomRequest' is set
        if (aggregateGuestRoomRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateGuestRoomRequest' when calling oauth2ShowPropertyRoomType", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<SellerInventoryGuestRoom> localVarReturnType = new ParameterizedTypeReference<SellerInventoryGuestRoom>() {};
        return apiClient.invokeAPI("/api/inventory/guestroom", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Guest Room
     * Show single guest room based on a channel inventory identifier
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param aggregateGuestRoomRequest The aggregateGuestRoomRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return SellerInventoryGuestRoom
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryGuestRoom> oauth2ShowPropertyRoomType(AggregateGuestRoomRequest aggregateGuestRoomRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryGuestRoom> localVarReturnType = new ParameterizedTypeReference<SellerInventoryGuestRoom>() {};
        return oauth2ShowPropertyRoomTypeRequestCreation(aggregateGuestRoomRequest, engineConfigurationIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryGuestRoom>> oauth2ShowPropertyRoomTypeWithHttpInfo(AggregateGuestRoomRequest aggregateGuestRoomRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryGuestRoom> localVarReturnType = new ParameterizedTypeReference<SellerInventoryGuestRoom>() {};
        return oauth2ShowPropertyRoomTypeRequestCreation(aggregateGuestRoomRequest, engineConfigurationIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Spa
     * Show single spa based on a channel inventory identifier
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param aggregateSpaRequest The aggregateSpaRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return SellerInventorySpa
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowPropertySpaRequestCreation(AggregateSpaRequest aggregateSpaRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        Object postBody = aggregateSpaRequest;
        // verify the required parameter 'aggregateSpaRequest' is set
        if (aggregateSpaRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateSpaRequest' when calling oauth2ShowPropertySpa", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<SellerInventorySpa> localVarReturnType = new ParameterizedTypeReference<SellerInventorySpa>() {};
        return apiClient.invokeAPI("/api/inventory/spa", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Spa
     * Show single spa based on a channel inventory identifier
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param aggregateSpaRequest The aggregateSpaRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return SellerInventorySpa
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventorySpa> oauth2ShowPropertySpa(AggregateSpaRequest aggregateSpaRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventorySpa> localVarReturnType = new ParameterizedTypeReference<SellerInventorySpa>() {};
        return oauth2ShowPropertySpaRequestCreation(aggregateSpaRequest, engineConfigurationIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventorySpa>> oauth2ShowPropertySpaWithHttpInfo(AggregateSpaRequest aggregateSpaRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventorySpa> localVarReturnType = new ParameterizedTypeReference<SellerInventorySpa>() {};
        return oauth2ShowPropertySpaRequestCreation(aggregateSpaRequest, engineConfigurationIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Inventories
     * Shows page of inventory items
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param aggregateSellerInventoryListRequest The aggregateSellerInventoryListRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return SellerInventoryListResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowSellerInventoryListRequestCreation(AggregateSellerInventoryListRequest aggregateSellerInventoryListRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        Object postBody = aggregateSellerInventoryListRequest;
        // verify the required parameter 'aggregateSellerInventoryListRequest' is set
        if (aggregateSellerInventoryListRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateSellerInventoryListRequest' when calling oauth2ShowSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<SellerInventoryListResponse> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListResponse>() {};
        return apiClient.invokeAPI("/api/inventory/grid", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Inventories
     * Shows page of inventory items
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param aggregateSellerInventoryListRequest The aggregateSellerInventoryListRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return SellerInventoryListResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryListResponse> oauth2ShowSellerInventoryList(AggregateSellerInventoryListRequest aggregateSellerInventoryListRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListResponse> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListResponse>() {};
        return oauth2ShowSellerInventoryListRequestCreation(aggregateSellerInventoryListRequest, engineConfigurationIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryListResponse>> oauth2ShowSellerInventoryListWithHttpInfo(AggregateSellerInventoryListRequest aggregateSellerInventoryListRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListResponse> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListResponse>() {};
        return oauth2ShowSellerInventoryListRequestCreation(aggregateSellerInventoryListRequest, engineConfigurationIdentifier, accept).toEntity(localVarReturnType);
    }
    /**
     * Show Ranked Inventories
     * Shows a paginated list of ranked inventory.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param aggregateSellerInventoryListRequest The aggregateSellerInventoryListRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return SellerInventoryRankedListResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowSellerInventoryRankedListRequestCreation(AggregateSellerInventoryListRequest aggregateSellerInventoryListRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        Object postBody = aggregateSellerInventoryListRequest;
        // verify the required parameter 'aggregateSellerInventoryListRequest' is set
        if (aggregateSellerInventoryListRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateSellerInventoryListRequest' when calling oauth2ShowSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*", "application/hal+json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<SellerInventoryRankedListResponse> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListResponse>() {};
        return apiClient.invokeAPI("/api/inventory/ranked/grid", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Ranked Inventories
     * Shows a paginated list of ranked inventory.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>200</b> - OK
     * @param aggregateSellerInventoryListRequest The aggregateSellerInventoryListRequest parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param accept The accept parameter
     * @return SellerInventoryRankedListResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryRankedListResponse> oauth2ShowSellerInventoryRankedList(AggregateSellerInventoryListRequest aggregateSellerInventoryListRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRankedListResponse> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListResponse>() {};
        return oauth2ShowSellerInventoryRankedListRequestCreation(aggregateSellerInventoryListRequest, engineConfigurationIdentifier, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryRankedListResponse>> oauth2ShowSellerInventoryRankedListWithHttpInfo(AggregateSellerInventoryListRequest aggregateSellerInventoryListRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRankedListResponse> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListResponse>() {};
        return oauth2ShowSellerInventoryRankedListRequestCreation(aggregateSellerInventoryListRequest, engineConfigurationIdentifier, accept).toEntity(localVarReturnType);
    }
}
