/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our payment.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Booking Engine API Welcome to the Booking Engine API - A programmer-friendly way to search for bespoke travel inventory and create bookings for you or your customers. We take great care in only working with properties that have quality, curated content and ways to upsell and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 20.0.1-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.engine.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import travel.wink.sdk.booking.engine.model.UserSession;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * HotelInventoryRequest
 */
@JsonPropertyOrder({
  HotelInventoryRequest.JSON_PROPERTY_HOTEL_IDENTIFIER,
  HotelInventoryRequest.JSON_PROPERTY_URL_NAME,
  HotelInventoryRequest.JSON_PROPERTY_SHOW_HOTEL,
  HotelInventoryRequest.JSON_PROPERTY_SHOW_METADATA,
  HotelInventoryRequest.JSON_PROPERTY_SHOW_VIDEOS,
  HotelInventoryRequest.JSON_PROPERTY_SHOW_IMAGES,
  HotelInventoryRequest.JSON_PROPERTY_SHOW_ROOM_TYPES,
  HotelInventoryRequest.JSON_PROPERTY_SHOW_PACKAGE_OFFERS,
  HotelInventoryRequest.JSON_PROPERTY_SHOW_ADD_ON_OFFERS,
  HotelInventoryRequest.JSON_PROPERTY_SHOW_RESTAURANTS,
  HotelInventoryRequest.JSON_PROPERTY_SHOW_MEETING_ROOMS,
  HotelInventoryRequest.JSON_PROPERTY_SHOW_SPAS,
  HotelInventoryRequest.JSON_PROPERTY_SHOW_ATTRACTIONS,
  HotelInventoryRequest.JSON_PROPERTY_SHOW_ACTIVITIES,
  HotelInventoryRequest.JSON_PROPERTY_SHOW_PLACES,
  HotelInventoryRequest.JSON_PROPERTY_SHOW_RECOGNITION,
  HotelInventoryRequest.JSON_PROPERTY_SHOW_AGGREGATE_GREEN_INDEX_SCORES,
  HotelInventoryRequest.JSON_PROPERTY_SHOW_ANNOUNCEMENTS,
  HotelInventoryRequest.JSON_PROPERTY_SHOW_REVIEWS,
  HotelInventoryRequest.JSON_PROPERTY_USER_SESSION
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-06-05T13:54:07.858909+07:00[Asia/Bangkok]")
public class HotelInventoryRequest {
  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private String hotelIdentifier;

  public static final String JSON_PROPERTY_URL_NAME = "urlName";
  private String urlName;

  public static final String JSON_PROPERTY_SHOW_HOTEL = "showHotel";
  private Boolean showHotel = true;

  public static final String JSON_PROPERTY_SHOW_METADATA = "showMetadata";
  private Boolean showMetadata = true;

  public static final String JSON_PROPERTY_SHOW_VIDEOS = "showVideos";
  private Boolean showVideos = false;

  public static final String JSON_PROPERTY_SHOW_IMAGES = "showImages";
  private Boolean showImages = false;

  public static final String JSON_PROPERTY_SHOW_ROOM_TYPES = "showRoomTypes";
  private Boolean showRoomTypes = true;

  public static final String JSON_PROPERTY_SHOW_PACKAGE_OFFERS = "showPackageOffers";
  private Boolean showPackageOffers = false;

  public static final String JSON_PROPERTY_SHOW_ADD_ON_OFFERS = "showAddOnOffers";
  private Boolean showAddOnOffers = false;

  public static final String JSON_PROPERTY_SHOW_RESTAURANTS = "showRestaurants";
  private Boolean showRestaurants = false;

  public static final String JSON_PROPERTY_SHOW_MEETING_ROOMS = "showMeetingRooms";
  private Boolean showMeetingRooms = false;

  public static final String JSON_PROPERTY_SHOW_SPAS = "showSpas";
  private Boolean showSpas = false;

  public static final String JSON_PROPERTY_SHOW_ATTRACTIONS = "showAttractions";
  private Boolean showAttractions = false;

  public static final String JSON_PROPERTY_SHOW_ACTIVITIES = "showActivities";
  private Boolean showActivities = false;

  public static final String JSON_PROPERTY_SHOW_PLACES = "showPlaces";
  private Boolean showPlaces = false;

  public static final String JSON_PROPERTY_SHOW_RECOGNITION = "showRecognition";
  private Boolean showRecognition = false;

  public static final String JSON_PROPERTY_SHOW_AGGREGATE_GREEN_INDEX_SCORES = "showAggregateGreenIndexScores";
  private Boolean showAggregateGreenIndexScores = false;

  public static final String JSON_PROPERTY_SHOW_ANNOUNCEMENTS = "showAnnouncements";
  private Boolean showAnnouncements = false;

  public static final String JSON_PROPERTY_SHOW_REVIEWS = "showReviews";
  private Boolean showReviews = false;

  public static final String JSON_PROPERTY_USER_SESSION = "userSession";
  private UserSession userSession;

  public HotelInventoryRequest() { 
  }

  public HotelInventoryRequest hotelIdentifier(String hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Unique property identifier to retrieve inventory for. Either the hotelIdentifier or urlName property is required.
   * @return hotelIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "hotel-1", value = "Unique property identifier to retrieve inventory for. Either the hotelIdentifier or urlName property is required.")
  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelIdentifier(String hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public HotelInventoryRequest urlName(String urlName) {
    
    this.urlName = urlName;
    return this;
  }

   /**
   * Unique url-friendly record identifier of property. Either the hotelIdentifier or urlName property is required.
   * @return urlName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "the-most-fantastic-hotel", value = "Unique url-friendly record identifier of property. Either the hotelIdentifier or urlName property is required.")
  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUrlName() {
    return urlName;
  }


  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUrlName(String urlName) {
    this.urlName = urlName;
  }


  public HotelInventoryRequest showHotel(Boolean showHotel) {
    
    this.showHotel = showHotel;
    return this;
  }

   /**
   * Flag to indicate whether to return basic property data. If you are loading up property for the first time, this data would be good to include. But there is no need to load that a second time if you are only going for availability data. This field populates &#x60;hotel&#x60; data in response.
   * @return showHotel
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Flag to indicate whether to return basic property data. If you are loading up property for the first time, this data would be good to include. But there is no need to load that a second time if you are only going for availability data. This field populates `hotel` data in response.")
  @JsonProperty(JSON_PROPERTY_SHOW_HOTEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowHotel() {
    return showHotel;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_HOTEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowHotel(Boolean showHotel) {
    this.showHotel = showHotel;
  }


  public HotelInventoryRequest showMetadata(Boolean showMetadata) {
    
    this.showMetadata = showMetadata;
    return this;
  }

   /**
   * Flag to indicate whether to return property meta data. This field populates &#x60;metadata&#x60; data in response.
   * @return showMetadata
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Flag to indicate whether to return property meta data. This field populates `metadata` data in response.")
  @JsonProperty(JSON_PROPERTY_SHOW_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowMetadata() {
    return showMetadata;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowMetadata(Boolean showMetadata) {
    this.showMetadata = showMetadata;
  }


  public HotelInventoryRequest showVideos(Boolean showVideos) {
    
    this.showVideos = showVideos;
    return this;
  }

   /**
   * Flag to indicate whether to return property video data. This field populates &#x60;videos&#x60; data in response.
   * @return showVideos
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Flag to indicate whether to return property video data. This field populates `videos` data in response.")
  @JsonProperty(JSON_PROPERTY_SHOW_VIDEOS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowVideos() {
    return showVideos;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_VIDEOS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowVideos(Boolean showVideos) {
    this.showVideos = showVideos;
  }


  public HotelInventoryRequest showImages(Boolean showImages) {
    
    this.showImages = showImages;
    return this;
  }

   /**
   * Flag to indicate whether to return property image data. This field populates &#x60;images&#x60; data in response.
   * @return showImages
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Flag to indicate whether to return property image data. This field populates `images` data in response.")
  @JsonProperty(JSON_PROPERTY_SHOW_IMAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowImages() {
    return showImages;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_IMAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowImages(Boolean showImages) {
    this.showImages = showImages;
  }


  public HotelInventoryRequest showRoomTypes(Boolean showRoomTypes) {
    
    this.showRoomTypes = showRoomTypes;
    return this;
  }

   /**
   * Flag to indicate whether to return property room type data. This field populates &#x60;roomType&#x60;, &#x60;cheapesRoomTypes&#x60; and &#x60;available&#x60; data in response.
   * @return showRoomTypes
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Flag to indicate whether to return property room type data. This field populates `roomType`, `cheapesRoomTypes` and `available` data in response.")
  @JsonProperty(JSON_PROPERTY_SHOW_ROOM_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowRoomTypes() {
    return showRoomTypes;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_ROOM_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowRoomTypes(Boolean showRoomTypes) {
    this.showRoomTypes = showRoomTypes;
  }


  public HotelInventoryRequest showPackageOffers(Boolean showPackageOffers) {
    
    this.showPackageOffers = showPackageOffers;
    return this;
  }

   /**
   * Flag to indicate whether to return property package offer data. This field populates &#x60;roomTypes.priceConfigurations.packageOffers&#x60; data in response.
   * @return showPackageOffers
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Flag to indicate whether to return property package offer data. This field populates `roomTypes.priceConfigurations.packageOffers` data in response.")
  @JsonProperty(JSON_PROPERTY_SHOW_PACKAGE_OFFERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowPackageOffers() {
    return showPackageOffers;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_PACKAGE_OFFERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowPackageOffers(Boolean showPackageOffers) {
    this.showPackageOffers = showPackageOffers;
  }


  public HotelInventoryRequest showAddOnOffers(Boolean showAddOnOffers) {
    
    this.showAddOnOffers = showAddOnOffers;
    return this;
  }

   /**
   * Flag to indicate whether to return property add-on data. This field populates &#x60;roomTypes.priceConfigurations.addOnOffers&#x60; data in response.
   * @return showAddOnOffers
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Flag to indicate whether to return property add-on data. This field populates `roomTypes.priceConfigurations.addOnOffers` data in response.")
  @JsonProperty(JSON_PROPERTY_SHOW_ADD_ON_OFFERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowAddOnOffers() {
    return showAddOnOffers;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_ADD_ON_OFFERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowAddOnOffers(Boolean showAddOnOffers) {
    this.showAddOnOffers = showAddOnOffers;
  }


  public HotelInventoryRequest showRestaurants(Boolean showRestaurants) {
    
    this.showRestaurants = showRestaurants;
    return this;
  }

   /**
   * Flag to indicate whether to return property restaurant data. This field populates &#x60;restaurants&#x60; data in response.
   * @return showRestaurants
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Flag to indicate whether to return property restaurant data. This field populates `restaurants` data in response.")
  @JsonProperty(JSON_PROPERTY_SHOW_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowRestaurants() {
    return showRestaurants;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowRestaurants(Boolean showRestaurants) {
    this.showRestaurants = showRestaurants;
  }


  public HotelInventoryRequest showMeetingRooms(Boolean showMeetingRooms) {
    
    this.showMeetingRooms = showMeetingRooms;
    return this;
  }

   /**
   * Flag to indicate whether to return property meeting room data. This field populates &#x60;meetingRooms&#x60; data in response.
   * @return showMeetingRooms
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Flag to indicate whether to return property meeting room data. This field populates `meetingRooms` data in response.")
  @JsonProperty(JSON_PROPERTY_SHOW_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowMeetingRooms() {
    return showMeetingRooms;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowMeetingRooms(Boolean showMeetingRooms) {
    this.showMeetingRooms = showMeetingRooms;
  }


  public HotelInventoryRequest showSpas(Boolean showSpas) {
    
    this.showSpas = showSpas;
    return this;
  }

   /**
   * Flag to indicate whether to return property spa data. This field populates &#x60;spas&#x60; data in response.
   * @return showSpas
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Flag to indicate whether to return property spa data. This field populates `spas` data in response.")
  @JsonProperty(JSON_PROPERTY_SHOW_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowSpas() {
    return showSpas;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowSpas(Boolean showSpas) {
    this.showSpas = showSpas;
  }


  public HotelInventoryRequest showAttractions(Boolean showAttractions) {
    
    this.showAttractions = showAttractions;
    return this;
  }

   /**
   * Flag to indicate whether to return property attraction data. This field populates &#x60;attractions&#x60; data in response.
   * @return showAttractions
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Flag to indicate whether to return property attraction data. This field populates `attractions` data in response.")
  @JsonProperty(JSON_PROPERTY_SHOW_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowAttractions() {
    return showAttractions;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowAttractions(Boolean showAttractions) {
    this.showAttractions = showAttractions;
  }


  public HotelInventoryRequest showActivities(Boolean showActivities) {
    
    this.showActivities = showActivities;
    return this;
  }

   /**
   * Flag to indicate whether to return property activity data. This field populates &#x60;activities&#x60; data in response.
   * @return showActivities
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Flag to indicate whether to return property activity data. This field populates `activities` data in response.")
  @JsonProperty(JSON_PROPERTY_SHOW_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowActivities() {
    return showActivities;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowActivities(Boolean showActivities) {
    this.showActivities = showActivities;
  }


  public HotelInventoryRequest showPlaces(Boolean showPlaces) {
    
    this.showPlaces = showPlaces;
    return this;
  }

   /**
   * Flag to indicate whether to return property place data. This field populates &#x60;places&#x60; data in response.
   * @return showPlaces
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Flag to indicate whether to return property place data. This field populates `places` data in response.")
  @JsonProperty(JSON_PROPERTY_SHOW_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowPlaces() {
    return showPlaces;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowPlaces(Boolean showPlaces) {
    this.showPlaces = showPlaces;
  }


  public HotelInventoryRequest showRecognition(Boolean showRecognition) {
    
    this.showRecognition = showRecognition;
    return this;
  }

   /**
   * Flag to indicate whether to return property recognition data. This field populates &#x60;recognitions&#x60; data in response.
   * @return showRecognition
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Flag to indicate whether to return property recognition data. This field populates `recognitions` data in response.")
  @JsonProperty(JSON_PROPERTY_SHOW_RECOGNITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowRecognition() {
    return showRecognition;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_RECOGNITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowRecognition(Boolean showRecognition) {
    this.showRecognition = showRecognition;
  }


  public HotelInventoryRequest showAggregateGreenIndexScores(Boolean showAggregateGreenIndexScores) {
    
    this.showAggregateGreenIndexScores = showAggregateGreenIndexScores;
    return this;
  }

   /**
   * Flag to indicate whether to return property green index score data. This field populates &#x60;greenIndexScores&#x60; data in response. Note: You only need to return hotel data to get the overall aggregate Green Index score and not detailed category scores.
   * @return showAggregateGreenIndexScores
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Flag to indicate whether to return property green index score data. This field populates `greenIndexScores` data in response. Note: You only need to return hotel data to get the overall aggregate Green Index score and not detailed category scores.")
  @JsonProperty(JSON_PROPERTY_SHOW_AGGREGATE_GREEN_INDEX_SCORES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowAggregateGreenIndexScores() {
    return showAggregateGreenIndexScores;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_AGGREGATE_GREEN_INDEX_SCORES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowAggregateGreenIndexScores(Boolean showAggregateGreenIndexScores) {
    this.showAggregateGreenIndexScores = showAggregateGreenIndexScores;
  }


  public HotelInventoryRequest showAnnouncements(Boolean showAnnouncements) {
    
    this.showAnnouncements = showAnnouncements;
    return this;
  }

   /**
   * Flag to indicate whether to return property announcement data. Announcements are messages the property wishes to convey to travelers for certain dates. This field populates &#x60;announcements&#x60; data in response.
   * @return showAnnouncements
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Flag to indicate whether to return property announcement data. Announcements are messages the property wishes to convey to travelers for certain dates. This field populates `announcements` data in response.")
  @JsonProperty(JSON_PROPERTY_SHOW_ANNOUNCEMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowAnnouncements() {
    return showAnnouncements;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_ANNOUNCEMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowAnnouncements(Boolean showAnnouncements) {
    this.showAnnouncements = showAnnouncements;
  }


  public HotelInventoryRequest showReviews(Boolean showReviews) {
    
    this.showReviews = showReviews;
    return this;
  }

   /**
   * Flag to indicate whether to return property review data. Note: You only need to return hotel data to get the overall aggregate review score and not the entire list of reviews. This field populates &#x60;reviews&#x60; data in response.
   * @return showReviews
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Flag to indicate whether to return property review data. Note: You only need to return hotel data to get the overall aggregate review score and not the entire list of reviews. This field populates `reviews` data in response.")
  @JsonProperty(JSON_PROPERTY_SHOW_REVIEWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowReviews() {
    return showReviews;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_REVIEWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowReviews(Boolean showReviews) {
    this.showReviews = showReviews;
  }


  public HotelInventoryRequest userSession(UserSession userSession) {
    
    this.userSession = userSession;
    return this;
  }

   /**
   * Get userSession
   * @return userSession
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_USER_SESSION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UserSession getUserSession() {
    return userSession;
  }


  @JsonProperty(JSON_PROPERTY_USER_SESSION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUserSession(UserSession userSession) {
    this.userSession = userSession;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HotelInventoryRequest hotelInventoryRequest = (HotelInventoryRequest) o;
    return Objects.equals(this.hotelIdentifier, hotelInventoryRequest.hotelIdentifier) &&
        Objects.equals(this.urlName, hotelInventoryRequest.urlName) &&
        Objects.equals(this.showHotel, hotelInventoryRequest.showHotel) &&
        Objects.equals(this.showMetadata, hotelInventoryRequest.showMetadata) &&
        Objects.equals(this.showVideos, hotelInventoryRequest.showVideos) &&
        Objects.equals(this.showImages, hotelInventoryRequest.showImages) &&
        Objects.equals(this.showRoomTypes, hotelInventoryRequest.showRoomTypes) &&
        Objects.equals(this.showPackageOffers, hotelInventoryRequest.showPackageOffers) &&
        Objects.equals(this.showAddOnOffers, hotelInventoryRequest.showAddOnOffers) &&
        Objects.equals(this.showRestaurants, hotelInventoryRequest.showRestaurants) &&
        Objects.equals(this.showMeetingRooms, hotelInventoryRequest.showMeetingRooms) &&
        Objects.equals(this.showSpas, hotelInventoryRequest.showSpas) &&
        Objects.equals(this.showAttractions, hotelInventoryRequest.showAttractions) &&
        Objects.equals(this.showActivities, hotelInventoryRequest.showActivities) &&
        Objects.equals(this.showPlaces, hotelInventoryRequest.showPlaces) &&
        Objects.equals(this.showRecognition, hotelInventoryRequest.showRecognition) &&
        Objects.equals(this.showAggregateGreenIndexScores, hotelInventoryRequest.showAggregateGreenIndexScores) &&
        Objects.equals(this.showAnnouncements, hotelInventoryRequest.showAnnouncements) &&
        Objects.equals(this.showReviews, hotelInventoryRequest.showReviews) &&
        Objects.equals(this.userSession, hotelInventoryRequest.userSession);
  }

  @Override
  public int hashCode() {
    return Objects.hash(hotelIdentifier, urlName, showHotel, showMetadata, showVideos, showImages, showRoomTypes, showPackageOffers, showAddOnOffers, showRestaurants, showMeetingRooms, showSpas, showAttractions, showActivities, showPlaces, showRecognition, showAggregateGreenIndexScores, showAnnouncements, showReviews, userSession);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HotelInventoryRequest {\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    urlName: ").append(toIndentedString(urlName)).append("\n");
    sb.append("    showHotel: ").append(toIndentedString(showHotel)).append("\n");
    sb.append("    showMetadata: ").append(toIndentedString(showMetadata)).append("\n");
    sb.append("    showVideos: ").append(toIndentedString(showVideos)).append("\n");
    sb.append("    showImages: ").append(toIndentedString(showImages)).append("\n");
    sb.append("    showRoomTypes: ").append(toIndentedString(showRoomTypes)).append("\n");
    sb.append("    showPackageOffers: ").append(toIndentedString(showPackageOffers)).append("\n");
    sb.append("    showAddOnOffers: ").append(toIndentedString(showAddOnOffers)).append("\n");
    sb.append("    showRestaurants: ").append(toIndentedString(showRestaurants)).append("\n");
    sb.append("    showMeetingRooms: ").append(toIndentedString(showMeetingRooms)).append("\n");
    sb.append("    showSpas: ").append(toIndentedString(showSpas)).append("\n");
    sb.append("    showAttractions: ").append(toIndentedString(showAttractions)).append("\n");
    sb.append("    showActivities: ").append(toIndentedString(showActivities)).append("\n");
    sb.append("    showPlaces: ").append(toIndentedString(showPlaces)).append("\n");
    sb.append("    showRecognition: ").append(toIndentedString(showRecognition)).append("\n");
    sb.append("    showAggregateGreenIndexScores: ").append(toIndentedString(showAggregateGreenIndexScores)).append("\n");
    sb.append("    showAnnouncements: ").append(toIndentedString(showAnnouncements)).append("\n");
    sb.append("    showReviews: ").append(toIndentedString(showReviews)).append("\n");
    sb.append("    userSession: ").append(toIndentedString(userSession)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

