/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.booking.engine.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.booking.engine.invoker.ApiClient;
import travel.wink.sdk.booking.engine.model.Lookup;
import travel.wink.sdk.booking.engine.model.LookupCached;

public class LookupApi {
    private ApiClient apiClient;

    public LookupApi() {
        this(new ApiClient());
    }

    @Autowired
    public LookupApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec oauth2SearchSuggestionsRequestCreation(String term, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (term == null) {
            throw new WebClientResponseException("Missing the required parameter 'term' when calling oauth2SearchSuggestions", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "term", term));
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<LookupCached> localVarReturnType = new ParameterizedTypeReference<LookupCached>(){};
        return this.apiClient.invokeAPI("/api/search", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<LookupCached> oauth2SearchSuggestions(String term, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<LookupCached> localVarReturnType = new ParameterizedTypeReference<LookupCached>(){};
        return this.oauth2SearchSuggestionsRequestCreation(term, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<LookupCached>>> oauth2SearchSuggestionsWithHttpInfo(String term, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<LookupCached> localVarReturnType = new ParameterizedTypeReference<LookupCached>(){};
        return this.oauth2SearchSuggestionsRequestCreation(term, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec oauth2ShowLookupRequestCreation(String urlName, String type, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (urlName == null) {
            throw new WebClientResponseException("Missing the required parameter 'urlName' when calling oauth2ShowLookup", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (type == null) {
            throw new WebClientResponseException("Missing the required parameter 'type' when calling oauth2ShowLookup", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("urlName", urlName);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "type", type));
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "application/hal+json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<Lookup> localVarReturnType = new ParameterizedTypeReference<Lookup>(){};
        return this.apiClient.invokeAPI("/api/lookup/{urlName}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Lookup> oauth2ShowLookup(String urlName, String type, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Lookup> localVarReturnType = new ParameterizedTypeReference<Lookup>(){};
        return this.oauth2ShowLookupRequestCreation(urlName, type, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Lookup>> oauth2ShowLookupWithHttpInfo(String urlName, String type, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Lookup> localVarReturnType = new ParameterizedTypeReference<Lookup>(){};
        return this.oauth2ShowLookupRequestCreation(urlName, type, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

