/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.booking.engine.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.booking.engine.model.RoomConfiguration;

@ApiModel(description="Itinerary")
@JsonPropertyOrder(value={"startDate", "endDate", "items", "children", "valid", "guests", "rooms", "nights"})
public class Itinerary {
    public static final String JSON_PROPERTY_START_DATE = "startDate";
    private LocalDate startDate;
    public static final String JSON_PROPERTY_END_DATE = "endDate";
    private LocalDate endDate;
    public static final String JSON_PROPERTY_ITEMS = "items";
    private List<RoomConfiguration> items = new ArrayList<RoomConfiguration>();
    public static final String JSON_PROPERTY_CHILDREN = "children";
    private Integer children;
    public static final String JSON_PROPERTY_VALID = "valid";
    private Boolean valid;
    public static final String JSON_PROPERTY_GUESTS = "guests";
    private Integer guests;
    public static final String JSON_PROPERTY_ROOMS = "rooms";
    private Integer rooms;
    public static final String JSON_PROPERTY_NIGHTS = "nights";
    private Integer nights;

    public Itinerary() {
    }

    @JsonCreator
    public Itinerary(@JsonProperty(value="children") Integer children, @JsonProperty(value="valid") Boolean valid, @JsonProperty(value="guests") Integer guests, @JsonProperty(value="rooms") Integer rooms, @JsonProperty(value="nights") Integer nights) {
        this();
        this.children = children;
        this.valid = valid;
        this.guests = guests;
        this.rooms = rooms;
        this.nights = nights;
    }

    public Itinerary startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Start date")
    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public Itinerary endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="End date")
    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public Itinerary items(List<RoomConfiguration> items) {
        this.items = items;
        return this;
    }

    public Itinerary addItemsItem(RoomConfiguration itemsItem) {
        this.items.add(itemsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Room configurations")
    @JsonProperty(value="items")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<RoomConfiguration> getItems() {
        return this.items;
    }

    @JsonProperty(value="items")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setItems(List<RoomConfiguration> items) {
        this.items = items;
    }

    @Nullable
    @ApiModelProperty(value="How many total children for this stay")
    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getChildren() {
        return this.children;
    }

    @Nullable
    @ApiModelProperty(value="Whether this is a valid itinerary")
    @JsonProperty(value="valid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getValid() {
        return this.valid;
    }

    @Nullable
    @ApiModelProperty(value="How many total guests for this stay")
    @JsonProperty(value="guests")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getGuests() {
        return this.guests;
    }

    @Nullable
    @ApiModelProperty(value="How many total rooms for this stay")
    @JsonProperty(value="rooms")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getRooms() {
        return this.rooms;
    }

    @Nullable
    @ApiModelProperty(value="How many total nights for this stay")
    @JsonProperty(value="nights")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getNights() {
        return this.nights;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Itinerary itinerary = (Itinerary)o;
        return Objects.equals(this.startDate, itinerary.startDate) && Objects.equals(this.endDate, itinerary.endDate) && Objects.equals(this.items, itinerary.items) && Objects.equals(this.children, itinerary.children) && Objects.equals(this.valid, itinerary.valid) && Objects.equals(this.guests, itinerary.guests) && Objects.equals(this.rooms, itinerary.rooms) && Objects.equals(this.nights, itinerary.nights);
    }

    public int hashCode() {
        return Objects.hash(this.startDate, this.endDate, this.items, this.children, this.valid, this.guests, this.rooms, this.nights);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Itinerary {\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    children: ").append(this.toIndentedString(this.children)).append("\n");
        sb.append("    valid: ").append(this.toIndentedString(this.valid)).append("\n");
        sb.append("    guests: ").append(this.toIndentedString(this.guests)).append("\n");
        sb.append("    rooms: ").append(this.toIndentedString(this.rooms)).append("\n");
        sb.append("    nights: ").append(this.toIndentedString(this.nights)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

