/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.booking.engine.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import travel.wink.sdk.booking.engine.model.Lookup;
import travel.wink.sdk.booking.engine.model.SimpleDescription;

@ApiModel(description="Identifier inventory record")
@JsonPropertyOrder(value={"identifier", "sellerIdentifier", "sellerInventoryRankedListName", "engineConfigurationIdentifier", "descriptions", "keywords", "status", "lookup", "animate", "animateDelay", "sort", "displayType"})
public class SellerInventoryRankedList {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private String identifier;
    public static final String JSON_PROPERTY_SELLER_IDENTIFIER = "sellerIdentifier";
    private String sellerIdentifier;
    public static final String JSON_PROPERTY_SELLER_INVENTORY_RANKED_LIST_NAME = "sellerInventoryRankedListName";
    private String sellerInventoryRankedListName;
    public static final String JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER = "engineConfigurationIdentifier";
    private String engineConfigurationIdentifier;
    public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
    private List<SimpleDescription> descriptions = new ArrayList<SimpleDescription>();
    public static final String JSON_PROPERTY_KEYWORDS = "keywords";
    private List<String> keywords = new ArrayList<String>();
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status = StatusEnum.ACTIVE;
    public static final String JSON_PROPERTY_LOOKUP = "lookup";
    private Lookup lookup;
    public static final String JSON_PROPERTY_ANIMATE = "animate";
    private Boolean animate = false;
    public static final String JSON_PROPERTY_ANIMATE_DELAY = "animateDelay";
    private Integer animateDelay = -1;
    public static final String JSON_PROPERTY_SORT = "sort";
    private SortEnum sort;
    public static final String JSON_PROPERTY_DISPLAY_TYPE = "displayType";
    private DisplayTypeEnum displayType = DisplayTypeEnum.NATIVE;

    public SellerInventoryRankedList identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="ranked-grid-1", value="Unique identifier")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public SellerInventoryRankedList sellerIdentifier(String sellerIdentifier) {
        this.sellerIdentifier = sellerIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="company-1", value="Company identifier")
    @JsonProperty(value="sellerIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSellerIdentifier() {
        return this.sellerIdentifier;
    }

    @JsonProperty(value="sellerIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSellerIdentifier(String sellerIdentifier) {
        this.sellerIdentifier = sellerIdentifier;
    }

    public SellerInventoryRankedList sellerInventoryRankedListName(String sellerInventoryRankedListName) {
        this.sellerInventoryRankedListName = sellerInventoryRankedListName;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="My ranked list", required=true, value="Descriptive name of this list for seller use only")
    @JsonProperty(value="sellerInventoryRankedListName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSellerInventoryRankedListName() {
        return this.sellerInventoryRankedListName;
    }

    @JsonProperty(value="sellerInventoryRankedListName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSellerInventoryRankedListName(String sellerInventoryRankedListName) {
        this.sellerInventoryRankedListName = sellerInventoryRankedListName;
    }

    public SellerInventoryRankedList engineConfigurationIdentifier(String engineConfigurationIdentifier) {
        this.engineConfigurationIdentifier = engineConfigurationIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="customization-1", required=true, value="Customization identifier")
    @JsonProperty(value="engineConfigurationIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getEngineConfigurationIdentifier() {
        return this.engineConfigurationIdentifier;
    }

    @JsonProperty(value="engineConfigurationIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEngineConfigurationIdentifier(String engineConfigurationIdentifier) {
        this.engineConfigurationIdentifier = engineConfigurationIdentifier;
    }

    public SellerInventoryRankedList descriptions(List<SimpleDescription> descriptions) {
        this.descriptions = descriptions;
        return this;
    }

    public SellerInventoryRankedList addDescriptionsItem(SimpleDescription descriptionsItem) {
        this.descriptions.add(descriptionsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @ApiModelProperty(required=true, value="Contains custom title and description of grid")
    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1, max=0x7FFFFFFF) List<SimpleDescription> getDescriptions() {
        return this.descriptions;
    }

    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescriptions(List<SimpleDescription> descriptions) {
        this.descriptions = descriptions;
    }

    public SellerInventoryRankedList keywords(List<String> keywords) {
        this.keywords = keywords;
        return this;
    }

    public SellerInventoryRankedList addKeywordsItem(String keywordsItem) {
        this.keywords.add(keywordsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1, max=0x7FFFFFFF)
    @ApiModelProperty(example="[\"bali\"]", required=true, value="Keywords is meta data for the grid you created that can be used for SEO purposes.")
    @JsonProperty(value="keywords")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1, max=0x7FFFFFFF) List<String> getKeywords() {
        return this.keywords;
    }

    @JsonProperty(value="keywords")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setKeywords(List<String> keywords) {
        this.keywords = keywords;
    }

    public SellerInventoryRankedList status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="ACTIVE", required=true, value="Status")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public SellerInventoryRankedList lookup(Lookup lookup) {
        this.lookup = lookup;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="lookup")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Lookup getLookup() {
        return this.lookup;
    }

    @JsonProperty(value="lookup")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLookup(Lookup lookup) {
        this.lookup = lookup;
    }

    public SellerInventoryRankedList animate(Boolean animate) {
        this.animate = animate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Create an animated gif instead of a list of images")
    @JsonProperty(value="animate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAnimate() {
        return this.animate;
    }

    @JsonProperty(value="animate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAnimate(Boolean animate) {
        this.animate = animate;
    }

    public SellerInventoryRankedList animateDelay(Integer animateDelay) {
        this.animateDelay = animateDelay;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Controls animation delay in milliseconds. -1 is disabled")
    @JsonProperty(value="animateDelay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getAnimateDelay() {
        return this.animateDelay;
    }

    @JsonProperty(value="animateDelay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAnimateDelay(Integer animateDelay) {
        this.animateDelay = animateDelay;
    }

    public SellerInventoryRankedList sort(SortEnum sort) {
        this.sort = sort;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="MEMBER", required=true, value="Determines which badge to show on the Web Component. Is also used to sort properties for search grids.")
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SortEnum getSort() {
        return this.sort;
    }

    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSort(SortEnum sort) {
        this.sort = sort;
    }

    public SellerInventoryRankedList displayType(DisplayTypeEnum displayType) {
        this.displayType = displayType;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="NATIVE", required=true, value="Indicate which initial values to display first on the front-facing card")
    @JsonProperty(value="displayType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public DisplayTypeEnum getDisplayType() {
        return this.displayType;
    }

    @JsonProperty(value="displayType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayType(DisplayTypeEnum displayType) {
        this.displayType = displayType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SellerInventoryRankedList sellerInventoryRankedList = (SellerInventoryRankedList)o;
        return Objects.equals(this.identifier, sellerInventoryRankedList.identifier) && Objects.equals(this.sellerIdentifier, sellerInventoryRankedList.sellerIdentifier) && Objects.equals(this.sellerInventoryRankedListName, sellerInventoryRankedList.sellerInventoryRankedListName) && Objects.equals(this.engineConfigurationIdentifier, sellerInventoryRankedList.engineConfigurationIdentifier) && Objects.equals(this.descriptions, sellerInventoryRankedList.descriptions) && Objects.equals(this.keywords, sellerInventoryRankedList.keywords) && Objects.equals((Object)this.status, (Object)sellerInventoryRankedList.status) && Objects.equals(this.lookup, sellerInventoryRankedList.lookup) && Objects.equals(this.animate, sellerInventoryRankedList.animate) && Objects.equals(this.animateDelay, sellerInventoryRankedList.animateDelay) && Objects.equals((Object)this.sort, (Object)sellerInventoryRankedList.sort) && Objects.equals((Object)this.displayType, (Object)sellerInventoryRankedList.displayType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.sellerIdentifier, this.sellerInventoryRankedListName, this.engineConfigurationIdentifier, this.descriptions, this.keywords, this.status, this.lookup, this.animate, this.animateDelay, this.sort, this.displayType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SellerInventoryRankedList {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    sellerIdentifier: ").append(this.toIndentedString(this.sellerIdentifier)).append("\n");
        sb.append("    sellerInventoryRankedListName: ").append(this.toIndentedString(this.sellerInventoryRankedListName)).append("\n");
        sb.append("    engineConfigurationIdentifier: ").append(this.toIndentedString(this.engineConfigurationIdentifier)).append("\n");
        sb.append("    descriptions: ").append(this.toIndentedString(this.descriptions)).append("\n");
        sb.append("    keywords: ").append(this.toIndentedString(this.keywords)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    lookup: ").append(this.toIndentedString(this.lookup)).append("\n");
        sb.append("    animate: ").append(this.toIndentedString(this.animate)).append("\n");
        sb.append("    animateDelay: ").append(this.toIndentedString(this.animateDelay)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString((Object)this.sort)).append("\n");
        sb.append("    displayType: ").append(this.toIndentedString((Object)this.displayType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        ACTIVE("ACTIVE"),
        INACTIVE("INACTIVE"),
        REMOVED("REMOVED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum DisplayTypeEnum {
        NATIVE("NATIVE"),
        HOTEL("HOTEL"),
        ROOM("ROOM");

        private String value;

        private DisplayTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DisplayTypeEnum fromValue(String value) {
            for (DisplayTypeEnum b : DisplayTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum SortEnum {
        MEMBER("MEMBER"),
        PRICE_LOW_TO_HIGH("PRICE_LOW_TO_HIGH"),
        PRICE_HIGH_TO_LOW("PRICE_HIGH_TO_LOW"),
        PRICE("PRICE"),
        POPULARITY("POPULARITY"),
        ECO("ECO"),
        EXPERIENCE("EXPERIENCE"),
        PERK("PERK"),
        LOYALTY("LOYALTY"),
        PACKAGE("PACKAGE");

        private String value;

        private SortEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SortEnum fromValue(String value) {
            for (SortEnum b : SortEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

