/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our payment.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Booking Engine API Welcome to the Booking Engine API - A programmer-friendly way to search for bespoke travel inventory and create bookings for you or your customers. We take great care in only working with properties that have quality, curated content and ways to ancillary and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 20.1.2-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.engine.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import travel.wink.sdk.booking.engine.model.ActivityWithBestPrice;
import travel.wink.sdk.booking.engine.model.AddOnWithBestPrice;
import travel.wink.sdk.booking.engine.model.AttractionWithBestPrice;
import travel.wink.sdk.booking.engine.model.HotelWithBestPrice;
import travel.wink.sdk.booking.engine.model.MeetingRoomWithBestPrice;
import travel.wink.sdk.booking.engine.model.PackageWithBestPrice;
import travel.wink.sdk.booking.engine.model.PlaceWithBestPrice;
import travel.wink.sdk.booking.engine.model.RestaurantWithBestPrice;
import travel.wink.sdk.booking.engine.model.SpaWithBestPrice;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * InventoryGridItem
 */
@JsonPropertyOrder({
  InventoryGridItem.JSON_PROPERTY_SORT,
  InventoryGridItem.JSON_PROPERTY_TYPE,
  InventoryGridItem.JSON_PROPERTY_IDENTIFIER,
  InventoryGridItem.JSON_PROPERTY_SUPPLIER_IDENTIFIER,
  InventoryGridItem.JSON_PROPERTY_ACTIVITY,
  InventoryGridItem.JSON_PROPERTY_ATTRACTION,
  InventoryGridItem.JSON_PROPERTY_PLACE,
  InventoryGridItem.JSON_PROPERTY_ROOM_TYPE,
  InventoryGridItem.JSON_PROPERTY_MEETING_ROOM,
  InventoryGridItem.JSON_PROPERTY_RESTAURANT,
  InventoryGridItem.JSON_PROPERTY_SPA,
  InventoryGridItem.JSON_PROPERTY_BUNDLE,
  InventoryGridItem.JSON_PROPERTY_UPGRADE,
  InventoryGridItem.JSON_PROPERTY_AVAILABLE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-06-16T12:47:15.131812+07:00[Asia/Bangkok]")
public class InventoryGridItem {
  public static final String JSON_PROPERTY_SORT = "sort";
  private Integer sort;

  /**
   * The type of inventory this item represents.
   */
  public enum TypeEnum {
    HOTEL("HOTEL"),
    
    GUEST_ROOM("GUEST_ROOM"),
    
    MEETING_ROOM("MEETING_ROOM"),
    
    RESTAURANT("RESTAURANT"),
    
    SPA("SPA"),
    
    PACKAGE("PACKAGE"),
    
    ADD_ON("ADD_ON"),
    
    ATTRACTION("ATTRACTION"),
    
    ACTIVITY("ACTIVITY"),
    
    PLACE("PLACE");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private String identifier;

  public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER = "supplierIdentifier";
  private String supplierIdentifier;

  public static final String JSON_PROPERTY_ACTIVITY = "activity";
  private ActivityWithBestPrice activity;

  public static final String JSON_PROPERTY_ATTRACTION = "attraction";
  private AttractionWithBestPrice attraction;

  public static final String JSON_PROPERTY_PLACE = "place";
  private PlaceWithBestPrice place;

  public static final String JSON_PROPERTY_ROOM_TYPE = "roomType";
  private HotelWithBestPrice roomType;

  public static final String JSON_PROPERTY_MEETING_ROOM = "meetingRoom";
  private MeetingRoomWithBestPrice meetingRoom;

  public static final String JSON_PROPERTY_RESTAURANT = "restaurant";
  private RestaurantWithBestPrice restaurant;

  public static final String JSON_PROPERTY_SPA = "spa";
  private SpaWithBestPrice spa;

  public static final String JSON_PROPERTY_BUNDLE = "bundle";
  private PackageWithBestPrice bundle;

  public static final String JSON_PROPERTY_UPGRADE = "upgrade";
  private AddOnWithBestPrice upgrade;

  public static final String JSON_PROPERTY_AVAILABLE = "available";
  private Boolean available;

  public InventoryGridItem() { 
  }

  public InventoryGridItem sort(Integer sort) {
    
    this.sort = sort;
    return this;
  }

   /**
   * Sort property indicates how this grid item fits in with the rest of the items in the list.
   * @return sort
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1", value = "Sort property indicates how this grid item fits in with the rest of the items in the list.")
  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSort(Integer sort) {
    this.sort = sort;
  }


  public InventoryGridItem type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * The type of inventory this item represents.
   * @return type
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "HOTEL", value = "The type of inventory this item represents.")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public InventoryGridItem identifier(String identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique inventory identifier
   * @return identifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Unique inventory identifier")
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifier(String identifier) {
    this.identifier = identifier;
  }


  public InventoryGridItem supplierIdentifier(String supplierIdentifier) {
    
    this.supplierIdentifier = supplierIdentifier;
    return this;
  }

   /**
   * Supplier identifier referencing inventory owner
   * @return supplierIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "hotel-1", value = "Supplier identifier referencing inventory owner")
  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSupplierIdentifier() {
    return supplierIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupplierIdentifier(String supplierIdentifier) {
    this.supplierIdentifier = supplierIdentifier;
  }


  public InventoryGridItem activity(ActivityWithBestPrice activity) {
    
    this.activity = activity;
    return this;
  }

   /**
   * Get activity
   * @return activity
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ACTIVITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ActivityWithBestPrice getActivity() {
    return activity;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActivity(ActivityWithBestPrice activity) {
    this.activity = activity;
  }


  public InventoryGridItem attraction(AttractionWithBestPrice attraction) {
    
    this.attraction = attraction;
    return this;
  }

   /**
   * Get attraction
   * @return attraction
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ATTRACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AttractionWithBestPrice getAttraction() {
    return attraction;
  }


  @JsonProperty(JSON_PROPERTY_ATTRACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttraction(AttractionWithBestPrice attraction) {
    this.attraction = attraction;
  }


  public InventoryGridItem place(PlaceWithBestPrice place) {
    
    this.place = place;
    return this;
  }

   /**
   * Get place
   * @return place
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PLACE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PlaceWithBestPrice getPlace() {
    return place;
  }


  @JsonProperty(JSON_PROPERTY_PLACE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPlace(PlaceWithBestPrice place) {
    this.place = place;
  }


  public InventoryGridItem roomType(HotelWithBestPrice roomType) {
    
    this.roomType = roomType;
    return this;
  }

   /**
   * Get roomType
   * @return roomType
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ROOM_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public HotelWithBestPrice getRoomType() {
    return roomType;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomType(HotelWithBestPrice roomType) {
    this.roomType = roomType;
  }


  public InventoryGridItem meetingRoom(MeetingRoomWithBestPrice meetingRoom) {
    
    this.meetingRoom = meetingRoom;
    return this;
  }

   /**
   * Get meetingRoom
   * @return meetingRoom
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MEETING_ROOM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MeetingRoomWithBestPrice getMeetingRoom() {
    return meetingRoom;
  }


  @JsonProperty(JSON_PROPERTY_MEETING_ROOM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMeetingRoom(MeetingRoomWithBestPrice meetingRoom) {
    this.meetingRoom = meetingRoom;
  }


  public InventoryGridItem restaurant(RestaurantWithBestPrice restaurant) {
    
    this.restaurant = restaurant;
    return this;
  }

   /**
   * Get restaurant
   * @return restaurant
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RESTAURANT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RestaurantWithBestPrice getRestaurant() {
    return restaurant;
  }


  @JsonProperty(JSON_PROPERTY_RESTAURANT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRestaurant(RestaurantWithBestPrice restaurant) {
    this.restaurant = restaurant;
  }


  public InventoryGridItem spa(SpaWithBestPrice spa) {
    
    this.spa = spa;
    return this;
  }

   /**
   * Get spa
   * @return spa
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SPA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SpaWithBestPrice getSpa() {
    return spa;
  }


  @JsonProperty(JSON_PROPERTY_SPA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSpa(SpaWithBestPrice spa) {
    this.spa = spa;
  }


  public InventoryGridItem bundle(PackageWithBestPrice bundle) {
    
    this.bundle = bundle;
    return this;
  }

   /**
   * Get bundle
   * @return bundle
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_BUNDLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PackageWithBestPrice getBundle() {
    return bundle;
  }


  @JsonProperty(JSON_PROPERTY_BUNDLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBundle(PackageWithBestPrice bundle) {
    this.bundle = bundle;
  }


  public InventoryGridItem upgrade(AddOnWithBestPrice upgrade) {
    
    this.upgrade = upgrade;
    return this;
  }

   /**
   * Get upgrade
   * @return upgrade
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_UPGRADE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AddOnWithBestPrice getUpgrade() {
    return upgrade;
  }


  @JsonProperty(JSON_PROPERTY_UPGRADE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpgrade(AddOnWithBestPrice upgrade) {
    this.upgrade = upgrade;
  }


  public InventoryGridItem available(Boolean available) {
    
    this.available = available;
    return this;
  }

   /**
   * Whether this inventory is available
   * @return available
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Whether this inventory is available")
  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAvailable() {
    return available;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailable(Boolean available) {
    this.available = available;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InventoryGridItem inventoryGridItem = (InventoryGridItem) o;
    return Objects.equals(this.sort, inventoryGridItem.sort) &&
        Objects.equals(this.type, inventoryGridItem.type) &&
        Objects.equals(this.identifier, inventoryGridItem.identifier) &&
        Objects.equals(this.supplierIdentifier, inventoryGridItem.supplierIdentifier) &&
        Objects.equals(this.activity, inventoryGridItem.activity) &&
        Objects.equals(this.attraction, inventoryGridItem.attraction) &&
        Objects.equals(this.place, inventoryGridItem.place) &&
        Objects.equals(this.roomType, inventoryGridItem.roomType) &&
        Objects.equals(this.meetingRoom, inventoryGridItem.meetingRoom) &&
        Objects.equals(this.restaurant, inventoryGridItem.restaurant) &&
        Objects.equals(this.spa, inventoryGridItem.spa) &&
        Objects.equals(this.bundle, inventoryGridItem.bundle) &&
        Objects.equals(this.upgrade, inventoryGridItem.upgrade) &&
        Objects.equals(this.available, inventoryGridItem.available);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sort, type, identifier, supplierIdentifier, activity, attraction, place, roomType, meetingRoom, restaurant, spa, bundle, upgrade, available);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InventoryGridItem {\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    supplierIdentifier: ").append(toIndentedString(supplierIdentifier)).append("\n");
    sb.append("    activity: ").append(toIndentedString(activity)).append("\n");
    sb.append("    attraction: ").append(toIndentedString(attraction)).append("\n");
    sb.append("    place: ").append(toIndentedString(place)).append("\n");
    sb.append("    roomType: ").append(toIndentedString(roomType)).append("\n");
    sb.append("    meetingRoom: ").append(toIndentedString(meetingRoom)).append("\n");
    sb.append("    restaurant: ").append(toIndentedString(restaurant)).append("\n");
    sb.append("    spa: ").append(toIndentedString(spa)).append("\n");
    sb.append("    bundle: ").append(toIndentedString(bundle)).append("\n");
    sb.append("    upgrade: ").append(toIndentedString(upgrade)).append("\n");
    sb.append("    available: ").append(toIndentedString(available)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

