/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our payment.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Booking Engine API Welcome to the Booking Engine API - A programmer-friendly way to search for bespoke travel inventory and create bookings for you or your customers. We take great care in only working with properties that have quality, curated content and ways to ancillary and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 20.1.2-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.engine.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Array of awards and third party reviews given to property by certified / non-certified providers.
 */
@ApiModel(description = "Array of awards and third party reviews given to property by certified / non-certified providers.")
@JsonPropertyOrder({
  Recognition.JSON_PROPERTY_IDENTIFIER,
  Recognition.JSON_PROPERTY_HOTEL_IDENTIFIER,
  Recognition.JSON_PROPERTY_CATEGORY,
  Recognition.JSON_PROPERTY_TYPE,
  Recognition.JSON_PROPERTY_PROVIDER,
  Recognition.JSON_PROPERTY_RATING,
  Recognition.JSON_PROPERTY_MAX_RATING,
  Recognition.JSON_PROPERTY_DATE,
  Recognition.JSON_PROPERTY_OFFICIAL_APPOINTMENT_IND,
  Recognition.JSON_PROPERTY_RATING_SYMBOL
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-06-16T12:47:15.131812+07:00[Asia/Bangkok]")
public class Recognition {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private String identifier;

  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private String hotelIdentifier;

  /**
   * Recognition category.
   */
  public enum CategoryEnum {
    THIRD_PARTY_REVIEW("THIRD_PARTY_REVIEW"),
    
    PUBLICATION("PUBLICATION"),
    
    AWARD("AWARD");

    private String value;

    CategoryEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CategoryEnum fromValue(String value) {
      for (CategoryEnum b : CategoryEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CATEGORY = "category";
  private CategoryEnum category;

  /**
   * Type of rating system the recognition operated on. This allows us to display the score properly.
   */
  public enum TypeEnum {
    STAR_RATING("STAR_RATING"),
    
    NUMERIC_RATING("NUMERIC_RATING"),
    
    PERCENT_RATING("PERCENT_RATING");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_PROVIDER = "provider";
  private String provider;

  public static final String JSON_PROPERTY_RATING = "rating";
  private Float rating;

  public static final String JSON_PROPERTY_MAX_RATING = "maxRating";
  private Float maxRating;

  public static final String JSON_PROPERTY_DATE = "date";
  private LocalDate date;

  public static final String JSON_PROPERTY_OFFICIAL_APPOINTMENT_IND = "officialAppointmentInd";
  private Boolean officialAppointmentInd;

  public static final String JSON_PROPERTY_RATING_SYMBOL = "ratingSymbol";
  private String ratingSymbol;

  public Recognition() { 
  }

  public Recognition identifier(String identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Recognition identifier.
   * @return identifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "recognition-1", value = "Recognition identifier.")
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifier(String identifier) {
    this.identifier = identifier;
  }


  public Recognition hotelIdentifier(String hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Unique hotel identifier.
   * @return hotelIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "hotel-1", value = "Unique hotel identifier.")
  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelIdentifier(String hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public Recognition category(CategoryEnum category) {
    
    this.category = category;
    return this;
  }

   /**
   * Recognition category.
   * @return category
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "AWARD", required = true, value = "Recognition category.")
  @JsonProperty(JSON_PROPERTY_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CategoryEnum getCategory() {
    return category;
  }


  @JsonProperty(JSON_PROPERTY_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCategory(CategoryEnum category) {
    this.category = category;
  }


  public Recognition type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Type of rating system the recognition operated on. This allows us to display the score properly.
   * @return type
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "PERCENT_RATING", required = true, value = "Type of rating system the recognition operated on. This allows us to display the score properly.")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public Recognition provider(String provider) {
    
    this.provider = provider;
    return this;
  }

   /**
   * The name of the entity that administers this recognition.
   * @return provider
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "Michelin", required = true, value = "The name of the entity that administers this recognition.")
  @JsonProperty(JSON_PROPERTY_PROVIDER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getProvider() {
    return provider;
  }


  @JsonProperty(JSON_PROPERTY_PROVIDER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setProvider(String provider) {
    this.provider = provider;
  }


  public Recognition rating(Float rating) {
    
    this.rating = rating;
    return this;
  }

   /**
   * The actual award or rating received by the hotel facility.
   * minimum: 0.0
   * @return rating
  **/
  @javax.annotation.Nonnull
  @NotNull
 @DecimalMin("0.0")  @ApiModelProperty(example = "8.5", required = true, value = "The actual award or rating received by the hotel facility.")
  @JsonProperty(JSON_PROPERTY_RATING)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Float getRating() {
    return rating;
  }


  @JsonProperty(JSON_PROPERTY_RATING)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRating(Float rating) {
    this.rating = rating;
  }


  public Recognition maxRating(Float maxRating) {
    
    this.maxRating = maxRating;
    return this;
  }

   /**
   * Use this to let hotels indicate what the total score for this award is.
   * @return maxRating
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "10", value = "Use this to let hotels indicate what the total score for this award is.")
  @JsonProperty(JSON_PROPERTY_MAX_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getMaxRating() {
    return maxRating;
  }


  @JsonProperty(JSON_PROPERTY_MAX_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxRating(Float maxRating) {
    this.maxRating = maxRating;
  }


  public Recognition date(LocalDate date) {
    
    this.date = date;
    return this;
  }

   /**
   * The date the award was received
   * @return date
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "Sat Oct 24 07:00:00 ICT 2020", value = "The date the award was received")
  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getDate() {
    return date;
  }


  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDate(LocalDate date) {
    this.date = date;
  }


  public Recognition officialAppointmentInd(Boolean officialAppointmentInd) {
    
    this.officialAppointmentInd = officialAppointmentInd;
    return this;
  }

   /**
   * When true, this indicates the property has received official permission from the award provider to use the rating in publications and marketing materials; when false this permission has not been granted.
   * @return officialAppointmentInd
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "When true, this indicates the property has received official permission from the award provider to use the rating in publications and marketing materials; when false this permission has not been granted.")
  @JsonProperty(JSON_PROPERTY_OFFICIAL_APPOINTMENT_IND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getOfficialAppointmentInd() {
    return officialAppointmentInd;
  }


  @JsonProperty(JSON_PROPERTY_OFFICIAL_APPOINTMENT_IND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOfficialAppointmentInd(Boolean officialAppointmentInd) {
    this.officialAppointmentInd = officialAppointmentInd;
  }


  public Recognition ratingSymbol(String ratingSymbol) {
    
    this.ratingSymbol = ratingSymbol;
    return this;
  }

   /**
   * Provides the symbol used in the rating. Used in conjunction with the Rating.
   * @return ratingSymbol
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "*", value = "Provides the symbol used in the rating. Used in conjunction with the Rating.")
  @JsonProperty(JSON_PROPERTY_RATING_SYMBOL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRatingSymbol() {
    return ratingSymbol;
  }


  @JsonProperty(JSON_PROPERTY_RATING_SYMBOL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRatingSymbol(String ratingSymbol) {
    this.ratingSymbol = ratingSymbol;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Recognition recognition = (Recognition) o;
    return Objects.equals(this.identifier, recognition.identifier) &&
        Objects.equals(this.hotelIdentifier, recognition.hotelIdentifier) &&
        Objects.equals(this.category, recognition.category) &&
        Objects.equals(this.type, recognition.type) &&
        Objects.equals(this.provider, recognition.provider) &&
        Objects.equals(this.rating, recognition.rating) &&
        Objects.equals(this.maxRating, recognition.maxRating) &&
        Objects.equals(this.date, recognition.date) &&
        Objects.equals(this.officialAppointmentInd, recognition.officialAppointmentInd) &&
        Objects.equals(this.ratingSymbol, recognition.ratingSymbol);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, hotelIdentifier, category, type, provider, rating, maxRating, date, officialAppointmentInd, ratingSymbol);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Recognition {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    category: ").append(toIndentedString(category)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    provider: ").append(toIndentedString(provider)).append("\n");
    sb.append("    rating: ").append(toIndentedString(rating)).append("\n");
    sb.append("    maxRating: ").append(toIndentedString(maxRating)).append("\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    officialAppointmentInd: ").append(toIndentedString(officialAppointmentInd)).append("\n");
    sb.append("    ratingSymbol: ").append(toIndentedString(ratingSymbol)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

