/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our payment.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Booking Engine API Welcome to the Booking Engine API - A programmer-friendly way to search for bespoke travel inventory and create bookings for you or your customers. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 20.1.2-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.engine.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.booking.engine.model.RoomConfiguration;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Itinerary
 */
@ApiModel(description = "Itinerary")
@JsonPropertyOrder({
  Itinerary.JSON_PROPERTY_START_DATE,
  Itinerary.JSON_PROPERTY_END_DATE,
  Itinerary.JSON_PROPERTY_ITEMS,
  Itinerary.JSON_PROPERTY_CHILDREN,
  Itinerary.JSON_PROPERTY_VALID,
  Itinerary.JSON_PROPERTY_ROOMS,
  Itinerary.JSON_PROPERTY_GUESTS,
  Itinerary.JSON_PROPERTY_NIGHTS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-06-20T22:26:28.213326+07:00[Asia/Bangkok]")
public class Itinerary {
  public static final String JSON_PROPERTY_START_DATE = "startDate";
  private LocalDate startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  private LocalDate endDate;

  public static final String JSON_PROPERTY_ITEMS = "items";
  private List<RoomConfiguration> items = new ArrayList<>();

  public static final String JSON_PROPERTY_CHILDREN = "children";
  private Integer children;

  public static final String JSON_PROPERTY_VALID = "valid";
  private Boolean valid;

  public static final String JSON_PROPERTY_ROOMS = "rooms";
  private Integer rooms;

  public static final String JSON_PROPERTY_GUESTS = "guests";
  private Integer guests;

  public static final String JSON_PROPERTY_NIGHTS = "nights";
  private Integer nights;

  public Itinerary() { 
  }

  @JsonCreator
  public Itinerary(
    @JsonProperty(JSON_PROPERTY_CHILDREN) Integer children, 
    @JsonProperty(JSON_PROPERTY_VALID) Boolean valid, 
    @JsonProperty(JSON_PROPERTY_ROOMS) Integer rooms, 
    @JsonProperty(JSON_PROPERTY_GUESTS) Integer guests, 
    @JsonProperty(JSON_PROPERTY_NIGHTS) Integer nights
  ) {
    this();
    this.children = children;
    this.valid = valid;
    this.rooms = rooms;
    this.guests = guests;
    this.nights = nights;
  }

  public Itinerary startDate(LocalDate startDate) {
    
    this.startDate = startDate;
    return this;
  }

   /**
   * Start date
   * @return startDate
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "Start date")
  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStartDate(LocalDate startDate) {
    this.startDate = startDate;
  }


  public Itinerary endDate(LocalDate endDate) {
    
    this.endDate = endDate;
    return this;
  }

   /**
   * End date
   * @return endDate
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "End date")
  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEndDate(LocalDate endDate) {
    this.endDate = endDate;
  }


  public Itinerary items(List<RoomConfiguration> items) {
    
    this.items = items;
    return this;
  }

  public Itinerary addItemsItem(RoomConfiguration itemsItem) {
    this.items.add(itemsItem);
    return this;
  }

   /**
   * Room configurations
   * @return items
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "Room configurations")
  @JsonProperty(JSON_PROPERTY_ITEMS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<RoomConfiguration> getItems() {
    return items;
  }


  @JsonProperty(JSON_PROPERTY_ITEMS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setItems(List<RoomConfiguration> items) {
    this.items = items;
  }


   /**
   * How many total children for this stay
   * @return children
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "How many total children for this stay")
  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getChildren() {
    return children;
  }




   /**
   * Whether this is a valid itinerary
   * @return valid
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Whether this is a valid itinerary")
  @JsonProperty(JSON_PROPERTY_VALID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getValid() {
    return valid;
  }




   /**
   * How many total rooms for this stay
   * @return rooms
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "How many total rooms for this stay")
  @JsonProperty(JSON_PROPERTY_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRooms() {
    return rooms;
  }




   /**
   * How many total guests for this stay
   * @return guests
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "How many total guests for this stay")
  @JsonProperty(JSON_PROPERTY_GUESTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getGuests() {
    return guests;
  }




   /**
   * How many total nights for this stay
   * @return nights
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "How many total nights for this stay")
  @JsonProperty(JSON_PROPERTY_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getNights() {
    return nights;
  }




  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Itinerary itinerary = (Itinerary) o;
    return Objects.equals(this.startDate, itinerary.startDate) &&
        Objects.equals(this.endDate, itinerary.endDate) &&
        Objects.equals(this.items, itinerary.items) &&
        Objects.equals(this.children, itinerary.children) &&
        Objects.equals(this.valid, itinerary.valid) &&
        Objects.equals(this.rooms, itinerary.rooms) &&
        Objects.equals(this.guests, itinerary.guests) &&
        Objects.equals(this.nights, itinerary.nights);
  }

  @Override
  public int hashCode() {
    return Objects.hash(startDate, endDate, items, children, valid, rooms, guests, nights);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Itinerary {\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    items: ").append(toIndentedString(items)).append("\n");
    sb.append("    children: ").append(toIndentedString(children)).append("\n");
    sb.append("    valid: ").append(toIndentedString(valid)).append("\n");
    sb.append("    rooms: ").append(toIndentedString(rooms)).append("\n");
    sb.append("    guests: ").append(toIndentedString(guests)).append("\n");
    sb.append("    nights: ").append(toIndentedString(nights)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

