/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.booking.engine.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.booking.engine.model.UserSession;

@JsonPropertyOrder(value={"userSession", "hotelIdentifiers", "page", "size"})
public class MapRequest {
    public static final String JSON_PROPERTY_USER_SESSION = "userSession";
    private UserSession userSession;
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIERS = "hotelIdentifiers";
    private List<String> hotelIdentifiers = null;
    public static final String JSON_PROPERTY_PAGE = "page";
    private Integer page;
    public static final String JSON_PROPERTY_SIZE = "size";
    private Integer size;

    public MapRequest userSession(UserSession userSession) {
        this.userSession = userSession;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="userSession")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UserSession getUserSession() {
        return this.userSession;
    }

    @JsonProperty(value="userSession")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUserSession(UserSession userSession) {
        this.userSession = userSession;
    }

    public MapRequest hotelIdentifiers(List<String> hotelIdentifiers) {
        this.hotelIdentifiers = hotelIdentifiers;
        return this;
    }

    public MapRequest addHotelIdentifiersItem(String hotelIdentifiersItem) {
        if (this.hotelIdentifiers == null) {
            this.hotelIdentifiers = new ArrayList<String>();
        }
        this.hotelIdentifiers.add(hotelIdentifiersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"hotel-1\"]", value="Optionally exclude property identifiers.")
    @JsonProperty(value="hotelIdentifiers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getHotelIdentifiers() {
        return this.hotelIdentifiers;
    }

    @JsonProperty(value="hotelIdentifiers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHotelIdentifiers(List<String> hotelIdentifiers) {
        this.hotelIdentifiers = hotelIdentifiers;
    }

    public MapRequest page(Integer page) {
        this.page = page;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @ApiModelProperty(example="0", required=true, value="The page to paginate to. Note: Page uses a 0-based index.")
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getPage() {
        return this.page;
    }

    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPage(Integer page) {
        this.page = page;
    }

    public MapRequest size(Integer size) {
        this.size = size;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @Max(value=50L)
    @ApiModelProperty(example="10", required=true, value="The result size to return.")
    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) @Max(value=50L) Integer getSize() {
        return this.size;
    }

    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSize(Integer size) {
        this.size = size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapRequest mapRequest = (MapRequest)o;
        return Objects.equals(this.userSession, mapRequest.userSession) && Objects.equals(this.hotelIdentifiers, mapRequest.hotelIdentifiers) && Objects.equals(this.page, mapRequest.page) && Objects.equals(this.size, mapRequest.size);
    }

    public int hashCode() {
        return Objects.hash(this.userSession, this.hotelIdentifiers, this.page, this.size);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MapRequest {\n");
        sb.append("    userSession: ").append(this.toIndentedString(this.userSession)).append("\n");
        sb.append("    hotelIdentifiers: ").append(this.toIndentedString(this.hotelIdentifiers)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

