package travel.wink.sdk.booking.engine.api;

import travel.wink.sdk.booking.engine.invoker.ApiClient;

import travel.wink.sdk.booking.engine.model.GenericErrorMessage;
import travel.wink.sdk.booking.engine.model.Lookup;
import travel.wink.sdk.booking.engine.model.LookupCached;
import travel.wink.sdk.booking.engine.model.Oauth2SearchByGeoLocation400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-07-01T17:00:30.497997+07:00[Asia/Bangkok]")
public class LookupApi {
    private ApiClient apiClient;

    public LookupApi() {
        this(new ApiClient());
    }

    @Autowired
    public LookupApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Search Lookups
     * Searches for hotels, cities or countries by the search term.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param term Search for lookups by this term
     * @param accept The accept parameter
     * @return List&lt;LookupCached&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2SearchSuggestionsRequestCreation(String term, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'term' is set
        if (term == null) {
            throw new WebClientResponseException("Missing the required parameter 'term' when calling oauth2SearchSuggestions", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "term", term));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<LookupCached> localVarReturnType = new ParameterizedTypeReference<LookupCached>() {};
        return apiClient.invokeAPI("/api/search", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Search Lookups
     * Searches for hotels, cities or countries by the search term.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param term Search for lookups by this term
     * @param accept The accept parameter
     * @return List&lt;LookupCached&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<LookupCached> oauth2SearchSuggestions(String term, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<LookupCached> localVarReturnType = new ParameterizedTypeReference<LookupCached>() {};
        return oauth2SearchSuggestionsRequestCreation(term, accept).bodyToFlux(localVarReturnType);
    }

    public Mono<ResponseEntity<List<LookupCached>>> oauth2SearchSuggestionsWithHttpInfo(String term, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<LookupCached> localVarReturnType = new ParameterizedTypeReference<LookupCached>() {};
        return oauth2SearchSuggestionsRequestCreation(term, accept).toEntityList(localVarReturnType);
    }
    /**
     * Show Lookup
     * Show lookup object by its unique url name.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param urlName Show lookup by unique url name
     * @param type Filter on type
     * @param accept The accept parameter
     * @return Lookup
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowLookupRequestCreation(String urlName, String type, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'urlName' is set
        if (urlName == null) {
            throw new WebClientResponseException("Missing the required parameter 'urlName' when calling oauth2ShowLookup", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'type' is set
        if (type == null) {
            throw new WebClientResponseException("Missing the required parameter 'type' when calling oauth2ShowLookup", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("urlName", urlName);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "type", type));

        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2_client_credentials" };

        ParameterizedTypeReference<Lookup> localVarReturnType = new ParameterizedTypeReference<Lookup>() {};
        return apiClient.invokeAPI("/api/lookup/{urlName}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Lookup
     * Show lookup object by its unique url name.
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>400</b> - Bad Request
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param urlName Show lookup by unique url name
     * @param type Filter on type
     * @param accept The accept parameter
     * @return Lookup
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Lookup> oauth2ShowLookup(String urlName, String type, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Lookup> localVarReturnType = new ParameterizedTypeReference<Lookup>() {};
        return oauth2ShowLookupRequestCreation(urlName, type, accept).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<Lookup>> oauth2ShowLookupWithHttpInfo(String urlName, String type, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Lookup> localVarReturnType = new ParameterizedTypeReference<Lookup>() {};
        return oauth2ShowLookupRequestCreation(urlName, type, accept).toEntity(localVarReturnType);
    }
}
