/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.booking.engine.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import travel.wink.sdk.booking.engine.invoker.ApiClient;
import travel.wink.sdk.booking.engine.model.AggregateActivityRequest;
import travel.wink.sdk.booking.engine.model.AggregateAddOnRequest;
import travel.wink.sdk.booking.engine.model.AggregateAttractionRequest;
import travel.wink.sdk.booking.engine.model.AggregateGuestRoomRequest;
import travel.wink.sdk.booking.engine.model.AggregateHotelRequest;
import travel.wink.sdk.booking.engine.model.AggregateInventoryGridItemRequest;
import travel.wink.sdk.booking.engine.model.AggregateMeetingRoomRequest;
import travel.wink.sdk.booking.engine.model.AggregatePackageRequest;
import travel.wink.sdk.booking.engine.model.AggregatePlaceRequest;
import travel.wink.sdk.booking.engine.model.AggregateRestaurantRequest;
import travel.wink.sdk.booking.engine.model.AggregateSellerInventoryListRequest;
import travel.wink.sdk.booking.engine.model.AggregateSpaRequest;
import travel.wink.sdk.booking.engine.model.CityScoreRequest;
import travel.wink.sdk.booking.engine.model.CitySearchRequest;
import travel.wink.sdk.booking.engine.model.CountryScoreRequest;
import travel.wink.sdk.booking.engine.model.GlobalScoreRequest;
import travel.wink.sdk.booking.engine.model.HotelInventoryListRequest;
import travel.wink.sdk.booking.engine.model.HotelInventoryListResponse;
import travel.wink.sdk.booking.engine.model.HotelInventoryRequest;
import travel.wink.sdk.booking.engine.model.HotelInventoryResponse;
import travel.wink.sdk.booking.engine.model.InventoryGridItem;
import travel.wink.sdk.booking.engine.model.MapRequest;
import travel.wink.sdk.booking.engine.model.PageHotelWithBestPrice;
import travel.wink.sdk.booking.engine.model.SellerInventoryActivity;
import travel.wink.sdk.booking.engine.model.SellerInventoryAddOn;
import travel.wink.sdk.booking.engine.model.SellerInventoryAttraction;
import travel.wink.sdk.booking.engine.model.SellerInventoryGuestRoom;
import travel.wink.sdk.booking.engine.model.SellerInventoryHotel;
import travel.wink.sdk.booking.engine.model.SellerInventoryListResponse;
import travel.wink.sdk.booking.engine.model.SellerInventoryMeetingRoom;
import travel.wink.sdk.booking.engine.model.SellerInventoryPackage;
import travel.wink.sdk.booking.engine.model.SellerInventoryPlace;
import travel.wink.sdk.booking.engine.model.SellerInventoryRankedListResponse;
import travel.wink.sdk.booking.engine.model.SellerInventoryRestaurant;
import travel.wink.sdk.booking.engine.model.SellerInventorySpa;

public class InventoryApi {
    private ApiClient apiClient;

    public InventoryApi() {
        this(new ApiClient());
    }

    @Autowired
    public InventoryApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec oauth2ScoreInventoryByCityRequestCreation(CityScoreRequest cityScoreRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        CityScoreRequest postBody = cityScoreRequest;
        if (cityScoreRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'cityScoreRequest' when calling oauth2ScoreInventoryByCity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<PageHotelWithBestPrice> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPrice>(){};
        return this.apiClient.invokeAPI("/api/ranked/search/city", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageHotelWithBestPrice> oauth2ScoreInventoryByCity(CityScoreRequest cityScoreRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPrice> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPrice>(){};
        return this.oauth2ScoreInventoryByCityRequestCreation(cityScoreRequest, engineConfigurationIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageHotelWithBestPrice>> oauth2ScoreInventoryByCityWithHttpInfo(CityScoreRequest cityScoreRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPrice> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPrice>(){};
        return this.oauth2ScoreInventoryByCityRequestCreation(cityScoreRequest, engineConfigurationIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec oauth2SearchByGeoLocationRequestCreation(MapRequest mapRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        MapRequest postBody = mapRequest;
        if (mapRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'mapRequest' when calling oauth2SearchByGeoLocation", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<PageHotelWithBestPrice> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPrice>(){};
        return this.apiClient.invokeAPI("/api/search/geo", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageHotelWithBestPrice> oauth2SearchByGeoLocation(MapRequest mapRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPrice> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPrice>(){};
        return this.oauth2SearchByGeoLocationRequestCreation(mapRequest, engineConfigurationIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageHotelWithBestPrice>> oauth2SearchByGeoLocationWithHttpInfo(MapRequest mapRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPrice> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPrice>(){};
        return this.oauth2SearchByGeoLocationRequestCreation(mapRequest, engineConfigurationIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec oauth2SearchInventoryByCityRequestCreation(CitySearchRequest citySearchRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        CitySearchRequest postBody = citySearchRequest;
        if (citySearchRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'citySearchRequest' when calling oauth2SearchInventoryByCity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<PageHotelWithBestPrice> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPrice>(){};
        return this.apiClient.invokeAPI("/api/search/city", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageHotelWithBestPrice> oauth2SearchInventoryByCity(CitySearchRequest citySearchRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPrice> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPrice>(){};
        return this.oauth2SearchInventoryByCityRequestCreation(citySearchRequest, engineConfigurationIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageHotelWithBestPrice>> oauth2SearchInventoryByCityWithHttpInfo(CitySearchRequest citySearchRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPrice> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPrice>(){};
        return this.oauth2SearchInventoryByCityRequestCreation(citySearchRequest, engineConfigurationIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec oauth2SearchScoreByCountryRequestCreation(CountryScoreRequest countryScoreRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        CountryScoreRequest postBody = countryScoreRequest;
        if (countryScoreRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'countryScoreRequest' when calling oauth2SearchScoreByCountry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<PageHotelWithBestPrice> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPrice>(){};
        return this.apiClient.invokeAPI("/api/ranked/search/country", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageHotelWithBestPrice> oauth2SearchScoreByCountry(CountryScoreRequest countryScoreRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPrice> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPrice>(){};
        return this.oauth2SearchScoreByCountryRequestCreation(countryScoreRequest, engineConfigurationIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageHotelWithBestPrice>> oauth2SearchScoreByCountryWithHttpInfo(CountryScoreRequest countryScoreRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPrice> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPrice>(){};
        return this.oauth2SearchScoreByCountryRequestCreation(countryScoreRequest, engineConfigurationIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec oauth2SearchScoreByGlobalRequestCreation(GlobalScoreRequest globalScoreRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        GlobalScoreRequest postBody = globalScoreRequest;
        if (globalScoreRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'globalScoreRequest' when calling oauth2SearchScoreByGlobal", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<PageHotelWithBestPrice> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPrice>(){};
        return this.apiClient.invokeAPI("/api/ranked/search/global", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageHotelWithBestPrice> oauth2SearchScoreByGlobal(GlobalScoreRequest globalScoreRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPrice> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPrice>(){};
        return this.oauth2SearchScoreByGlobalRequestCreation(globalScoreRequest, engineConfigurationIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageHotelWithBestPrice>> oauth2SearchScoreByGlobalWithHttpInfo(GlobalScoreRequest globalScoreRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelWithBestPrice> localVarReturnType = new ParameterizedTypeReference<PageHotelWithBestPrice>(){};
        return this.oauth2SearchScoreByGlobalRequestCreation(globalScoreRequest, engineConfigurationIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec oauth2ShowInventoryGridItemRequestCreation(AggregateInventoryGridItemRequest aggregateInventoryGridItemRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        AggregateInventoryGridItemRequest postBody = aggregateInventoryGridItemRequest;
        if (aggregateInventoryGridItemRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateInventoryGridItemRequest' when calling oauth2ShowInventoryGridItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<InventoryGridItem> localVarReturnType = new ParameterizedTypeReference<InventoryGridItem>(){};
        return this.apiClient.invokeAPI("/api/inventory/grid/item", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InventoryGridItem> oauth2ShowInventoryGridItem(AggregateInventoryGridItemRequest aggregateInventoryGridItemRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryGridItem> localVarReturnType = new ParameterizedTypeReference<InventoryGridItem>(){};
        return this.oauth2ShowInventoryGridItemRequestCreation(aggregateInventoryGridItemRequest, engineConfigurationIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InventoryGridItem>> oauth2ShowInventoryGridItemWithHttpInfo(AggregateInventoryGridItemRequest aggregateInventoryGridItemRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryGridItem> localVarReturnType = new ParameterizedTypeReference<InventoryGridItem>(){};
        return this.oauth2ShowInventoryGridItemRequestCreation(aggregateInventoryGridItemRequest, engineConfigurationIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec oauth2ShowPropertyAddOnRequestCreation(AggregateAddOnRequest aggregateAddOnRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        AggregateAddOnRequest postBody = aggregateAddOnRequest;
        if (aggregateAddOnRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateAddOnRequest' when calling oauth2ShowPropertyAddOn", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<SellerInventoryAddOn> localVarReturnType = new ParameterizedTypeReference<SellerInventoryAddOn>(){};
        return this.apiClient.invokeAPI("/api/inventory/upgrade", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellerInventoryAddOn> oauth2ShowPropertyAddOn(AggregateAddOnRequest aggregateAddOnRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryAddOn> localVarReturnType = new ParameterizedTypeReference<SellerInventoryAddOn>(){};
        return this.oauth2ShowPropertyAddOnRequestCreation(aggregateAddOnRequest, engineConfigurationIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryAddOn>> oauth2ShowPropertyAddOnWithHttpInfo(AggregateAddOnRequest aggregateAddOnRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryAddOn> localVarReturnType = new ParameterizedTypeReference<SellerInventoryAddOn>(){};
        return this.oauth2ShowPropertyAddOnRequestCreation(aggregateAddOnRequest, engineConfigurationIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec oauth2ShowPropertyAggregateRequestCreation(AggregateHotelRequest aggregateHotelRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        AggregateHotelRequest postBody = aggregateHotelRequest;
        if (aggregateHotelRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateHotelRequest' when calling oauth2ShowPropertyAggregate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<SellerInventoryHotel> localVarReturnType = new ParameterizedTypeReference<SellerInventoryHotel>(){};
        return this.apiClient.invokeAPI("/api/inventory/property", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellerInventoryHotel> oauth2ShowPropertyAggregate(AggregateHotelRequest aggregateHotelRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryHotel> localVarReturnType = new ParameterizedTypeReference<SellerInventoryHotel>(){};
        return this.oauth2ShowPropertyAggregateRequestCreation(aggregateHotelRequest, engineConfigurationIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryHotel>> oauth2ShowPropertyAggregateWithHttpInfo(AggregateHotelRequest aggregateHotelRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryHotel> localVarReturnType = new ParameterizedTypeReference<SellerInventoryHotel>(){};
        return this.oauth2ShowPropertyAggregateRequestCreation(aggregateHotelRequest, engineConfigurationIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec oauth2ShowPropertyAttractionRequestCreation(AggregateAttractionRequest aggregateAttractionRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        AggregateAttractionRequest postBody = aggregateAttractionRequest;
        if (aggregateAttractionRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateAttractionRequest' when calling oauth2ShowPropertyAttraction", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<SellerInventoryAttraction> localVarReturnType = new ParameterizedTypeReference<SellerInventoryAttraction>(){};
        return this.apiClient.invokeAPI("/api/inventory/attraction", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellerInventoryAttraction> oauth2ShowPropertyAttraction(AggregateAttractionRequest aggregateAttractionRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryAttraction> localVarReturnType = new ParameterizedTypeReference<SellerInventoryAttraction>(){};
        return this.oauth2ShowPropertyAttractionRequestCreation(aggregateAttractionRequest, engineConfigurationIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryAttraction>> oauth2ShowPropertyAttractionWithHttpInfo(AggregateAttractionRequest aggregateAttractionRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryAttraction> localVarReturnType = new ParameterizedTypeReference<SellerInventoryAttraction>(){};
        return this.oauth2ShowPropertyAttractionRequestCreation(aggregateAttractionRequest, engineConfigurationIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec oauth2ShowPropertyInventoryRequestCreation(HotelInventoryRequest hotelInventoryRequest, String engineConfigurationIdentifier) throws WebClientResponseException {
        HotelInventoryRequest postBody = hotelInventoryRequest;
        if (hotelInventoryRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelInventoryRequest' when calling oauth2ShowPropertyInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<HotelInventoryResponse> localVarReturnType = new ParameterizedTypeReference<HotelInventoryResponse>(){};
        return this.apiClient.invokeAPI("/api/inventory", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<HotelInventoryResponse> oauth2ShowPropertyInventory(HotelInventoryRequest hotelInventoryRequest, String engineConfigurationIdentifier) throws WebClientResponseException {
        ParameterizedTypeReference<HotelInventoryResponse> localVarReturnType = new ParameterizedTypeReference<HotelInventoryResponse>(){};
        return this.oauth2ShowPropertyInventoryRequestCreation(hotelInventoryRequest, engineConfigurationIdentifier).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<HotelInventoryResponse>> oauth2ShowPropertyInventoryWithHttpInfo(HotelInventoryRequest hotelInventoryRequest, String engineConfigurationIdentifier) throws WebClientResponseException {
        ParameterizedTypeReference<HotelInventoryResponse> localVarReturnType = new ParameterizedTypeReference<HotelInventoryResponse>(){};
        return this.oauth2ShowPropertyInventoryRequestCreation(hotelInventoryRequest, engineConfigurationIdentifier).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec oauth2ShowPropertyListRequestCreation(HotelInventoryListRequest hotelInventoryListRequest, String engineConfigurationIdentifier) throws WebClientResponseException {
        HotelInventoryListRequest postBody = hotelInventoryListRequest;
        if (hotelInventoryListRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelInventoryListRequest' when calling oauth2ShowPropertyList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.platform-v1+json", "application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<HotelInventoryListResponse> localVarReturnType = new ParameterizedTypeReference<HotelInventoryListResponse>(){};
        return this.apiClient.invokeAPI("/api/inventory/list", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<HotelInventoryListResponse> oauth2ShowPropertyList(HotelInventoryListRequest hotelInventoryListRequest, String engineConfigurationIdentifier) throws WebClientResponseException {
        ParameterizedTypeReference<HotelInventoryListResponse> localVarReturnType = new ParameterizedTypeReference<HotelInventoryListResponse>(){};
        return this.oauth2ShowPropertyListRequestCreation(hotelInventoryListRequest, engineConfigurationIdentifier).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<HotelInventoryListResponse>> oauth2ShowPropertyListWithHttpInfo(HotelInventoryListRequest hotelInventoryListRequest, String engineConfigurationIdentifier) throws WebClientResponseException {
        ParameterizedTypeReference<HotelInventoryListResponse> localVarReturnType = new ParameterizedTypeReference<HotelInventoryListResponse>(){};
        return this.oauth2ShowPropertyListRequestCreation(hotelInventoryListRequest, engineConfigurationIdentifier).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec oauth2ShowPropertyMeetingRoomRequestCreation(AggregateMeetingRoomRequest aggregateMeetingRoomRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        AggregateMeetingRoomRequest postBody = aggregateMeetingRoomRequest;
        if (aggregateMeetingRoomRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateMeetingRoomRequest' when calling oauth2ShowPropertyMeetingRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<SellerInventoryMeetingRoom> localVarReturnType = new ParameterizedTypeReference<SellerInventoryMeetingRoom>(){};
        return this.apiClient.invokeAPI("/api/inventory/meetingroom", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellerInventoryMeetingRoom> oauth2ShowPropertyMeetingRoom(AggregateMeetingRoomRequest aggregateMeetingRoomRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryMeetingRoom> localVarReturnType = new ParameterizedTypeReference<SellerInventoryMeetingRoom>(){};
        return this.oauth2ShowPropertyMeetingRoomRequestCreation(aggregateMeetingRoomRequest, engineConfigurationIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryMeetingRoom>> oauth2ShowPropertyMeetingRoomWithHttpInfo(AggregateMeetingRoomRequest aggregateMeetingRoomRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryMeetingRoom> localVarReturnType = new ParameterizedTypeReference<SellerInventoryMeetingRoom>(){};
        return this.oauth2ShowPropertyMeetingRoomRequestCreation(aggregateMeetingRoomRequest, engineConfigurationIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec oauth2ShowPropertyPackageRequestCreation(AggregatePackageRequest aggregatePackageRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        AggregatePackageRequest postBody = aggregatePackageRequest;
        if (aggregatePackageRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregatePackageRequest' when calling oauth2ShowPropertyPackage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<SellerInventoryPackage> localVarReturnType = new ParameterizedTypeReference<SellerInventoryPackage>(){};
        return this.apiClient.invokeAPI("/api/inventory/bundle", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellerInventoryPackage> oauth2ShowPropertyPackage(AggregatePackageRequest aggregatePackageRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryPackage> localVarReturnType = new ParameterizedTypeReference<SellerInventoryPackage>(){};
        return this.oauth2ShowPropertyPackageRequestCreation(aggregatePackageRequest, engineConfigurationIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryPackage>> oauth2ShowPropertyPackageWithHttpInfo(AggregatePackageRequest aggregatePackageRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryPackage> localVarReturnType = new ParameterizedTypeReference<SellerInventoryPackage>(){};
        return this.oauth2ShowPropertyPackageRequestCreation(aggregatePackageRequest, engineConfigurationIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec oauth2ShowPropertyPlaceRequestCreation(AggregatePlaceRequest aggregatePlaceRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        AggregatePlaceRequest postBody = aggregatePlaceRequest;
        if (aggregatePlaceRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregatePlaceRequest' when calling oauth2ShowPropertyPlace", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<SellerInventoryPlace> localVarReturnType = new ParameterizedTypeReference<SellerInventoryPlace>(){};
        return this.apiClient.invokeAPI("/api/inventory/place", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellerInventoryPlace> oauth2ShowPropertyPlace(AggregatePlaceRequest aggregatePlaceRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryPlace> localVarReturnType = new ParameterizedTypeReference<SellerInventoryPlace>(){};
        return this.oauth2ShowPropertyPlaceRequestCreation(aggregatePlaceRequest, engineConfigurationIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryPlace>> oauth2ShowPropertyPlaceWithHttpInfo(AggregatePlaceRequest aggregatePlaceRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryPlace> localVarReturnType = new ParameterizedTypeReference<SellerInventoryPlace>(){};
        return this.oauth2ShowPropertyPlaceRequestCreation(aggregatePlaceRequest, engineConfigurationIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec oauth2ShowPropertyRecreationRequestCreation(AggregateActivityRequest aggregateActivityRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        AggregateActivityRequest postBody = aggregateActivityRequest;
        if (aggregateActivityRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateActivityRequest' when calling oauth2ShowPropertyRecreation", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<SellerInventoryActivity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryActivity>(){};
        return this.apiClient.invokeAPI("/api/inventory/activity", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellerInventoryActivity> oauth2ShowPropertyRecreation(AggregateActivityRequest aggregateActivityRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryActivity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryActivity>(){};
        return this.oauth2ShowPropertyRecreationRequestCreation(aggregateActivityRequest, engineConfigurationIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryActivity>> oauth2ShowPropertyRecreationWithHttpInfo(AggregateActivityRequest aggregateActivityRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryActivity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryActivity>(){};
        return this.oauth2ShowPropertyRecreationRequestCreation(aggregateActivityRequest, engineConfigurationIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec oauth2ShowPropertyRestaurantRequestCreation(AggregateRestaurantRequest aggregateRestaurantRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        AggregateRestaurantRequest postBody = aggregateRestaurantRequest;
        if (aggregateRestaurantRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateRestaurantRequest' when calling oauth2ShowPropertyRestaurant", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<SellerInventoryRestaurant> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRestaurant>(){};
        return this.apiClient.invokeAPI("/api/inventory/restaurant", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellerInventoryRestaurant> oauth2ShowPropertyRestaurant(AggregateRestaurantRequest aggregateRestaurantRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRestaurant> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRestaurant>(){};
        return this.oauth2ShowPropertyRestaurantRequestCreation(aggregateRestaurantRequest, engineConfigurationIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryRestaurant>> oauth2ShowPropertyRestaurantWithHttpInfo(AggregateRestaurantRequest aggregateRestaurantRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRestaurant> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRestaurant>(){};
        return this.oauth2ShowPropertyRestaurantRequestCreation(aggregateRestaurantRequest, engineConfigurationIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec oauth2ShowPropertyRoomTypeRequestCreation(AggregateGuestRoomRequest aggregateGuestRoomRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        AggregateGuestRoomRequest postBody = aggregateGuestRoomRequest;
        if (aggregateGuestRoomRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateGuestRoomRequest' when calling oauth2ShowPropertyRoomType", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<SellerInventoryGuestRoom> localVarReturnType = new ParameterizedTypeReference<SellerInventoryGuestRoom>(){};
        return this.apiClient.invokeAPI("/api/inventory/guestroom", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellerInventoryGuestRoom> oauth2ShowPropertyRoomType(AggregateGuestRoomRequest aggregateGuestRoomRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryGuestRoom> localVarReturnType = new ParameterizedTypeReference<SellerInventoryGuestRoom>(){};
        return this.oauth2ShowPropertyRoomTypeRequestCreation(aggregateGuestRoomRequest, engineConfigurationIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryGuestRoom>> oauth2ShowPropertyRoomTypeWithHttpInfo(AggregateGuestRoomRequest aggregateGuestRoomRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryGuestRoom> localVarReturnType = new ParameterizedTypeReference<SellerInventoryGuestRoom>(){};
        return this.oauth2ShowPropertyRoomTypeRequestCreation(aggregateGuestRoomRequest, engineConfigurationIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec oauth2ShowPropertySpaRequestCreation(AggregateSpaRequest aggregateSpaRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        AggregateSpaRequest postBody = aggregateSpaRequest;
        if (aggregateSpaRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateSpaRequest' when calling oauth2ShowPropertySpa", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<SellerInventorySpa> localVarReturnType = new ParameterizedTypeReference<SellerInventorySpa>(){};
        return this.apiClient.invokeAPI("/api/inventory/spa", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellerInventorySpa> oauth2ShowPropertySpa(AggregateSpaRequest aggregateSpaRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventorySpa> localVarReturnType = new ParameterizedTypeReference<SellerInventorySpa>(){};
        return this.oauth2ShowPropertySpaRequestCreation(aggregateSpaRequest, engineConfigurationIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventorySpa>> oauth2ShowPropertySpaWithHttpInfo(AggregateSpaRequest aggregateSpaRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventorySpa> localVarReturnType = new ParameterizedTypeReference<SellerInventorySpa>(){};
        return this.oauth2ShowPropertySpaRequestCreation(aggregateSpaRequest, engineConfigurationIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec oauth2ShowSellerInventoryListRequestCreation(AggregateSellerInventoryListRequest aggregateSellerInventoryListRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        AggregateSellerInventoryListRequest postBody = aggregateSellerInventoryListRequest;
        if (aggregateSellerInventoryListRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateSellerInventoryListRequest' when calling oauth2ShowSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<SellerInventoryListResponse> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListResponse>(){};
        return this.apiClient.invokeAPI("/api/inventory/grid", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellerInventoryListResponse> oauth2ShowSellerInventoryList(AggregateSellerInventoryListRequest aggregateSellerInventoryListRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListResponse> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListResponse>(){};
        return this.oauth2ShowSellerInventoryListRequestCreation(aggregateSellerInventoryListRequest, engineConfigurationIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryListResponse>> oauth2ShowSellerInventoryListWithHttpInfo(AggregateSellerInventoryListRequest aggregateSellerInventoryListRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListResponse> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListResponse>(){};
        return this.oauth2ShowSellerInventoryListRequestCreation(aggregateSellerInventoryListRequest, engineConfigurationIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec oauth2ShowSellerInventoryRankedListRequestCreation(AggregateSellerInventoryListRequest aggregateSellerInventoryListRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        AggregateSellerInventoryListRequest postBody = aggregateSellerInventoryListRequest;
        if (aggregateSellerInventoryListRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateSellerInventoryListRequest' when calling oauth2ShowSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/vnd.platform-v1+json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2_client_credentials"};
        ParameterizedTypeReference<SellerInventoryRankedListResponse> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListResponse>(){};
        return this.apiClient.invokeAPI("/api/inventory/ranked/grid", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellerInventoryRankedListResponse> oauth2ShowSellerInventoryRankedList(AggregateSellerInventoryListRequest aggregateSellerInventoryListRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRankedListResponse> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListResponse>(){};
        return this.oauth2ShowSellerInventoryRankedListRequestCreation(aggregateSellerInventoryListRequest, engineConfigurationIdentifier, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryRankedListResponse>> oauth2ShowSellerInventoryRankedListWithHttpInfo(AggregateSellerInventoryListRequest aggregateSellerInventoryListRequest, String engineConfigurationIdentifier, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRankedListResponse> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListResponse>(){};
        return this.oauth2ShowSellerInventoryRankedListRequestCreation(aggregateSellerInventoryListRequest, engineConfigurationIdentifier, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

