/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](https://integration.wink.travel/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Events](https://integration.wink.travel/docs?api=events):  All APIs related to Integration events.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Booking Engine API Welcome to the Booking Engine API - A programmer-friendly way to search for bespoke travel inventory and create bookings for you or your customers. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 20.3.4-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.engine.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.booking.engine.model.BookingView;
import travel.wink.sdk.booking.engine.model.Moneys;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * BookingConfirmations
 */
@JsonPropertyOrder({
  BookingConfirmations.JSON_PROPERTY_LIST,
  BookingConfirmations.JSON_PROPERTY_POINTS_TO_BE_EARNED,
  BookingConfirmations.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL,
  BookingConfirmations.JSON_PROPERTY_SOURCE_TOTAL
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-07-03T20:10:07.141948+07:00[Asia/Bangkok]")
public class BookingConfirmations {
  public static final String JSON_PROPERTY_LIST = "list";
  private List<BookingView> _list = null;

  public static final String JSON_PROPERTY_POINTS_TO_BE_EARNED = "pointsToBeEarned";
  private Integer pointsToBeEarned;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL = "userSpecifiedCurrencyTotal";
  private Moneys userSpecifiedCurrencyTotal;

  public static final String JSON_PROPERTY_SOURCE_TOTAL = "sourceTotal";
  private Moneys sourceTotal;

  public BookingConfirmations() { 
  }

  public BookingConfirmations _list(List<BookingView> _list) {
    
    this._list = _list;
    return this;
  }

  public BookingConfirmations addListItem(BookingView _listItem) {
    if (this._list == null) {
      this._list = new ArrayList<>();
    }
    this._list.add(_listItem);
    return this;
  }

   /**
   * Get _list
   * @return _list
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<BookingView> getList() {
    return _list;
  }


  @JsonProperty(JSON_PROPERTY_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setList(List<BookingView> _list) {
    this._list = _list;
  }


  public BookingConfirmations pointsToBeEarned(Integer pointsToBeEarned) {
    
    this.pointsToBeEarned = pointsToBeEarned;
    return this;
  }

   /**
   * Get pointsToBeEarned
   * @return pointsToBeEarned
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_POINTS_TO_BE_EARNED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPointsToBeEarned() {
    return pointsToBeEarned;
  }


  @JsonProperty(JSON_PROPERTY_POINTS_TO_BE_EARNED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPointsToBeEarned(Integer pointsToBeEarned) {
    this.pointsToBeEarned = pointsToBeEarned;
  }


  public BookingConfirmations userSpecifiedCurrencyTotal(Moneys userSpecifiedCurrencyTotal) {
    
    this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
    return this;
  }

   /**
   * Get userSpecifiedCurrencyTotal
   * @return userSpecifiedCurrencyTotal
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getUserSpecifiedCurrencyTotal() {
    return userSpecifiedCurrencyTotal;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyTotal(Moneys userSpecifiedCurrencyTotal) {
    this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
  }


  public BookingConfirmations sourceTotal(Moneys sourceTotal) {
    
    this.sourceTotal = sourceTotal;
    return this;
  }

   /**
   * Get sourceTotal
   * @return sourceTotal
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getSourceTotal() {
    return sourceTotal;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceTotal(Moneys sourceTotal) {
    this.sourceTotal = sourceTotal;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BookingConfirmations bookingConfirmations = (BookingConfirmations) o;
    return Objects.equals(this._list, bookingConfirmations._list) &&
        Objects.equals(this.pointsToBeEarned, bookingConfirmations.pointsToBeEarned) &&
        Objects.equals(this.userSpecifiedCurrencyTotal, bookingConfirmations.userSpecifiedCurrencyTotal) &&
        Objects.equals(this.sourceTotal, bookingConfirmations.sourceTotal);
  }

  @Override
  public int hashCode() {
    return Objects.hash(_list, pointsToBeEarned, userSpecifiedCurrencyTotal, sourceTotal);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BookingConfirmations {\n");
    sb.append("    _list: ").append(toIndentedString(_list)).append("\n");
    sb.append("    pointsToBeEarned: ").append(toIndentedString(pointsToBeEarned)).append("\n");
    sb.append("    userSpecifiedCurrencyTotal: ").append(toIndentedString(userSpecifiedCurrencyTotal)).append("\n");
    sb.append("    sourceTotal: ").append(toIndentedString(sourceTotal)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

