/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](https://integration.wink.travel/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Events](https://integration.wink.travel/docs?api=events):  All APIs related to Integration events.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Booking Engine API Welcome to the Booking Engine API - A programmer-friendly way to search for bespoke travel inventory and create bookings for you or your customers. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 20.3.4-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.engine.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Days of the week on which the guest can arrive.
 */
@ApiModel(description = "Days of the week on which the guest can arrive.")
@JsonPropertyOrder({
  RatePlanArrivalDaysOfWeek.JSON_PROPERTY_MON,
  RatePlanArrivalDaysOfWeek.JSON_PROPERTY_TUE,
  RatePlanArrivalDaysOfWeek.JSON_PROPERTY_WED,
  RatePlanArrivalDaysOfWeek.JSON_PROPERTY_THU,
  RatePlanArrivalDaysOfWeek.JSON_PROPERTY_FRI,
  RatePlanArrivalDaysOfWeek.JSON_PROPERTY_SAT,
  RatePlanArrivalDaysOfWeek.JSON_PROPERTY_SUN,
  RatePlanArrivalDaysOfWeek.JSON_PROPERTY_DISABLED
})
@JsonTypeName("ratePlanArrivalDaysOfWeek")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-07-03T20:10:07.141948+07:00[Asia/Bangkok]")
public class RatePlanArrivalDaysOfWeek {
  public static final String JSON_PROPERTY_MON = "mon";
  private Boolean mon;

  public static final String JSON_PROPERTY_TUE = "tue";
  private Boolean tue;

  public static final String JSON_PROPERTY_WED = "wed";
  private Boolean wed;

  public static final String JSON_PROPERTY_THU = "thu";
  private Boolean thu;

  public static final String JSON_PROPERTY_FRI = "fri";
  private Boolean fri;

  public static final String JSON_PROPERTY_SAT = "sat";
  private Boolean sat;

  public static final String JSON_PROPERTY_SUN = "sun";
  private Boolean sun;

  public static final String JSON_PROPERTY_DISABLED = "disabled";
  private Boolean disabled;

  public RatePlanArrivalDaysOfWeek() { 
  }

  public RatePlanArrivalDaysOfWeek mon(Boolean mon) {
    
    this.mon = mon;
    return this;
  }

   /**
   * Set to &#x60;true&#x60; to enable Monday.
   * @return mon
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Set to `true` to enable Monday.")
  @JsonProperty(JSON_PROPERTY_MON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getMon() {
    return mon;
  }


  @JsonProperty(JSON_PROPERTY_MON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMon(Boolean mon) {
    this.mon = mon;
  }


  public RatePlanArrivalDaysOfWeek tue(Boolean tue) {
    
    this.tue = tue;
    return this;
  }

   /**
   * Set to &#x60;true&#x60; to enable Tuesday.
   * @return tue
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Set to `true` to enable Tuesday.")
  @JsonProperty(JSON_PROPERTY_TUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getTue() {
    return tue;
  }


  @JsonProperty(JSON_PROPERTY_TUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTue(Boolean tue) {
    this.tue = tue;
  }


  public RatePlanArrivalDaysOfWeek wed(Boolean wed) {
    
    this.wed = wed;
    return this;
  }

   /**
   * Set to &#x60;true&#x60; to enable Wednesday.
   * @return wed
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Set to `true` to enable Wednesday.")
  @JsonProperty(JSON_PROPERTY_WED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getWed() {
    return wed;
  }


  @JsonProperty(JSON_PROPERTY_WED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWed(Boolean wed) {
    this.wed = wed;
  }


  public RatePlanArrivalDaysOfWeek thu(Boolean thu) {
    
    this.thu = thu;
    return this;
  }

   /**
   * Set to &#x60;true&#x60; to enable Thursday.
   * @return thu
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Set to `true` to enable Thursday.")
  @JsonProperty(JSON_PROPERTY_THU)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getThu() {
    return thu;
  }


  @JsonProperty(JSON_PROPERTY_THU)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThu(Boolean thu) {
    this.thu = thu;
  }


  public RatePlanArrivalDaysOfWeek fri(Boolean fri) {
    
    this.fri = fri;
    return this;
  }

   /**
   * Set to &#x60;true&#x60; to enable Friday.
   * @return fri
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Set to `true` to enable Friday.")
  @JsonProperty(JSON_PROPERTY_FRI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getFri() {
    return fri;
  }


  @JsonProperty(JSON_PROPERTY_FRI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFri(Boolean fri) {
    this.fri = fri;
  }


  public RatePlanArrivalDaysOfWeek sat(Boolean sat) {
    
    this.sat = sat;
    return this;
  }

   /**
   * Set to &#x60;true&#x60; to enable Saturday.
   * @return sat
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Set to `true` to enable Saturday.")
  @JsonProperty(JSON_PROPERTY_SAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSat() {
    return sat;
  }


  @JsonProperty(JSON_PROPERTY_SAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSat(Boolean sat) {
    this.sat = sat;
  }


  public RatePlanArrivalDaysOfWeek sun(Boolean sun) {
    
    this.sun = sun;
    return this;
  }

   /**
   * Set to &#x60;true&#x60; to enable Sunday.
   * @return sun
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Set to `true` to enable Sunday.")
  @JsonProperty(JSON_PROPERTY_SUN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSun() {
    return sun;
  }


  @JsonProperty(JSON_PROPERTY_SUN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSun(Boolean sun) {
    this.sun = sun;
  }


  public RatePlanArrivalDaysOfWeek disabled(Boolean disabled) {
    
    this.disabled = disabled;
    return this;
  }

   /**
   * Convenience property to quickly determine if this existing object has any active days enabled.
   * @return disabled
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Convenience property to quickly determine if this existing object has any active days enabled.")
  @JsonProperty(JSON_PROPERTY_DISABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getDisabled() {
    return disabled;
  }


  @JsonProperty(JSON_PROPERTY_DISABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisabled(Boolean disabled) {
    this.disabled = disabled;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RatePlanArrivalDaysOfWeek ratePlanArrivalDaysOfWeek = (RatePlanArrivalDaysOfWeek) o;
    return Objects.equals(this.mon, ratePlanArrivalDaysOfWeek.mon) &&
        Objects.equals(this.tue, ratePlanArrivalDaysOfWeek.tue) &&
        Objects.equals(this.wed, ratePlanArrivalDaysOfWeek.wed) &&
        Objects.equals(this.thu, ratePlanArrivalDaysOfWeek.thu) &&
        Objects.equals(this.fri, ratePlanArrivalDaysOfWeek.fri) &&
        Objects.equals(this.sat, ratePlanArrivalDaysOfWeek.sat) &&
        Objects.equals(this.sun, ratePlanArrivalDaysOfWeek.sun) &&
        Objects.equals(this.disabled, ratePlanArrivalDaysOfWeek.disabled);
  }

  @Override
  public int hashCode() {
    return Objects.hash(mon, tue, wed, thu, fri, sat, sun, disabled);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RatePlanArrivalDaysOfWeek {\n");
    sb.append("    mon: ").append(toIndentedString(mon)).append("\n");
    sb.append("    tue: ").append(toIndentedString(tue)).append("\n");
    sb.append("    wed: ").append(toIndentedString(wed)).append("\n");
    sb.append("    thu: ").append(toIndentedString(thu)).append("\n");
    sb.append("    fri: ").append(toIndentedString(fri)).append("\n");
    sb.append("    sat: ").append(toIndentedString(sat)).append("\n");
    sb.append("    sun: ").append(toIndentedString(sun)).append("\n");
    sb.append("    disabled: ").append(toIndentedString(disabled)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

