/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.booking.engine.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.booking.engine.model.MerchantBookingRequest;

@JsonPropertyOrder(value={"rooms", "displayCurrency", "displayLanguage", "engineConfigurationIdentifier"})
public class CreateMerchantBookingRequest {
    public static final String JSON_PROPERTY_ROOMS = "rooms";
    private List<MerchantBookingRequest> rooms = new ArrayList<MerchantBookingRequest>();
    public static final String JSON_PROPERTY_DISPLAY_CURRENCY = "displayCurrency";
    private String displayCurrency = "USD";
    public static final String JSON_PROPERTY_DISPLAY_LANGUAGE = "displayLanguage";
    private String displayLanguage = "en";
    public static final String JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER = "engineConfigurationIdentifier";
    private UUID engineConfigurationIdentifier;

    public CreateMerchantBookingRequest rooms(List<MerchantBookingRequest> rooms) {
        this.rooms = rooms;
        return this;
    }

    public CreateMerchantBookingRequest addRoomsItem(MerchantBookingRequest roomsItem) {
        this.rooms.add(roomsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="List of room configuration booking requests. Each entry is a separately booked room.")
    @JsonProperty(value="rooms")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<MerchantBookingRequest> getRooms() {
        return this.rooms;
    }

    @JsonProperty(value="rooms")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRooms(List<MerchantBookingRequest> rooms) {
        this.rooms = rooms;
    }

    public CreateMerchantBookingRequest displayCurrency(String displayCurrency) {
        this.displayCurrency = displayCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="USD", required=true, value="The desired currency")
    @JsonProperty(value="displayCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDisplayCurrency() {
        return this.displayCurrency;
    }

    @JsonProperty(value="displayCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayCurrency(String displayCurrency) {
        this.displayCurrency = displayCurrency;
    }

    public CreateMerchantBookingRequest displayLanguage(String displayLanguage) {
        this.displayLanguage = displayLanguage;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="en", required=true, value="The desired language")
    @JsonProperty(value="displayLanguage")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDisplayLanguage() {
        return this.displayLanguage;
    }

    @JsonProperty(value="displayLanguage")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayLanguage(String displayLanguage) {
        this.displayLanguage = displayLanguage;
    }

    public CreateMerchantBookingRequest engineConfigurationIdentifier(UUID engineConfigurationIdentifier) {
        this.engineConfigurationIdentifier = engineConfigurationIdentifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Optionally include the specific configuration used to make the booking. If no identifier is included, it will default to the primary application configuration.")
    @JsonProperty(value="engineConfigurationIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getEngineConfigurationIdentifier() {
        return this.engineConfigurationIdentifier;
    }

    @JsonProperty(value="engineConfigurationIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEngineConfigurationIdentifier(UUID engineConfigurationIdentifier) {
        this.engineConfigurationIdentifier = engineConfigurationIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateMerchantBookingRequest createMerchantBookingRequest = (CreateMerchantBookingRequest)o;
        return Objects.equals(this.rooms, createMerchantBookingRequest.rooms) && Objects.equals(this.displayCurrency, createMerchantBookingRequest.displayCurrency) && Objects.equals(this.displayLanguage, createMerchantBookingRequest.displayLanguage) && Objects.equals(this.engineConfigurationIdentifier, createMerchantBookingRequest.engineConfigurationIdentifier);
    }

    public int hashCode() {
        return Objects.hash(this.rooms, this.displayCurrency, this.displayLanguage, this.engineConfigurationIdentifier);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateMerchantBookingRequest {\n");
        sb.append("    rooms: ").append(this.toIndentedString(this.rooms)).append("\n");
        sb.append("    displayCurrency: ").append(this.toIndentedString(this.displayCurrency)).append("\n");
        sb.append("    displayLanguage: ").append(this.toIndentedString(this.displayLanguage)).append("\n");
        sb.append("    engineConfigurationIdentifier: ").append(this.toIndentedString(this.engineConfigurationIdentifier)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

