/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.booking.engine.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;

@ApiModel(description="Property Policy")
@JsonPropertyOrder(value={"childrenAllowed", "childrenMinimumAge", "internetAvailability", "internetConnectionType", "internetConnectionLocation", "parkingAvailability", "parkingAccess", "petsAllowed", "checkOutTime", "checkInTime"})
public class PropertyPolicy {
    public static final String JSON_PROPERTY_CHILDREN_ALLOWED = "childrenAllowed";
    private Boolean childrenAllowed = false;
    public static final String JSON_PROPERTY_CHILDREN_MINIMUM_AGE = "childrenMinimumAge";
    private Integer childrenMinimumAge;
    public static final String JSON_PROPERTY_INTERNET_AVAILABILITY = "internetAvailability";
    private InternetAvailabilityEnum internetAvailability;
    public static final String JSON_PROPERTY_INTERNET_CONNECTION_TYPE = "internetConnectionType";
    private InternetConnectionTypeEnum internetConnectionType;
    public static final String JSON_PROPERTY_INTERNET_CONNECTION_LOCATION = "internetConnectionLocation";
    private InternetConnectionLocationEnum internetConnectionLocation;
    public static final String JSON_PROPERTY_PARKING_AVAILABILITY = "parkingAvailability";
    private ParkingAvailabilityEnum parkingAvailability;
    public static final String JSON_PROPERTY_PARKING_ACCESS = "parkingAccess";
    private ParkingAccessEnum parkingAccess;
    public static final String JSON_PROPERTY_PETS_ALLOWED = "petsAllowed";
    private Boolean petsAllowed = false;
    public static final String JSON_PROPERTY_CHECK_OUT_TIME = "checkOutTime";
    private String checkOutTime;
    public static final String JSON_PROPERTY_CHECK_IN_TIME = "checkInTime";
    private String checkInTime;

    public PropertyPolicy childrenAllowed(Boolean childrenAllowed) {
        this.childrenAllowed = childrenAllowed;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="Indicates whether property allows children")
    @JsonProperty(value="childrenAllowed")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getChildrenAllowed() {
        return this.childrenAllowed;
    }

    @JsonProperty(value="childrenAllowed")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setChildrenAllowed(Boolean childrenAllowed) {
        this.childrenAllowed = childrenAllowed;
    }

    public PropertyPolicy childrenMinimumAge(Integer childrenMinimumAge) {
        this.childrenMinimumAge = childrenMinimumAge;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="6", value="When a property allows children, it can also indicate what the minimum age is for children to be allowed.")
    @JsonProperty(value="childrenMinimumAge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getChildrenMinimumAge() {
        return this.childrenMinimumAge;
    }

    @JsonProperty(value="childrenMinimumAge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChildrenMinimumAge(Integer childrenMinimumAge) {
        this.childrenMinimumAge = childrenMinimumAge;
    }

    public PropertyPolicy internetAvailability(InternetAvailabilityEnum internetAvailability) {
        this.internetAvailability = internetAvailability;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="YES", required=true, value="Indicates the availability of internet on the property.")
    @JsonProperty(value="internetAvailability")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public InternetAvailabilityEnum getInternetAvailability() {
        return this.internetAvailability;
    }

    @JsonProperty(value="internetAvailability")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInternetAvailability(InternetAvailabilityEnum internetAvailability) {
        this.internetAvailability = internetAvailability;
    }

    public PropertyPolicy internetConnectionType(InternetConnectionTypeEnum internetConnectionType) {
        this.internetConnectionType = internetConnectionType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="WIFI", value="Indicates how guests can access the Internet on the property.")
    @JsonProperty(value="internetConnectionType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public InternetConnectionTypeEnum getInternetConnectionType() {
        return this.internetConnectionType;
    }

    @JsonProperty(value="internetConnectionType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInternetConnectionType(InternetConnectionTypeEnum internetConnectionType) {
        this.internetConnectionType = internetConnectionType;
    }

    public PropertyPolicy internetConnectionLocation(InternetConnectionLocationEnum internetConnectionLocation) {
        this.internetConnectionLocation = internetConnectionLocation;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="ENTIRE_PROPERTY", value="Indicates where internet is available in and around the property.")
    @JsonProperty(value="internetConnectionLocation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public InternetConnectionLocationEnum getInternetConnectionLocation() {
        return this.internetConnectionLocation;
    }

    @JsonProperty(value="internetConnectionLocation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInternetConnectionLocation(InternetConnectionLocationEnum internetConnectionLocation) {
        this.internetConnectionLocation = internetConnectionLocation;
    }

    public PropertyPolicy parkingAvailability(ParkingAvailabilityEnum parkingAvailability) {
        this.parkingAvailability = parkingAvailability;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="YES", required=true, value="Indicates whether parking is available at the property.")
    @JsonProperty(value="parkingAvailability")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ParkingAvailabilityEnum getParkingAvailability() {
        return this.parkingAvailability;
    }

    @JsonProperty(value="parkingAvailability")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setParkingAvailability(ParkingAvailabilityEnum parkingAvailability) {
        this.parkingAvailability = parkingAvailability;
    }

    public PropertyPolicy parkingAccess(ParkingAccessEnum parkingAccess) {
        this.parkingAccess = parkingAccess;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="PRIVATE", value="Indicates what type of parking is available at the property.")
    @JsonProperty(value="parkingAccess")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ParkingAccessEnum getParkingAccess() {
        return this.parkingAccess;
    }

    @JsonProperty(value="parkingAccess")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setParkingAccess(ParkingAccessEnum parkingAccess) {
        this.parkingAccess = parkingAccess;
    }

    public PropertyPolicy petsAllowed(Boolean petsAllowed) {
        this.petsAllowed = petsAllowed;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="Indicates whether pets are allowed on the property. Note: There are thousand different kinds of pets. Just because the property allows small dogs does not mean the guest can bring a python. Always best to check with property.")
    @JsonProperty(value="petsAllowed")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getPetsAllowed() {
        return this.petsAllowed;
    }

    @JsonProperty(value="petsAllowed")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPetsAllowed(Boolean petsAllowed) {
        this.petsAllowed = petsAllowed;
    }

    public PropertyPolicy checkOutTime(String checkOutTime) {
        this.checkOutTime = checkOutTime;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="10:00", required=true, value="When the guest has to check out.")
    @JsonProperty(value="checkOutTime")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCheckOutTime() {
        return this.checkOutTime;
    }

    @JsonProperty(value="checkOutTime")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCheckOutTime(String checkOutTime) {
        this.checkOutTime = checkOutTime;
    }

    public PropertyPolicy checkInTime(String checkInTime) {
        this.checkInTime = checkInTime;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="14:00", required=true, value="When the guest can check in.")
    @JsonProperty(value="checkInTime")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCheckInTime() {
        return this.checkInTime;
    }

    @JsonProperty(value="checkInTime")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCheckInTime(String checkInTime) {
        this.checkInTime = checkInTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyPolicy propertyPolicy = (PropertyPolicy)o;
        return Objects.equals(this.childrenAllowed, propertyPolicy.childrenAllowed) && Objects.equals(this.childrenMinimumAge, propertyPolicy.childrenMinimumAge) && Objects.equals((Object)this.internetAvailability, (Object)propertyPolicy.internetAvailability) && Objects.equals((Object)this.internetConnectionType, (Object)propertyPolicy.internetConnectionType) && Objects.equals((Object)this.internetConnectionLocation, (Object)propertyPolicy.internetConnectionLocation) && Objects.equals((Object)this.parkingAvailability, (Object)propertyPolicy.parkingAvailability) && Objects.equals((Object)this.parkingAccess, (Object)propertyPolicy.parkingAccess) && Objects.equals(this.petsAllowed, propertyPolicy.petsAllowed) && Objects.equals(this.checkOutTime, propertyPolicy.checkOutTime) && Objects.equals(this.checkInTime, propertyPolicy.checkInTime);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.childrenAllowed, this.childrenMinimumAge, this.internetAvailability, this.internetConnectionType, this.internetConnectionLocation, this.parkingAvailability, this.parkingAccess, this.petsAllowed, this.checkOutTime, this.checkInTime});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PropertyPolicy {\n");
        sb.append("    childrenAllowed: ").append(this.toIndentedString(this.childrenAllowed)).append("\n");
        sb.append("    childrenMinimumAge: ").append(this.toIndentedString(this.childrenMinimumAge)).append("\n");
        sb.append("    internetAvailability: ").append(this.toIndentedString((Object)this.internetAvailability)).append("\n");
        sb.append("    internetConnectionType: ").append(this.toIndentedString((Object)this.internetConnectionType)).append("\n");
        sb.append("    internetConnectionLocation: ").append(this.toIndentedString((Object)this.internetConnectionLocation)).append("\n");
        sb.append("    parkingAvailability: ").append(this.toIndentedString((Object)this.parkingAvailability)).append("\n");
        sb.append("    parkingAccess: ").append(this.toIndentedString((Object)this.parkingAccess)).append("\n");
        sb.append("    petsAllowed: ").append(this.toIndentedString(this.petsAllowed)).append("\n");
        sb.append("    checkOutTime: ").append(this.toIndentedString(this.checkOutTime)).append("\n");
        sb.append("    checkInTime: ").append(this.toIndentedString(this.checkInTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum InternetAvailabilityEnum {
        YES("YES"),
        NO("NO"),
        YES_PAID("YES_PAID");

        private String value;

        private InternetAvailabilityEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static InternetAvailabilityEnum fromValue(String value) {
            for (InternetAvailabilityEnum b : InternetAvailabilityEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum InternetConnectionTypeEnum {
        WIFI("WIFI"),
        CABLE("CABLE");

        private String value;

        private InternetConnectionTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static InternetConnectionTypeEnum fromValue(String value) {
            for (InternetConnectionTypeEnum b : InternetConnectionTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum InternetConnectionLocationEnum {
        ENTIRE_PROPERTY("ENTIRE_PROPERTY"),
        PUBLIC_AREAS("PUBLIC_AREAS"),
        ALL_ROOMS("ALL_ROOMS"),
        SOME_ROOMS("SOME_ROOMS"),
        BUSINESS_CENTER("BUSINESS_CENTER");

        private String value;

        private InternetConnectionLocationEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static InternetConnectionLocationEnum fromValue(String value) {
            for (InternetConnectionLocationEnum b : InternetConnectionLocationEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ParkingAvailabilityEnum {
        YES("YES"),
        NO("NO"),
        YES_PAID("YES_PAID");

        private String value;

        private ParkingAvailabilityEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ParkingAvailabilityEnum fromValue(String value) {
            for (ParkingAvailabilityEnum b : ParkingAvailabilityEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ParkingAccessEnum {
        PRIVATE("PRIVATE"),
        PUBLIC("PUBLIC");

        private String value;

        private ParkingAccessEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ParkingAccessEnum fromValue(String value) {
            for (ParkingAccessEnum b : ParkingAccessEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

