/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.booking.engine.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.validation.Valid;
import travel.wink.sdk.booking.engine.model.HotelWithBestPrice;
import travel.wink.sdk.booking.engine.model.LocalizedPrice;
import travel.wink.sdk.booking.engine.model.Spa;

@ApiModel(description="Property details along with the priced spa record.")
@JsonPropertyOrder(value={"spa", "price", "hotelWithBestPrice", "sort", "channelInventoryIdentifier"})
public class SpaWithBestPrice {
    public static final String JSON_PROPERTY_SPA = "spa";
    private Spa spa;
    public static final String JSON_PROPERTY_PRICE = "price";
    private LocalizedPrice price;
    public static final String JSON_PROPERTY_HOTEL_WITH_BEST_PRICE = "hotelWithBestPrice";
    private HotelWithBestPrice hotelWithBestPrice;
    public static final String JSON_PROPERTY_SORT = "sort";
    private Integer sort = 0;
    public static final String JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER = "channelInventoryIdentifier";
    private UUID channelInventoryIdentifier;

    public SpaWithBestPrice spa(Spa spa) {
        this.spa = spa;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="spa")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Spa getSpa() {
        return this.spa;
    }

    @JsonProperty(value="spa")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSpa(Spa spa) {
        this.spa = spa;
    }

    public SpaWithBestPrice price(LocalizedPrice price) {
        this.price = price;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalizedPrice getPrice() {
        return this.price;
    }

    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrice(LocalizedPrice price) {
        this.price = price;
    }

    public SpaWithBestPrice hotelWithBestPrice(HotelWithBestPrice hotelWithBestPrice) {
        this.hotelWithBestPrice = hotelWithBestPrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="hotelWithBestPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HotelWithBestPrice getHotelWithBestPrice() {
        return this.hotelWithBestPrice;
    }

    @JsonProperty(value="hotelWithBestPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHotelWithBestPrice(HotelWithBestPrice hotelWithBestPrice) {
        this.hotelWithBestPrice = hotelWithBestPrice;
    }

    public SpaWithBestPrice sort(Integer sort) {
        this.sort = sort;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1", value="Populated when the record is in the context of static lists.")
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSort() {
        return this.sort;
    }

    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public SpaWithBestPrice channelInventoryIdentifier(UUID channelInventoryIdentifier) {
        this.channelInventoryIdentifier = channelInventoryIdentifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Channel inventory identifier referencing this record.")
    @JsonProperty(value="channelInventoryIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getChannelInventoryIdentifier() {
        return this.channelInventoryIdentifier;
    }

    @JsonProperty(value="channelInventoryIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChannelInventoryIdentifier(UUID channelInventoryIdentifier) {
        this.channelInventoryIdentifier = channelInventoryIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpaWithBestPrice spaWithBestPrice = (SpaWithBestPrice)o;
        return Objects.equals(this.spa, spaWithBestPrice.spa) && Objects.equals(this.price, spaWithBestPrice.price) && Objects.equals(this.hotelWithBestPrice, spaWithBestPrice.hotelWithBestPrice) && Objects.equals(this.sort, spaWithBestPrice.sort) && Objects.equals(this.channelInventoryIdentifier, spaWithBestPrice.channelInventoryIdentifier);
    }

    public int hashCode() {
        return Objects.hash(this.spa, this.price, this.hotelWithBestPrice, this.sort, this.channelInventoryIdentifier);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SpaWithBestPrice {\n");
        sb.append("    spa: ").append(this.toIndentedString(this.spa)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    hotelWithBestPrice: ").append(this.toIndentedString(this.hotelWithBestPrice)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    channelInventoryIdentifier: ").append(this.toIndentedString(this.channelInventoryIdentifier)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

