/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](https://integration.wink.travel/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Events](https://integration.wink.travel/docs?api=events):  All APIs related to Integration events.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Booking Engine API Welcome to the Booking Engine API - A programmer-friendly way to search for bespoke travel inventory and create bookings for you or your customers. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 21.4.3-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.engine.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.UUID;
import travel.wink.sdk.booking.engine.model.GeoJsonPoint;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * LookupCached
 */
@JsonPropertyOrder({
  LookupCached.JSON_PROPERTY_IDENTIFIER,
  LookupCached.JSON_PROPERTY_TYPE,
  LookupCached.JSON_PROPERTY_TYPE_IDENTIFIER,
  LookupCached.JSON_PROPERTY_NAME,
  LookupCached.JSON_PROPERTY_URL_NAME,
  LookupCached.JSON_PROPERTY_OWNER_IDENTIFIER,
  LookupCached.JSON_PROPERTY_OWNER_NAME,
  LookupCached.JSON_PROPERTY_CITY_NAME,
  LookupCached.JSON_PROPERTY_COUNTRY_NAME,
  LookupCached.JSON_PROPERTY_SUB_COUNTRY_NAME,
  LookupCached.JSON_PROPERTY_SUB_SUB_COUNTRY_NAME,
  LookupCached.JSON_PROPERTY_COUNTRY_CODE,
  LookupCached.JSON_PROPERTY_OWNER_TYPE,
  LookupCached.JSON_PROPERTY_LANGUAGE_CODE,
  LookupCached.JSON_PROPERTY_SORT,
  LookupCached.JSON_PROPERTY_ORIGIN,
  LookupCached.JSON_PROPERTY_LOWERCASE_NAME,
  LookupCached.JSON_PROPERTY_LOCATION_X,
  LookupCached.JSON_PROPERTY_LOCATION_Y,
  LookupCached.JSON_PROPERTY_LOCATION
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-07T09:36:43.710591+07:00[Asia/Bangkok]")
public class LookupCached {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  /**
   * Type of lookup
   */
  public enum TypeEnum {
    CITY("CITY"),
    
    ISLAND("ISLAND"),
    
    HOTEL("HOTEL"),
    
    SPA("SPA"),
    
    MEETING_ROOM("MEETING_ROOM"),
    
    RESTAURANT("RESTAURANT"),
    
    ATTRACTION("ATTRACTION"),
    
    ACTIVITY("ACTIVITY"),
    
    PLACE("PLACE"),
    
    COUNTRY("COUNTRY");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_TYPE_IDENTIFIER = "typeIdentifier";
  private UUID typeIdentifier;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_URL_NAME = "urlName";
  private String urlName;

  public static final String JSON_PROPERTY_OWNER_IDENTIFIER = "ownerIdentifier";
  private UUID ownerIdentifier;

  public static final String JSON_PROPERTY_OWNER_NAME = "ownerName";
  private String ownerName;

  public static final String JSON_PROPERTY_CITY_NAME = "cityName";
  private String cityName;

  public static final String JSON_PROPERTY_COUNTRY_NAME = "countryName";
  private String countryName;

  public static final String JSON_PROPERTY_SUB_COUNTRY_NAME = "subCountryName";
  private String subCountryName;

  public static final String JSON_PROPERTY_SUB_SUB_COUNTRY_NAME = "subSubCountryName";
  private String subSubCountryName;

  public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
  private String countryCode;

  /**
   * The type of owner that created this lookup
   */
  public enum OwnerTypeEnum {
    TRAVELIKO("TRAVELIKO"),
    
    HOTEL("HOTEL");

    private String value;

    OwnerTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static OwnerTypeEnum fromValue(String value) {
      for (OwnerTypeEnum b : OwnerTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_OWNER_TYPE = "ownerType";
  private OwnerTypeEnum ownerType;

  public static final String JSON_PROPERTY_LANGUAGE_CODE = "languageCode";
  private String languageCode;

  public static final String JSON_PROPERTY_SORT = "sort";
  private Integer sort;

  public static final String JSON_PROPERTY_ORIGIN = "origin";
  private Boolean origin;

  public static final String JSON_PROPERTY_LOWERCASE_NAME = "lowercaseName";
  private String lowercaseName;

  public static final String JSON_PROPERTY_LOCATION_X = "locationX";
  private Double locationX;

  public static final String JSON_PROPERTY_LOCATION_Y = "locationY";
  private Double locationY;

  public static final String JSON_PROPERTY_LOCATION = "location";
  private GeoJsonPoint location;

  public LookupCached() { 
  }

  public LookupCached identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique lookup identifier
   * @return identifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Unique lookup identifier")
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public LookupCached type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Type of lookup
   * @return type
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "ACTIVITY", value = "Type of lookup")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public LookupCached typeIdentifier(UUID typeIdentifier) {
    
    this.typeIdentifier = typeIdentifier;
    return this;
  }

   /**
   * Unique lookup type identifier
   * @return typeIdentifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Unique lookup type identifier")
  @JsonProperty(JSON_PROPERTY_TYPE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getTypeIdentifier() {
    return typeIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_TYPE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTypeIdentifier(UUID typeIdentifier) {
    this.typeIdentifier = typeIdentifier;
  }


  public LookupCached name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Name of lookup
   * @return name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Archery on horseback", value = "Name of lookup")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public LookupCached urlName(String urlName) {
    
    this.urlName = urlName;
    return this;
  }

   /**
   * Url-friendly slug that uniquely identifies this lookup
   * @return urlName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "archery-on-horseback", value = "Url-friendly slug that uniquely identifies this lookup")
  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUrlName() {
    return urlName;
  }


  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUrlName(String urlName) {
    this.urlName = urlName;
  }


  public LookupCached ownerIdentifier(UUID ownerIdentifier) {
    
    this.ownerIdentifier = ownerIdentifier;
    return this;
  }

   /**
   * Lookup that is supplier inventory includes the supplier identifier
   * @return ownerIdentifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Lookup that is supplier inventory includes the supplier identifier")
  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getOwnerIdentifier() {
    return ownerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwnerIdentifier(UUID ownerIdentifier) {
    this.ownerIdentifier = ownerIdentifier;
  }


  public LookupCached ownerName(String ownerName) {
    
    this.ownerName = ownerName;
    return this;
  }

   /**
   * Lookup that is supplier inventory includes the supplier name
   * @return ownerName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "My Chic Hotel", value = "Lookup that is supplier inventory includes the supplier name")
  @JsonProperty(JSON_PROPERTY_OWNER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOwnerName() {
    return ownerName;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwnerName(String ownerName) {
    this.ownerName = ownerName;
  }


  public LookupCached cityName(String cityName) {
    
    this.cityName = cityName;
    return this;
  }

   /**
   * Closest city where lookup entry is located
   * @return cityName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Los Angeles", value = "Closest city where lookup entry is located")
  @JsonProperty(JSON_PROPERTY_CITY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCityName() {
    return cityName;
  }


  @JsonProperty(JSON_PROPERTY_CITY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCityName(String cityName) {
    this.cityName = cityName;
  }


  public LookupCached countryName(String countryName) {
    
    this.countryName = countryName;
    return this;
  }

   /**
   * Country where lookup entry is located
   * @return countryName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "United States", value = "Country where lookup entry is located")
  @JsonProperty(JSON_PROPERTY_COUNTRY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountryName() {
    return countryName;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryName(String countryName) {
    this.countryName = countryName;
  }


  public LookupCached subCountryName(String subCountryName) {
    
    this.subCountryName = subCountryName;
    return this;
  }

   /**
   * State where lookup entry is located
   * @return subCountryName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "California", value = "State where lookup entry is located")
  @JsonProperty(JSON_PROPERTY_SUB_COUNTRY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubCountryName() {
    return subCountryName;
  }


  @JsonProperty(JSON_PROPERTY_SUB_COUNTRY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubCountryName(String subCountryName) {
    this.subCountryName = subCountryName;
  }


  public LookupCached subSubCountryName(String subSubCountryName) {
    
    this.subSubCountryName = subSubCountryName;
    return this;
  }

   /**
   * County where lookup entry is located
   * @return subSubCountryName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Orange County", value = "County where lookup entry is located")
  @JsonProperty(JSON_PROPERTY_SUB_SUB_COUNTRY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubSubCountryName() {
    return subSubCountryName;
  }


  @JsonProperty(JSON_PROPERTY_SUB_SUB_COUNTRY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubSubCountryName(String subSubCountryName) {
    this.subSubCountryName = subSubCountryName;
  }


  public LookupCached countryCode(String countryCode) {
    
    this.countryCode = countryCode;
    return this;
  }

   /**
   * Country code
   * @return countryCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "US", value = "Country code")
  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountryCode() {
    return countryCode;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryCode(String countryCode) {
    this.countryCode = countryCode;
  }


  public LookupCached ownerType(OwnerTypeEnum ownerType) {
    
    this.ownerType = ownerType;
    return this;
  }

   /**
   * The type of owner that created this lookup
   * @return ownerType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "HOTEL", value = "The type of owner that created this lookup")
  @JsonProperty(JSON_PROPERTY_OWNER_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OwnerTypeEnum getOwnerType() {
    return ownerType;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwnerType(OwnerTypeEnum ownerType) {
    this.ownerType = ownerType;
  }


  public LookupCached languageCode(String languageCode) {
    
    this.languageCode = languageCode;
    return this;
  }

   /**
   * The language the lookup code was written in
   * @return languageCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "en-US", value = "The language the lookup code was written in")
  @JsonProperty(JSON_PROPERTY_LANGUAGE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLanguageCode() {
    return languageCode;
  }


  @JsonProperty(JSON_PROPERTY_LANGUAGE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLanguageCode(String languageCode) {
    this.languageCode = languageCode;
  }


  public LookupCached sort(Integer sort) {
    
    this.sort = sort;
    return this;
  }

   /**
   * Platform-specific sort
   * @return sort
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "2", value = "Platform-specific sort")
  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSort(Integer sort) {
    this.sort = sort;
  }


  public LookupCached origin(Boolean origin) {
    
    this.origin = origin;
    return this;
  }

   /**
   * If this lookup is the origin lookup.
   * @return origin
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "If this lookup is the origin lookup.")
  @JsonProperty(JSON_PROPERTY_ORIGIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getOrigin() {
    return origin;
  }


  @JsonProperty(JSON_PROPERTY_ORIGIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOrigin(Boolean origin) {
    this.origin = origin;
  }


  public LookupCached lowercaseName(String lowercaseName) {
    
    this.lowercaseName = lowercaseName;
    return this;
  }

   /**
   * Name in lower case
   * @return lowercaseName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "archery on horseback", value = "Name in lower case")
  @JsonProperty(JSON_PROPERTY_LOWERCASE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLowercaseName() {
    return lowercaseName;
  }


  @JsonProperty(JSON_PROPERTY_LOWERCASE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLowercaseName(String lowercaseName) {
    this.lowercaseName = lowercaseName;
  }


  public LookupCached locationX(Double locationX) {
    
    this.locationX = locationX;
    return this;
  }

   /**
   * Longitude
   * @return locationX
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "12.003455", value = "Longitude")
  @JsonProperty(JSON_PROPERTY_LOCATION_X)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getLocationX() {
    return locationX;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION_X)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocationX(Double locationX) {
    this.locationX = locationX;
  }


  public LookupCached locationY(Double locationY) {
    
    this.locationY = locationY;
    return this;
  }

   /**
   * Latitude
   * @return locationY
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "25.012", value = "Latitude")
  @JsonProperty(JSON_PROPERTY_LOCATION_Y)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getLocationY() {
    return locationY;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION_Y)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocationY(Double locationY) {
    this.locationY = locationY;
  }


  public LookupCached location(GeoJsonPoint location) {
    
    this.location = location;
    return this;
  }

   /**
   * Get location
   * @return location
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GeoJsonPoint getLocation() {
    return location;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocation(GeoJsonPoint location) {
    this.location = location;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LookupCached lookupCached = (LookupCached) o;
    return Objects.equals(this.identifier, lookupCached.identifier) &&
        Objects.equals(this.type, lookupCached.type) &&
        Objects.equals(this.typeIdentifier, lookupCached.typeIdentifier) &&
        Objects.equals(this.name, lookupCached.name) &&
        Objects.equals(this.urlName, lookupCached.urlName) &&
        Objects.equals(this.ownerIdentifier, lookupCached.ownerIdentifier) &&
        Objects.equals(this.ownerName, lookupCached.ownerName) &&
        Objects.equals(this.cityName, lookupCached.cityName) &&
        Objects.equals(this.countryName, lookupCached.countryName) &&
        Objects.equals(this.subCountryName, lookupCached.subCountryName) &&
        Objects.equals(this.subSubCountryName, lookupCached.subSubCountryName) &&
        Objects.equals(this.countryCode, lookupCached.countryCode) &&
        Objects.equals(this.ownerType, lookupCached.ownerType) &&
        Objects.equals(this.languageCode, lookupCached.languageCode) &&
        Objects.equals(this.sort, lookupCached.sort) &&
        Objects.equals(this.origin, lookupCached.origin) &&
        Objects.equals(this.lowercaseName, lookupCached.lowercaseName) &&
        Objects.equals(this.locationX, lookupCached.locationX) &&
        Objects.equals(this.locationY, lookupCached.locationY) &&
        Objects.equals(this.location, lookupCached.location);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, type, typeIdentifier, name, urlName, ownerIdentifier, ownerName, cityName, countryName, subCountryName, subSubCountryName, countryCode, ownerType, languageCode, sort, origin, lowercaseName, locationX, locationY, location);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LookupCached {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    typeIdentifier: ").append(toIndentedString(typeIdentifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    urlName: ").append(toIndentedString(urlName)).append("\n");
    sb.append("    ownerIdentifier: ").append(toIndentedString(ownerIdentifier)).append("\n");
    sb.append("    ownerName: ").append(toIndentedString(ownerName)).append("\n");
    sb.append("    cityName: ").append(toIndentedString(cityName)).append("\n");
    sb.append("    countryName: ").append(toIndentedString(countryName)).append("\n");
    sb.append("    subCountryName: ").append(toIndentedString(subCountryName)).append("\n");
    sb.append("    subSubCountryName: ").append(toIndentedString(subSubCountryName)).append("\n");
    sb.append("    countryCode: ").append(toIndentedString(countryCode)).append("\n");
    sb.append("    ownerType: ").append(toIndentedString(ownerType)).append("\n");
    sb.append("    languageCode: ").append(toIndentedString(languageCode)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    origin: ").append(toIndentedString(origin)).append("\n");
    sb.append("    lowercaseName: ").append(toIndentedString(lowercaseName)).append("\n");
    sb.append("    locationX: ").append(toIndentedString(locationX)).append("\n");
    sb.append("    locationY: ").append(toIndentedString(locationY)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

