/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.booking.engine.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.booking.engine.model.GeoJsonPoint;
import travel.wink.sdk.booking.engine.model.GeoJsonPolygon;
import travel.wink.sdk.booking.engine.model.Itinerary;
import travel.wink.sdk.booking.engine.model.RoomConfiguration;
import travel.wink.sdk.booking.engine.model.SearchFilters;

@ApiModel(description="User session information containing itinerary and other user related data.")
@JsonPropertyOrder(value={"location", "ipNumber", "bounds", "itinerary", "searchFilters", "language", "currency", "userIdentifier", "promotionalCodes", "selectedRoomConfiguration"})
public class UserSession {
    public static final String JSON_PROPERTY_LOCATION = "location";
    private GeoJsonPoint location;
    public static final String JSON_PROPERTY_IP_NUMBER = "ipNumber";
    private String ipNumber;
    public static final String JSON_PROPERTY_BOUNDS = "bounds";
    private GeoJsonPolygon bounds;
    public static final String JSON_PROPERTY_ITINERARY = "itinerary";
    private Itinerary itinerary;
    public static final String JSON_PROPERTY_SEARCH_FILTERS = "searchFilters";
    private SearchFilters searchFilters;
    public static final String JSON_PROPERTY_LANGUAGE = "language";
    private String language;
    public static final String JSON_PROPERTY_CURRENCY = "currency";
    private String currency;
    public static final String JSON_PROPERTY_USER_IDENTIFIER = "userIdentifier";
    private UUID userIdentifier;
    public static final String JSON_PROPERTY_PROMOTIONAL_CODES = "promotionalCodes";
    private List<String> promotionalCodes = null;
    public static final String JSON_PROPERTY_SELECTED_ROOM_CONFIGURATION = "selectedRoomConfiguration";
    private RoomConfiguration selectedRoomConfiguration;

    public UserSession location(GeoJsonPoint location) {
        this.location = location;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public GeoJsonPoint getLocation() {
        return this.location;
    }

    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocation(GeoJsonPoint location) {
        this.location = location;
    }

    public UserSession ipNumber(String ipNumber) {
        this.ipNumber = ipNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="203.543.122.021", value="User's incoming IP number")
    @JsonProperty(value="ipNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIpNumber() {
        return this.ipNumber;
    }

    @JsonProperty(value="ipNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIpNumber(String ipNumber) {
        this.ipNumber = ipNumber;
    }

    public UserSession bounds(GeoJsonPolygon bounds) {
        this.bounds = bounds;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="bounds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public GeoJsonPolygon getBounds() {
        return this.bounds;
    }

    @JsonProperty(value="bounds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBounds(GeoJsonPolygon bounds) {
        this.bounds = bounds;
    }

    public UserSession itinerary(Itinerary itinerary) {
        this.itinerary = itinerary;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="itinerary")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Itinerary getItinerary() {
        return this.itinerary;
    }

    @JsonProperty(value="itinerary")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setItinerary(Itinerary itinerary) {
        this.itinerary = itinerary;
    }

    public UserSession searchFilters(SearchFilters searchFilters) {
        this.searchFilters = searchFilters;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="searchFilters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SearchFilters getSearchFilters() {
        return this.searchFilters;
    }

    @JsonProperty(value="searchFilters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSearchFilters(SearchFilters searchFilters) {
        this.searchFilters = searchFilters;
    }

    public UserSession language(String language) {
        this.language = language;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="en", value="User's language preference")
    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLanguage() {
        return this.language;
    }

    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLanguage(String language) {
        this.language = language;
    }

    public UserSession currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="USD", value="User's currency preference")
    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public UserSession userIdentifier(UUID userIdentifier) {
        this.userIdentifier = userIdentifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Pass along the user identifier if user is known.")
    @JsonProperty(value="userIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getUserIdentifier() {
        return this.userIdentifier;
    }

    @JsonProperty(value="userIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserIdentifier(UUID userIdentifier) {
        this.userIdentifier = userIdentifier;
    }

    public UserSession promotionalCodes(List<String> promotionalCodes) {
        this.promotionalCodes = promotionalCodes;
        return this;
    }

    public UserSession addPromotionalCodesItem(String promotionalCodesItem) {
        if (this.promotionalCodes == null) {
            this.promotionalCodes = new ArrayList<String>();
        }
        this.promotionalCodes.add(promotionalCodesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"promo-1\",\"promo-2\"]", value="User can pass promotional codes to system to change prices.")
    @JsonProperty(value="promotionalCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getPromotionalCodes() {
        return this.promotionalCodes;
    }

    @JsonProperty(value="promotionalCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPromotionalCodes(List<String> promotionalCodes) {
        this.promotionalCodes = promotionalCodes;
    }

    public UserSession selectedRoomConfiguration(RoomConfiguration selectedRoomConfiguration) {
        this.selectedRoomConfiguration = selectedRoomConfiguration;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="selectedRoomConfiguration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RoomConfiguration getSelectedRoomConfiguration() {
        return this.selectedRoomConfiguration;
    }

    @JsonProperty(value="selectedRoomConfiguration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSelectedRoomConfiguration(RoomConfiguration selectedRoomConfiguration) {
        this.selectedRoomConfiguration = selectedRoomConfiguration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserSession userSession = (UserSession)o;
        return Objects.equals(this.location, userSession.location) && Objects.equals(this.ipNumber, userSession.ipNumber) && Objects.equals(this.bounds, userSession.bounds) && Objects.equals(this.itinerary, userSession.itinerary) && Objects.equals(this.searchFilters, userSession.searchFilters) && Objects.equals(this.language, userSession.language) && Objects.equals(this.currency, userSession.currency) && Objects.equals(this.userIdentifier, userSession.userIdentifier) && Objects.equals(this.promotionalCodes, userSession.promotionalCodes) && Objects.equals(this.selectedRoomConfiguration, userSession.selectedRoomConfiguration);
    }

    public int hashCode() {
        return Objects.hash(this.location, this.ipNumber, this.bounds, this.itinerary, this.searchFilters, this.language, this.currency, this.userIdentifier, this.promotionalCodes, this.selectedRoomConfiguration);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserSession {\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    ipNumber: ").append(this.toIndentedString(this.ipNumber)).append("\n");
        sb.append("    bounds: ").append(this.toIndentedString(this.bounds)).append("\n");
        sb.append("    itinerary: ").append(this.toIndentedString(this.itinerary)).append("\n");
        sb.append("    searchFilters: ").append(this.toIndentedString(this.searchFilters)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    userIdentifier: ").append(this.toIndentedString(this.userIdentifier)).append("\n");
        sb.append("    promotionalCodes: ").append(this.toIndentedString(this.promotionalCodes)).append("\n");
        sb.append("    selectedRoomConfiguration: ").append(this.toIndentedString(this.selectedRoomConfiguration)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

