/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [TripPay Acquiring](/payment-acquiring): All APIs related to how our Web Components work. - [TripPay](/payment): All APIs related to account management, mapping and integrator features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Booking Engine API Welcome to the Booking Engine API - A programmer-friendly way to search for bespoke travel inventory and create bookings for you or your customers. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 21.15.1
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.engine.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import travel.wink.sdk.booking.engine.model.UserSession;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * CityScoreRequest
 */
@JsonPropertyOrder({
  CityScoreRequest.JSON_PROPERTY_URL_NAME,
  CityScoreRequest.JSON_PROPERTY_SORT,
  CityScoreRequest.JSON_PROPERTY_USER_SESSION,
  CityScoreRequest.JSON_PROPERTY_PAGE,
  CityScoreRequest.JSON_PROPERTY_SIZE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-08T16:32:00.316996+07:00[Asia/Bangkok]")
public class CityScoreRequest {
  public static final String JSON_PROPERTY_URL_NAME = "urlName";
  private String urlName;

  /**
   * Choose the criteria you want the results sorted on.
   */
  public enum SortEnum {
    MEMBER("MEMBER"),
    
    PRICE_LOW_TO_HIGH("PRICE_LOW_TO_HIGH"),
    
    PRICE_HIGH_TO_LOW("PRICE_HIGH_TO_LOW"),
    
    PRICE("PRICE"),
    
    POPULARITY("POPULARITY"),
    
    ECO("ECO"),
    
    EXPERIENCE("EXPERIENCE"),
    
    PERK("PERK"),
    
    LOYALTY("LOYALTY"),
    
    PACKAGE("PACKAGE");

    private String value;

    SortEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SortEnum fromValue(String value) {
      for (SortEnum b : SortEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SORT = "sort";
  private SortEnum sort;

  public static final String JSON_PROPERTY_USER_SESSION = "userSession";
  private UserSession userSession;

  public static final String JSON_PROPERTY_PAGE = "page";
  private Integer page;

  public static final String JSON_PROPERTY_SIZE = "size";
  private Integer size;

  public CityScoreRequest() { 
  }

  public CityScoreRequest urlName(String urlName) {
    
    this.urlName = urlName;
    return this;
  }

   /**
   * Unique url name for city you wish to search in as it was given to you in the lookup entry.
   * @return urlName
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "los-angeles-california-united-states", required = true, value = "Unique url name for city you wish to search in as it was given to you in the lookup entry.")
  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getUrlName() {
    return urlName;
  }


  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUrlName(String urlName) {
    this.urlName = urlName;
  }


  public CityScoreRequest sort(SortEnum sort) {
    
    this.sort = sort;
    return this;
  }

   /**
   * Choose the criteria you want the results sorted on.
   * @return sort
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "MEMBER", required = true, value = "Choose the criteria you want the results sorted on.")
  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public SortEnum getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSort(SortEnum sort) {
    this.sort = sort;
  }


  public CityScoreRequest userSession(UserSession userSession) {
    
    this.userSession = userSession;
    return this;
  }

   /**
   * Get userSession
   * @return userSession
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_USER_SESSION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UserSession getUserSession() {
    return userSession;
  }


  @JsonProperty(JSON_PROPERTY_USER_SESSION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUserSession(UserSession userSession) {
    this.userSession = userSession;
  }


  public CityScoreRequest page(Integer page) {
    
    this.page = page;
    return this;
  }

   /**
   * The page to paginate to. Note: Page uses a 0-based index.
   * minimum: 0
   * @return page
  **/
  @javax.annotation.Nonnull
  @NotNull
 @Min(0)  @ApiModelProperty(example = "0", required = true, value = "The page to paginate to. Note: Page uses a 0-based index.")
  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getPage() {
    return page;
  }


  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPage(Integer page) {
    this.page = page;
  }


  public CityScoreRequest size(Integer size) {
    
    this.size = size;
    return this;
  }

   /**
   * The result size to return.
   * minimum: 1
   * maximum: 50
   * @return size
  **/
  @javax.annotation.Nonnull
  @NotNull
 @Min(1) @Max(50)  @ApiModelProperty(example = "10", required = true, value = "The result size to return.")
  @JsonProperty(JSON_PROPERTY_SIZE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getSize() {
    return size;
  }


  @JsonProperty(JSON_PROPERTY_SIZE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSize(Integer size) {
    this.size = size;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CityScoreRequest cityScoreRequest = (CityScoreRequest) o;
    return Objects.equals(this.urlName, cityScoreRequest.urlName) &&
        Objects.equals(this.sort, cityScoreRequest.sort) &&
        Objects.equals(this.userSession, cityScoreRequest.userSession) &&
        Objects.equals(this.page, cityScoreRequest.page) &&
        Objects.equals(this.size, cityScoreRequest.size);
  }

  @Override
  public int hashCode() {
    return Objects.hash(urlName, sort, userSession, page, size);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CityScoreRequest {\n");
    sb.append("    urlName: ").append(toIndentedString(urlName)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    userSession: ").append(toIndentedString(userSession)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    size: ").append(toIndentedString(size)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

