/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](https://integration.wink.travel/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Events](https://integration.wink.travel/docs?api=events):  All APIs related to Integration events.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Booking Engine API Welcome to the Booking Engine API - A programmer-friendly way to search for bespoke travel inventory and create bookings for you or your customers. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 21.8.1-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.engine.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.UUID;
import travel.wink.sdk.booking.engine.model.HotelWithBestPrice;
import travel.wink.sdk.booking.engine.model.LocalizedPrice;
import travel.wink.sdk.booking.engine.model.Recreation;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Populated only when the type of grid item is &#x60;ACTIVITY&#x60;
 */
@ApiModel(description = "Populated only when the type of grid item is `ACTIVITY`")
@JsonPropertyOrder({
  ActivityWithBestPrice.JSON_PROPERTY_RECREATION,
  ActivityWithBestPrice.JSON_PROPERTY_PRICE,
  ActivityWithBestPrice.JSON_PROPERTY_HOTEL_WITH_BEST_PRICE,
  ActivityWithBestPrice.JSON_PROPERTY_SORT,
  ActivityWithBestPrice.JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-16T13:27:12.790694+07:00[Asia/Bangkok]")
public class ActivityWithBestPrice {
  public static final String JSON_PROPERTY_RECREATION = "recreation";
  private Recreation recreation;

  public static final String JSON_PROPERTY_PRICE = "price";
  private LocalizedPrice price;

  public static final String JSON_PROPERTY_HOTEL_WITH_BEST_PRICE = "hotelWithBestPrice";
  private HotelWithBestPrice hotelWithBestPrice;

  public static final String JSON_PROPERTY_SORT = "sort";
  private Integer sort = 0;

  public static final String JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER = "channelInventoryIdentifier";
  private UUID channelInventoryIdentifier;

  public ActivityWithBestPrice() { 
  }

  public ActivityWithBestPrice recreation(Recreation recreation) {
    
    this.recreation = recreation;
    return this;
  }

   /**
   * Get recreation
   * @return recreation
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_RECREATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Recreation getRecreation() {
    return recreation;
  }


  @JsonProperty(JSON_PROPERTY_RECREATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecreation(Recreation recreation) {
    this.recreation = recreation;
  }


  public ActivityWithBestPrice price(LocalizedPrice price) {
    
    this.price = price;
    return this;
  }

   /**
   * Get price
   * @return price
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalizedPrice getPrice() {
    return price;
  }


  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrice(LocalizedPrice price) {
    this.price = price;
  }


  public ActivityWithBestPrice hotelWithBestPrice(HotelWithBestPrice hotelWithBestPrice) {
    
    this.hotelWithBestPrice = hotelWithBestPrice;
    return this;
  }

   /**
   * Get hotelWithBestPrice
   * @return hotelWithBestPrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_HOTEL_WITH_BEST_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public HotelWithBestPrice getHotelWithBestPrice() {
    return hotelWithBestPrice;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_WITH_BEST_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelWithBestPrice(HotelWithBestPrice hotelWithBestPrice) {
    this.hotelWithBestPrice = hotelWithBestPrice;
  }


  public ActivityWithBestPrice sort(Integer sort) {
    
    this.sort = sort;
    return this;
  }

   /**
   * Populated when the record is in the context of static lists.
   * @return sort
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1", value = "Populated when the record is in the context of static lists.")
  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSort(Integer sort) {
    this.sort = sort;
  }


  public ActivityWithBestPrice channelInventoryIdentifier(UUID channelInventoryIdentifier) {
    
    this.channelInventoryIdentifier = channelInventoryIdentifier;
    return this;
  }

   /**
   * Channel inventory identifier referencing this spa.
   * @return channelInventoryIdentifier
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Channel inventory identifier referencing this spa.")
  @JsonProperty(JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getChannelInventoryIdentifier() {
    return channelInventoryIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChannelInventoryIdentifier(UUID channelInventoryIdentifier) {
    this.channelInventoryIdentifier = channelInventoryIdentifier;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ActivityWithBestPrice activityWithBestPrice = (ActivityWithBestPrice) o;
    return Objects.equals(this.recreation, activityWithBestPrice.recreation) &&
        Objects.equals(this.price, activityWithBestPrice.price) &&
        Objects.equals(this.hotelWithBestPrice, activityWithBestPrice.hotelWithBestPrice) &&
        Objects.equals(this.sort, activityWithBestPrice.sort) &&
        Objects.equals(this.channelInventoryIdentifier, activityWithBestPrice.channelInventoryIdentifier);
  }

  @Override
  public int hashCode() {
    return Objects.hash(recreation, price, hotelWithBestPrice, sort, channelInventoryIdentifier);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ActivityWithBestPrice {\n");
    sb.append("    recreation: ").append(toIndentedString(recreation)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    hotelWithBestPrice: ").append(toIndentedString(hotelWithBestPrice)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    channelInventoryIdentifier: ").append(toIndentedString(channelInventoryIdentifier)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

