/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.booking.engine.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.validation.Valid;

@ApiModel(description="Extra reservations of spas, meeting rooms etc that should accompany the room type booking.")
@JsonPropertyOrder(value={"typeIdentifier", "type", "startDate", "endDate", "allDay", "attendees"})
public class AncillaryRequest {
    public static final String JSON_PROPERTY_TYPE_IDENTIFIER = "typeIdentifier";
    private UUID typeIdentifier;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_START_DATE = "startDate";
    private OffsetDateTime startDate;
    public static final String JSON_PROPERTY_END_DATE = "endDate";
    private OffsetDateTime endDate;
    public static final String JSON_PROPERTY_ALL_DAY = "allDay";
    private Boolean allDay = false;
    public static final String JSON_PROPERTY_ATTENDEES = "attendees";
    private Integer attendees = 1;

    public AncillaryRequest typeIdentifier(UUID typeIdentifier) {
        this.typeIdentifier = typeIdentifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Travel inventory identifier")
    @JsonProperty(value="typeIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getTypeIdentifier() {
        return this.typeIdentifier;
    }

    @JsonProperty(value="typeIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTypeIdentifier(UUID typeIdentifier) {
        this.typeIdentifier = typeIdentifier;
    }

    public AncillaryRequest type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="PLACE", value="Inventory type")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public AncillaryRequest startDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Date start time when reservation was made for.")
    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
    }

    public AncillaryRequest endDate(OffsetDateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Date end time when reservation was made for.")
    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEndDate(OffsetDateTime endDate) {
        this.endDate = endDate;
    }

    public AncillaryRequest allDay(Boolean allDay) {
        this.allDay = allDay;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Indicates if this reservation is for the whole day.")
    @JsonProperty(value="allDay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAllDay() {
        return this.allDay;
    }

    @JsonProperty(value="allDay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllDay(Boolean allDay) {
        this.allDay = allDay;
    }

    public AncillaryRequest attendees(Integer attendees) {
        this.attendees = attendees;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2", value="Number of guests that are part of this reservation.")
    @JsonProperty(value="attendees")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getAttendees() {
        return this.attendees;
    }

    @JsonProperty(value="attendees")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttendees(Integer attendees) {
        this.attendees = attendees;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AncillaryRequest ancillaryRequest = (AncillaryRequest)o;
        return Objects.equals(this.typeIdentifier, ancillaryRequest.typeIdentifier) && Objects.equals((Object)this.type, (Object)ancillaryRequest.type) && Objects.equals(this.startDate, ancillaryRequest.startDate) && Objects.equals(this.endDate, ancillaryRequest.endDate) && Objects.equals(this.allDay, ancillaryRequest.allDay) && Objects.equals(this.attendees, ancillaryRequest.attendees);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.typeIdentifier, this.type, this.startDate, this.endDate, this.allDay, this.attendees});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AncillaryRequest {\n");
        sb.append("    typeIdentifier: ").append(this.toIndentedString(this.typeIdentifier)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    allDay: ").append(this.toIndentedString(this.allDay)).append("\n");
        sb.append("    attendees: ").append(this.toIndentedString(this.attendees)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        MEETING_ROOM("MEETING_ROOM"),
        SPA("SPA"),
        RESTAURANT("RESTAURANT"),
        ACTIVITY("ACTIVITY"),
        ATTRACTION("ATTRACTION"),
        PLACE("PLACE");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

