/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel blocking on the Wink platform. The API gives you all the tools you need to ready your properties and blocking for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel blocking and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel blocking and get that same blocking out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel blocking and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/engine-client): A single endpoint to retrieve whitelabel + customization information for the booking engine.  - [Lookup](/lookup): All APIs related to locating blocking by region, locale and property flags.  - [Inventory](/blocking): All APIs related to retrieve known travel blocking as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel blocking.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and blocking calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and blocking to sell.  - [Inventory](/affiliate/blocking): The Inventory API exposes endpoints for affiliates to manage the blocking they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel blocking and need taxonomies of standard and non-standard codes for blocking types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel blocking. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Booking Engine API Welcome to the Booking Engine API - A programmer-friendly way to book blocking that was found on our platform. This API lets you:  1. Shopping Cart: Manage shopping cart. 2. Checkout: Move shopping cart items through the reactive workflow. 3. Booking: Move selected blocking through to booking completion. 4. Review: Leave a review after a completed stay.  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.9.11
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.booking.model.AddressAuthenticatedEntity;
import travel.wink.sdk.booking.model.ContactAuthenticatedEntity;
import travel.wink.sdk.booking.model.GeneralManagerAuthenticatedEntity;
import travel.wink.sdk.booking.model.GeoJsonPointAuthenticatedEntity;
import travel.wink.sdk.booking.model.LocalizedDescriptionAuthenticatedEntity;
import travel.wink.sdk.booking.model.PropertyPolicyAuthenticatedEntity;
import travel.wink.sdk.booking.model.SimpleMultimediaAuthenticatedEntity;
import travel.wink.sdk.booking.model.SocialAuthenticatedEntity;
import travel.wink.sdk.booking.model.TravelInventoryRecognitionAuthenticatedEntity;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * The hotel where the stay occurs.
 */
@JsonPropertyOrder({
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_IDENTIFIER,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_HOTEL_IDENTIFIER,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_NAME,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_LOCAL_NAME,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_CHAIN,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_BRAND,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_URL_NAME,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_STAR_RATING,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_BOOKINGS,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_AGGREGATE_REVIEW_RATING,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_LOCATION,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_SHORT_DESCRIPTIONS,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_LONG_DESCRIPTIONS,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_AGGREGATE_GREENDEX_RATING,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_LIFESTYLE_TYPES,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_TOTAL_REVIEWS,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_AVAILABLE,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_HOTEL_AVAILABLE,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_RESERVATIONS,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_SOCIALS,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_IMAGES,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_VIDEOS,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_POLICY,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_THIRD_PARTY_REVIEWS,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_ATTRACTIONS,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_RECREATIONS,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_POIS,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_RESTAURANTS,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_MEETING_ROOMS,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_SPAS,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_ADD_ONS,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_GENERAL_MANAGER,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_LOCATION_CATEGORY,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_SEGMENT_CATEGORY,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_HOTEL_CATEGORY,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_ARCHITECTURAL_STYLE,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_WHEN_BUILT,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_CURRENCY_CODE,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_MEMBERSHIP_RATE_DISCOUNT,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_PRICE_SCORE,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_PERK_SCORE,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_PACKAGE_SCORE,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_LOYALTY_SCORE,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_POPULAR_SCORE,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_EXPERIENCE_SCORE,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_AVAILABILITY_SCORE,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_VIEWS,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_HOTEL_AMENITY_CODES,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_PROPERTY_ACCESSIBILITY_CODES,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_PROPERTY_SECURITY_CODES,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_NUMBER_OF_ROOMS,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_ADDRESS,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_ACTIVE,
  HotelOnMapAuthenticatedEntity.JSON_PROPERTY_URL_PARAMETERS
})
@JsonTypeName("HotelOnMap_Authenticated_Entity")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-12-27T09:35:47.117628182+07:00[Asia/Bangkok]")
public class HotelOnMapAuthenticatedEntity {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private String identifier;

  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private UUID hotelIdentifier;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_LOCAL_NAME = "localName";
  private String localName;

  public static final String JSON_PROPERTY_CHAIN = "chain";
  private String chain;

  public static final String JSON_PROPERTY_BRAND = "brand";
  private String brand;

  public static final String JSON_PROPERTY_URL_NAME = "urlName";
  private String urlName;

  public static final String JSON_PROPERTY_STAR_RATING = "starRating";
  private Integer starRating;

  public static final String JSON_PROPERTY_BOOKINGS = "bookings";
  private Long bookings = 0l;

  public static final String JSON_PROPERTY_AGGREGATE_REVIEW_RATING = "aggregateReviewRating";
  private Float aggregateReviewRating = 0.0f;

  public static final String JSON_PROPERTY_LOCATION = "location";
  private GeoJsonPointAuthenticatedEntity location;

  public static final String JSON_PROPERTY_SHORT_DESCRIPTIONS = "shortDescriptions";
  private List<LocalizedDescriptionAuthenticatedEntity> shortDescriptions;

  public static final String JSON_PROPERTY_LONG_DESCRIPTIONS = "longDescriptions";
  private List<LocalizedDescriptionAuthenticatedEntity> longDescriptions;

  public static final String JSON_PROPERTY_AGGREGATE_GREENDEX_RATING = "aggregateGreendexRating";
  private Float aggregateGreendexRating = 0.0f;

  /**
   * A list of lifestyles the property associates with.
   */
  public enum LifestyleTypesEnum {
    HEALTH_FITNESS("LIFESTYLE_HEALTH_FITNESS"),
    
    RELAX("LIFESTYLE_RELAX"),
    
    ADULT_ONLY("LIFESTYLE_ADULT_ONLY"),
    
    ADVENTURE("LIFESTYLE_ADVENTURE"),
    
    BUSINESS("LIFESTYLE_BUSINESS"),
    
    LGBT("LIFESTYLE_LGBT"),
    
    SINGLE_PARENT("LIFESTYLE_SINGLE_PARENT"),
    
    SOLO_FEMALE("LIFESTYLE_SOLO_FEMALE"),
    
    BEAUTY("LIFESTYLE_BEAUTY"),
    
    FOODIE("LIFESTYLE_FOODIE"),
    
    FAMILY("LIFESTYLE_FAMILY"),
    
    ROMANCE("LIFESTYLE_ROMANCE"),
    
    COUPLE("LIFESTYLE_COUPLE"),
    
    SOLO("LIFESTYLE_SOLO"),
    
    BACKPACKER("LIFESTYLE_BACKPACKER"),
    
    SHOPPING("LIFESTYLE_SHOPPING"),
    
    SPORTS("LIFESTYLE_SPORTS"),
    
    MOUNTAIN("LIFESTYLE_MOUNTAIN"),
    
    BEACH("LIFESTYLE_BEACH"),
    
    CITY("LIFESTYLE_CITY"),
    
    COUNTRY("LIFESTYLE_COUNTRY"),
    
    CULTURE("LIFESTYLE_CULTURE"),
    
    ECO("LIFESTYLE_ECO");

    private String value;

    LifestyleTypesEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static LifestyleTypesEnum fromValue(String value) {
      for (LifestyleTypesEnum b : LifestyleTypesEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_LIFESTYLE_TYPES = "lifestyleTypes";
  private List<LifestyleTypesEnum> lifestyleTypes;

  public static final String JSON_PROPERTY_TOTAL_REVIEWS = "totalReviews";
  private Integer totalReviews = 0;

  public static final String JSON_PROPERTY_AVAILABLE = "available";
  private Boolean available = false;

  public static final String JSON_PROPERTY_HOTEL_AVAILABLE = "hotelAvailable";
  private Boolean hotelAvailable = false;

  public static final String JSON_PROPERTY_RESERVATIONS = "reservations";
  private ContactAuthenticatedEntity reservations;

  public static final String JSON_PROPERTY_SOCIALS = "socials";
  private List<SocialAuthenticatedEntity> socials;

  public static final String JSON_PROPERTY_IMAGES = "images";
  private List<SimpleMultimediaAuthenticatedEntity> images;

  public static final String JSON_PROPERTY_VIDEOS = "videos";
  private List<SimpleMultimediaAuthenticatedEntity> videos;

  public static final String JSON_PROPERTY_POLICY = "policy";
  private PropertyPolicyAuthenticatedEntity policy;

  public static final String JSON_PROPERTY_THIRD_PARTY_REVIEWS = "thirdPartyReviews";
  private List<TravelInventoryRecognitionAuthenticatedEntity> thirdPartyReviews;

  public static final String JSON_PROPERTY_ATTRACTIONS = "attractions";
  private Integer attractions = 0;

  public static final String JSON_PROPERTY_RECREATIONS = "recreations";
  private Integer recreations = 0;

  public static final String JSON_PROPERTY_POIS = "pois";
  private Integer pois = 0;

  public static final String JSON_PROPERTY_RESTAURANTS = "restaurants";
  private Integer restaurants = 0;

  public static final String JSON_PROPERTY_MEETING_ROOMS = "meetingRooms";
  private Integer meetingRooms = 0;

  public static final String JSON_PROPERTY_SPAS = "spas";
  private Integer spas = 0;

  public static final String JSON_PROPERTY_ADD_ONS = "addOns";
  private Integer addOns = 0;

  public static final String JSON_PROPERTY_GENERAL_MANAGER = "generalManager";
  private GeneralManagerAuthenticatedEntity generalManager;

  public static final String JSON_PROPERTY_LOCATION_CATEGORY = "locationCategory";
  private String locationCategory;

  public static final String JSON_PROPERTY_SEGMENT_CATEGORY = "segmentCategory";
  private String segmentCategory;

  public static final String JSON_PROPERTY_HOTEL_CATEGORY = "hotelCategory";
  private String hotelCategory;

  public static final String JSON_PROPERTY_ARCHITECTURAL_STYLE = "architecturalStyle";
  private String architecturalStyle;

  public static final String JSON_PROPERTY_WHEN_BUILT = "whenBuilt";
  private String whenBuilt;

  public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
  private String currencyCode;

  public static final String JSON_PROPERTY_MEMBERSHIP_RATE_DISCOUNT = "membershipRateDiscount";
  private Float membershipRateDiscount = 0f;

  public static final String JSON_PROPERTY_PRICE_SCORE = "priceScore";
  private Integer priceScore = 0;

  public static final String JSON_PROPERTY_PERK_SCORE = "perkScore";
  private Integer perkScore = 0;

  public static final String JSON_PROPERTY_PACKAGE_SCORE = "packageScore";
  private Integer packageScore = 0;

  public static final String JSON_PROPERTY_LOYALTY_SCORE = "loyaltyScore";
  private Integer loyaltyScore = 0;

  public static final String JSON_PROPERTY_POPULAR_SCORE = "popularScore";
  private Integer popularScore = 0;

  public static final String JSON_PROPERTY_EXPERIENCE_SCORE = "experienceScore";
  private Integer experienceScore = 0;

  public static final String JSON_PROPERTY_AVAILABILITY_SCORE = "availabilityScore";
  private Integer availabilityScore = 0;

  public static final String JSON_PROPERTY_VIEWS = "views";
  private Long views = 0l;

  public static final String JSON_PROPERTY_HOTEL_AMENITY_CODES = "hotelAmenityCodes";
  private List<String> hotelAmenityCodes;

  public static final String JSON_PROPERTY_PROPERTY_ACCESSIBILITY_CODES = "propertyAccessibilityCodes";
  private List<String> propertyAccessibilityCodes;

  public static final String JSON_PROPERTY_PROPERTY_SECURITY_CODES = "propertySecurityCodes";
  private List<String> propertySecurityCodes;

  public static final String JSON_PROPERTY_NUMBER_OF_ROOMS = "numberOfRooms";
  private Integer numberOfRooms = 0;

  public static final String JSON_PROPERTY_ADDRESS = "address";
  private AddressAuthenticatedEntity address;

  public static final String JSON_PROPERTY_ACTIVE = "active";
  private Boolean active;

  public static final String JSON_PROPERTY_URL_PARAMETERS = "urlParameters";
  private String urlParameters;

  public HotelOnMapAuthenticatedEntity() {
  }

  public HotelOnMapAuthenticatedEntity identifier(String identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique record identifier. This is NOT the same as the unique hotel record identifier.
   * @return identifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifier(String identifier) {
    this.identifier = identifier;
  }


  public HotelOnMapAuthenticatedEntity hotelIdentifier(UUID hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Unique hotel record identifier.
   * @return hotelIdentifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelIdentifier(UUID hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public HotelOnMapAuthenticatedEntity name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Hotel trade name
   * @return name
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public HotelOnMapAuthenticatedEntity localName(String localName) {
    
    this.localName = localName;
    return this;
  }

   /**
   * Hotel local name if different from the trade name or if it is the local language.
   * @return localName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LOCAL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLocalName() {
    return localName;
  }


  @JsonProperty(JSON_PROPERTY_LOCAL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocalName(String localName) {
    this.localName = localName;
  }


  public HotelOnMapAuthenticatedEntity chain(String chain) {
    
    this.chain = chain;
    return this;
  }

   /**
   * Name of hotel chain if applicable.
   * @return chain
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CHAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getChain() {
    return chain;
  }


  @JsonProperty(JSON_PROPERTY_CHAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChain(String chain) {
    this.chain = chain;
  }


  public HotelOnMapAuthenticatedEntity brand(String brand) {
    
    this.brand = brand;
    return this;
  }

   /**
   * Name of hotel brand
   * @return brand
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BRAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBrand() {
    return brand;
  }


  @JsonProperty(JSON_PROPERTY_BRAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBrand(String brand) {
    this.brand = brand;
  }


  public HotelOnMapAuthenticatedEntity urlName(String urlName) {
    
    this.urlName = urlName;
    return this;
  }

   /**
   * Unique URL-friendly name slug of hotel
   * @return urlName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUrlName() {
    return urlName;
  }


  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUrlName(String urlName) {
    this.urlName = urlName;
  }


  public HotelOnMapAuthenticatedEntity starRating(Integer starRating) {
    
    this.starRating = starRating;
    return this;
  }

   /**
   * Official or self-designated property star rating. Note that in some regions there are 6-star hotels. They are the same as 5-star hotels everywhere else.
   * minimum: 0
   * maximum: 6
   * @return starRating
  **/
  @jakarta.annotation.Nullable
 @Min(0) @Max(6)
  @JsonProperty(JSON_PROPERTY_STAR_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getStarRating() {
    return starRating;
  }


  @JsonProperty(JSON_PROPERTY_STAR_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStarRating(Integer starRating) {
    this.starRating = starRating;
  }


  public HotelOnMapAuthenticatedEntity bookings(Long bookings) {
    
    this.bookings = bookings;
    return this;
  }

   /**
   * Number of bookings for this property on the wink.travel platform.
   * @return bookings
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BOOKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getBookings() {
    return bookings;
  }


  @JsonProperty(JSON_PROPERTY_BOOKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBookings(Long bookings) {
    this.bookings = bookings;
  }


  public HotelOnMapAuthenticatedEntity aggregateReviewRating(Float aggregateReviewRating) {
    
    this.aggregateReviewRating = aggregateReviewRating;
    return this;
  }

   /**
   * Aggregate score based on all current user reviews.
   * @return aggregateReviewRating
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AGGREGATE_REVIEW_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getAggregateReviewRating() {
    return aggregateReviewRating;
  }


  @JsonProperty(JSON_PROPERTY_AGGREGATE_REVIEW_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAggregateReviewRating(Float aggregateReviewRating) {
    this.aggregateReviewRating = aggregateReviewRating;
  }


  public HotelOnMapAuthenticatedEntity location(GeoJsonPointAuthenticatedEntity location) {
    
    this.location = location;
    return this;
  }

   /**
   * Get location
   * @return location
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GeoJsonPointAuthenticatedEntity getLocation() {
    return location;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocation(GeoJsonPointAuthenticatedEntity location) {
    this.location = location;
  }


  public HotelOnMapAuthenticatedEntity shortDescriptions(List<LocalizedDescriptionAuthenticatedEntity> shortDescriptions) {
    
    this.shortDescriptions = shortDescriptions;
    return this;
  }

  public HotelOnMapAuthenticatedEntity addShortDescriptionsItem(LocalizedDescriptionAuthenticatedEntity shortDescriptionsItem) {
    if (this.shortDescriptions == null) {
      this.shortDescriptions = new ArrayList<>();
    }
    this.shortDescriptions.add(shortDescriptionsItem);
    return this;
  }

   /**
   * A localized list of short property descriptions
   * @return shortDescriptions
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SHORT_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<LocalizedDescriptionAuthenticatedEntity> getShortDescriptions() {
    return shortDescriptions;
  }


  @JsonProperty(JSON_PROPERTY_SHORT_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShortDescriptions(List<LocalizedDescriptionAuthenticatedEntity> shortDescriptions) {
    this.shortDescriptions = shortDescriptions;
  }


  public HotelOnMapAuthenticatedEntity longDescriptions(List<LocalizedDescriptionAuthenticatedEntity> longDescriptions) {
    
    this.longDescriptions = longDescriptions;
    return this;
  }

  public HotelOnMapAuthenticatedEntity addLongDescriptionsItem(LocalizedDescriptionAuthenticatedEntity longDescriptionsItem) {
    if (this.longDescriptions == null) {
      this.longDescriptions = new ArrayList<>();
    }
    this.longDescriptions.add(longDescriptionsItem);
    return this;
  }

   /**
   * A localized list of longer property descriptions
   * @return longDescriptions
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LONG_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<LocalizedDescriptionAuthenticatedEntity> getLongDescriptions() {
    return longDescriptions;
  }


  @JsonProperty(JSON_PROPERTY_LONG_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLongDescriptions(List<LocalizedDescriptionAuthenticatedEntity> longDescriptions) {
    this.longDescriptions = longDescriptions;
  }


  public HotelOnMapAuthenticatedEntity aggregateGreendexRating(Float aggregateGreendexRating) {
    
    this.aggregateGreendexRating = aggregateGreendexRating;
    return this;
  }

   /**
   * Aggregate Green Index score if the property has answered our questionnaire available in the Extranet.
   * @return aggregateGreendexRating
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AGGREGATE_GREENDEX_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getAggregateGreendexRating() {
    return aggregateGreendexRating;
  }


  @JsonProperty(JSON_PROPERTY_AGGREGATE_GREENDEX_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAggregateGreendexRating(Float aggregateGreendexRating) {
    this.aggregateGreendexRating = aggregateGreendexRating;
  }


  public HotelOnMapAuthenticatedEntity lifestyleTypes(List<LifestyleTypesEnum> lifestyleTypes) {
    
    this.lifestyleTypes = lifestyleTypes;
    return this;
  }

  public HotelOnMapAuthenticatedEntity addLifestyleTypesItem(LifestyleTypesEnum lifestyleTypesItem) {
    if (this.lifestyleTypes == null) {
      this.lifestyleTypes = new ArrayList<>();
    }
    this.lifestyleTypes.add(lifestyleTypesItem);
    return this;
  }

   /**
   * Get lifestyleTypes
   * @return lifestyleTypes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LIFESTYLE_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<LifestyleTypesEnum> getLifestyleTypes() {
    return lifestyleTypes;
  }


  @JsonProperty(JSON_PROPERTY_LIFESTYLE_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLifestyleTypes(List<LifestyleTypesEnum> lifestyleTypes) {
    this.lifestyleTypes = lifestyleTypes;
  }


  public HotelOnMapAuthenticatedEntity totalReviews(Integer totalReviews) {
    
    this.totalReviews = totalReviews;
    return this;
  }

   /**
   * Count of total reviews left by users at this property.
   * @return totalReviews
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_REVIEWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getTotalReviews() {
    return totalReviews;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_REVIEWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalReviews(Integer totalReviews) {
    this.totalReviews = totalReviews;
  }


  public HotelOnMapAuthenticatedEntity available(Boolean available) {
    
    this.available = available;
    return this;
  }

   /**
   * Flag indicating whether the reactive has made this property available for sale.
   * @return available
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAvailable() {
    return available;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailable(Boolean available) {
    this.available = available;
  }


  public HotelOnMapAuthenticatedEntity hotelAvailable(Boolean hotelAvailable) {
    
    this.hotelAvailable = hotelAvailable;
    return this;
  }

   /**
   * Flag indicating whether the property has made this property available for sale.
   * @return hotelAvailable
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HOTEL_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHotelAvailable() {
    return hotelAvailable;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelAvailable(Boolean hotelAvailable) {
    this.hotelAvailable = hotelAvailable;
  }


  public HotelOnMapAuthenticatedEntity reservations(ContactAuthenticatedEntity reservations) {
    
    this.reservations = reservations;
    return this;
  }

   /**
   * Get reservations
   * @return reservations
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_RESERVATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ContactAuthenticatedEntity getReservations() {
    return reservations;
  }


  @JsonProperty(JSON_PROPERTY_RESERVATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReservations(ContactAuthenticatedEntity reservations) {
    this.reservations = reservations;
  }


  public HotelOnMapAuthenticatedEntity socials(List<SocialAuthenticatedEntity> socials) {
    
    this.socials = socials;
    return this;
  }

  public HotelOnMapAuthenticatedEntity addSocialsItem(SocialAuthenticatedEntity socialsItem) {
    if (this.socials == null) {
      this.socials = new ArrayList<>();
    }
    this.socials.add(socialsItem);
    return this;
  }

   /**
   * Property&#39;s social network accounts
   * @return socials
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SocialAuthenticatedEntity> getSocials() {
    return socials;
  }


  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSocials(List<SocialAuthenticatedEntity> socials) {
    this.socials = socials;
  }


  public HotelOnMapAuthenticatedEntity images(List<SimpleMultimediaAuthenticatedEntity> images) {
    
    this.images = images;
    return this;
  }

  public HotelOnMapAuthenticatedEntity addImagesItem(SimpleMultimediaAuthenticatedEntity imagesItem) {
    if (this.images == null) {
      this.images = new ArrayList<>();
    }
    this.images.add(imagesItem);
    return this;
  }

   /**
   * Property images.
   * @return images
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_IMAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SimpleMultimediaAuthenticatedEntity> getImages() {
    return images;
  }


  @JsonProperty(JSON_PROPERTY_IMAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImages(List<SimpleMultimediaAuthenticatedEntity> images) {
    this.images = images;
  }


  public HotelOnMapAuthenticatedEntity videos(List<SimpleMultimediaAuthenticatedEntity> videos) {
    
    this.videos = videos;
    return this;
  }

  public HotelOnMapAuthenticatedEntity addVideosItem(SimpleMultimediaAuthenticatedEntity videosItem) {
    if (this.videos == null) {
      this.videos = new ArrayList<>();
    }
    this.videos.add(videosItem);
    return this;
  }

   /**
   * Property videos.
   * @return videos
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_VIDEOS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SimpleMultimediaAuthenticatedEntity> getVideos() {
    return videos;
  }


  @JsonProperty(JSON_PROPERTY_VIDEOS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVideos(List<SimpleMultimediaAuthenticatedEntity> videos) {
    this.videos = videos;
  }


  public HotelOnMapAuthenticatedEntity policy(PropertyPolicyAuthenticatedEntity policy) {
    
    this.policy = policy;
    return this;
  }

   /**
   * Get policy
   * @return policy
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PropertyPolicyAuthenticatedEntity getPolicy() {
    return policy;
  }


  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPolicy(PropertyPolicyAuthenticatedEntity policy) {
    this.policy = policy;
  }


  public HotelOnMapAuthenticatedEntity thirdPartyReviews(List<TravelInventoryRecognitionAuthenticatedEntity> thirdPartyReviews) {
    
    this.thirdPartyReviews = thirdPartyReviews;
    return this;
  }

  public HotelOnMapAuthenticatedEntity addThirdPartyReviewsItem(TravelInventoryRecognitionAuthenticatedEntity thirdPartyReviewsItem) {
    if (this.thirdPartyReviews == null) {
      this.thirdPartyReviews = new ArrayList<>();
    }
    this.thirdPartyReviews.add(thirdPartyReviewsItem);
    return this;
  }

   /**
   * Array of awards and third party reviews given to property by certified / non-certified providers.
   * @return thirdPartyReviews
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_THIRD_PARTY_REVIEWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TravelInventoryRecognitionAuthenticatedEntity> getThirdPartyReviews() {
    return thirdPartyReviews;
  }


  @JsonProperty(JSON_PROPERTY_THIRD_PARTY_REVIEWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThirdPartyReviews(List<TravelInventoryRecognitionAuthenticatedEntity> thirdPartyReviews) {
    this.thirdPartyReviews = thirdPartyReviews;
  }


  public HotelOnMapAuthenticatedEntity attractions(Integer attractions) {
    
    this.attractions = attractions;
    return this;
  }

   /**
   * Number of attractions property has listed on its profile.
   * @return attractions
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAttractions() {
    return attractions;
  }


  @JsonProperty(JSON_PROPERTY_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttractions(Integer attractions) {
    this.attractions = attractions;
  }


  public HotelOnMapAuthenticatedEntity recreations(Integer recreations) {
    
    this.recreations = recreations;
    return this;
  }

   /**
   * Number of activites property has listed on its profile.
   * @return recreations
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RECREATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRecreations() {
    return recreations;
  }


  @JsonProperty(JSON_PROPERTY_RECREATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecreations(Integer recreations) {
    this.recreations = recreations;
  }


  public HotelOnMapAuthenticatedEntity pois(Integer pois) {
    
    this.pois = pois;
    return this;
  }

   /**
   * Number of places property has listed on its profile.
   * @return pois
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_POIS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPois() {
    return pois;
  }


  @JsonProperty(JSON_PROPERTY_POIS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPois(Integer pois) {
    this.pois = pois;
  }


  public HotelOnMapAuthenticatedEntity restaurants(Integer restaurants) {
    
    this.restaurants = restaurants;
    return this;
  }

   /**
   * Number of restaurants property has on its profile.
   * @return restaurants
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRestaurants() {
    return restaurants;
  }


  @JsonProperty(JSON_PROPERTY_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRestaurants(Integer restaurants) {
    this.restaurants = restaurants;
  }


  public HotelOnMapAuthenticatedEntity meetingRooms(Integer meetingRooms) {
    
    this.meetingRooms = meetingRooms;
    return this;
  }

   /**
   * Number of meeting rooms property has on its profile.
   * @return meetingRooms
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMeetingRooms() {
    return meetingRooms;
  }


  @JsonProperty(JSON_PROPERTY_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMeetingRooms(Integer meetingRooms) {
    this.meetingRooms = meetingRooms;
  }


  public HotelOnMapAuthenticatedEntity spas(Integer spas) {
    
    this.spas = spas;
    return this;
  }

   /**
   * Number of spas property has on its profile.
   * @return spas
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSpas() {
    return spas;
  }


  @JsonProperty(JSON_PROPERTY_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSpas(Integer spas) {
    this.spas = spas;
  }


  public HotelOnMapAuthenticatedEntity addOns(Integer addOns) {
    
    this.addOns = addOns;
    return this;
  }

   /**
   * Number of add-ons property has on its profile.
   * @return addOns
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAddOns() {
    return addOns;
  }


  @JsonProperty(JSON_PROPERTY_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddOns(Integer addOns) {
    this.addOns = addOns;
  }


  public HotelOnMapAuthenticatedEntity generalManager(GeneralManagerAuthenticatedEntity generalManager) {
    
    this.generalManager = generalManager;
    return this;
  }

   /**
   * Get generalManager
   * @return generalManager
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_GENERAL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GeneralManagerAuthenticatedEntity getGeneralManager() {
    return generalManager;
  }


  @JsonProperty(JSON_PROPERTY_GENERAL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGeneralManager(GeneralManagerAuthenticatedEntity generalManager) {
    this.generalManager = generalManager;
  }


  public HotelOnMapAuthenticatedEntity locationCategory(String locationCategory) {
    
    this.locationCategory = locationCategory;
    return this;
  }

   /**
   * Supported OTA specification &#x60;LOC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return locationCategory
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LOCATION_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLocationCategory() {
    return locationCategory;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocationCategory(String locationCategory) {
    this.locationCategory = locationCategory;
  }


  public HotelOnMapAuthenticatedEntity segmentCategory(String segmentCategory) {
    
    this.segmentCategory = segmentCategory;
    return this;
  }

   /**
   * Supported OTA specification &#x60;SEG&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return segmentCategory
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SEGMENT_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSegmentCategory() {
    return segmentCategory;
  }


  @JsonProperty(JSON_PROPERTY_SEGMENT_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSegmentCategory(String segmentCategory) {
    this.segmentCategory = segmentCategory;
  }


  public HotelOnMapAuthenticatedEntity hotelCategory(String hotelCategory) {
    
    this.hotelCategory = hotelCategory;
    return this;
  }

   /**
   * Supported OTA specification &#x60;PCT&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return hotelCategory
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HOTEL_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHotelCategory() {
    return hotelCategory;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelCategory(String hotelCategory) {
    this.hotelCategory = hotelCategory;
  }


  public HotelOnMapAuthenticatedEntity architecturalStyle(String architecturalStyle) {
    
    this.architecturalStyle = architecturalStyle;
    return this;
  }

   /**
   * Supported OTA specification &#x60;ARC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return architecturalStyle
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ARCHITECTURAL_STYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getArchitecturalStyle() {
    return architecturalStyle;
  }


  @JsonProperty(JSON_PROPERTY_ARCHITECTURAL_STYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setArchitecturalStyle(String architecturalStyle) {
    this.architecturalStyle = architecturalStyle;
  }


  public HotelOnMapAuthenticatedEntity whenBuilt(String whenBuilt) {
    
    this.whenBuilt = whenBuilt;
    return this;
  }

   /**
   * Year the property was constructed.
   * @return whenBuilt
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_WHEN_BUILT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getWhenBuilt() {
    return whenBuilt;
  }


  @JsonProperty(JSON_PROPERTY_WHEN_BUILT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWhenBuilt(String whenBuilt) {
    this.whenBuilt = whenBuilt;
  }


  public HotelOnMapAuthenticatedEntity currencyCode(String currencyCode) {
    
    this.currencyCode = currencyCode;
    return this;
  }

   /**
   * Currency code for property.
   * @return currencyCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrencyCode() {
    return currencyCode;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrencyCode(String currencyCode) {
    this.currencyCode = currencyCode;
  }


  public HotelOnMapAuthenticatedEntity membershipRateDiscount(Float membershipRateDiscount) {
    
    this.membershipRateDiscount = membershipRateDiscount;
    return this;
  }

   /**
   * A property&#39;s price score is based on calculating historical pricing data. Each property receives a unique score. There is no max score; it&#39;s there to compare it against other properties.
   * @return membershipRateDiscount
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MEMBERSHIP_RATE_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getMembershipRateDiscount() {
    return membershipRateDiscount;
  }


  @JsonProperty(JSON_PROPERTY_MEMBERSHIP_RATE_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMembershipRateDiscount(Float membershipRateDiscount) {
    this.membershipRateDiscount = membershipRateDiscount;
  }


  public HotelOnMapAuthenticatedEntity priceScore(Integer priceScore) {
    
    this.priceScore = priceScore;
    return this;
  }

   /**
   * A property&#39;s price score is based on calculating historical pricing data. Each property receives a unique score. There is no max score; it&#39;s there to compare it against other properties.
   * @return priceScore
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PRICE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPriceScore() {
    return priceScore;
  }


  @JsonProperty(JSON_PROPERTY_PRICE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPriceScore(Integer priceScore) {
    this.priceScore = priceScore;
  }


  public HotelOnMapAuthenticatedEntity perkScore(Integer perkScore) {
    
    this.perkScore = perkScore;
    return this;
  }

   /**
   * A property&#39;s perk score is based on the type of perks that is offered to the guests across all master rates. There is no max score; it&#39;s there to compare it against other properties.
   * @return perkScore
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PERK_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPerkScore() {
    return perkScore;
  }


  @JsonProperty(JSON_PROPERTY_PERK_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPerkScore(Integer perkScore) {
    this.perkScore = perkScore;
  }


  public HotelOnMapAuthenticatedEntity packageScore(Integer packageScore) {
    
    this.packageScore = packageScore;
    return this;
  }

   /**
   * A property&#39;s package score is based on general availability and price for all packages and add-ons offered by the property. There is no max score; it&#39;s there to compare it against other properties.
   * @return packageScore
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PACKAGE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPackageScore() {
    return packageScore;
  }


  @JsonProperty(JSON_PROPERTY_PACKAGE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPackageScore(Integer packageScore) {
    this.packageScore = packageScore;
  }


  public HotelOnMapAuthenticatedEntity loyaltyScore(Integer loyaltyScore) {
    
    this.loyaltyScore = loyaltyScore;
    return this;
  }

   /**
   * A property&#39;s loyalty score is based on calculating how many available rate plans honor loyalty points. There is no max score; it&#39;s there to compare it against other properties.
   * @return loyaltyScore
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LOYALTY_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getLoyaltyScore() {
    return loyaltyScore;
  }


  @JsonProperty(JSON_PROPERTY_LOYALTY_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLoyaltyScore(Integer loyaltyScore) {
    this.loyaltyScore = loyaltyScore;
  }


  public HotelOnMapAuthenticatedEntity popularScore(Integer popularScore) {
    
    this.popularScore = popularScore;
    return this;
  }

   /**
   * A property&#39;s popular score is based on calculating number of bookings across room types. There is no max score; it&#39;s there to compare it against other properties.
   * @return popularScore
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_POPULAR_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPopularScore() {
    return popularScore;
  }


  @JsonProperty(JSON_PROPERTY_POPULAR_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPopularScore(Integer popularScore) {
    this.popularScore = popularScore;
  }


  public HotelOnMapAuthenticatedEntity experienceScore(Integer experienceScore) {
    
    this.experienceScore = experienceScore;
    return this;
  }

   /**
   * A property&#39;s experience score is based on how calculating how many types of experiences are available and at what price ranges. There is no max score; it&#39;s there to compare it against other properties.
   * @return experienceScore
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_EXPERIENCE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getExperienceScore() {
    return experienceScore;
  }


  @JsonProperty(JSON_PROPERTY_EXPERIENCE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExperienceScore(Integer experienceScore) {
    this.experienceScore = experienceScore;
  }


  public HotelOnMapAuthenticatedEntity availabilityScore(Integer availabilityScore) {
    
    this.availabilityScore = availabilityScore;
    return this;
  }

   /**
   * A property&#39;s availability score is based on general availability of all room types. If most room types are always unavailable, the attractiveness of this property goes down. We use this as our primary benchmark to decide how and when to feature properties. There is no max score; it&#39;s there to compare it against other properties.
   * @return availabilityScore
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AVAILABILITY_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAvailabilityScore() {
    return availabilityScore;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABILITY_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailabilityScore(Integer availabilityScore) {
    this.availabilityScore = availabilityScore;
  }


  public HotelOnMapAuthenticatedEntity views(Long views) {
    
    this.views = views;
    return this;
  }

   /**
   * Total number of user views of this property.
   * @return views
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_VIEWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getViews() {
    return views;
  }


  @JsonProperty(JSON_PROPERTY_VIEWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setViews(Long views) {
    this.views = views;
  }


  public HotelOnMapAuthenticatedEntity hotelAmenityCodes(List<String> hotelAmenityCodes) {
    
    this.hotelAmenityCodes = hotelAmenityCodes;
    return this;
  }

  public HotelOnMapAuthenticatedEntity addHotelAmenityCodesItem(String hotelAmenityCodesItem) {
    if (this.hotelAmenityCodes == null) {
      this.hotelAmenityCodes = new ArrayList<>();
    }
    this.hotelAmenityCodes.add(hotelAmenityCodesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;HAC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return hotelAmenityCodes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HOTEL_AMENITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getHotelAmenityCodes() {
    return hotelAmenityCodes;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_AMENITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelAmenityCodes(List<String> hotelAmenityCodes) {
    this.hotelAmenityCodes = hotelAmenityCodes;
  }


  public HotelOnMapAuthenticatedEntity propertyAccessibilityCodes(List<String> propertyAccessibilityCodes) {
    
    this.propertyAccessibilityCodes = propertyAccessibilityCodes;
    return this;
  }

  public HotelOnMapAuthenticatedEntity addPropertyAccessibilityCodesItem(String propertyAccessibilityCodesItem) {
    if (this.propertyAccessibilityCodes == null) {
      this.propertyAccessibilityCodes = new ArrayList<>();
    }
    this.propertyAccessibilityCodes.add(propertyAccessibilityCodesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;PHY&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return propertyAccessibilityCodes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROPERTY_ACCESSIBILITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPropertyAccessibilityCodes() {
    return propertyAccessibilityCodes;
  }


  @JsonProperty(JSON_PROPERTY_PROPERTY_ACCESSIBILITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPropertyAccessibilityCodes(List<String> propertyAccessibilityCodes) {
    this.propertyAccessibilityCodes = propertyAccessibilityCodes;
  }


  public HotelOnMapAuthenticatedEntity propertySecurityCodes(List<String> propertySecurityCodes) {
    
    this.propertySecurityCodes = propertySecurityCodes;
    return this;
  }

  public HotelOnMapAuthenticatedEntity addPropertySecurityCodesItem(String propertySecurityCodesItem) {
    if (this.propertySecurityCodes == null) {
      this.propertySecurityCodes = new ArrayList<>();
    }
    this.propertySecurityCodes.add(propertySecurityCodesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;SEC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return propertySecurityCodes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROPERTY_SECURITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPropertySecurityCodes() {
    return propertySecurityCodes;
  }


  @JsonProperty(JSON_PROPERTY_PROPERTY_SECURITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPropertySecurityCodes(List<String> propertySecurityCodes) {
    this.propertySecurityCodes = propertySecurityCodes;
  }


  public HotelOnMapAuthenticatedEntity numberOfRooms(Integer numberOfRooms) {
    
    this.numberOfRooms = numberOfRooms;
    return this;
  }

   /**
   * Number of rooms / keys for this property.
   * @return numberOfRooms
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NUMBER_OF_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getNumberOfRooms() {
    return numberOfRooms;
  }


  @JsonProperty(JSON_PROPERTY_NUMBER_OF_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumberOfRooms(Integer numberOfRooms) {
    this.numberOfRooms = numberOfRooms;
  }


  public HotelOnMapAuthenticatedEntity address(AddressAuthenticatedEntity address) {
    
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AddressAuthenticatedEntity getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddress(AddressAuthenticatedEntity address) {
    this.address = address;
  }


  public HotelOnMapAuthenticatedEntity active(Boolean active) {
    
    this.active = active;
    return this;
  }

   /**
   * A property is considered active when both available and hotelAvailable flags are true.
   * @return active
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getActive() {
    return active;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActive(Boolean active) {
    this.active = active;
  }


  public HotelOnMapAuthenticatedEntity urlParameters(String urlParameters) {
    
    this.urlParameters = urlParameters;
    return this;
  }

   /**
   * Convenience data point that creates url friendly query parameters of property.
   * @return urlParameters
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_URL_PARAMETERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUrlParameters() {
    return urlParameters;
  }


  @JsonProperty(JSON_PROPERTY_URL_PARAMETERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUrlParameters(String urlParameters) {
    this.urlParameters = urlParameters;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HotelOnMapAuthenticatedEntity hotelOnMapAuthenticatedEntity = (HotelOnMapAuthenticatedEntity) o;
    return Objects.equals(this.identifier, hotelOnMapAuthenticatedEntity.identifier) &&
        Objects.equals(this.hotelIdentifier, hotelOnMapAuthenticatedEntity.hotelIdentifier) &&
        Objects.equals(this.name, hotelOnMapAuthenticatedEntity.name) &&
        Objects.equals(this.localName, hotelOnMapAuthenticatedEntity.localName) &&
        Objects.equals(this.chain, hotelOnMapAuthenticatedEntity.chain) &&
        Objects.equals(this.brand, hotelOnMapAuthenticatedEntity.brand) &&
        Objects.equals(this.urlName, hotelOnMapAuthenticatedEntity.urlName) &&
        Objects.equals(this.starRating, hotelOnMapAuthenticatedEntity.starRating) &&
        Objects.equals(this.bookings, hotelOnMapAuthenticatedEntity.bookings) &&
        Objects.equals(this.aggregateReviewRating, hotelOnMapAuthenticatedEntity.aggregateReviewRating) &&
        Objects.equals(this.location, hotelOnMapAuthenticatedEntity.location) &&
        Objects.equals(this.shortDescriptions, hotelOnMapAuthenticatedEntity.shortDescriptions) &&
        Objects.equals(this.longDescriptions, hotelOnMapAuthenticatedEntity.longDescriptions) &&
        Objects.equals(this.aggregateGreendexRating, hotelOnMapAuthenticatedEntity.aggregateGreendexRating) &&
        Objects.equals(this.lifestyleTypes, hotelOnMapAuthenticatedEntity.lifestyleTypes) &&
        Objects.equals(this.totalReviews, hotelOnMapAuthenticatedEntity.totalReviews) &&
        Objects.equals(this.available, hotelOnMapAuthenticatedEntity.available) &&
        Objects.equals(this.hotelAvailable, hotelOnMapAuthenticatedEntity.hotelAvailable) &&
        Objects.equals(this.reservations, hotelOnMapAuthenticatedEntity.reservations) &&
        Objects.equals(this.socials, hotelOnMapAuthenticatedEntity.socials) &&
        Objects.equals(this.images, hotelOnMapAuthenticatedEntity.images) &&
        Objects.equals(this.videos, hotelOnMapAuthenticatedEntity.videos) &&
        Objects.equals(this.policy, hotelOnMapAuthenticatedEntity.policy) &&
        Objects.equals(this.thirdPartyReviews, hotelOnMapAuthenticatedEntity.thirdPartyReviews) &&
        Objects.equals(this.attractions, hotelOnMapAuthenticatedEntity.attractions) &&
        Objects.equals(this.recreations, hotelOnMapAuthenticatedEntity.recreations) &&
        Objects.equals(this.pois, hotelOnMapAuthenticatedEntity.pois) &&
        Objects.equals(this.restaurants, hotelOnMapAuthenticatedEntity.restaurants) &&
        Objects.equals(this.meetingRooms, hotelOnMapAuthenticatedEntity.meetingRooms) &&
        Objects.equals(this.spas, hotelOnMapAuthenticatedEntity.spas) &&
        Objects.equals(this.addOns, hotelOnMapAuthenticatedEntity.addOns) &&
        Objects.equals(this.generalManager, hotelOnMapAuthenticatedEntity.generalManager) &&
        Objects.equals(this.locationCategory, hotelOnMapAuthenticatedEntity.locationCategory) &&
        Objects.equals(this.segmentCategory, hotelOnMapAuthenticatedEntity.segmentCategory) &&
        Objects.equals(this.hotelCategory, hotelOnMapAuthenticatedEntity.hotelCategory) &&
        Objects.equals(this.architecturalStyle, hotelOnMapAuthenticatedEntity.architecturalStyle) &&
        Objects.equals(this.whenBuilt, hotelOnMapAuthenticatedEntity.whenBuilt) &&
        Objects.equals(this.currencyCode, hotelOnMapAuthenticatedEntity.currencyCode) &&
        Objects.equals(this.membershipRateDiscount, hotelOnMapAuthenticatedEntity.membershipRateDiscount) &&
        Objects.equals(this.priceScore, hotelOnMapAuthenticatedEntity.priceScore) &&
        Objects.equals(this.perkScore, hotelOnMapAuthenticatedEntity.perkScore) &&
        Objects.equals(this.packageScore, hotelOnMapAuthenticatedEntity.packageScore) &&
        Objects.equals(this.loyaltyScore, hotelOnMapAuthenticatedEntity.loyaltyScore) &&
        Objects.equals(this.popularScore, hotelOnMapAuthenticatedEntity.popularScore) &&
        Objects.equals(this.experienceScore, hotelOnMapAuthenticatedEntity.experienceScore) &&
        Objects.equals(this.availabilityScore, hotelOnMapAuthenticatedEntity.availabilityScore) &&
        Objects.equals(this.views, hotelOnMapAuthenticatedEntity.views) &&
        Objects.equals(this.hotelAmenityCodes, hotelOnMapAuthenticatedEntity.hotelAmenityCodes) &&
        Objects.equals(this.propertyAccessibilityCodes, hotelOnMapAuthenticatedEntity.propertyAccessibilityCodes) &&
        Objects.equals(this.propertySecurityCodes, hotelOnMapAuthenticatedEntity.propertySecurityCodes) &&
        Objects.equals(this.numberOfRooms, hotelOnMapAuthenticatedEntity.numberOfRooms) &&
        Objects.equals(this.address, hotelOnMapAuthenticatedEntity.address) &&
        Objects.equals(this.active, hotelOnMapAuthenticatedEntity.active) &&
        Objects.equals(this.urlParameters, hotelOnMapAuthenticatedEntity.urlParameters);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, hotelIdentifier, name, localName, chain, brand, urlName, starRating, bookings, aggregateReviewRating, location, shortDescriptions, longDescriptions, aggregateGreendexRating, lifestyleTypes, totalReviews, available, hotelAvailable, reservations, socials, images, videos, policy, thirdPartyReviews, attractions, recreations, pois, restaurants, meetingRooms, spas, addOns, generalManager, locationCategory, segmentCategory, hotelCategory, architecturalStyle, whenBuilt, currencyCode, membershipRateDiscount, priceScore, perkScore, packageScore, loyaltyScore, popularScore, experienceScore, availabilityScore, views, hotelAmenityCodes, propertyAccessibilityCodes, propertySecurityCodes, numberOfRooms, address, active, urlParameters);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HotelOnMapAuthenticatedEntity {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    localName: ").append(toIndentedString(localName)).append("\n");
    sb.append("    chain: ").append(toIndentedString(chain)).append("\n");
    sb.append("    brand: ").append(toIndentedString(brand)).append("\n");
    sb.append("    urlName: ").append(toIndentedString(urlName)).append("\n");
    sb.append("    starRating: ").append(toIndentedString(starRating)).append("\n");
    sb.append("    bookings: ").append(toIndentedString(bookings)).append("\n");
    sb.append("    aggregateReviewRating: ").append(toIndentedString(aggregateReviewRating)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    shortDescriptions: ").append(toIndentedString(shortDescriptions)).append("\n");
    sb.append("    longDescriptions: ").append(toIndentedString(longDescriptions)).append("\n");
    sb.append("    aggregateGreendexRating: ").append(toIndentedString(aggregateGreendexRating)).append("\n");
    sb.append("    lifestyleTypes: ").append(toIndentedString(lifestyleTypes)).append("\n");
    sb.append("    totalReviews: ").append(toIndentedString(totalReviews)).append("\n");
    sb.append("    available: ").append(toIndentedString(available)).append("\n");
    sb.append("    hotelAvailable: ").append(toIndentedString(hotelAvailable)).append("\n");
    sb.append("    reservations: ").append(toIndentedString(reservations)).append("\n");
    sb.append("    socials: ").append(toIndentedString(socials)).append("\n");
    sb.append("    images: ").append(toIndentedString(images)).append("\n");
    sb.append("    videos: ").append(toIndentedString(videos)).append("\n");
    sb.append("    policy: ").append(toIndentedString(policy)).append("\n");
    sb.append("    thirdPartyReviews: ").append(toIndentedString(thirdPartyReviews)).append("\n");
    sb.append("    attractions: ").append(toIndentedString(attractions)).append("\n");
    sb.append("    recreations: ").append(toIndentedString(recreations)).append("\n");
    sb.append("    pois: ").append(toIndentedString(pois)).append("\n");
    sb.append("    restaurants: ").append(toIndentedString(restaurants)).append("\n");
    sb.append("    meetingRooms: ").append(toIndentedString(meetingRooms)).append("\n");
    sb.append("    spas: ").append(toIndentedString(spas)).append("\n");
    sb.append("    addOns: ").append(toIndentedString(addOns)).append("\n");
    sb.append("    generalManager: ").append(toIndentedString(generalManager)).append("\n");
    sb.append("    locationCategory: ").append(toIndentedString(locationCategory)).append("\n");
    sb.append("    segmentCategory: ").append(toIndentedString(segmentCategory)).append("\n");
    sb.append("    hotelCategory: ").append(toIndentedString(hotelCategory)).append("\n");
    sb.append("    architecturalStyle: ").append(toIndentedString(architecturalStyle)).append("\n");
    sb.append("    whenBuilt: ").append(toIndentedString(whenBuilt)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("    membershipRateDiscount: ").append(toIndentedString(membershipRateDiscount)).append("\n");
    sb.append("    priceScore: ").append(toIndentedString(priceScore)).append("\n");
    sb.append("    perkScore: ").append(toIndentedString(perkScore)).append("\n");
    sb.append("    packageScore: ").append(toIndentedString(packageScore)).append("\n");
    sb.append("    loyaltyScore: ").append(toIndentedString(loyaltyScore)).append("\n");
    sb.append("    popularScore: ").append(toIndentedString(popularScore)).append("\n");
    sb.append("    experienceScore: ").append(toIndentedString(experienceScore)).append("\n");
    sb.append("    availabilityScore: ").append(toIndentedString(availabilityScore)).append("\n");
    sb.append("    views: ").append(toIndentedString(views)).append("\n");
    sb.append("    hotelAmenityCodes: ").append(toIndentedString(hotelAmenityCodes)).append("\n");
    sb.append("    propertyAccessibilityCodes: ").append(toIndentedString(propertyAccessibilityCodes)).append("\n");
    sb.append("    propertySecurityCodes: ").append(toIndentedString(propertySecurityCodes)).append("\n");
    sb.append("    numberOfRooms: ").append(toIndentedString(numberOfRooms)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    urlParameters: ").append(toIndentedString(urlParameters)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

