/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel blocking on the Wink platform. The API gives you all the tools you need to ready your properties and blocking for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel blocking and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel blocking and get that same blocking out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel blocking and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/engine-client): A single endpoint to retrieve whitelabel + customization information for the booking engine.  - [Lookup](/lookup): All APIs related to locating blocking by region, locale and property flags.  - [Inventory](/blocking): All APIs related to retrieve known travel blocking as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel blocking.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and blocking calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and blocking to sell.  - [Inventory](/affiliate/blocking): The Inventory API exposes endpoints for affiliates to manage the blocking they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel blocking and need taxonomies of standard and non-standard codes for blocking types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel blocking. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Booking Engine API Welcome to the Booking Engine API - A programmer-friendly way to book blocking that was found on our platform. This API lets you:  1. Shopping Cart: Manage shopping cart. 2. Checkout: Move shopping cart items through the reactive workflow. 3. Booking: Move selected blocking through to booking completion. 4. Review: Leave a review after a completed stay.  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.9.11
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import travel.wink.sdk.booking.model.CustomMonetaryAmount;
import travel.wink.sdk.booking.model.QuoteBooker;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Pricing information for this ancillary.
 */
@JsonPropertyOrder({
  LocalizedPriceBooker.JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE,
  LocalizedPriceBooker.JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE,
  LocalizedPriceBooker.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_BASE_TOTAL,
  LocalizedPriceBooker.JSON_PROPERTY_SOURCE_BASE_TOTAL,
  LocalizedPriceBooker.JSON_PROPERTY_INTERNAL_BASE_TOTAL,
  LocalizedPriceBooker.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PROMOTIONAL_MODIFIER,
  LocalizedPriceBooker.JSON_PROPERTY_SOURCE_PROMOTIONAL_MODIFIER,
  LocalizedPriceBooker.JSON_PROPERTY_INTERNAL_PROMOTIONAL_MODIFIER,
  LocalizedPriceBooker.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PREMIUM_MODIFIER,
  LocalizedPriceBooker.JSON_PROPERTY_SOURCE_PREMIUM_MODIFIER,
  LocalizedPriceBooker.JSON_PROPERTY_INTERNAL_PREMIUM_MODIFIER,
  LocalizedPriceBooker.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_CHANNEL_MODIFIER,
  LocalizedPriceBooker.JSON_PROPERTY_SOURCE_CHANNEL_MODIFIER,
  LocalizedPriceBooker.JSON_PROPERTY_INTERNAL_CHANNEL_MODIFIER,
  LocalizedPriceBooker.JSON_PROPERTY_QUANTITY,
  LocalizedPriceBooker.JSON_PROPERTY_PROMOTIONAL_DISCOUNT_PERCENT,
  LocalizedPriceBooker.JSON_PROPERTY_CHANNEL_DISCOUNT_PERCENT,
  LocalizedPriceBooker.JSON_PROPERTY_PREMIUM_PERCENT,
  LocalizedPriceBooker.JSON_PROPERTY_HAS_PREMIUM,
  LocalizedPriceBooker.JSON_PROPERTY_HAS_PROMOTION,
  LocalizedPriceBooker.JSON_PROPERTY_HAS_CHANNEL_DISCOUNT,
  LocalizedPriceBooker.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL,
  LocalizedPriceBooker.JSON_PROPERTY_INTERNAL_TOTAL,
  LocalizedPriceBooker.JSON_PROPERTY_SOURCE_TOTAL,
  LocalizedPriceBooker.JSON_PROPERTY_TOTAL_DISCOUNT_PERCENT
})
@JsonTypeName("LocalizedPrice_Booker")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-12-27T09:35:47.117628182+07:00[Asia/Bangkok]")
public class LocalizedPriceBooker {
  public static final String JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE = "sourceToUserCurrencyQuote";
  private QuoteBooker sourceToUserCurrencyQuote;

  public static final String JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE = "sourceToInternalCurrencyQuote";
  private QuoteBooker sourceToInternalCurrencyQuote;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_BASE_TOTAL = "userSpecifiedCurrencyBaseTotal";
  private CustomMonetaryAmount userSpecifiedCurrencyBaseTotal;

  public static final String JSON_PROPERTY_SOURCE_BASE_TOTAL = "sourceBaseTotal";
  private CustomMonetaryAmount sourceBaseTotal;

  public static final String JSON_PROPERTY_INTERNAL_BASE_TOTAL = "internalBaseTotal";
  private CustomMonetaryAmount internalBaseTotal;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PROMOTIONAL_MODIFIER = "userSpecifiedCurrencyPromotionalModifier";
  private BigDecimal userSpecifiedCurrencyPromotionalModifier;

  public static final String JSON_PROPERTY_SOURCE_PROMOTIONAL_MODIFIER = "sourcePromotionalModifier";
  private BigDecimal sourcePromotionalModifier;

  public static final String JSON_PROPERTY_INTERNAL_PROMOTIONAL_MODIFIER = "internalPromotionalModifier";
  private BigDecimal internalPromotionalModifier;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PREMIUM_MODIFIER = "userSpecifiedCurrencyPremiumModifier";
  private BigDecimal userSpecifiedCurrencyPremiumModifier;

  public static final String JSON_PROPERTY_SOURCE_PREMIUM_MODIFIER = "sourcePremiumModifier";
  private BigDecimal sourcePremiumModifier;

  public static final String JSON_PROPERTY_INTERNAL_PREMIUM_MODIFIER = "internalPremiumModifier";
  private BigDecimal internalPremiumModifier;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_CHANNEL_MODIFIER = "userSpecifiedCurrencyChannelModifier";
  private BigDecimal userSpecifiedCurrencyChannelModifier;

  public static final String JSON_PROPERTY_SOURCE_CHANNEL_MODIFIER = "sourceChannelModifier";
  private BigDecimal sourceChannelModifier;

  public static final String JSON_PROPERTY_INTERNAL_CHANNEL_MODIFIER = "internalChannelModifier";
  private BigDecimal internalChannelModifier;

  public static final String JSON_PROPERTY_QUANTITY = "quantity";
  private Long quantity = 1l;

  public static final String JSON_PROPERTY_PROMOTIONAL_DISCOUNT_PERCENT = "promotionalDiscountPercent";
  private Float promotionalDiscountPercent;

  public static final String JSON_PROPERTY_CHANNEL_DISCOUNT_PERCENT = "channelDiscountPercent";
  private Float channelDiscountPercent;

  public static final String JSON_PROPERTY_PREMIUM_PERCENT = "premiumPercent";
  private Float premiumPercent;

  public static final String JSON_PROPERTY_HAS_PREMIUM = "hasPremium";
  private Boolean hasPremium;

  public static final String JSON_PROPERTY_HAS_PROMOTION = "hasPromotion";
  private Boolean hasPromotion;

  public static final String JSON_PROPERTY_HAS_CHANNEL_DISCOUNT = "hasChannelDiscount";
  private Boolean hasChannelDiscount;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL = "userSpecifiedCurrencyTotal";
  private CustomMonetaryAmount userSpecifiedCurrencyTotal;

  public static final String JSON_PROPERTY_INTERNAL_TOTAL = "internalTotal";
  private CustomMonetaryAmount internalTotal;

  public static final String JSON_PROPERTY_SOURCE_TOTAL = "sourceTotal";
  private CustomMonetaryAmount sourceTotal;

  public static final String JSON_PROPERTY_TOTAL_DISCOUNT_PERCENT = "totalDiscountPercent";
  private Float totalDiscountPercent;

  public LocalizedPriceBooker() {
  }

  public LocalizedPriceBooker sourceToUserCurrencyQuote(QuoteBooker sourceToUserCurrencyQuote) {
    
    this.sourceToUserCurrencyQuote = sourceToUserCurrencyQuote;
    return this;
  }

   /**
   * Get sourceToUserCurrencyQuote
   * @return sourceToUserCurrencyQuote
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public QuoteBooker getSourceToUserCurrencyQuote() {
    return sourceToUserCurrencyQuote;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceToUserCurrencyQuote(QuoteBooker sourceToUserCurrencyQuote) {
    this.sourceToUserCurrencyQuote = sourceToUserCurrencyQuote;
  }


  public LocalizedPriceBooker sourceToInternalCurrencyQuote(QuoteBooker sourceToInternalCurrencyQuote) {
    
    this.sourceToInternalCurrencyQuote = sourceToInternalCurrencyQuote;
    return this;
  }

   /**
   * Get sourceToInternalCurrencyQuote
   * @return sourceToInternalCurrencyQuote
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public QuoteBooker getSourceToInternalCurrencyQuote() {
    return sourceToInternalCurrencyQuote;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceToInternalCurrencyQuote(QuoteBooker sourceToInternalCurrencyQuote) {
    this.sourceToInternalCurrencyQuote = sourceToInternalCurrencyQuote;
  }


  public LocalizedPriceBooker userSpecifiedCurrencyBaseTotal(CustomMonetaryAmount userSpecifiedCurrencyBaseTotal) {
    
    this.userSpecifiedCurrencyBaseTotal = userSpecifiedCurrencyBaseTotal;
    return this;
  }

   /**
   * Get userSpecifiedCurrencyBaseTotal
   * @return userSpecifiedCurrencyBaseTotal
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CustomMonetaryAmount getUserSpecifiedCurrencyBaseTotal() {
    return userSpecifiedCurrencyBaseTotal;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUserSpecifiedCurrencyBaseTotal(CustomMonetaryAmount userSpecifiedCurrencyBaseTotal) {
    this.userSpecifiedCurrencyBaseTotal = userSpecifiedCurrencyBaseTotal;
  }


  public LocalizedPriceBooker sourceBaseTotal(CustomMonetaryAmount sourceBaseTotal) {
    
    this.sourceBaseTotal = sourceBaseTotal;
    return this;
  }

   /**
   * Get sourceBaseTotal
   * @return sourceBaseTotal
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CustomMonetaryAmount getSourceBaseTotal() {
    return sourceBaseTotal;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceBaseTotal(CustomMonetaryAmount sourceBaseTotal) {
    this.sourceBaseTotal = sourceBaseTotal;
  }


  public LocalizedPriceBooker internalBaseTotal(CustomMonetaryAmount internalBaseTotal) {
    
    this.internalBaseTotal = internalBaseTotal;
    return this;
  }

   /**
   * Get internalBaseTotal
   * @return internalBaseTotal
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CustomMonetaryAmount getInternalBaseTotal() {
    return internalBaseTotal;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInternalBaseTotal(CustomMonetaryAmount internalBaseTotal) {
    this.internalBaseTotal = internalBaseTotal;
  }


  public LocalizedPriceBooker userSpecifiedCurrencyPromotionalModifier(BigDecimal userSpecifiedCurrencyPromotionalModifier) {
    
    this.userSpecifiedCurrencyPromotionalModifier = userSpecifiedCurrencyPromotionalModifier;
    return this;
  }

   /**
   * Promotional modifiers in user specified currency
   * @return userSpecifiedCurrencyPromotionalModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getUserSpecifiedCurrencyPromotionalModifier() {
    return userSpecifiedCurrencyPromotionalModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyPromotionalModifier(BigDecimal userSpecifiedCurrencyPromotionalModifier) {
    this.userSpecifiedCurrencyPromotionalModifier = userSpecifiedCurrencyPromotionalModifier;
  }


  public LocalizedPriceBooker sourcePromotionalModifier(BigDecimal sourcePromotionalModifier) {
    
    this.sourcePromotionalModifier = sourcePromotionalModifier;
    return this;
  }

   /**
   * Promotional modifiers in hotel currency
   * @return sourcePromotionalModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSourcePromotionalModifier() {
    return sourcePromotionalModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourcePromotionalModifier(BigDecimal sourcePromotionalModifier) {
    this.sourcePromotionalModifier = sourcePromotionalModifier;
  }


  public LocalizedPriceBooker internalPromotionalModifier(BigDecimal internalPromotionalModifier) {
    
    this.internalPromotionalModifier = internalPromotionalModifier;
    return this;
  }

   /**
   * Promotional modifiers in wink currency
   * @return internalPromotionalModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getInternalPromotionalModifier() {
    return internalPromotionalModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalPromotionalModifier(BigDecimal internalPromotionalModifier) {
    this.internalPromotionalModifier = internalPromotionalModifier;
  }


  public LocalizedPriceBooker userSpecifiedCurrencyPremiumModifier(BigDecimal userSpecifiedCurrencyPremiumModifier) {
    
    this.userSpecifiedCurrencyPremiumModifier = userSpecifiedCurrencyPremiumModifier;
    return this;
  }

   /**
   * Premium modifiers in user specified currency
   * @return userSpecifiedCurrencyPremiumModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getUserSpecifiedCurrencyPremiumModifier() {
    return userSpecifiedCurrencyPremiumModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyPremiumModifier(BigDecimal userSpecifiedCurrencyPremiumModifier) {
    this.userSpecifiedCurrencyPremiumModifier = userSpecifiedCurrencyPremiumModifier;
  }


  public LocalizedPriceBooker sourcePremiumModifier(BigDecimal sourcePremiumModifier) {
    
    this.sourcePremiumModifier = sourcePremiumModifier;
    return this;
  }

   /**
   * Premium modifiers in hotel currency
   * @return sourcePremiumModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSourcePremiumModifier() {
    return sourcePremiumModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourcePremiumModifier(BigDecimal sourcePremiumModifier) {
    this.sourcePremiumModifier = sourcePremiumModifier;
  }


  public LocalizedPriceBooker internalPremiumModifier(BigDecimal internalPremiumModifier) {
    
    this.internalPremiumModifier = internalPremiumModifier;
    return this;
  }

   /**
   * Premium modifiers in wink currency
   * @return internalPremiumModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getInternalPremiumModifier() {
    return internalPremiumModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalPremiumModifier(BigDecimal internalPremiumModifier) {
    this.internalPremiumModifier = internalPremiumModifier;
  }


  public LocalizedPriceBooker userSpecifiedCurrencyChannelModifier(BigDecimal userSpecifiedCurrencyChannelModifier) {
    
    this.userSpecifiedCurrencyChannelModifier = userSpecifiedCurrencyChannelModifier;
    return this;
  }

   /**
   * Channel / Membership modifier in user specified currency
   * @return userSpecifiedCurrencyChannelModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getUserSpecifiedCurrencyChannelModifier() {
    return userSpecifiedCurrencyChannelModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyChannelModifier(BigDecimal userSpecifiedCurrencyChannelModifier) {
    this.userSpecifiedCurrencyChannelModifier = userSpecifiedCurrencyChannelModifier;
  }


  public LocalizedPriceBooker sourceChannelModifier(BigDecimal sourceChannelModifier) {
    
    this.sourceChannelModifier = sourceChannelModifier;
    return this;
  }

   /**
   * Channel / Membership modifier in hotel currency
   * @return sourceChannelModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSourceChannelModifier() {
    return sourceChannelModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceChannelModifier(BigDecimal sourceChannelModifier) {
    this.sourceChannelModifier = sourceChannelModifier;
  }


  public LocalizedPriceBooker internalChannelModifier(BigDecimal internalChannelModifier) {
    
    this.internalChannelModifier = internalChannelModifier;
    return this;
  }

   /**
   * Channel / Membership modifier in wink currency
   * @return internalChannelModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getInternalChannelModifier() {
    return internalChannelModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalChannelModifier(BigDecimal internalChannelModifier) {
    this.internalChannelModifier = internalChannelModifier;
  }


  public LocalizedPriceBooker quantity(Long quantity) {
    
    this.quantity = quantity;
    return this;
  }

   /**
   * How many of this item is included in this price
   * @return quantity
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getQuantity() {
    return quantity;
  }


  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setQuantity(Long quantity) {
    this.quantity = quantity;
  }


  public LocalizedPriceBooker promotionalDiscountPercent(Float promotionalDiscountPercent) {
    
    this.promotionalDiscountPercent = promotionalDiscountPercent;
    return this;
  }

   /**
   * Promotional discount percent
   * @return promotionalDiscountPercent
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getPromotionalDiscountPercent() {
    return promotionalDiscountPercent;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotionalDiscountPercent(Float promotionalDiscountPercent) {
    this.promotionalDiscountPercent = promotionalDiscountPercent;
  }


  public LocalizedPriceBooker channelDiscountPercent(Float channelDiscountPercent) {
    
    this.channelDiscountPercent = channelDiscountPercent;
    return this;
  }

   /**
   * Channel discount percent
   * @return channelDiscountPercent
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CHANNEL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getChannelDiscountPercent() {
    return channelDiscountPercent;
  }


  @JsonProperty(JSON_PROPERTY_CHANNEL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChannelDiscountPercent(Float channelDiscountPercent) {
    this.channelDiscountPercent = channelDiscountPercent;
  }


  public LocalizedPriceBooker premiumPercent(Float premiumPercent) {
    
    this.premiumPercent = premiumPercent;
    return this;
  }

   /**
   * Premium percent
   * @return premiumPercent
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PREMIUM_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getPremiumPercent() {
    return premiumPercent;
  }


  @JsonProperty(JSON_PROPERTY_PREMIUM_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPremiumPercent(Float premiumPercent) {
    this.premiumPercent = premiumPercent;
  }


  public LocalizedPriceBooker hasPremium(Boolean hasPremium) {
    
    this.hasPremium = hasPremium;
    return this;
  }

   /**
   * Get hasPremium
   * @return hasPremium
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_PREMIUM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasPremium() {
    return hasPremium;
  }


  @JsonProperty(JSON_PROPERTY_HAS_PREMIUM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasPremium(Boolean hasPremium) {
    this.hasPremium = hasPremium;
  }


  public LocalizedPriceBooker hasPromotion(Boolean hasPromotion) {
    
    this.hasPromotion = hasPromotion;
    return this;
  }

   /**
   * Get hasPromotion
   * @return hasPromotion
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_PROMOTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasPromotion() {
    return hasPromotion;
  }


  @JsonProperty(JSON_PROPERTY_HAS_PROMOTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasPromotion(Boolean hasPromotion) {
    this.hasPromotion = hasPromotion;
  }


  public LocalizedPriceBooker hasChannelDiscount(Boolean hasChannelDiscount) {
    
    this.hasChannelDiscount = hasChannelDiscount;
    return this;
  }

   /**
   * Get hasChannelDiscount
   * @return hasChannelDiscount
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_CHANNEL_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasChannelDiscount() {
    return hasChannelDiscount;
  }


  @JsonProperty(JSON_PROPERTY_HAS_CHANNEL_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasChannelDiscount(Boolean hasChannelDiscount) {
    this.hasChannelDiscount = hasChannelDiscount;
  }


  public LocalizedPriceBooker userSpecifiedCurrencyTotal(CustomMonetaryAmount userSpecifiedCurrencyTotal) {
    
    this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
    return this;
  }

   /**
   * Get userSpecifiedCurrencyTotal
   * @return userSpecifiedCurrencyTotal
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getUserSpecifiedCurrencyTotal() {
    return userSpecifiedCurrencyTotal;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyTotal(CustomMonetaryAmount userSpecifiedCurrencyTotal) {
    this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
  }


  public LocalizedPriceBooker internalTotal(CustomMonetaryAmount internalTotal) {
    
    this.internalTotal = internalTotal;
    return this;
  }

   /**
   * Get internalTotal
   * @return internalTotal
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getInternalTotal() {
    return internalTotal;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalTotal(CustomMonetaryAmount internalTotal) {
    this.internalTotal = internalTotal;
  }


  public LocalizedPriceBooker sourceTotal(CustomMonetaryAmount sourceTotal) {
    
    this.sourceTotal = sourceTotal;
    return this;
  }

   /**
   * Get sourceTotal
   * @return sourceTotal
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getSourceTotal() {
    return sourceTotal;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceTotal(CustomMonetaryAmount sourceTotal) {
    this.sourceTotal = sourceTotal;
  }


  public LocalizedPriceBooker totalDiscountPercent(Float totalDiscountPercent) {
    
    this.totalDiscountPercent = totalDiscountPercent;
    return this;
  }

   /**
   * Get totalDiscountPercent
   * @return totalDiscountPercent
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getTotalDiscountPercent() {
    return totalDiscountPercent;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalDiscountPercent(Float totalDiscountPercent) {
    this.totalDiscountPercent = totalDiscountPercent;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LocalizedPriceBooker localizedPriceBooker = (LocalizedPriceBooker) o;
    return Objects.equals(this.sourceToUserCurrencyQuote, localizedPriceBooker.sourceToUserCurrencyQuote) &&
        Objects.equals(this.sourceToInternalCurrencyQuote, localizedPriceBooker.sourceToInternalCurrencyQuote) &&
        Objects.equals(this.userSpecifiedCurrencyBaseTotal, localizedPriceBooker.userSpecifiedCurrencyBaseTotal) &&
        Objects.equals(this.sourceBaseTotal, localizedPriceBooker.sourceBaseTotal) &&
        Objects.equals(this.internalBaseTotal, localizedPriceBooker.internalBaseTotal) &&
        Objects.equals(this.userSpecifiedCurrencyPromotionalModifier, localizedPriceBooker.userSpecifiedCurrencyPromotionalModifier) &&
        Objects.equals(this.sourcePromotionalModifier, localizedPriceBooker.sourcePromotionalModifier) &&
        Objects.equals(this.internalPromotionalModifier, localizedPriceBooker.internalPromotionalModifier) &&
        Objects.equals(this.userSpecifiedCurrencyPremiumModifier, localizedPriceBooker.userSpecifiedCurrencyPremiumModifier) &&
        Objects.equals(this.sourcePremiumModifier, localizedPriceBooker.sourcePremiumModifier) &&
        Objects.equals(this.internalPremiumModifier, localizedPriceBooker.internalPremiumModifier) &&
        Objects.equals(this.userSpecifiedCurrencyChannelModifier, localizedPriceBooker.userSpecifiedCurrencyChannelModifier) &&
        Objects.equals(this.sourceChannelModifier, localizedPriceBooker.sourceChannelModifier) &&
        Objects.equals(this.internalChannelModifier, localizedPriceBooker.internalChannelModifier) &&
        Objects.equals(this.quantity, localizedPriceBooker.quantity) &&
        Objects.equals(this.promotionalDiscountPercent, localizedPriceBooker.promotionalDiscountPercent) &&
        Objects.equals(this.channelDiscountPercent, localizedPriceBooker.channelDiscountPercent) &&
        Objects.equals(this.premiumPercent, localizedPriceBooker.premiumPercent) &&
        Objects.equals(this.hasPremium, localizedPriceBooker.hasPremium) &&
        Objects.equals(this.hasPromotion, localizedPriceBooker.hasPromotion) &&
        Objects.equals(this.hasChannelDiscount, localizedPriceBooker.hasChannelDiscount) &&
        Objects.equals(this.userSpecifiedCurrencyTotal, localizedPriceBooker.userSpecifiedCurrencyTotal) &&
        Objects.equals(this.internalTotal, localizedPriceBooker.internalTotal) &&
        Objects.equals(this.sourceTotal, localizedPriceBooker.sourceTotal) &&
        Objects.equals(this.totalDiscountPercent, localizedPriceBooker.totalDiscountPercent);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sourceToUserCurrencyQuote, sourceToInternalCurrencyQuote, userSpecifiedCurrencyBaseTotal, sourceBaseTotal, internalBaseTotal, userSpecifiedCurrencyPromotionalModifier, sourcePromotionalModifier, internalPromotionalModifier, userSpecifiedCurrencyPremiumModifier, sourcePremiumModifier, internalPremiumModifier, userSpecifiedCurrencyChannelModifier, sourceChannelModifier, internalChannelModifier, quantity, promotionalDiscountPercent, channelDiscountPercent, premiumPercent, hasPremium, hasPromotion, hasChannelDiscount, userSpecifiedCurrencyTotal, internalTotal, sourceTotal, totalDiscountPercent);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LocalizedPriceBooker {\n");
    sb.append("    sourceToUserCurrencyQuote: ").append(toIndentedString(sourceToUserCurrencyQuote)).append("\n");
    sb.append("    sourceToInternalCurrencyQuote: ").append(toIndentedString(sourceToInternalCurrencyQuote)).append("\n");
    sb.append("    userSpecifiedCurrencyBaseTotal: ").append(toIndentedString(userSpecifiedCurrencyBaseTotal)).append("\n");
    sb.append("    sourceBaseTotal: ").append(toIndentedString(sourceBaseTotal)).append("\n");
    sb.append("    internalBaseTotal: ").append(toIndentedString(internalBaseTotal)).append("\n");
    sb.append("    userSpecifiedCurrencyPromotionalModifier: ").append(toIndentedString(userSpecifiedCurrencyPromotionalModifier)).append("\n");
    sb.append("    sourcePromotionalModifier: ").append(toIndentedString(sourcePromotionalModifier)).append("\n");
    sb.append("    internalPromotionalModifier: ").append(toIndentedString(internalPromotionalModifier)).append("\n");
    sb.append("    userSpecifiedCurrencyPremiumModifier: ").append(toIndentedString(userSpecifiedCurrencyPremiumModifier)).append("\n");
    sb.append("    sourcePremiumModifier: ").append(toIndentedString(sourcePremiumModifier)).append("\n");
    sb.append("    internalPremiumModifier: ").append(toIndentedString(internalPremiumModifier)).append("\n");
    sb.append("    userSpecifiedCurrencyChannelModifier: ").append(toIndentedString(userSpecifiedCurrencyChannelModifier)).append("\n");
    sb.append("    sourceChannelModifier: ").append(toIndentedString(sourceChannelModifier)).append("\n");
    sb.append("    internalChannelModifier: ").append(toIndentedString(internalChannelModifier)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    promotionalDiscountPercent: ").append(toIndentedString(promotionalDiscountPercent)).append("\n");
    sb.append("    channelDiscountPercent: ").append(toIndentedString(channelDiscountPercent)).append("\n");
    sb.append("    premiumPercent: ").append(toIndentedString(premiumPercent)).append("\n");
    sb.append("    hasPremium: ").append(toIndentedString(hasPremium)).append("\n");
    sb.append("    hasPromotion: ").append(toIndentedString(hasPromotion)).append("\n");
    sb.append("    hasChannelDiscount: ").append(toIndentedString(hasChannelDiscount)).append("\n");
    sb.append("    userSpecifiedCurrencyTotal: ").append(toIndentedString(userSpecifiedCurrencyTotal)).append("\n");
    sb.append("    internalTotal: ").append(toIndentedString(internalTotal)).append("\n");
    sb.append("    sourceTotal: ").append(toIndentedString(sourceTotal)).append("\n");
    sb.append("    totalDiscountPercent: ").append(toIndentedString(totalDiscountPercent)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

