/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel blocking on the Wink platform. The API gives you all the tools you need to ready your properties and blocking for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel blocking and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel blocking and get that same blocking out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel blocking and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/engine-client): A single endpoint to retrieve whitelabel + customization information for the booking engine.  - [Lookup](/lookup): All APIs related to locating blocking by region, locale and property flags.  - [Inventory](/blocking): All APIs related to retrieve known travel blocking as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel blocking.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and blocking calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and blocking to sell.  - [Inventory](/affiliate/blocking): The Inventory API exposes endpoints for affiliates to manage the blocking they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel blocking and need taxonomies of standard and non-standard codes for blocking types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel blocking. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Booking Engine API Welcome to the Booking Engine API - A programmer-friendly way to book blocking that was found on our platform. This API lets you:  1. Shopping Cart: Manage shopping cart. 2. Checkout: Move shopping cart items through the reactive workflow. 3. Booking: Move selected blocking through to booking completion. 4. Review: Leave a review after a completed stay.  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.9.11
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import travel.wink.sdk.booking.model.SubmitReviewAnswerAuthenticatedEntity;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * SubmitReviewRequestAuthenticatedEntity
 */
@JsonPropertyOrder({
  SubmitReviewRequestAuthenticatedEntity.JSON_PROPERTY_ANSWERS,
  SubmitReviewRequestAuthenticatedEntity.JSON_PROPERTY_MESSAGE_FROM_GUEST,
  SubmitReviewRequestAuthenticatedEntity.JSON_PROPERTY_IMAGE_IDENTIFIER,
  SubmitReviewRequestAuthenticatedEntity.JSON_PROPERTY_TEXT,
  SubmitReviewRequestAuthenticatedEntity.JSON_PROPERTY_ROOM_NUMBER,
  SubmitReviewRequestAuthenticatedEntity.JSON_PROPERTY_ROOM_RATING
})
@JsonTypeName("SubmitReviewRequest_Authenticated_Entity")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-12-27T09:35:47.117628182+07:00[Asia/Bangkok]")
public class SubmitReviewRequestAuthenticatedEntity {
  public static final String JSON_PROPERTY_ANSWERS = "answers";
  private List<SubmitReviewAnswerAuthenticatedEntity> answers = new ArrayList<>();

  public static final String JSON_PROPERTY_MESSAGE_FROM_GUEST = "messageFromGuest";
  private String messageFromGuest;

  public static final String JSON_PROPERTY_IMAGE_IDENTIFIER = "imageIdentifier";
  private String imageIdentifier;

  public static final String JSON_PROPERTY_TEXT = "text";
  private String text;

  public static final String JSON_PROPERTY_ROOM_NUMBER = "roomNumber";
  private String roomNumber;

  public static final String JSON_PROPERTY_ROOM_RATING = "roomRating";
  private Integer roomRating;

  public SubmitReviewRequestAuthenticatedEntity() {
  }

  public SubmitReviewRequestAuthenticatedEntity answers(List<SubmitReviewAnswerAuthenticatedEntity> answers) {
    
    this.answers = answers;
    return this;
  }

  public SubmitReviewRequestAuthenticatedEntity addAnswersItem(SubmitReviewAnswerAuthenticatedEntity answersItem) {
    if (this.answers == null) {
      this.answers = new ArrayList<>();
    }
    this.answers.add(answersItem);
    return this;
  }

   /**
   * List of user review answers.
   * @return answers
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1,max=2147483647)
  @JsonProperty(JSON_PROPERTY_ANSWERS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<SubmitReviewAnswerAuthenticatedEntity> getAnswers() {
    return answers;
  }


  @JsonProperty(JSON_PROPERTY_ANSWERS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAnswers(List<SubmitReviewAnswerAuthenticatedEntity> answers) {
    this.answers = answers;
  }


  public SubmitReviewRequestAuthenticatedEntity messageFromGuest(String messageFromGuest) {
    
    this.messageFromGuest = messageFromGuest;
    return this;
  }

   /**
   * Private message from guest to the hotel. Is not displayed on property profile.
   * @return messageFromGuest
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MESSAGE_FROM_GUEST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMessageFromGuest() {
    return messageFromGuest;
  }


  @JsonProperty(JSON_PROPERTY_MESSAGE_FROM_GUEST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMessageFromGuest(String messageFromGuest) {
    this.messageFromGuest = messageFromGuest;
  }


  public SubmitReviewRequestAuthenticatedEntity imageIdentifier(String imageIdentifier) {
    
    this.imageIdentifier = imageIdentifier;
    return this;
  }

   /**
   * Reviewer can upload her best picture from the property. Cloudinary image identifier.
   * @return imageIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_IMAGE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getImageIdentifier() {
    return imageIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImageIdentifier(String imageIdentifier) {
    this.imageIdentifier = imageIdentifier;
  }


  public SubmitReviewRequestAuthenticatedEntity text(String text) {
    
    this.text = text;
    return this;
  }

   /**
   * Free text record created by traveler
   * @return text
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getText() {
    return text;
  }


  @JsonProperty(JSON_PROPERTY_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setText(String text) {
    this.text = text;
  }


  public SubmitReviewRequestAuthenticatedEntity roomNumber(String roomNumber) {
    
    this.roomNumber = roomNumber;
    return this;
  }

   /**
   * Guest&#39;s room number during their stay.
   * @return roomNumber
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ROOM_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRoomNumber() {
    return roomNumber;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomNumber(String roomNumber) {
    this.roomNumber = roomNumber;
  }


  public SubmitReviewRequestAuthenticatedEntity roomRating(Integer roomRating) {
    
    this.roomRating = roomRating;
    return this;
  }

   /**
   * Guest&#39;s room rating
   * @return roomRating
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ROOM_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRoomRating() {
    return roomRating;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomRating(Integer roomRating) {
    this.roomRating = roomRating;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SubmitReviewRequestAuthenticatedEntity submitReviewRequestAuthenticatedEntity = (SubmitReviewRequestAuthenticatedEntity) o;
    return Objects.equals(this.answers, submitReviewRequestAuthenticatedEntity.answers) &&
        Objects.equals(this.messageFromGuest, submitReviewRequestAuthenticatedEntity.messageFromGuest) &&
        Objects.equals(this.imageIdentifier, submitReviewRequestAuthenticatedEntity.imageIdentifier) &&
        Objects.equals(this.text, submitReviewRequestAuthenticatedEntity.text) &&
        Objects.equals(this.roomNumber, submitReviewRequestAuthenticatedEntity.roomNumber) &&
        Objects.equals(this.roomRating, submitReviewRequestAuthenticatedEntity.roomRating);
  }

  @Override
  public int hashCode() {
    return Objects.hash(answers, messageFromGuest, imageIdentifier, text, roomNumber, roomRating);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SubmitReviewRequestAuthenticatedEntity {\n");
    sb.append("    answers: ").append(toIndentedString(answers)).append("\n");
    sb.append("    messageFromGuest: ").append(toIndentedString(messageFromGuest)).append("\n");
    sb.append("    imageIdentifier: ").append(toIndentedString(imageIdentifier)).append("\n");
    sb.append("    text: ").append(toIndentedString(text)).append("\n");
    sb.append("    roomNumber: ").append(toIndentedString(roomNumber)).append("\n");
    sb.append("    roomRating: ").append(toIndentedString(roomRating)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

