/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.booking.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.booking.invoker.ApiClient;
import travel.wink.sdk.booking.model.BooleanResponseAuthenticatedEntity;
import travel.wink.sdk.booking.model.RealtimeShoppingCartAuthenticatedEntity;
import travel.wink.sdk.booking.model.RemoveEntryResponseAuthenticatedEntity;
import travel.wink.sdk.booking.model.UpsertShoppingCartItemRequestAuthenticatedEntity;

public class ShoppingCartApi {
    private ApiClient apiClient;

    public ShoppingCartApi() {
        this(new ApiClient());
    }

    @Autowired
    public ShoppingCartApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createCartRequestCreation(UpsertShoppingCartItemRequestAuthenticatedEntity upsertShoppingCartItemRequestAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        UpsertShoppingCartItemRequestAuthenticatedEntity postBody = upsertShoppingCartItemRequestAuthenticatedEntity;
        if (upsertShoppingCartItemRequestAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertShoppingCartItemRequestAuthenticatedEntity' when calling createCart", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/shopping-cart", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RealtimeShoppingCartAuthenticatedEntity> createCart(UpsertShoppingCartItemRequestAuthenticatedEntity upsertShoppingCartItemRequestAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>(this){};
        return this.createCartRequestCreation(upsertShoppingCartItemRequestAuthenticatedEntity, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RealtimeShoppingCartAuthenticatedEntity>> createCartWithHttpInfo(UpsertShoppingCartItemRequestAuthenticatedEntity upsertShoppingCartItemRequestAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>(this){};
        return this.createCartRequestCreation(upsertShoppingCartItemRequestAuthenticatedEntity, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createCartWithResponseSpec(UpsertShoppingCartItemRequestAuthenticatedEntity upsertShoppingCartItemRequestAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        return this.createCartRequestCreation(upsertShoppingCartItemRequestAuthenticatedEntity, winkVersion);
    }

    private WebClient.ResponseSpec createCartsRequestCreation(List<UpsertShoppingCartItemRequestAuthenticatedEntity> upsertShoppingCartItemRequestAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        List<UpsertShoppingCartItemRequestAuthenticatedEntity> postBody = upsertShoppingCartItemRequestAuthenticatedEntity;
        if (upsertShoppingCartItemRequestAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertShoppingCartItemRequestAuthenticatedEntity' when calling createCarts", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/shopping-cart/list", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<RealtimeShoppingCartAuthenticatedEntity> createCarts(List<UpsertShoppingCartItemRequestAuthenticatedEntity> upsertShoppingCartItemRequestAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>(this){};
        return this.createCartsRequestCreation(upsertShoppingCartItemRequestAuthenticatedEntity, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<RealtimeShoppingCartAuthenticatedEntity>>> createCartsWithHttpInfo(List<UpsertShoppingCartItemRequestAuthenticatedEntity> upsertShoppingCartItemRequestAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>(this){};
        return this.createCartsRequestCreation(upsertShoppingCartItemRequestAuthenticatedEntity, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createCartsWithResponseSpec(List<UpsertShoppingCartItemRequestAuthenticatedEntity> upsertShoppingCartItemRequestAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        return this.createCartsRequestCreation(upsertShoppingCartItemRequestAuthenticatedEntity, winkVersion);
    }

    private WebClient.ResponseSpec deleteCartRequestCreation(String shoppingCartIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (shoppingCartIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'shoppingCartIdentifier' when calling deleteCart", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("shoppingCartIdentifier", shoppingCartIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/shopping-cart/{shoppingCartIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponseAuthenticatedEntity> deleteCart(String shoppingCartIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity>(this){};
        return this.deleteCartRequestCreation(shoppingCartIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponseAuthenticatedEntity>> deleteCartWithHttpInfo(String shoppingCartIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity>(this){};
        return this.deleteCartRequestCreation(shoppingCartIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec deleteCartWithResponseSpec(String shoppingCartIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.deleteCartRequestCreation(shoppingCartIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec deleteCartItemRequestCreation(String shoppingCartIdentifier, String shoppingCartItemIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (shoppingCartIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'shoppingCartIdentifier' when calling deleteCartItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (shoppingCartItemIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'shoppingCartItemIdentifier' when calling deleteCartItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("shoppingCartIdentifier", shoppingCartIdentifier);
        pathParams.put("shoppingCartItemIdentifier", shoppingCartItemIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/shopping-cart/{shoppingCartIdentifier}/item/{shoppingCartItemIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RealtimeShoppingCartAuthenticatedEntity> deleteCartItem(String shoppingCartIdentifier, String shoppingCartItemIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>(this){};
        return this.deleteCartItemRequestCreation(shoppingCartIdentifier, shoppingCartItemIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RealtimeShoppingCartAuthenticatedEntity>> deleteCartItemWithHttpInfo(String shoppingCartIdentifier, String shoppingCartItemIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>(this){};
        return this.deleteCartItemRequestCreation(shoppingCartIdentifier, shoppingCartItemIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec deleteCartItemWithResponseSpec(String shoppingCartIdentifier, String shoppingCartItemIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.deleteCartItemRequestCreation(shoppingCartIdentifier, shoppingCartItemIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec deleteCartItemAncillaryRequestCreation(String shoppingCartIdentifier, String shoppingCartItemIdentifier, String shoppingCartItemAncillaryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (shoppingCartIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'shoppingCartIdentifier' when calling deleteCartItemAncillary", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (shoppingCartItemIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'shoppingCartItemIdentifier' when calling deleteCartItemAncillary", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (shoppingCartItemAncillaryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'shoppingCartItemAncillaryIdentifier' when calling deleteCartItemAncillary", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("shoppingCartIdentifier", shoppingCartIdentifier);
        pathParams.put("shoppingCartItemIdentifier", shoppingCartItemIdentifier);
        pathParams.put("shoppingCartItemAncillaryIdentifier", shoppingCartItemAncillaryIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/shopping-cart/{shoppingCartIdentifier}/item/{shoppingCartItemIdentifier}/ancillary/{shoppingCartItemAncillaryIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RealtimeShoppingCartAuthenticatedEntity> deleteCartItemAncillary(String shoppingCartIdentifier, String shoppingCartItemIdentifier, String shoppingCartItemAncillaryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>(this){};
        return this.deleteCartItemAncillaryRequestCreation(shoppingCartIdentifier, shoppingCartItemIdentifier, shoppingCartItemAncillaryIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RealtimeShoppingCartAuthenticatedEntity>> deleteCartItemAncillaryWithHttpInfo(String shoppingCartIdentifier, String shoppingCartItemIdentifier, String shoppingCartItemAncillaryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>(this){};
        return this.deleteCartItemAncillaryRequestCreation(shoppingCartIdentifier, shoppingCartItemIdentifier, shoppingCartItemAncillaryIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec deleteCartItemAncillaryWithResponseSpec(String shoppingCartIdentifier, String shoppingCartItemIdentifier, String shoppingCartItemAncillaryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.deleteCartItemAncillaryRequestCreation(shoppingCartIdentifier, shoppingCartItemIdentifier, shoppingCartItemAncillaryIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec deleteCartsRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BooleanResponseAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/shopping-cart", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BooleanResponseAuthenticatedEntity> deleteCarts(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAuthenticatedEntity>(this){};
        return this.deleteCartsRequestCreation(winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BooleanResponseAuthenticatedEntity>> deleteCartsWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAuthenticatedEntity>(this){};
        return this.deleteCartsRequestCreation(winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec deleteCartsWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return this.deleteCartsRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec emptyCartRequestCreation(String shoppingCartIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (shoppingCartIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'shoppingCartIdentifier' when calling emptyCart", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("shoppingCartIdentifier", shoppingCartIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/shopping-cart/{shoppingCartIdentifier}/empty", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RealtimeShoppingCartAuthenticatedEntity> emptyCart(String shoppingCartIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>(this){};
        return this.emptyCartRequestCreation(shoppingCartIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RealtimeShoppingCartAuthenticatedEntity>> emptyCartWithHttpInfo(String shoppingCartIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>(this){};
        return this.emptyCartRequestCreation(shoppingCartIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec emptyCartWithResponseSpec(String shoppingCartIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.emptyCartRequestCreation(shoppingCartIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showCartRequestCreation(String shoppingCartIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (shoppingCartIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'shoppingCartIdentifier' when calling showCart", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("shoppingCartIdentifier", shoppingCartIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/shopping-cart/{shoppingCartIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RealtimeShoppingCartAuthenticatedEntity> showCart(String shoppingCartIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>(this){};
        return this.showCartRequestCreation(shoppingCartIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RealtimeShoppingCartAuthenticatedEntity>> showCartWithHttpInfo(String shoppingCartIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>(this){};
        return this.showCartRequestCreation(shoppingCartIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showCartWithResponseSpec(String shoppingCartIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showCartRequestCreation(shoppingCartIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showCartsRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/shopping-cart/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<RealtimeShoppingCartAuthenticatedEntity> showCarts(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>(this){};
        return this.showCartsRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<RealtimeShoppingCartAuthenticatedEntity>>> showCartsWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>(this){};
        return this.showCartsRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showCartsWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return this.showCartsRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec updateCartItemRequestCreation(String shoppingCartIdentifier, String shoppingCartItemIdentifier, UpsertShoppingCartItemRequestAuthenticatedEntity upsertShoppingCartItemRequestAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        UpsertShoppingCartItemRequestAuthenticatedEntity postBody = upsertShoppingCartItemRequestAuthenticatedEntity;
        if (shoppingCartIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'shoppingCartIdentifier' when calling updateCartItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (shoppingCartItemIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'shoppingCartItemIdentifier' when calling updateCartItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertShoppingCartItemRequestAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertShoppingCartItemRequestAuthenticatedEntity' when calling updateCartItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("shoppingCartIdentifier", shoppingCartIdentifier);
        pathParams.put("shoppingCartItemIdentifier", shoppingCartItemIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/shopping-cart/{shoppingCartIdentifier}/item/{shoppingCartItemIdentifier}", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RealtimeShoppingCartAuthenticatedEntity> updateCartItem(String shoppingCartIdentifier, String shoppingCartItemIdentifier, UpsertShoppingCartItemRequestAuthenticatedEntity upsertShoppingCartItemRequestAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>(this){};
        return this.updateCartItemRequestCreation(shoppingCartIdentifier, shoppingCartItemIdentifier, upsertShoppingCartItemRequestAuthenticatedEntity, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RealtimeShoppingCartAuthenticatedEntity>> updateCartItemWithHttpInfo(String shoppingCartIdentifier, String shoppingCartItemIdentifier, UpsertShoppingCartItemRequestAuthenticatedEntity upsertShoppingCartItemRequestAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>(this){};
        return this.updateCartItemRequestCreation(shoppingCartIdentifier, shoppingCartItemIdentifier, upsertShoppingCartItemRequestAuthenticatedEntity, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateCartItemWithResponseSpec(String shoppingCartIdentifier, String shoppingCartItemIdentifier, UpsertShoppingCartItemRequestAuthenticatedEntity upsertShoppingCartItemRequestAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        return this.updateCartItemRequestCreation(shoppingCartIdentifier, shoppingCartItemIdentifier, upsertShoppingCartItemRequestAuthenticatedEntity, winkVersion);
    }
}

