/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/engine-client): A single endpoint to retrieve whitelabel + customization information for the booking engine.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Booking Engine API Welcome to the Booking Engine API - A programmer-friendly way to book inventory that was found on our platform. This API lets you:  1. Shopping Cart: Manage shopping cart. 2. Checkout: Move shopping cart items through the reactive workflow. 3. Booking: Move selected inventory through to booking completion. 4. Review: Leave a review after a completed stay.  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.10.4
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.UUID;
import travel.wink.sdk.booking.model.CustomMonetaryAmount;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Details of the booking entries that went in for one particular supplier directly.
 */
@JsonPropertyOrder({
  PayableContractResponseAuthenticatedEntity.JSON_PROPERTY_ID,
  PayableContractResponseAuthenticatedEntity.JSON_PROPERTY_TRACE_ID,
  PayableContractResponseAuthenticatedEntity.JSON_PROPERTY_SUPPLIER_CONTRACT_IDENTIFIER,
  PayableContractResponseAuthenticatedEntity.JSON_PROPERTY_SUPPLIER_IDENTIFIER,
  PayableContractResponseAuthenticatedEntity.JSON_PROPERTY_SUPPLIER_NAME,
  PayableContractResponseAuthenticatedEntity.JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER,
  PayableContractResponseAuthenticatedEntity.JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE,
  PayableContractResponseAuthenticatedEntity.JSON_PROPERTY_EXTERNAL_TRANSACTION_IDENTIFIER,
  PayableContractResponseAuthenticatedEntity.JSON_PROPERTY_TOTAL_PRICE,
  PayableContractResponseAuthenticatedEntity.JSON_PROPERTY_TOTAL_DISPLAY_PRICE,
  PayableContractResponseAuthenticatedEntity.JSON_PROPERTY_TOTAL_SUPPLIER_PRICE,
  PayableContractResponseAuthenticatedEntity.JSON_PROPERTY_TOTAL_INTERNAL_PRICE,
  PayableContractResponseAuthenticatedEntity.JSON_PROPERTY_TOTAL_CAPTURE_PRICE
})
@JsonTypeName("PayableContractResponse_Authenticated_Entity")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-02T16:42:22.978624448+07:00[Asia/Bangkok]")
public class PayableContractResponseAuthenticatedEntity {
  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_TRACE_ID = "traceId";
  private String traceId;

  public static final String JSON_PROPERTY_SUPPLIER_CONTRACT_IDENTIFIER = "supplierContractIdentifier";
  private UUID supplierContractIdentifier;

  public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER = "supplierIdentifier";
  private UUID supplierIdentifier;

  public static final String JSON_PROPERTY_SUPPLIER_NAME = "supplierName";
  private String supplierName;

  public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER = "externalSupplierIdentifier";
  private String externalSupplierIdentifier;

  public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE = "externalSupplierBookingCode";
  private String externalSupplierBookingCode;

  public static final String JSON_PROPERTY_EXTERNAL_TRANSACTION_IDENTIFIER = "externalTransactionIdentifier";
  private String externalTransactionIdentifier;

  public static final String JSON_PROPERTY_TOTAL_PRICE = "totalPrice";
  private CustomMonetaryAmount totalPrice;

  public static final String JSON_PROPERTY_TOTAL_DISPLAY_PRICE = "totalDisplayPrice";
  private CustomMonetaryAmount totalDisplayPrice;

  public static final String JSON_PROPERTY_TOTAL_SUPPLIER_PRICE = "totalSupplierPrice";
  private CustomMonetaryAmount totalSupplierPrice;

  public static final String JSON_PROPERTY_TOTAL_INTERNAL_PRICE = "totalInternalPrice";
  private CustomMonetaryAmount totalInternalPrice;

  public static final String JSON_PROPERTY_TOTAL_CAPTURE_PRICE = "totalCapturePrice";
  private CustomMonetaryAmount totalCapturePrice;

  public PayableContractResponseAuthenticatedEntity() {
  }

  public PayableContractResponseAuthenticatedEntity id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * TripPay supplierContractIdentifier for reactive widget
   * @return id
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setId(String id) {
    this.id = id;
  }


  public PayableContractResponseAuthenticatedEntity traceId(String traceId) {
    
    this.traceId = traceId;
    return this;
  }

   /**
   * Groups all booking contracts submitted at the same time
   * @return traceId
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TRACE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTraceId() {
    return traceId;
  }


  @JsonProperty(JSON_PROPERTY_TRACE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTraceId(String traceId) {
    this.traceId = traceId;
  }


  public PayableContractResponseAuthenticatedEntity supplierContractIdentifier(UUID supplierContractIdentifier) {
    
    this.supplierContractIdentifier = supplierContractIdentifier;
    return this;
  }

   /**
   * Unique supplierContractIdentifier used to track the contract. Create a UUID for this purpose.
   * @return supplierContractIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_SUPPLIER_CONTRACT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getSupplierContractIdentifier() {
    return supplierContractIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_CONTRACT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierContractIdentifier(UUID supplierContractIdentifier) {
    this.supplierContractIdentifier = supplierContractIdentifier;
  }


  public PayableContractResponseAuthenticatedEntity supplierIdentifier(UUID supplierIdentifier) {
    
    this.supplierIdentifier = supplierIdentifier;
    return this;
  }

   /**
   * Supplier supplierContractIdentifier
   * @return supplierIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getSupplierIdentifier() {
    return supplierIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierIdentifier(UUID supplierIdentifier) {
    this.supplierIdentifier = supplierIdentifier;
  }


  public PayableContractResponseAuthenticatedEntity supplierName(String supplierName) {
    
    this.supplierName = supplierName;
    return this;
  }

   /**
   * Supplier name
   * @return supplierName
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SUPPLIER_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSupplierName() {
    return supplierName;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierName(String supplierName) {
    this.supplierName = supplierName;
  }


  public PayableContractResponseAuthenticatedEntity externalSupplierIdentifier(String externalSupplierIdentifier) {
    
    this.externalSupplierIdentifier = externalSupplierIdentifier;
    return this;
  }

   /**
   * Track supplier with its external supplier supplierContractIdentifier
   * @return externalSupplierIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getExternalSupplierIdentifier() {
    return externalSupplierIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setExternalSupplierIdentifier(String externalSupplierIdentifier) {
    this.externalSupplierIdentifier = externalSupplierIdentifier;
  }


  public PayableContractResponseAuthenticatedEntity externalSupplierBookingCode(String externalSupplierBookingCode) {
    
    this.externalSupplierBookingCode = externalSupplierBookingCode;
    return this;
  }

   /**
   * External booking code generated by the affiliate
   * @return externalSupplierBookingCode
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getExternalSupplierBookingCode() {
    return externalSupplierBookingCode;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setExternalSupplierBookingCode(String externalSupplierBookingCode) {
    this.externalSupplierBookingCode = externalSupplierBookingCode;
  }


  public PayableContractResponseAuthenticatedEntity externalTransactionIdentifier(String externalTransactionIdentifier) {
    
    this.externalTransactionIdentifier = externalTransactionIdentifier;
    return this;
  }

   /**
   * External transaction supplierContractIdentifier populated when agent responsible for acquiring
   * @return externalTransactionIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_EXTERNAL_TRANSACTION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalTransactionIdentifier() {
    return externalTransactionIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_TRANSACTION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalTransactionIdentifier(String externalTransactionIdentifier) {
    this.externalTransactionIdentifier = externalTransactionIdentifier;
  }


  public PayableContractResponseAuthenticatedEntity totalPrice(CustomMonetaryAmount totalPrice) {
    
    this.totalPrice = totalPrice;
    return this;
  }

   /**
   * Get totalPrice
   * @return totalPrice
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CustomMonetaryAmount getTotalPrice() {
    return totalPrice;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTotalPrice(CustomMonetaryAmount totalPrice) {
    this.totalPrice = totalPrice;
  }


  public PayableContractResponseAuthenticatedEntity totalDisplayPrice(CustomMonetaryAmount totalDisplayPrice) {
    
    this.totalDisplayPrice = totalDisplayPrice;
    return this;
  }

   /**
   * Get totalDisplayPrice
   * @return totalDisplayPrice
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_DISPLAY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CustomMonetaryAmount getTotalDisplayPrice() {
    return totalDisplayPrice;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_DISPLAY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTotalDisplayPrice(CustomMonetaryAmount totalDisplayPrice) {
    this.totalDisplayPrice = totalDisplayPrice;
  }


  public PayableContractResponseAuthenticatedEntity totalSupplierPrice(CustomMonetaryAmount totalSupplierPrice) {
    
    this.totalSupplierPrice = totalSupplierPrice;
    return this;
  }

   /**
   * Get totalSupplierPrice
   * @return totalSupplierPrice
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_SUPPLIER_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CustomMonetaryAmount getTotalSupplierPrice() {
    return totalSupplierPrice;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SUPPLIER_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTotalSupplierPrice(CustomMonetaryAmount totalSupplierPrice) {
    this.totalSupplierPrice = totalSupplierPrice;
  }


  public PayableContractResponseAuthenticatedEntity totalInternalPrice(CustomMonetaryAmount totalInternalPrice) {
    
    this.totalInternalPrice = totalInternalPrice;
    return this;
  }

   /**
   * Get totalInternalPrice
   * @return totalInternalPrice
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_INTERNAL_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CustomMonetaryAmount getTotalInternalPrice() {
    return totalInternalPrice;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_INTERNAL_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTotalInternalPrice(CustomMonetaryAmount totalInternalPrice) {
    this.totalInternalPrice = totalInternalPrice;
  }


  public PayableContractResponseAuthenticatedEntity totalCapturePrice(CustomMonetaryAmount totalCapturePrice) {
    
    this.totalCapturePrice = totalCapturePrice;
    return this;
  }

   /**
   * Get totalCapturePrice
   * @return totalCapturePrice
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_CAPTURE_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CustomMonetaryAmount getTotalCapturePrice() {
    return totalCapturePrice;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_CAPTURE_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTotalCapturePrice(CustomMonetaryAmount totalCapturePrice) {
    this.totalCapturePrice = totalCapturePrice;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PayableContractResponseAuthenticatedEntity payableContractResponseAuthenticatedEntity = (PayableContractResponseAuthenticatedEntity) o;
    return Objects.equals(this.id, payableContractResponseAuthenticatedEntity.id) &&
        Objects.equals(this.traceId, payableContractResponseAuthenticatedEntity.traceId) &&
        Objects.equals(this.supplierContractIdentifier, payableContractResponseAuthenticatedEntity.supplierContractIdentifier) &&
        Objects.equals(this.supplierIdentifier, payableContractResponseAuthenticatedEntity.supplierIdentifier) &&
        Objects.equals(this.supplierName, payableContractResponseAuthenticatedEntity.supplierName) &&
        Objects.equals(this.externalSupplierIdentifier, payableContractResponseAuthenticatedEntity.externalSupplierIdentifier) &&
        Objects.equals(this.externalSupplierBookingCode, payableContractResponseAuthenticatedEntity.externalSupplierBookingCode) &&
        Objects.equals(this.externalTransactionIdentifier, payableContractResponseAuthenticatedEntity.externalTransactionIdentifier) &&
        Objects.equals(this.totalPrice, payableContractResponseAuthenticatedEntity.totalPrice) &&
        Objects.equals(this.totalDisplayPrice, payableContractResponseAuthenticatedEntity.totalDisplayPrice) &&
        Objects.equals(this.totalSupplierPrice, payableContractResponseAuthenticatedEntity.totalSupplierPrice) &&
        Objects.equals(this.totalInternalPrice, payableContractResponseAuthenticatedEntity.totalInternalPrice) &&
        Objects.equals(this.totalCapturePrice, payableContractResponseAuthenticatedEntity.totalCapturePrice);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, traceId, supplierContractIdentifier, supplierIdentifier, supplierName, externalSupplierIdentifier, externalSupplierBookingCode, externalTransactionIdentifier, totalPrice, totalDisplayPrice, totalSupplierPrice, totalInternalPrice, totalCapturePrice);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PayableContractResponseAuthenticatedEntity {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    traceId: ").append(toIndentedString(traceId)).append("\n");
    sb.append("    supplierContractIdentifier: ").append(toIndentedString(supplierContractIdentifier)).append("\n");
    sb.append("    supplierIdentifier: ").append(toIndentedString(supplierIdentifier)).append("\n");
    sb.append("    supplierName: ").append(toIndentedString(supplierName)).append("\n");
    sb.append("    externalSupplierIdentifier: ").append(toIndentedString(externalSupplierIdentifier)).append("\n");
    sb.append("    externalSupplierBookingCode: ").append(toIndentedString(externalSupplierBookingCode)).append("\n");
    sb.append("    externalTransactionIdentifier: ").append(toIndentedString(externalTransactionIdentifier)).append("\n");
    sb.append("    totalPrice: ").append(toIndentedString(totalPrice)).append("\n");
    sb.append("    totalDisplayPrice: ").append(toIndentedString(totalDisplayPrice)).append("\n");
    sb.append("    totalSupplierPrice: ").append(toIndentedString(totalSupplierPrice)).append("\n");
    sb.append("    totalInternalPrice: ").append(toIndentedString(totalInternalPrice)).append("\n");
    sb.append("    totalCapturePrice: ").append(toIndentedString(totalCapturePrice)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

