package travel.wink.sdk.booking.api;

import travel.wink.sdk.booking.invoker.ApiClient;

import travel.wink.sdk.booking.model.BookingViewBooker;
import travel.wink.sdk.booking.model.BooleanResponseBooker;
import travel.wink.sdk.booking.model.CancellationDetailBooker;
import travel.wink.sdk.booking.model.CreateCart400Response;
import travel.wink.sdk.booking.model.GenericErrorMessage;
import travel.wink.sdk.booking.model.PageBookingViewBooker;
import travel.wink.sdk.booking.model.StateBooker;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-24T16:08:22.581857564+07:00[Asia/Bangkok]")
public class BookingApi {
    private ApiClient apiClient;

    public BookingApi() {
        this(new ApiClient());
    }

    @Autowired
    public BookingApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Cancel Booking
     * Cancel a booking by its booking identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param bookingIdentifier Cancel booking by identifier
     * @param cancellationDetailBooker The cancellationDetailBooker parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingViewBooker
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec cancelBookingRequestCreation(String bookingIdentifier, CancellationDetailBooker cancellationDetailBooker, String winkVersion) throws WebClientResponseException {
        Object postBody = cancellationDetailBooker;
        // verify the required parameter 'bookingIdentifier' is set
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling cancelBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'cancellationDetailBooker' is set
        if (cancellationDetailBooker == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancellationDetailBooker' when calling cancelBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("bookingIdentifier", bookingIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingViewBooker> localVarReturnType = new ParameterizedTypeReference<BookingViewBooker>() {};
        return apiClient.invokeAPI("/api/booking/{bookingIdentifier}", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Cancel Booking
     * Cancel a booking by its booking identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param bookingIdentifier Cancel booking by identifier
     * @param cancellationDetailBooker The cancellationDetailBooker parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingViewBooker
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingViewBooker> cancelBooking(String bookingIdentifier, CancellationDetailBooker cancellationDetailBooker, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewBooker> localVarReturnType = new ParameterizedTypeReference<BookingViewBooker>() {};
        return cancelBookingRequestCreation(bookingIdentifier, cancellationDetailBooker, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Cancel Booking
     * Cancel a booking by its booking identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param bookingIdentifier Cancel booking by identifier
     * @param cancellationDetailBooker The cancellationDetailBooker parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;BookingViewBooker&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BookingViewBooker>> cancelBookingWithHttpInfo(String bookingIdentifier, CancellationDetailBooker cancellationDetailBooker, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewBooker> localVarReturnType = new ParameterizedTypeReference<BookingViewBooker>() {};
        return cancelBookingRequestCreation(bookingIdentifier, cancellationDetailBooker, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Cancel Booking
     * Cancel a booking by its booking identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param bookingIdentifier Cancel booking by identifier
     * @param cancellationDetailBooker The cancellationDetailBooker parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec cancelBookingWithResponseSpec(String bookingIdentifier, CancellationDetailBooker cancellationDetailBooker, String winkVersion) throws WebClientResponseException {
        return cancelBookingRequestCreation(bookingIdentifier, cancellationDetailBooker, winkVersion);
    }
    /**
     * Cancel Group Booking
     * Cancel a group booking by its group identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param groupIdentifier Cancel booking by group identifier
     * @param cancellationDetailBooker The cancellationDetailBooker parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;BookingViewBooker&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec cancelGroupBookingRequestCreation(String groupIdentifier, CancellationDetailBooker cancellationDetailBooker, String winkVersion) throws WebClientResponseException {
        Object postBody = cancellationDetailBooker;
        // verify the required parameter 'groupIdentifier' is set
        if (groupIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'groupIdentifier' when calling cancelGroupBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'cancellationDetailBooker' is set
        if (cancellationDetailBooker == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancellationDetailBooker' when calling cancelGroupBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("groupIdentifier", groupIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingViewBooker> localVarReturnType = new ParameterizedTypeReference<BookingViewBooker>() {};
        return apiClient.invokeAPI("/api/booking/group/{groupIdentifier}", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Cancel Group Booking
     * Cancel a group booking by its group identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param groupIdentifier Cancel booking by group identifier
     * @param cancellationDetailBooker The cancellationDetailBooker parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;BookingViewBooker&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<BookingViewBooker> cancelGroupBooking(String groupIdentifier, CancellationDetailBooker cancellationDetailBooker, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewBooker> localVarReturnType = new ParameterizedTypeReference<BookingViewBooker>() {};
        return cancelGroupBookingRequestCreation(groupIdentifier, cancellationDetailBooker, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Cancel Group Booking
     * Cancel a group booking by its group identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param groupIdentifier Cancel booking by group identifier
     * @param cancellationDetailBooker The cancellationDetailBooker parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;BookingViewBooker&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<BookingViewBooker>>> cancelGroupBookingWithHttpInfo(String groupIdentifier, CancellationDetailBooker cancellationDetailBooker, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewBooker> localVarReturnType = new ParameterizedTypeReference<BookingViewBooker>() {};
        return cancelGroupBookingRequestCreation(groupIdentifier, cancellationDetailBooker, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Cancel Group Booking
     * Cancel a group booking by its group identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param groupIdentifier Cancel booking by group identifier
     * @param cancellationDetailBooker The cancellationDetailBooker parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec cancelGroupBookingWithResponseSpec(String groupIdentifier, CancellationDetailBooker cancellationDetailBooker, String winkVersion) throws WebClientResponseException {
        return cancelGroupBookingRequestCreation(groupIdentifier, cancellationDetailBooker, winkVersion);
    }
    /**
     * Resend Booking Confirmation
     * Resends booking confirmation email to traveler.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param bookingIdentifier Retrieve booking by identifier
     * @param body Empty request body
     * @param winkVersion The winkVersion parameter
     * @return BooleanResponseBooker
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec resendBookingConfirmationEmailRequestCreation(String bookingIdentifier, Object body, String winkVersion) throws WebClientResponseException {
        Object postBody = body;
        // verify the required parameter 'bookingIdentifier' is set
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling resendBookingConfirmationEmail", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new WebClientResponseException("Missing the required parameter 'body' when calling resendBookingConfirmationEmail", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("bookingIdentifier", bookingIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BooleanResponseBooker> localVarReturnType = new ParameterizedTypeReference<BooleanResponseBooker>() {};
        return apiClient.invokeAPI("/api/booking/{bookingIdentifier}/resend", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Resend Booking Confirmation
     * Resends booking confirmation email to traveler.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param bookingIdentifier Retrieve booking by identifier
     * @param body Empty request body
     * @param winkVersion The winkVersion parameter
     * @return BooleanResponseBooker
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BooleanResponseBooker> resendBookingConfirmationEmail(String bookingIdentifier, Object body, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseBooker> localVarReturnType = new ParameterizedTypeReference<BooleanResponseBooker>() {};
        return resendBookingConfirmationEmailRequestCreation(bookingIdentifier, body, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Resend Booking Confirmation
     * Resends booking confirmation email to traveler.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param bookingIdentifier Retrieve booking by identifier
     * @param body Empty request body
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;BooleanResponseBooker&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BooleanResponseBooker>> resendBookingConfirmationEmailWithHttpInfo(String bookingIdentifier, Object body, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseBooker> localVarReturnType = new ParameterizedTypeReference<BooleanResponseBooker>() {};
        return resendBookingConfirmationEmailRequestCreation(bookingIdentifier, body, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Resend Booking Confirmation
     * Resends booking confirmation email to traveler.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param bookingIdentifier Retrieve booking by identifier
     * @param body Empty request body
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec resendBookingConfirmationEmailWithResponseSpec(String bookingIdentifier, Object body, String winkVersion) throws WebClientResponseException {
        return resendBookingConfirmationEmailRequestCreation(bookingIdentifier, body, winkVersion);
    }
    /**
     * Show Booking
     * Retrieve a booking by its booking identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param bookingIdentifier Retrieve booking by identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return BookingViewBooker
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showBookingRequestCreation(String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'bookingIdentifier' is set
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling showBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("bookingIdentifier", bookingIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingViewBooker> localVarReturnType = new ParameterizedTypeReference<BookingViewBooker>() {};
        return apiClient.invokeAPI("/api/booking/{bookingIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Booking
     * Retrieve a booking by its booking identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param bookingIdentifier Retrieve booking by identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return BookingViewBooker
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingViewBooker> showBooking(String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewBooker> localVarReturnType = new ParameterizedTypeReference<BookingViewBooker>() {};
        return showBookingRequestCreation(bookingIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Booking
     * Retrieve a booking by its booking identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param bookingIdentifier Retrieve booking by identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;BookingViewBooker&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BookingViewBooker>> showBookingWithHttpInfo(String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewBooker> localVarReturnType = new ParameterizedTypeReference<BookingViewBooker>() {};
        return showBookingRequestCreation(bookingIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Booking
     * Retrieve a booking by its booking identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param bookingIdentifier Retrieve booking by identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showBookingWithResponseSpec(String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showBookingRequestCreation(bookingIdentifier, winkVersion, accept);
    }
    /**
     * Show Booking by TX ID
     * Retrieve a booking by its transaction identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param transactionIdentifier Retrieve booking by transaction identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return BookingViewBooker
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showBookingByTransactionIdRequestCreation(String transactionIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'transactionIdentifier' is set
        if (transactionIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'transactionIdentifier' when calling showBookingByTransactionId", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("transactionIdentifier", transactionIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingViewBooker> localVarReturnType = new ParameterizedTypeReference<BookingViewBooker>() {};
        return apiClient.invokeAPI("/api/booking/tx/{transactionIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Booking by TX ID
     * Retrieve a booking by its transaction identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param transactionIdentifier Retrieve booking by transaction identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return BookingViewBooker
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingViewBooker> showBookingByTransactionId(String transactionIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewBooker> localVarReturnType = new ParameterizedTypeReference<BookingViewBooker>() {};
        return showBookingByTransactionIdRequestCreation(transactionIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Booking by TX ID
     * Retrieve a booking by its transaction identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param transactionIdentifier Retrieve booking by transaction identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;BookingViewBooker&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BookingViewBooker>> showBookingByTransactionIdWithHttpInfo(String transactionIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewBooker> localVarReturnType = new ParameterizedTypeReference<BookingViewBooker>() {};
        return showBookingByTransactionIdRequestCreation(transactionIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Booking by TX ID
     * Retrieve a booking by its transaction identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param transactionIdentifier Retrieve booking by transaction identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showBookingByTransactionIdWithResponseSpec(String transactionIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showBookingByTransactionIdRequestCreation(transactionIdentifier, winkVersion, accept);
    }
    /**
     * Search Bookings
     * Retrieve paginated bookings based on a query state
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param stateBooker The stateBooker parameter
     * @param winkVersion The winkVersion parameter
     * @return PageBookingViewBooker
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showBookingGridRequestCreation(StateBooker stateBooker, String winkVersion) throws WebClientResponseException {
        Object postBody = stateBooker;
        // verify the required parameter 'stateBooker' is set
        if (stateBooker == null) {
            throw new WebClientResponseException("Missing the required parameter 'stateBooker' when calling showBookingGrid", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageBookingViewBooker> localVarReturnType = new ParameterizedTypeReference<PageBookingViewBooker>() {};
        return apiClient.invokeAPI("/api/booking/grid", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Search Bookings
     * Retrieve paginated bookings based on a query state
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param stateBooker The stateBooker parameter
     * @param winkVersion The winkVersion parameter
     * @return PageBookingViewBooker
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageBookingViewBooker> showBookingGrid(StateBooker stateBooker, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingViewBooker> localVarReturnType = new ParameterizedTypeReference<PageBookingViewBooker>() {};
        return showBookingGridRequestCreation(stateBooker, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Search Bookings
     * Retrieve paginated bookings based on a query state
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param stateBooker The stateBooker parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;PageBookingViewBooker&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageBookingViewBooker>> showBookingGridWithHttpInfo(StateBooker stateBooker, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingViewBooker> localVarReturnType = new ParameterizedTypeReference<PageBookingViewBooker>() {};
        return showBookingGridRequestCreation(stateBooker, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Search Bookings
     * Retrieve paginated bookings based on a query state
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param stateBooker The stateBooker parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showBookingGridWithResponseSpec(StateBooker stateBooker, String winkVersion) throws WebClientResponseException {
        return showBookingGridRequestCreation(stateBooker, winkVersion);
    }
    /**
     * Show Booking List
     * Retrieve bookings in a paginated list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param page Page to start retrieving records for
     * @param size Number of records to retrieve
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return PageBookingViewBooker
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showBookingsRequestCreation(Integer page, Integer size, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "size", size));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageBookingViewBooker> localVarReturnType = new ParameterizedTypeReference<PageBookingViewBooker>() {};
        return apiClient.invokeAPI("/api/booking/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Booking List
     * Retrieve bookings in a paginated list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param page Page to start retrieving records for
     * @param size Number of records to retrieve
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return PageBookingViewBooker
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageBookingViewBooker> showBookings(Integer page, Integer size, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingViewBooker> localVarReturnType = new ParameterizedTypeReference<PageBookingViewBooker>() {};
        return showBookingsRequestCreation(page, size, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Booking List
     * Retrieve bookings in a paginated list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param page Page to start retrieving records for
     * @param size Number of records to retrieve
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;PageBookingViewBooker&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageBookingViewBooker>> showBookingsWithHttpInfo(Integer page, Integer size, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingViewBooker> localVarReturnType = new ParameterizedTypeReference<PageBookingViewBooker>() {};
        return showBookingsRequestCreation(page, size, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Booking List
     * Retrieve bookings in a paginated list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param page Page to start retrieving records for
     * @param size Number of records to retrieve
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showBookingsWithResponseSpec(Integer page, Integer size, String winkVersion, String accept) throws WebClientResponseException {
        return showBookingsRequestCreation(page, size, winkVersion, accept);
    }
    /**
     * Show Bookings by Review
     * List bookings by their review state
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param state Retrieve bookings by review state
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;BookingViewBooker&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showBookingsByReviewStateRequestCreation(String state, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "state", state));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingViewBooker> localVarReturnType = new ParameterizedTypeReference<BookingViewBooker>() {};
        return apiClient.invokeAPI("/api/booking/review/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Bookings by Review
     * List bookings by their review state
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param state Retrieve bookings by review state
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;BookingViewBooker&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<BookingViewBooker> showBookingsByReviewState(String state, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewBooker> localVarReturnType = new ParameterizedTypeReference<BookingViewBooker>() {};
        return showBookingsByReviewStateRequestCreation(state, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Bookings by Review
     * List bookings by their review state
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param state Retrieve bookings by review state
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;BookingViewBooker&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<BookingViewBooker>>> showBookingsByReviewStateWithHttpInfo(String state, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewBooker> localVarReturnType = new ParameterizedTypeReference<BookingViewBooker>() {};
        return showBookingsByReviewStateRequestCreation(state, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Bookings by Review
     * List bookings by their review state
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param state Retrieve bookings by review state
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showBookingsByReviewStateWithResponseSpec(String state, String winkVersion, String accept) throws WebClientResponseException {
        return showBookingsByReviewStateRequestCreation(state, winkVersion, accept);
    }
    /**
     * Show Bookings by Time
     * Retrieve bookings for a date state
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param state Retrieve bookings by state
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;BookingViewBooker&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showBookingsByStateRequestCreation(String state, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "state", state));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingViewBooker> localVarReturnType = new ParameterizedTypeReference<BookingViewBooker>() {};
        return apiClient.invokeAPI("/api/booking/state", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Bookings by Time
     * Retrieve bookings for a date state
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param state Retrieve bookings by state
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;BookingViewBooker&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<BookingViewBooker> showBookingsByState(String state, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewBooker> localVarReturnType = new ParameterizedTypeReference<BookingViewBooker>() {};
        return showBookingsByStateRequestCreation(state, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Bookings by Time
     * Retrieve bookings for a date state
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param state Retrieve bookings by state
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;BookingViewBooker&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<BookingViewBooker>>> showBookingsByStateWithHttpInfo(String state, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewBooker> localVarReturnType = new ParameterizedTypeReference<BookingViewBooker>() {};
        return showBookingsByStateRequestCreation(state, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Bookings by Time
     * Retrieve bookings for a date state
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param state Retrieve bookings by state
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showBookingsByStateWithResponseSpec(String state, String winkVersion, String accept) throws WebClientResponseException {
        return showBookingsByStateRequestCreation(state, winkVersion, accept);
    }
    /**
     * Show Grouped Bookings
     * Retrieve a list of bookings by group identifier. User needs to be authenticated.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param groupIdentifier Retrieve booking by identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;BookingViewBooker&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showGroupedBookingsRequestCreation(String groupIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'groupIdentifier' is set
        if (groupIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'groupIdentifier' when calling showGroupedBookings", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("groupIdentifier", groupIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingViewBooker> localVarReturnType = new ParameterizedTypeReference<BookingViewBooker>() {};
        return apiClient.invokeAPI("/api/booking/group/{groupIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Grouped Bookings
     * Retrieve a list of bookings by group identifier. User needs to be authenticated.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param groupIdentifier Retrieve booking by identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;BookingViewBooker&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<BookingViewBooker> showGroupedBookings(String groupIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewBooker> localVarReturnType = new ParameterizedTypeReference<BookingViewBooker>() {};
        return showGroupedBookingsRequestCreation(groupIdentifier, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Grouped Bookings
     * Retrieve a list of bookings by group identifier. User needs to be authenticated.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param groupIdentifier Retrieve booking by identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;BookingViewBooker&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<BookingViewBooker>>> showGroupedBookingsWithHttpInfo(String groupIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewBooker> localVarReturnType = new ParameterizedTypeReference<BookingViewBooker>() {};
        return showGroupedBookingsRequestCreation(groupIdentifier, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Grouped Bookings
     * Retrieve a list of bookings by group identifier. User needs to be authenticated.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param groupIdentifier Retrieve booking by identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showGroupedBookingsWithResponseSpec(String groupIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showGroupedBookingsRequestCreation(groupIdentifier, winkVersion, accept);
    }
}
