package travel.wink.sdk.booking.api;

import travel.wink.sdk.booking.invoker.ApiClient;

import travel.wink.sdk.booking.model.BooleanResponseAuthenticatedEntity;
import travel.wink.sdk.booking.model.CreateCart400Response;
import travel.wink.sdk.booking.model.GenericErrorMessage;
import travel.wink.sdk.booking.model.RealtimeShoppingCartAuthenticatedEntity;
import travel.wink.sdk.booking.model.RemoveEntryResponseAuthenticatedEntity;
import travel.wink.sdk.booking.model.UpsertShoppingCartItemRequestAuthenticatedEntity;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-24T16:08:22.581857564+07:00[Asia/Bangkok]")
public class ShoppingCartApi {
    private ApiClient apiClient;

    public ShoppingCartApi() {
        this(new ApiClient());
    }

    @Autowired
    public ShoppingCartApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Shopping Cart
     * Creates a shopping cart and adds item.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param upsertShoppingCartItemRequestAuthenticatedEntity The upsertShoppingCartItemRequestAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return RealtimeShoppingCartAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createCartRequestCreation(UpsertShoppingCartItemRequestAuthenticatedEntity upsertShoppingCartItemRequestAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertShoppingCartItemRequestAuthenticatedEntity;
        // verify the required parameter 'upsertShoppingCartItemRequestAuthenticatedEntity' is set
        if (upsertShoppingCartItemRequestAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertShoppingCartItemRequestAuthenticatedEntity' when calling createCart", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/shopping-cart", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Shopping Cart
     * Creates a shopping cart and adds item.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param upsertShoppingCartItemRequestAuthenticatedEntity The upsertShoppingCartItemRequestAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return RealtimeShoppingCartAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RealtimeShoppingCartAuthenticatedEntity> createCart(UpsertShoppingCartItemRequestAuthenticatedEntity upsertShoppingCartItemRequestAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>() {};
        return createCartRequestCreation(upsertShoppingCartItemRequestAuthenticatedEntity, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Shopping Cart
     * Creates a shopping cart and adds item.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param upsertShoppingCartItemRequestAuthenticatedEntity The upsertShoppingCartItemRequestAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RealtimeShoppingCartAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RealtimeShoppingCartAuthenticatedEntity>> createCartWithHttpInfo(UpsertShoppingCartItemRequestAuthenticatedEntity upsertShoppingCartItemRequestAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>() {};
        return createCartRequestCreation(upsertShoppingCartItemRequestAuthenticatedEntity, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Shopping Cart
     * Creates a shopping cart and adds item.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param upsertShoppingCartItemRequestAuthenticatedEntity The upsertShoppingCartItemRequestAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createCartWithResponseSpec(UpsertShoppingCartItemRequestAuthenticatedEntity upsertShoppingCartItemRequestAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        return createCartRequestCreation(upsertShoppingCartItemRequestAuthenticatedEntity, winkVersion);
    }
    /**
     * Create Shopping Carts
     * Creates shopping carts and adds an item to each.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param upsertShoppingCartItemRequestAuthenticatedEntity The upsertShoppingCartItemRequestAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;RealtimeShoppingCartAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createCartsRequestCreation(List<UpsertShoppingCartItemRequestAuthenticatedEntity> upsertShoppingCartItemRequestAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertShoppingCartItemRequestAuthenticatedEntity;
        // verify the required parameter 'upsertShoppingCartItemRequestAuthenticatedEntity' is set
        if (upsertShoppingCartItemRequestAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertShoppingCartItemRequestAuthenticatedEntity' when calling createCarts", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/shopping-cart/list", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Shopping Carts
     * Creates shopping carts and adds an item to each.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param upsertShoppingCartItemRequestAuthenticatedEntity The upsertShoppingCartItemRequestAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;RealtimeShoppingCartAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<RealtimeShoppingCartAuthenticatedEntity> createCarts(List<UpsertShoppingCartItemRequestAuthenticatedEntity> upsertShoppingCartItemRequestAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>() {};
        return createCartsRequestCreation(upsertShoppingCartItemRequestAuthenticatedEntity, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Create Shopping Carts
     * Creates shopping carts and adds an item to each.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param upsertShoppingCartItemRequestAuthenticatedEntity The upsertShoppingCartItemRequestAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;RealtimeShoppingCartAuthenticatedEntity&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<RealtimeShoppingCartAuthenticatedEntity>>> createCartsWithHttpInfo(List<UpsertShoppingCartItemRequestAuthenticatedEntity> upsertShoppingCartItemRequestAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>() {};
        return createCartsRequestCreation(upsertShoppingCartItemRequestAuthenticatedEntity, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Create Shopping Carts
     * Creates shopping carts and adds an item to each.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param upsertShoppingCartItemRequestAuthenticatedEntity The upsertShoppingCartItemRequestAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createCartsWithResponseSpec(List<UpsertShoppingCartItemRequestAuthenticatedEntity> upsertShoppingCartItemRequestAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        return createCartsRequestCreation(upsertShoppingCartItemRequestAuthenticatedEntity, winkVersion);
    }
    /**
     * Remove Shopping Cart
     * Removes the cart. Not necessary as the cart has a TTL of only an hour anyway.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param shoppingCartIdentifier Cart to remove
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponseAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec deleteCartRequestCreation(String shoppingCartIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'shoppingCartIdentifier' is set
        if (shoppingCartIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'shoppingCartIdentifier' when calling deleteCart", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("shoppingCartIdentifier", shoppingCartIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/shopping-cart/{shoppingCartIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Remove Shopping Cart
     * Removes the cart. Not necessary as the cart has a TTL of only an hour anyway.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param shoppingCartIdentifier Cart to remove
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponseAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponseAuthenticatedEntity> deleteCart(String shoppingCartIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity>() {};
        return deleteCartRequestCreation(shoppingCartIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Remove Shopping Cart
     * Removes the cart. Not necessary as the cart has a TTL of only an hour anyway.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param shoppingCartIdentifier Cart to remove
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;RemoveEntryResponseAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponseAuthenticatedEntity>> deleteCartWithHttpInfo(String shoppingCartIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAuthenticatedEntity>() {};
        return deleteCartRequestCreation(shoppingCartIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Remove Shopping Cart
     * Removes the cart. Not necessary as the cart has a TTL of only an hour anyway.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param shoppingCartIdentifier Cart to remove
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec deleteCartWithResponseSpec(String shoppingCartIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return deleteCartRequestCreation(shoppingCartIdentifier, winkVersion, accept);
    }
    /**
     * Remove Shopping Cart Item
     * Remove item from cart
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param shoppingCartIdentifier Cart to update
     * @param shoppingCartItemIdentifier Cart item to remove
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RealtimeShoppingCartAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec deleteCartItemRequestCreation(String shoppingCartIdentifier, String shoppingCartItemIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'shoppingCartIdentifier' is set
        if (shoppingCartIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'shoppingCartIdentifier' when calling deleteCartItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'shoppingCartItemIdentifier' is set
        if (shoppingCartItemIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'shoppingCartItemIdentifier' when calling deleteCartItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("shoppingCartIdentifier", shoppingCartIdentifier);
        pathParams.put("shoppingCartItemIdentifier", shoppingCartItemIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/shopping-cart/{shoppingCartIdentifier}/item/{shoppingCartItemIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Remove Shopping Cart Item
     * Remove item from cart
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param shoppingCartIdentifier Cart to update
     * @param shoppingCartItemIdentifier Cart item to remove
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RealtimeShoppingCartAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RealtimeShoppingCartAuthenticatedEntity> deleteCartItem(String shoppingCartIdentifier, String shoppingCartItemIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>() {};
        return deleteCartItemRequestCreation(shoppingCartIdentifier, shoppingCartItemIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Remove Shopping Cart Item
     * Remove item from cart
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param shoppingCartIdentifier Cart to update
     * @param shoppingCartItemIdentifier Cart item to remove
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;RealtimeShoppingCartAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RealtimeShoppingCartAuthenticatedEntity>> deleteCartItemWithHttpInfo(String shoppingCartIdentifier, String shoppingCartItemIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>() {};
        return deleteCartItemRequestCreation(shoppingCartIdentifier, shoppingCartItemIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Remove Shopping Cart Item
     * Remove item from cart
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param shoppingCartIdentifier Cart to update
     * @param shoppingCartItemIdentifier Cart item to remove
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec deleteCartItemWithResponseSpec(String shoppingCartIdentifier, String shoppingCartItemIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return deleteCartItemRequestCreation(shoppingCartIdentifier, shoppingCartItemIdentifier, winkVersion, accept);
    }
    /**
     * Remove Shopping Cart Item Ancillary
     * Remove item ancillary from cart
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param shoppingCartIdentifier Cart to update
     * @param shoppingCartItemIdentifier Cart item to update
     * @param shoppingCartItemAncillaryIdentifier Cart item ancillary to remove
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RealtimeShoppingCartAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec deleteCartItemAncillaryRequestCreation(String shoppingCartIdentifier, String shoppingCartItemIdentifier, String shoppingCartItemAncillaryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'shoppingCartIdentifier' is set
        if (shoppingCartIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'shoppingCartIdentifier' when calling deleteCartItemAncillary", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'shoppingCartItemIdentifier' is set
        if (shoppingCartItemIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'shoppingCartItemIdentifier' when calling deleteCartItemAncillary", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'shoppingCartItemAncillaryIdentifier' is set
        if (shoppingCartItemAncillaryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'shoppingCartItemAncillaryIdentifier' when calling deleteCartItemAncillary", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("shoppingCartIdentifier", shoppingCartIdentifier);
        pathParams.put("shoppingCartItemIdentifier", shoppingCartItemIdentifier);
        pathParams.put("shoppingCartItemAncillaryIdentifier", shoppingCartItemAncillaryIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/shopping-cart/{shoppingCartIdentifier}/item/{shoppingCartItemIdentifier}/ancillary/{shoppingCartItemAncillaryIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Remove Shopping Cart Item Ancillary
     * Remove item ancillary from cart
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param shoppingCartIdentifier Cart to update
     * @param shoppingCartItemIdentifier Cart item to update
     * @param shoppingCartItemAncillaryIdentifier Cart item ancillary to remove
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RealtimeShoppingCartAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RealtimeShoppingCartAuthenticatedEntity> deleteCartItemAncillary(String shoppingCartIdentifier, String shoppingCartItemIdentifier, String shoppingCartItemAncillaryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>() {};
        return deleteCartItemAncillaryRequestCreation(shoppingCartIdentifier, shoppingCartItemIdentifier, shoppingCartItemAncillaryIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Remove Shopping Cart Item Ancillary
     * Remove item ancillary from cart
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param shoppingCartIdentifier Cart to update
     * @param shoppingCartItemIdentifier Cart item to update
     * @param shoppingCartItemAncillaryIdentifier Cart item ancillary to remove
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;RealtimeShoppingCartAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RealtimeShoppingCartAuthenticatedEntity>> deleteCartItemAncillaryWithHttpInfo(String shoppingCartIdentifier, String shoppingCartItemIdentifier, String shoppingCartItemAncillaryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>() {};
        return deleteCartItemAncillaryRequestCreation(shoppingCartIdentifier, shoppingCartItemIdentifier, shoppingCartItemAncillaryIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Remove Shopping Cart Item Ancillary
     * Remove item ancillary from cart
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param shoppingCartIdentifier Cart to update
     * @param shoppingCartItemIdentifier Cart item to update
     * @param shoppingCartItemAncillaryIdentifier Cart item ancillary to remove
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec deleteCartItemAncillaryWithResponseSpec(String shoppingCartIdentifier, String shoppingCartItemIdentifier, String shoppingCartItemAncillaryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return deleteCartItemAncillaryRequestCreation(shoppingCartIdentifier, shoppingCartItemIdentifier, shoppingCartItemAncillaryIdentifier, winkVersion, accept);
    }
    /**
     * Empty Shopping Carts
     * Empties all carts.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return BooleanResponseAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec deleteCartsRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BooleanResponseAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/shopping-cart", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Empty Shopping Carts
     * Empties all carts.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return BooleanResponseAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BooleanResponseAuthenticatedEntity> deleteCarts(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAuthenticatedEntity>() {};
        return deleteCartsRequestCreation(winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Empty Shopping Carts
     * Empties all carts.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;BooleanResponseAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BooleanResponseAuthenticatedEntity>> deleteCartsWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAuthenticatedEntity>() {};
        return deleteCartsRequestCreation(winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Empty Shopping Carts
     * Empties all carts.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec deleteCartsWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return deleteCartsRequestCreation(winkVersion, accept);
    }
    /**
     * Empty Shopping Cart
     * Empties selected cart.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param shoppingCartIdentifier Cart to empty
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RealtimeShoppingCartAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec emptyCartRequestCreation(String shoppingCartIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'shoppingCartIdentifier' is set
        if (shoppingCartIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'shoppingCartIdentifier' when calling emptyCart", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("shoppingCartIdentifier", shoppingCartIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/shopping-cart/{shoppingCartIdentifier}/empty", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Empty Shopping Cart
     * Empties selected cart.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param shoppingCartIdentifier Cart to empty
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RealtimeShoppingCartAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RealtimeShoppingCartAuthenticatedEntity> emptyCart(String shoppingCartIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>() {};
        return emptyCartRequestCreation(shoppingCartIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Empty Shopping Cart
     * Empties selected cart.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param shoppingCartIdentifier Cart to empty
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;RealtimeShoppingCartAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RealtimeShoppingCartAuthenticatedEntity>> emptyCartWithHttpInfo(String shoppingCartIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>() {};
        return emptyCartRequestCreation(shoppingCartIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Empty Shopping Cart
     * Empties selected cart.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param shoppingCartIdentifier Cart to empty
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec emptyCartWithResponseSpec(String shoppingCartIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return emptyCartRequestCreation(shoppingCartIdentifier, winkVersion, accept);
    }
    /**
     * Show Shopping Cart
     * Display user&#39;s shopping cart
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param shoppingCartIdentifier Cart to retrieve
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RealtimeShoppingCartAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showCartRequestCreation(String shoppingCartIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'shoppingCartIdentifier' is set
        if (shoppingCartIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'shoppingCartIdentifier' when calling showCart", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("shoppingCartIdentifier", shoppingCartIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/shopping-cart/{shoppingCartIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Shopping Cart
     * Display user&#39;s shopping cart
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param shoppingCartIdentifier Cart to retrieve
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RealtimeShoppingCartAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RealtimeShoppingCartAuthenticatedEntity> showCart(String shoppingCartIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>() {};
        return showCartRequestCreation(shoppingCartIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Shopping Cart
     * Display user&#39;s shopping cart
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param shoppingCartIdentifier Cart to retrieve
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;RealtimeShoppingCartAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RealtimeShoppingCartAuthenticatedEntity>> showCartWithHttpInfo(String shoppingCartIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>() {};
        return showCartRequestCreation(shoppingCartIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Shopping Cart
     * Display user&#39;s shopping cart
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param shoppingCartIdentifier Cart to retrieve
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showCartWithResponseSpec(String shoppingCartIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showCartRequestCreation(shoppingCartIdentifier, winkVersion, accept);
    }
    /**
     * Show Shopping Carts
     * Display all of user&#39;s shopping cart
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;RealtimeShoppingCartAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showCartsRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/shopping-cart/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Shopping Carts
     * Display all of user&#39;s shopping cart
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;RealtimeShoppingCartAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<RealtimeShoppingCartAuthenticatedEntity> showCarts(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>() {};
        return showCartsRequestCreation(winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Shopping Carts
     * Display all of user&#39;s shopping cart
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;RealtimeShoppingCartAuthenticatedEntity&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<RealtimeShoppingCartAuthenticatedEntity>>> showCartsWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>() {};
        return showCartsRequestCreation(winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Shopping Carts
     * Display all of user&#39;s shopping cart
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showCartsWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return showCartsRequestCreation(winkVersion, accept);
    }
    /**
     * Update Shopping Cart Item
     * Updates item in shopping cart.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param shoppingCartIdentifier Cart to update
     * @param shoppingCartItemIdentifier Cart item to update
     * @param upsertShoppingCartItemRequestAuthenticatedEntity The upsertShoppingCartItemRequestAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return RealtimeShoppingCartAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateCartItemRequestCreation(String shoppingCartIdentifier, String shoppingCartItemIdentifier, UpsertShoppingCartItemRequestAuthenticatedEntity upsertShoppingCartItemRequestAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertShoppingCartItemRequestAuthenticatedEntity;
        // verify the required parameter 'shoppingCartIdentifier' is set
        if (shoppingCartIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'shoppingCartIdentifier' when calling updateCartItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'shoppingCartItemIdentifier' is set
        if (shoppingCartItemIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'shoppingCartItemIdentifier' when calling updateCartItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertShoppingCartItemRequestAuthenticatedEntity' is set
        if (upsertShoppingCartItemRequestAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertShoppingCartItemRequestAuthenticatedEntity' when calling updateCartItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("shoppingCartIdentifier", shoppingCartIdentifier);
        pathParams.put("shoppingCartItemIdentifier", shoppingCartItemIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/shopping-cart/{shoppingCartIdentifier}/item/{shoppingCartItemIdentifier}", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Shopping Cart Item
     * Updates item in shopping cart.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param shoppingCartIdentifier Cart to update
     * @param shoppingCartItemIdentifier Cart item to update
     * @param upsertShoppingCartItemRequestAuthenticatedEntity The upsertShoppingCartItemRequestAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return RealtimeShoppingCartAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RealtimeShoppingCartAuthenticatedEntity> updateCartItem(String shoppingCartIdentifier, String shoppingCartItemIdentifier, UpsertShoppingCartItemRequestAuthenticatedEntity upsertShoppingCartItemRequestAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>() {};
        return updateCartItemRequestCreation(shoppingCartIdentifier, shoppingCartItemIdentifier, upsertShoppingCartItemRequestAuthenticatedEntity, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Shopping Cart Item
     * Updates item in shopping cart.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param shoppingCartIdentifier Cart to update
     * @param shoppingCartItemIdentifier Cart item to update
     * @param upsertShoppingCartItemRequestAuthenticatedEntity The upsertShoppingCartItemRequestAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RealtimeShoppingCartAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RealtimeShoppingCartAuthenticatedEntity>> updateCartItemWithHttpInfo(String shoppingCartIdentifier, String shoppingCartItemIdentifier, UpsertShoppingCartItemRequestAuthenticatedEntity upsertShoppingCartItemRequestAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<RealtimeShoppingCartAuthenticatedEntity>() {};
        return updateCartItemRequestCreation(shoppingCartIdentifier, shoppingCartItemIdentifier, upsertShoppingCartItemRequestAuthenticatedEntity, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Shopping Cart Item
     * Updates item in shopping cart.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param shoppingCartIdentifier Cart to update
     * @param shoppingCartItemIdentifier Cart item to update
     * @param upsertShoppingCartItemRequestAuthenticatedEntity The upsertShoppingCartItemRequestAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateCartItemWithResponseSpec(String shoppingCartIdentifier, String shoppingCartItemIdentifier, UpsertShoppingCartItemRequestAuthenticatedEntity upsertShoppingCartItemRequestAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        return updateCartItemRequestCreation(shoppingCartIdentifier, shoppingCartItemIdentifier, upsertShoppingCartItemRequestAuthenticatedEntity, winkVersion);
    }
}
