/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.booking.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.UUID;

@JsonPropertyOrder(value={"typeIdentifier", "channelInventoryIdentifier", "transactionalTravelInventoryIdentifier", "startDate", "endDate", "quantity", "identifier", "type"})
@JsonTypeName(value="AncillaryRequest_Authenticated_Entity")
public class AncillaryRequestAuthenticatedEntity {
    public static final String JSON_PROPERTY_TYPE_IDENTIFIER = "typeIdentifier";
    private UUID typeIdentifier;
    public static final String JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER = "channelInventoryIdentifier";
    private UUID channelInventoryIdentifier;
    public static final String JSON_PROPERTY_TRANSACTIONAL_TRAVEL_INVENTORY_IDENTIFIER = "transactionalTravelInventoryIdentifier";
    private UUID transactionalTravelInventoryIdentifier;
    public static final String JSON_PROPERTY_START_DATE = "startDate";
    private LocalDateTime startDate;
    public static final String JSON_PROPERTY_END_DATE = "endDate";
    private LocalDateTime endDate;
    public static final String JSON_PROPERTY_QUANTITY = "quantity";
    private Integer quantity = 1;
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private UUID identifier;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public AncillaryRequestAuthenticatedEntity typeIdentifier(UUID typeIdentifier) {
        this.typeIdentifier = typeIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="typeIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getTypeIdentifier() {
        return this.typeIdentifier;
    }

    @JsonProperty(value="typeIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTypeIdentifier(UUID typeIdentifier) {
        this.typeIdentifier = typeIdentifier;
    }

    public AncillaryRequestAuthenticatedEntity channelInventoryIdentifier(UUID channelInventoryIdentifier) {
        this.channelInventoryIdentifier = channelInventoryIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="channelInventoryIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getChannelInventoryIdentifier() {
        return this.channelInventoryIdentifier;
    }

    @JsonProperty(value="channelInventoryIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setChannelInventoryIdentifier(UUID channelInventoryIdentifier) {
        this.channelInventoryIdentifier = channelInventoryIdentifier;
    }

    public AncillaryRequestAuthenticatedEntity transactionalTravelInventoryIdentifier(UUID transactionalTravelInventoryIdentifier) {
        this.transactionalTravelInventoryIdentifier = transactionalTravelInventoryIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="transactionalTravelInventoryIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getTransactionalTravelInventoryIdentifier() {
        return this.transactionalTravelInventoryIdentifier;
    }

    @JsonProperty(value="transactionalTravelInventoryIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTransactionalTravelInventoryIdentifier(UUID transactionalTravelInventoryIdentifier) {
        this.transactionalTravelInventoryIdentifier = transactionalTravelInventoryIdentifier;
    }

    public AncillaryRequestAuthenticatedEntity startDate(LocalDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDateTime getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStartDate(LocalDateTime startDate) {
        this.startDate = startDate;
    }

    public AncillaryRequestAuthenticatedEntity endDate(LocalDateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDateTime getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEndDate(LocalDateTime endDate) {
        this.endDate = endDate;
    }

    public AncillaryRequestAuthenticatedEntity quantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @JsonProperty(value="quantity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getQuantity() {
        return this.quantity;
    }

    @JsonProperty(value="quantity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public AncillaryRequestAuthenticatedEntity identifier(UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentifier(UUID identifier) {
        this.identifier = identifier;
    }

    public AncillaryRequestAuthenticatedEntity type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AncillaryRequestAuthenticatedEntity ancillaryRequestAuthenticatedEntity = (AncillaryRequestAuthenticatedEntity)o;
        return Objects.equals(this.typeIdentifier, ancillaryRequestAuthenticatedEntity.typeIdentifier) && Objects.equals(this.channelInventoryIdentifier, ancillaryRequestAuthenticatedEntity.channelInventoryIdentifier) && Objects.equals(this.transactionalTravelInventoryIdentifier, ancillaryRequestAuthenticatedEntity.transactionalTravelInventoryIdentifier) && Objects.equals(this.startDate, ancillaryRequestAuthenticatedEntity.startDate) && Objects.equals(this.endDate, ancillaryRequestAuthenticatedEntity.endDate) && Objects.equals(this.quantity, ancillaryRequestAuthenticatedEntity.quantity) && Objects.equals(this.identifier, ancillaryRequestAuthenticatedEntity.identifier) && Objects.equals((Object)this.type, (Object)ancillaryRequestAuthenticatedEntity.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.typeIdentifier, this.channelInventoryIdentifier, this.transactionalTravelInventoryIdentifier, this.startDate, this.endDate, this.quantity, this.identifier, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AncillaryRequestAuthenticatedEntity {\n");
        sb.append("    typeIdentifier: ").append(this.toIndentedString(this.typeIdentifier)).append("\n");
        sb.append("    channelInventoryIdentifier: ").append(this.toIndentedString(this.channelInventoryIdentifier)).append("\n");
        sb.append("    transactionalTravelInventoryIdentifier: ").append(this.toIndentedString(this.transactionalTravelInventoryIdentifier)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        ROOM_TYPE_ANCILLARY("ROOM_TYPE_ANCILLARY"),
        ADD_ON("ADD_ON"),
        MEETING_ROOM("MEETING_ROOM"),
        SPA("SPA"),
        RESTAURANT("RESTAURANT"),
        ACTIVITY("ACTIVITY"),
        ATTRACTION("ATTRACTION"),
        PLACE("PLACE");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

