/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.booking.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import travel.wink.sdk.booking.model.CustomMonetaryAmount;
import travel.wink.sdk.booking.model.PayoutFeeBooker;
import travel.wink.sdk.booking.model.QuoteBooker;

@JsonPropertyOrder(value={"vendor", "vendorIdentifier", "vendorName", "ledgerIdentifier", "beneficiaryIdentifier", "externalPayeeIdentifier", "type", "entry", "fees", "quote", "created", "description", "payoutId", "referenceCode", "referenceCodeDate", "status"})
@JsonTypeName(value="Payout_Booker")
public class PayoutBooker {
    public static final String JSON_PROPERTY_VENDOR = "vendor";
    private VendorEnum vendor;
    public static final String JSON_PROPERTY_VENDOR_IDENTIFIER = "vendorIdentifier";
    private String vendorIdentifier;
    public static final String JSON_PROPERTY_VENDOR_NAME = "vendorName";
    private String vendorName;
    public static final String JSON_PROPERTY_LEDGER_IDENTIFIER = "ledgerIdentifier";
    private UUID ledgerIdentifier;
    public static final String JSON_PROPERTY_BENEFICIARY_IDENTIFIER = "beneficiaryIdentifier";
    private UUID beneficiaryIdentifier;
    public static final String JSON_PROPERTY_EXTERNAL_PAYEE_IDENTIFIER = "externalPayeeIdentifier";
    private String externalPayeeIdentifier;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_ENTRY = "entry";
    private CustomMonetaryAmount entry;
    public static final String JSON_PROPERTY_FEES = "fees";
    private List<PayoutFeeBooker> fees;
    public static final String JSON_PROPERTY_QUOTE = "quote";
    private QuoteBooker quote;
    public static final String JSON_PROPERTY_CREATED = "created";
    private LocalDateTime created;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_PAYOUT_ID = "payoutId";
    private String payoutId;
    public static final String JSON_PROPERTY_REFERENCE_CODE = "referenceCode";
    private String referenceCode;
    public static final String JSON_PROPERTY_REFERENCE_CODE_DATE = "referenceCodeDate";
    private LocalDateTime referenceCodeDate;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;

    public PayoutBooker vendor(VendorEnum vendor) {
        this.vendor = vendor;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="vendor")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public VendorEnum getVendor() {
        return this.vendor;
    }

    @JsonProperty(value="vendor")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setVendor(VendorEnum vendor) {
        this.vendor = vendor;
    }

    public PayoutBooker vendorIdentifier(String vendorIdentifier) {
        this.vendorIdentifier = vendorIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="vendorIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getVendorIdentifier() {
        return this.vendorIdentifier;
    }

    @JsonProperty(value="vendorIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setVendorIdentifier(String vendorIdentifier) {
        this.vendorIdentifier = vendorIdentifier;
    }

    public PayoutBooker vendorName(String vendorName) {
        this.vendorName = vendorName;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="vendorName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getVendorName() {
        return this.vendorName;
    }

    @JsonProperty(value="vendorName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setVendorName(String vendorName) {
        this.vendorName = vendorName;
    }

    public PayoutBooker ledgerIdentifier(UUID ledgerIdentifier) {
        this.ledgerIdentifier = ledgerIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="ledgerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getLedgerIdentifier() {
        return this.ledgerIdentifier;
    }

    @JsonProperty(value="ledgerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLedgerIdentifier(UUID ledgerIdentifier) {
        this.ledgerIdentifier = ledgerIdentifier;
    }

    public PayoutBooker beneficiaryIdentifier(UUID beneficiaryIdentifier) {
        this.beneficiaryIdentifier = beneficiaryIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="beneficiaryIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getBeneficiaryIdentifier() {
        return this.beneficiaryIdentifier;
    }

    @JsonProperty(value="beneficiaryIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBeneficiaryIdentifier(UUID beneficiaryIdentifier) {
        this.beneficiaryIdentifier = beneficiaryIdentifier;
    }

    public PayoutBooker externalPayeeIdentifier(String externalPayeeIdentifier) {
        this.externalPayeeIdentifier = externalPayeeIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="externalPayeeIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getExternalPayeeIdentifier() {
        return this.externalPayeeIdentifier;
    }

    @JsonProperty(value="externalPayeeIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setExternalPayeeIdentifier(String externalPayeeIdentifier) {
        this.externalPayeeIdentifier = externalPayeeIdentifier;
    }

    public PayoutBooker type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public PayoutBooker entry(CustomMonetaryAmount entry) {
        this.entry = entry;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="entry")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CustomMonetaryAmount getEntry() {
        return this.entry;
    }

    @JsonProperty(value="entry")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEntry(CustomMonetaryAmount entry) {
        this.entry = entry;
    }

    public PayoutBooker fees(List<PayoutFeeBooker> fees) {
        this.fees = fees;
        return this;
    }

    public PayoutBooker addFeesItem(PayoutFeeBooker feesItem) {
        if (this.fees == null) {
            this.fees = new ArrayList<PayoutFeeBooker>();
        }
        this.fees.add(feesItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="fees")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PayoutFeeBooker> getFees() {
        return this.fees;
    }

    @JsonProperty(value="fees")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFees(List<PayoutFeeBooker> fees) {
        this.fees = fees;
    }

    public PayoutBooker quote(QuoteBooker quote) {
        this.quote = quote;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="quote")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public QuoteBooker getQuote() {
        return this.quote;
    }

    @JsonProperty(value="quote")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setQuote(QuoteBooker quote) {
        this.quote = quote;
    }

    public PayoutBooker created(LocalDateTime created) {
        this.created = created;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDateTime getCreated() {
        return this.created;
    }

    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCreated(LocalDateTime created) {
        this.created = created;
    }

    public PayoutBooker description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public PayoutBooker payoutId(String payoutId) {
        this.payoutId = payoutId;
        return this;
    }

    @Nullable
    @JsonProperty(value="payoutId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPayoutId() {
        return this.payoutId;
    }

    @JsonProperty(value="payoutId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayoutId(String payoutId) {
        this.payoutId = payoutId;
    }

    public PayoutBooker referenceCode(String referenceCode) {
        this.referenceCode = referenceCode;
        return this;
    }

    @Nullable
    @JsonProperty(value="referenceCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReferenceCode() {
        return this.referenceCode;
    }

    @JsonProperty(value="referenceCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReferenceCode(String referenceCode) {
        this.referenceCode = referenceCode;
    }

    public PayoutBooker referenceCodeDate(LocalDateTime referenceCodeDate) {
        this.referenceCodeDate = referenceCodeDate;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="referenceCodeDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getReferenceCodeDate() {
        return this.referenceCodeDate;
    }

    @JsonProperty(value="referenceCodeDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReferenceCodeDate(LocalDateTime referenceCodeDate) {
        this.referenceCodeDate = referenceCodeDate;
    }

    public PayoutBooker status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayoutBooker payoutBooker = (PayoutBooker)o;
        return Objects.equals((Object)this.vendor, (Object)payoutBooker.vendor) && Objects.equals(this.vendorIdentifier, payoutBooker.vendorIdentifier) && Objects.equals(this.vendorName, payoutBooker.vendorName) && Objects.equals(this.ledgerIdentifier, payoutBooker.ledgerIdentifier) && Objects.equals(this.beneficiaryIdentifier, payoutBooker.beneficiaryIdentifier) && Objects.equals(this.externalPayeeIdentifier, payoutBooker.externalPayeeIdentifier) && Objects.equals((Object)this.type, (Object)payoutBooker.type) && Objects.equals(this.entry, payoutBooker.entry) && Objects.equals(this.fees, payoutBooker.fees) && Objects.equals(this.quote, payoutBooker.quote) && Objects.equals(this.created, payoutBooker.created) && Objects.equals(this.description, payoutBooker.description) && Objects.equals(this.payoutId, payoutBooker.payoutId) && Objects.equals(this.referenceCode, payoutBooker.referenceCode) && Objects.equals(this.referenceCodeDate, payoutBooker.referenceCodeDate) && Objects.equals((Object)this.status, (Object)payoutBooker.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.vendor, this.vendorIdentifier, this.vendorName, this.ledgerIdentifier, this.beneficiaryIdentifier, this.externalPayeeIdentifier, this.type, this.entry, this.fees, this.quote, this.created, this.description, this.payoutId, this.referenceCode, this.referenceCodeDate, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayoutBooker {\n");
        sb.append("    vendor: ").append(this.toIndentedString((Object)this.vendor)).append("\n");
        sb.append("    vendorIdentifier: ").append(this.toIndentedString(this.vendorIdentifier)).append("\n");
        sb.append("    vendorName: ").append(this.toIndentedString(this.vendorName)).append("\n");
        sb.append("    ledgerIdentifier: ").append(this.toIndentedString(this.ledgerIdentifier)).append("\n");
        sb.append("    beneficiaryIdentifier: ").append(this.toIndentedString(this.beneficiaryIdentifier)).append("\n");
        sb.append("    externalPayeeIdentifier: ").append(this.toIndentedString(this.externalPayeeIdentifier)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    entry: ").append(this.toIndentedString(this.entry)).append("\n");
        sb.append("    fees: ").append(this.toIndentedString(this.fees)).append("\n");
        sb.append("    quote: ").append(this.toIndentedString(this.quote)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    payoutId: ").append(this.toIndentedString(this.payoutId)).append("\n");
        sb.append("    referenceCode: ").append(this.toIndentedString(this.referenceCode)).append("\n");
        sb.append("    referenceCodeDate: ").append(this.toIndentedString(this.referenceCodeDate)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum VendorEnum {
        STRIPE("STRIPE"),
        AGENT("AGENT"),
        NMI("NMI"),
        WISE("WISE");

        private String value;

        private VendorEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static VendorEnum fromValue(String value) {
            for (VendorEnum b : VendorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        BANK_TRANSFER("BANK_TRANSFER");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum StatusEnum {
        INITIATED("INITIATED"),
        ACTIVE("ACTIVE"),
        INACTIVE("INACTIVE"),
        FAILED("FAILED"),
        CANCELLED("CANCELLED"),
        COMPLETE("COMPLETE");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

