/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/engine-client): A single endpoint to retrieve whitelabel + customization information for the booking engine.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Booking Engine API Welcome to the Booking Engine API - A programmer-friendly way to book inventory that was found on our platform. This API lets you:  1. Shopping Cart: Manage shopping cart. 2. Checkout: Move shopping cart items through the reactive workflow. 3. Booking: Move selected inventory through to booking completion. 4. Review: Leave a review after a completed stay.  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.14.5
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import travel.wink.sdk.booking.model.BeneficiaryBooker;
import travel.wink.sdk.booking.model.DailyRateBooker;
import travel.wink.sdk.booking.model.GuestUserBooker;
import travel.wink.sdk.booking.model.SimpleDateTimeItineraryBooker;
import travel.wink.sdk.booking.model.SupplierContractItemPolicyBooker;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Returns the lodging item only.
 */
@JsonPropertyOrder({
  BookingContractItemBooker.JSON_PROPERTY_SUPPLIER_ITEM_BOOKING_CODE,
  BookingContractItemBooker.JSON_PROPERTY_USER,
  BookingContractItemBooker.JSON_PROPERTY_NAME_IN_ENGLISH,
  BookingContractItemBooker.JSON_PROPERTY_DESCRIPTION_IN_ENGLISH,
  BookingContractItemBooker.JSON_PROPERTY_ITINERARY,
  BookingContractItemBooker.JSON_PROPERTY_PRICING_TYPE,
  BookingContractItemBooker.JSON_PROPERTY_TYPE,
  BookingContractItemBooker.JSON_PROPERTY_BENEFICIARY_LIST,
  BookingContractItemBooker.JSON_PROPERTY_PAYABLE,
  BookingContractItemBooker.JSON_PROPERTY_POLICY,
  BookingContractItemBooker.JSON_PROPERTY_EXTERNAL_IDENTIFIER,
  BookingContractItemBooker.JSON_PROPERTY_TOKENS_EARNED,
  BookingContractItemBooker.JSON_PROPERTY_DAILY_RATE_LIST,
  BookingContractItemBooker.JSON_PROPERTY_CANCELLED,
  BookingContractItemBooker.JSON_PROPERTY_SOURCE_CURRENCY,
  BookingContractItemBooker.JSON_PROPERTY_DISPLAY_CURRENCY,
  BookingContractItemBooker.JSON_PROPERTY_SUPPLIER_CURRENCY,
  BookingContractItemBooker.JSON_PROPERTY_INTERNAL_CURRENCY,
  BookingContractItemBooker.JSON_PROPERTY_CAPTURE_CURRENCY,
  BookingContractItemBooker.JSON_PROPERTY_SOURCE_AMOUNT,
  BookingContractItemBooker.JSON_PROPERTY_DISPLAY_AMOUNT,
  BookingContractItemBooker.JSON_PROPERTY_SUPPLIER_AMOUNT,
  BookingContractItemBooker.JSON_PROPERTY_INTERNAL_AMOUNT,
  BookingContractItemBooker.JSON_PROPERTY_CAPTURE_AMOUNT,
  BookingContractItemBooker.JSON_PROPERTY_SOURCE_AMOUNT_REFUND_MODIFIER,
  BookingContractItemBooker.JSON_PROPERTY_DISPLAY_AMOUNT_REFUND_MODIFIER,
  BookingContractItemBooker.JSON_PROPERTY_SUPPLIER_AMOUNT_REFUND_MODIFIER,
  BookingContractItemBooker.JSON_PROPERTY_INTERNAL_AMOUNT_REFUND_MODIFIER,
  BookingContractItemBooker.JSON_PROPERTY_CAPTURE_AMOUNT_REFUND_MODIFIER,
  BookingContractItemBooker.JSON_PROPERTY_NET_SOURCE_AMOUNT,
  BookingContractItemBooker.JSON_PROPERTY_NET_DISPLAY_AMOUNT,
  BookingContractItemBooker.JSON_PROPERTY_NET_SUPPLIER_AMOUNT,
  BookingContractItemBooker.JSON_PROPERTY_NET_INTERNAL_AMOUNT,
  BookingContractItemBooker.JSON_PROPERTY_NET_CAPTURE_AMOUNT,
  BookingContractItemBooker.JSON_PROPERTY_METADATA,
  BookingContractItemBooker.JSON_PROPERTY_CANCELLABLE_BY_TRAVELER,
  BookingContractItemBooker.JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES,
  BookingContractItemBooker.JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGES,
  BookingContractItemBooker.JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER_OR_AGENT
})
@JsonTypeName("BookingContractItem_Booker")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-03-04T20:46:30.066932548+07:00[Asia/Bangkok]")
public class BookingContractItemBooker {
  public static final String JSON_PROPERTY_SUPPLIER_ITEM_BOOKING_CODE = "supplierItemBookingCode";
  private String supplierItemBookingCode;

  public static final String JSON_PROPERTY_USER = "user";
  private GuestUserBooker user;

  public static final String JSON_PROPERTY_NAME_IN_ENGLISH = "nameInEnglish";
  private String nameInEnglish;

  public static final String JSON_PROPERTY_DESCRIPTION_IN_ENGLISH = "descriptionInEnglish";
  private String descriptionInEnglish;

  public static final String JSON_PROPERTY_ITINERARY = "itinerary";
  private SimpleDateTimeItineraryBooker itinerary;

  /**
   * How to calculate the total amount.
   */
  public enum PricingTypeEnum {
    STAY("PER_STAY"),
    
    DAY("PER_DAY"),
    
    NIGHT("PER_NIGHT"),
    
    USE("PER_USE"),
    
    HOUR("PER_HOUR"),
    
    PERSON("PER_PERSON"),
    
    PERSON_PER_NIGHT("PER_PERSON_PER_NIGHT"),
    
    PERSON_PER_HOUR("PER_PERSON_PER_HOUR"),
    
    ADULT("PER_ADULT"),
    
    ADULT_PER_NIGHT("PER_ADULT_PER_NIGHT"),
    
    ADULT_PER_HOUR("PER_ADULT_PER_HOUR"),
    
    CHILD("PER_CHILD"),
    
    CHILD_PER_NIGHT("PER_CHILD_PER_NIGHT"),
    
    CHILD_PER_HOUR("PER_CHILD_PER_HOUR");

    private String value;

    PricingTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PricingTypeEnum fromValue(String value) {
      for (PricingTypeEnum b : PricingTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
  private PricingTypeEnum pricingType;

  /**
   * Type of item this is.
   */
  public enum TypeEnum {
    LODGING("LODGING"),
    
    RAIL("RAIL"),
    
    AIR("AIR"),
    
    CAR("CAR"),
    
    CRUISE("CRUISE"),
    
    PACKAGE("PACKAGE"),
    
    ADD_ON("ADD_ON"),
    
    RENTAL("RENTAL"),
    
    EXPERIENCE("EXPERIENCE"),
    
    ANCILLARY_BOOKING("ANCILLARY_BOOKING"),
    
    ANCILLARY_FEE("ANCILLARY_FEE");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_BENEFICIARY_LIST = "beneficiaryList";
  private List<BeneficiaryBooker> beneficiaryList = new ArrayList<>();

  /**
   * When to charge for this item.
   */
  public enum PayableEnum {
    IMMEDIATE("IMMEDIATE"),
    
    ARRIVAL("ARRIVAL"),
    
    DEPARTURE("DEPARTURE"),
    
    AGENT("AGENT");

    private String value;

    PayableEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PayableEnum fromValue(String value) {
      for (PayableEnum b : PayableEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PAYABLE = "payable";
  private PayableEnum payable;

  public static final String JSON_PROPERTY_POLICY = "policy";
  private SupplierContractItemPolicyBooker policy;

  public static final String JSON_PROPERTY_EXTERNAL_IDENTIFIER = "externalIdentifier";
  private String externalIdentifier;

  public static final String JSON_PROPERTY_TOKENS_EARNED = "tokensEarned";
  private Long tokensEarned;

  public static final String JSON_PROPERTY_DAILY_RATE_LIST = "dailyRateList";
  private List<DailyRateBooker> dailyRateList;

  public static final String JSON_PROPERTY_CANCELLED = "cancelled";
  private Boolean cancelled;

  public static final String JSON_PROPERTY_SOURCE_CURRENCY = "sourceCurrency";
  private String sourceCurrency;

  public static final String JSON_PROPERTY_DISPLAY_CURRENCY = "displayCurrency";
  private String displayCurrency;

  public static final String JSON_PROPERTY_SUPPLIER_CURRENCY = "supplierCurrency";
  private String supplierCurrency;

  public static final String JSON_PROPERTY_INTERNAL_CURRENCY = "internalCurrency";
  private String internalCurrency;

  public static final String JSON_PROPERTY_CAPTURE_CURRENCY = "captureCurrency";
  private String captureCurrency;

  public static final String JSON_PROPERTY_SOURCE_AMOUNT = "sourceAmount";
  private BigDecimal sourceAmount;

  public static final String JSON_PROPERTY_DISPLAY_AMOUNT = "displayAmount";
  private BigDecimal displayAmount;

  public static final String JSON_PROPERTY_SUPPLIER_AMOUNT = "supplierAmount";
  private BigDecimal supplierAmount;

  public static final String JSON_PROPERTY_INTERNAL_AMOUNT = "internalAmount";
  private BigDecimal internalAmount;

  public static final String JSON_PROPERTY_CAPTURE_AMOUNT = "captureAmount";
  private BigDecimal captureAmount;

  public static final String JSON_PROPERTY_SOURCE_AMOUNT_REFUND_MODIFIER = "sourceAmountRefundModifier";
  private BigDecimal sourceAmountRefundModifier;

  public static final String JSON_PROPERTY_DISPLAY_AMOUNT_REFUND_MODIFIER = "displayAmountRefundModifier";
  private BigDecimal displayAmountRefundModifier;

  public static final String JSON_PROPERTY_SUPPLIER_AMOUNT_REFUND_MODIFIER = "supplierAmountRefundModifier";
  private BigDecimal supplierAmountRefundModifier;

  public static final String JSON_PROPERTY_INTERNAL_AMOUNT_REFUND_MODIFIER = "internalAmountRefundModifier";
  private BigDecimal internalAmountRefundModifier;

  public static final String JSON_PROPERTY_CAPTURE_AMOUNT_REFUND_MODIFIER = "captureAmountRefundModifier";
  private BigDecimal captureAmountRefundModifier;

  public static final String JSON_PROPERTY_NET_SOURCE_AMOUNT = "netSourceAmount";
  private BigDecimal netSourceAmount;

  public static final String JSON_PROPERTY_NET_DISPLAY_AMOUNT = "netDisplayAmount";
  private BigDecimal netDisplayAmount;

  public static final String JSON_PROPERTY_NET_SUPPLIER_AMOUNT = "netSupplierAmount";
  private BigDecimal netSupplierAmount;

  public static final String JSON_PROPERTY_NET_INTERNAL_AMOUNT = "netInternalAmount";
  private BigDecimal netInternalAmount;

  public static final String JSON_PROPERTY_NET_CAPTURE_AMOUNT = "netCaptureAmount";
  private BigDecimal netCaptureAmount;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private Map<String, String> metadata = new HashMap<>();

  public static final String JSON_PROPERTY_CANCELLABLE_BY_TRAVELER = "cancellableByTraveler";
  private Boolean cancellableByTraveler;

  public static final String JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES = "cancellableWithNoCharges";
  private Boolean cancellableWithNoCharges;

  public static final String JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGES = "cancellableWithPotentialCharges";
  private Boolean cancellableWithPotentialCharges;

  public static final String JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER_OR_AGENT = "cancellableBySupplierOrAgent";
  private Boolean cancellableBySupplierOrAgent;

  public BookingContractItemBooker() {
  }

  public BookingContractItemBooker supplierItemBookingCode(String supplierItemBookingCode) {
    
    this.supplierItemBookingCode = supplierItemBookingCode;
    return this;
  }

   /**
   * Booking code identifying the supplier line item.
   * @return supplierItemBookingCode
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SUPPLIER_ITEM_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSupplierItemBookingCode() {
    return supplierItemBookingCode;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_ITEM_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierItemBookingCode(String supplierItemBookingCode) {
    this.supplierItemBookingCode = supplierItemBookingCode;
  }


  public BookingContractItemBooker user(GuestUserBooker user) {
    
    this.user = user;
    return this;
  }

   /**
   * Get user
   * @return user
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public GuestUserBooker getUser() {
    return user;
  }


  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUser(GuestUserBooker user) {
    this.user = user;
  }


  public BookingContractItemBooker nameInEnglish(String nameInEnglish) {
    
    this.nameInEnglish = nameInEnglish;
    return this;
  }

   /**
   * Name of item in English included in booking.
   * @return nameInEnglish
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_NAME_IN_ENGLISH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getNameInEnglish() {
    return nameInEnglish;
  }


  @JsonProperty(JSON_PROPERTY_NAME_IN_ENGLISH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setNameInEnglish(String nameInEnglish) {
    this.nameInEnglish = nameInEnglish;
  }


  public BookingContractItemBooker descriptionInEnglish(String descriptionInEnglish) {
    
    this.descriptionInEnglish = descriptionInEnglish;
    return this;
  }

   /**
   * Short description in English of item included in booking.
   * @return descriptionInEnglish
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_DESCRIPTION_IN_ENGLISH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDescriptionInEnglish() {
    return descriptionInEnglish;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION_IN_ENGLISH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescriptionInEnglish(String descriptionInEnglish) {
    this.descriptionInEnglish = descriptionInEnglish;
  }


  public BookingContractItemBooker itinerary(SimpleDateTimeItineraryBooker itinerary) {
    
    this.itinerary = itinerary;
    return this;
  }

   /**
   * Get itinerary
   * @return itinerary
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ITINERARY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public SimpleDateTimeItineraryBooker getItinerary() {
    return itinerary;
  }


  @JsonProperty(JSON_PROPERTY_ITINERARY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setItinerary(SimpleDateTimeItineraryBooker itinerary) {
    this.itinerary = itinerary;
  }


  public BookingContractItemBooker pricingType(PricingTypeEnum pricingType) {
    
    this.pricingType = pricingType;
    return this;
  }

   /**
   * How to calculate the total amount.
   * @return pricingType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PricingTypeEnum getPricingType() {
    return pricingType;
  }


  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPricingType(PricingTypeEnum pricingType) {
    this.pricingType = pricingType;
  }


  public BookingContractItemBooker type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Type of item this is.
   * @return type
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public BookingContractItemBooker beneficiaryList(List<BeneficiaryBooker> beneficiaryList) {
    
    this.beneficiaryList = beneficiaryList;
    return this;
  }

  public BookingContractItemBooker addBeneficiaryListItem(BeneficiaryBooker beneficiaryListItem) {
    if (this.beneficiaryList == null) {
      this.beneficiaryList = new ArrayList<>();
    }
    this.beneficiaryList.add(beneficiaryListItem);
    return this;
  }

   /**
   * Get beneficiaryList
   * @return beneficiaryList
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1,max=2147483647)
  @JsonProperty(JSON_PROPERTY_BENEFICIARY_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<BeneficiaryBooker> getBeneficiaryList() {
    return beneficiaryList;
  }


  @JsonProperty(JSON_PROPERTY_BENEFICIARY_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBeneficiaryList(List<BeneficiaryBooker> beneficiaryList) {
    this.beneficiaryList = beneficiaryList;
  }


  public BookingContractItemBooker payable(PayableEnum payable) {
    
    this.payable = payable;
    return this;
  }

   /**
   * When to charge for this item.
   * @return payable
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PAYABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PayableEnum getPayable() {
    return payable;
  }


  @JsonProperty(JSON_PROPERTY_PAYABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPayable(PayableEnum payable) {
    this.payable = payable;
  }


  public BookingContractItemBooker policy(SupplierContractItemPolicyBooker policy) {
    
    this.policy = policy;
    return this;
  }

   /**
   * Get policy
   * @return policy
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SupplierContractItemPolicyBooker getPolicy() {
    return policy;
  }


  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPolicy(SupplierContractItemPolicyBooker policy) {
    this.policy = policy;
  }


  public BookingContractItemBooker externalIdentifier(String externalIdentifier) {
    
    this.externalIdentifier = externalIdentifier;
    return this;
  }

   /**
   * Optional externalIdentifier to remote inventory.
   * @return externalIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_EXTERNAL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalIdentifier() {
    return externalIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalIdentifier(String externalIdentifier) {
    this.externalIdentifier = externalIdentifier;
  }


  public BookingContractItemBooker tokensEarned(Long tokensEarned) {
    
    this.tokensEarned = tokensEarned;
    return this;
  }

   /**
   * Tokens minted for this item
   * @return tokensEarned
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOKENS_EARNED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getTokensEarned() {
    return tokensEarned;
  }


  @JsonProperty(JSON_PROPERTY_TOKENS_EARNED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTokensEarned(Long tokensEarned) {
    this.tokensEarned = tokensEarned;
  }


  public BookingContractItemBooker dailyRateList(List<DailyRateBooker> dailyRateList) {
    
    this.dailyRateList = dailyRateList;
    return this;
  }

  public BookingContractItemBooker addDailyRateListItem(DailyRateBooker dailyRateListItem) {
    if (this.dailyRateList == null) {
      this.dailyRateList = new ArrayList<>();
    }
    this.dailyRateList.add(dailyRateListItem);
    return this;
  }

   /**
   * Get dailyRateList
   * @return dailyRateList
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DAILY_RATE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<DailyRateBooker> getDailyRateList() {
    return dailyRateList;
  }


  @JsonProperty(JSON_PROPERTY_DAILY_RATE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDailyRateList(List<DailyRateBooker> dailyRateList) {
    this.dailyRateList = dailyRateList;
  }


  public BookingContractItemBooker cancelled(Boolean cancelled) {
    
    this.cancelled = cancelled;
    return this;
  }

   /**
   * Optional geoname externalIdentifier to remote inventory.
   * @return cancelled
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancelled() {
    return cancelled;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancelled(Boolean cancelled) {
    this.cancelled = cancelled;
  }


  public BookingContractItemBooker sourceCurrency(String sourceCurrency) {
    
    this.sourceCurrency = sourceCurrency;
    return this;
  }

   /**
   * The source currency
   * @return sourceCurrency
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SOURCE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSourceCurrency() {
    return sourceCurrency;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceCurrency(String sourceCurrency) {
    this.sourceCurrency = sourceCurrency;
  }


  public BookingContractItemBooker displayCurrency(String displayCurrency) {
    
    this.displayCurrency = displayCurrency;
    return this;
  }

   /**
   * The display currency
   * @return displayCurrency
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_DISPLAY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDisplayCurrency() {
    return displayCurrency;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisplayCurrency(String displayCurrency) {
    this.displayCurrency = displayCurrency;
  }


  public BookingContractItemBooker supplierCurrency(String supplierCurrency) {
    
    this.supplierCurrency = supplierCurrency;
    return this;
  }

   /**
   * The supplier currency
   * @return supplierCurrency
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SUPPLIER_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSupplierCurrency() {
    return supplierCurrency;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierCurrency(String supplierCurrency) {
    this.supplierCurrency = supplierCurrency;
  }


  public BookingContractItemBooker internalCurrency(String internalCurrency) {
    
    this.internalCurrency = internalCurrency;
    return this;
  }

   /**
   * The internal currency
   * @return internalCurrency
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_INTERNAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getInternalCurrency() {
    return internalCurrency;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInternalCurrency(String internalCurrency) {
    this.internalCurrency = internalCurrency;
  }


  public BookingContractItemBooker captureCurrency(String captureCurrency) {
    
    this.captureCurrency = captureCurrency;
    return this;
  }

   /**
   * The capture currency
   * @return captureCurrency
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CAPTURE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCaptureCurrency() {
    return captureCurrency;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCaptureCurrency(String captureCurrency) {
    this.captureCurrency = captureCurrency;
  }


  public BookingContractItemBooker sourceAmount(BigDecimal sourceAmount) {
    
    this.sourceAmount = sourceAmount;
    return this;
  }

   /**
   * The total initial price as quoted in the original TripPay contract.
   * minimum: 0
   * @return sourceAmount
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getSourceAmount() {
    return sourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceAmount(BigDecimal sourceAmount) {
    this.sourceAmount = sourceAmount;
  }


  public BookingContractItemBooker displayAmount(BigDecimal displayAmount) {
    
    this.displayAmount = displayAmount;
    return this;
  }

   /**
   * The total display price.
   * minimum: 0
   * @return displayAmount
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getDisplayAmount() {
    return displayAmount;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisplayAmount(BigDecimal displayAmount) {
    this.displayAmount = displayAmount;
  }


  public BookingContractItemBooker supplierAmount(BigDecimal supplierAmount) {
    
    this.supplierAmount = supplierAmount;
    return this;
  }

   /**
   * The total supplier price.
   * minimum: 0
   * @return supplierAmount
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getSupplierAmount() {
    return supplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierAmount(BigDecimal supplierAmount) {
    this.supplierAmount = supplierAmount;
  }


  public BookingContractItemBooker internalAmount(BigDecimal internalAmount) {
    
    this.internalAmount = internalAmount;
    return this;
  }

   /**
   * The total internal price.
   * minimum: 0
   * @return internalAmount
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getInternalAmount() {
    return internalAmount;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInternalAmount(BigDecimal internalAmount) {
    this.internalAmount = internalAmount;
  }


  public BookingContractItemBooker captureAmount(BigDecimal captureAmount) {
    
    this.captureAmount = captureAmount;
    return this;
  }

   /**
   * The total capture price.
   * minimum: 0
   * @return captureAmount
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getCaptureAmount() {
    return captureAmount;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCaptureAmount(BigDecimal captureAmount) {
    this.captureAmount = captureAmount;
  }


  public BookingContractItemBooker sourceAmountRefundModifier(BigDecimal sourceAmountRefundModifier) {
    
    this.sourceAmountRefundModifier = sourceAmountRefundModifier;
    return this;
  }

   /**
   * The source amount still due after a partial refund occurs.
   * minimum: 0
   * @return sourceAmountRefundModifier
  **/
  @jakarta.annotation.Nullable
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_SOURCE_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSourceAmountRefundModifier() {
    return sourceAmountRefundModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceAmountRefundModifier(BigDecimal sourceAmountRefundModifier) {
    this.sourceAmountRefundModifier = sourceAmountRefundModifier;
  }


  public BookingContractItemBooker displayAmountRefundModifier(BigDecimal displayAmountRefundModifier) {
    
    this.displayAmountRefundModifier = displayAmountRefundModifier;
    return this;
  }

   /**
   * The display amount still due after a partial refund occurs.
   * minimum: 0
   * @return displayAmountRefundModifier
  **/
  @jakarta.annotation.Nullable
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_DISPLAY_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getDisplayAmountRefundModifier() {
    return displayAmountRefundModifier;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayAmountRefundModifier(BigDecimal displayAmountRefundModifier) {
    this.displayAmountRefundModifier = displayAmountRefundModifier;
  }


  public BookingContractItemBooker supplierAmountRefundModifier(BigDecimal supplierAmountRefundModifier) {
    
    this.supplierAmountRefundModifier = supplierAmountRefundModifier;
    return this;
  }

   /**
   * The supplier amount still due after a partial refund occurs.
   * minimum: 0
   * @return supplierAmountRefundModifier
  **/
  @jakarta.annotation.Nullable
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_SUPPLIER_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSupplierAmountRefundModifier() {
    return supplierAmountRefundModifier;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupplierAmountRefundModifier(BigDecimal supplierAmountRefundModifier) {
    this.supplierAmountRefundModifier = supplierAmountRefundModifier;
  }


  public BookingContractItemBooker internalAmountRefundModifier(BigDecimal internalAmountRefundModifier) {
    
    this.internalAmountRefundModifier = internalAmountRefundModifier;
    return this;
  }

   /**
   * The internal amount still due after a partial refund occurs.
   * minimum: 0
   * @return internalAmountRefundModifier
  **/
  @jakarta.annotation.Nullable
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_INTERNAL_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getInternalAmountRefundModifier() {
    return internalAmountRefundModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalAmountRefundModifier(BigDecimal internalAmountRefundModifier) {
    this.internalAmountRefundModifier = internalAmountRefundModifier;
  }


  public BookingContractItemBooker captureAmountRefundModifier(BigDecimal captureAmountRefundModifier) {
    
    this.captureAmountRefundModifier = captureAmountRefundModifier;
    return this;
  }

   /**
   * The capture amount still due after a partial refund occurs.
   * minimum: 0
   * @return captureAmountRefundModifier
  **/
  @jakarta.annotation.Nullable
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_CAPTURE_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getCaptureAmountRefundModifier() {
    return captureAmountRefundModifier;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCaptureAmountRefundModifier(BigDecimal captureAmountRefundModifier) {
    this.captureAmountRefundModifier = captureAmountRefundModifier;
  }


  public BookingContractItemBooker netSourceAmount(BigDecimal netSourceAmount) {
    
    this.netSourceAmount = netSourceAmount;
    return this;
  }

   /**
   * Source amount minus source modifier.
   * minimum: 0
   * @return netSourceAmount
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_NET_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getNetSourceAmount() {
    return netSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setNetSourceAmount(BigDecimal netSourceAmount) {
    this.netSourceAmount = netSourceAmount;
  }


  public BookingContractItemBooker netDisplayAmount(BigDecimal netDisplayAmount) {
    
    this.netDisplayAmount = netDisplayAmount;
    return this;
  }

   /**
   * Display amount minus display modifier.
   * minimum: 0
   * @return netDisplayAmount
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_NET_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getNetDisplayAmount() {
    return netDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setNetDisplayAmount(BigDecimal netDisplayAmount) {
    this.netDisplayAmount = netDisplayAmount;
  }


  public BookingContractItemBooker netSupplierAmount(BigDecimal netSupplierAmount) {
    
    this.netSupplierAmount = netSupplierAmount;
    return this;
  }

   /**
   * Supplier amount minus supplier modifier.
   * minimum: 0
   * @return netSupplierAmount
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_NET_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getNetSupplierAmount() {
    return netSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setNetSupplierAmount(BigDecimal netSupplierAmount) {
    this.netSupplierAmount = netSupplierAmount;
  }


  public BookingContractItemBooker netInternalAmount(BigDecimal netInternalAmount) {
    
    this.netInternalAmount = netInternalAmount;
    return this;
  }

   /**
   * Internal amount minus internal modifier.
   * minimum: 0
   * @return netInternalAmount
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_NET_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getNetInternalAmount() {
    return netInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setNetInternalAmount(BigDecimal netInternalAmount) {
    this.netInternalAmount = netInternalAmount;
  }


  public BookingContractItemBooker netCaptureAmount(BigDecimal netCaptureAmount) {
    
    this.netCaptureAmount = netCaptureAmount;
    return this;
  }

   /**
   * Capture amount minus capture modifier.
   * minimum: 0
   * @return netCaptureAmount
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_NET_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getNetCaptureAmount() {
    return netCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setNetCaptureAmount(BigDecimal netCaptureAmount) {
    this.netCaptureAmount = netCaptureAmount;
  }


  public BookingContractItemBooker metadata(Map<String, String> metadata) {
    
    this.metadata = metadata;
    return this;
  }

  public BookingContractItemBooker putMetadataItem(String key, String metadataItem) {
    if (this.metadata == null) {
      this.metadata = new HashMap<>();
    }
    this.metadata.put(key, metadataItem);
    return this;
  }

   /**
   * Place to add more data related to the booking contract item.
   * @return metadata
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, String> getMetadata() {
    return metadata;
  }


  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(Map<String, String> metadata) {
    this.metadata = metadata;
  }


  public BookingContractItemBooker cancellableByTraveler(Boolean cancellableByTraveler) {
    
    this.cancellableByTraveler = cancellableByTraveler;
    return this;
  }

   /**
   * Whether the booking can still be cancelled by the traveller.
   * @return cancellableByTraveler
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_TRAVELER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableByTraveler() {
    return cancellableByTraveler;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_TRAVELER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableByTraveler(Boolean cancellableByTraveler) {
    this.cancellableByTraveler = cancellableByTraveler;
  }


  public BookingContractItemBooker cancellableWithNoCharges(Boolean cancellableWithNoCharges) {
    
    this.cancellableWithNoCharges = cancellableWithNoCharges;
    return this;
  }

   /**
   * Whether the booking can still be cancelled and whether cancellation charges might still occur.
   * @return cancellableWithNoCharges
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableWithNoCharges() {
    return cancellableWithNoCharges;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableWithNoCharges(Boolean cancellableWithNoCharges) {
    this.cancellableWithNoCharges = cancellableWithNoCharges;
  }


  public BookingContractItemBooker cancellableWithPotentialCharges(Boolean cancellableWithPotentialCharges) {
    
    this.cancellableWithPotentialCharges = cancellableWithPotentialCharges;
    return this;
  }

   /**
   * Whether the booking can still be cancelled and whether cancellation charges might still occur.
   * @return cancellableWithPotentialCharges
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableWithPotentialCharges() {
    return cancellableWithPotentialCharges;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableWithPotentialCharges(Boolean cancellableWithPotentialCharges) {
    this.cancellableWithPotentialCharges = cancellableWithPotentialCharges;
  }


  public BookingContractItemBooker cancellableBySupplierOrAgent(Boolean cancellableBySupplierOrAgent) {
    
    this.cancellableBySupplierOrAgent = cancellableBySupplierOrAgent;
    return this;
  }

   /**
   * Whether the booking can still be cancelled by the supplier. A supplier cancellation overrides the refundable
   * @return cancellableBySupplierOrAgent
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER_OR_AGENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableBySupplierOrAgent() {
    return cancellableBySupplierOrAgent;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER_OR_AGENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableBySupplierOrAgent(Boolean cancellableBySupplierOrAgent) {
    this.cancellableBySupplierOrAgent = cancellableBySupplierOrAgent;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BookingContractItemBooker bookingContractItemBooker = (BookingContractItemBooker) o;
    return Objects.equals(this.supplierItemBookingCode, bookingContractItemBooker.supplierItemBookingCode) &&
        Objects.equals(this.user, bookingContractItemBooker.user) &&
        Objects.equals(this.nameInEnglish, bookingContractItemBooker.nameInEnglish) &&
        Objects.equals(this.descriptionInEnglish, bookingContractItemBooker.descriptionInEnglish) &&
        Objects.equals(this.itinerary, bookingContractItemBooker.itinerary) &&
        Objects.equals(this.pricingType, bookingContractItemBooker.pricingType) &&
        Objects.equals(this.type, bookingContractItemBooker.type) &&
        Objects.equals(this.beneficiaryList, bookingContractItemBooker.beneficiaryList) &&
        Objects.equals(this.payable, bookingContractItemBooker.payable) &&
        Objects.equals(this.policy, bookingContractItemBooker.policy) &&
        Objects.equals(this.externalIdentifier, bookingContractItemBooker.externalIdentifier) &&
        Objects.equals(this.tokensEarned, bookingContractItemBooker.tokensEarned) &&
        Objects.equals(this.dailyRateList, bookingContractItemBooker.dailyRateList) &&
        Objects.equals(this.cancelled, bookingContractItemBooker.cancelled) &&
        Objects.equals(this.sourceCurrency, bookingContractItemBooker.sourceCurrency) &&
        Objects.equals(this.displayCurrency, bookingContractItemBooker.displayCurrency) &&
        Objects.equals(this.supplierCurrency, bookingContractItemBooker.supplierCurrency) &&
        Objects.equals(this.internalCurrency, bookingContractItemBooker.internalCurrency) &&
        Objects.equals(this.captureCurrency, bookingContractItemBooker.captureCurrency) &&
        Objects.equals(this.sourceAmount, bookingContractItemBooker.sourceAmount) &&
        Objects.equals(this.displayAmount, bookingContractItemBooker.displayAmount) &&
        Objects.equals(this.supplierAmount, bookingContractItemBooker.supplierAmount) &&
        Objects.equals(this.internalAmount, bookingContractItemBooker.internalAmount) &&
        Objects.equals(this.captureAmount, bookingContractItemBooker.captureAmount) &&
        Objects.equals(this.sourceAmountRefundModifier, bookingContractItemBooker.sourceAmountRefundModifier) &&
        Objects.equals(this.displayAmountRefundModifier, bookingContractItemBooker.displayAmountRefundModifier) &&
        Objects.equals(this.supplierAmountRefundModifier, bookingContractItemBooker.supplierAmountRefundModifier) &&
        Objects.equals(this.internalAmountRefundModifier, bookingContractItemBooker.internalAmountRefundModifier) &&
        Objects.equals(this.captureAmountRefundModifier, bookingContractItemBooker.captureAmountRefundModifier) &&
        Objects.equals(this.netSourceAmount, bookingContractItemBooker.netSourceAmount) &&
        Objects.equals(this.netDisplayAmount, bookingContractItemBooker.netDisplayAmount) &&
        Objects.equals(this.netSupplierAmount, bookingContractItemBooker.netSupplierAmount) &&
        Objects.equals(this.netInternalAmount, bookingContractItemBooker.netInternalAmount) &&
        Objects.equals(this.netCaptureAmount, bookingContractItemBooker.netCaptureAmount) &&
        Objects.equals(this.metadata, bookingContractItemBooker.metadata) &&
        Objects.equals(this.cancellableByTraveler, bookingContractItemBooker.cancellableByTraveler) &&
        Objects.equals(this.cancellableWithNoCharges, bookingContractItemBooker.cancellableWithNoCharges) &&
        Objects.equals(this.cancellableWithPotentialCharges, bookingContractItemBooker.cancellableWithPotentialCharges) &&
        Objects.equals(this.cancellableBySupplierOrAgent, bookingContractItemBooker.cancellableBySupplierOrAgent);
  }

  @Override
  public int hashCode() {
    return Objects.hash(supplierItemBookingCode, user, nameInEnglish, descriptionInEnglish, itinerary, pricingType, type, beneficiaryList, payable, policy, externalIdentifier, tokensEarned, dailyRateList, cancelled, sourceCurrency, displayCurrency, supplierCurrency, internalCurrency, captureCurrency, sourceAmount, displayAmount, supplierAmount, internalAmount, captureAmount, sourceAmountRefundModifier, displayAmountRefundModifier, supplierAmountRefundModifier, internalAmountRefundModifier, captureAmountRefundModifier, netSourceAmount, netDisplayAmount, netSupplierAmount, netInternalAmount, netCaptureAmount, metadata, cancellableByTraveler, cancellableWithNoCharges, cancellableWithPotentialCharges, cancellableBySupplierOrAgent);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BookingContractItemBooker {\n");
    sb.append("    supplierItemBookingCode: ").append(toIndentedString(supplierItemBookingCode)).append("\n");
    sb.append("    user: ").append(toIndentedString(user)).append("\n");
    sb.append("    nameInEnglish: ").append(toIndentedString(nameInEnglish)).append("\n");
    sb.append("    descriptionInEnglish: ").append(toIndentedString(descriptionInEnglish)).append("\n");
    sb.append("    itinerary: ").append(toIndentedString(itinerary)).append("\n");
    sb.append("    pricingType: ").append(toIndentedString(pricingType)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    beneficiaryList: ").append(toIndentedString(beneficiaryList)).append("\n");
    sb.append("    payable: ").append(toIndentedString(payable)).append("\n");
    sb.append("    policy: ").append(toIndentedString(policy)).append("\n");
    sb.append("    externalIdentifier: ").append(toIndentedString(externalIdentifier)).append("\n");
    sb.append("    tokensEarned: ").append(toIndentedString(tokensEarned)).append("\n");
    sb.append("    dailyRateList: ").append(toIndentedString(dailyRateList)).append("\n");
    sb.append("    cancelled: ").append(toIndentedString(cancelled)).append("\n");
    sb.append("    sourceCurrency: ").append(toIndentedString(sourceCurrency)).append("\n");
    sb.append("    displayCurrency: ").append(toIndentedString(displayCurrency)).append("\n");
    sb.append("    supplierCurrency: ").append(toIndentedString(supplierCurrency)).append("\n");
    sb.append("    internalCurrency: ").append(toIndentedString(internalCurrency)).append("\n");
    sb.append("    captureCurrency: ").append(toIndentedString(captureCurrency)).append("\n");
    sb.append("    sourceAmount: ").append(toIndentedString(sourceAmount)).append("\n");
    sb.append("    displayAmount: ").append(toIndentedString(displayAmount)).append("\n");
    sb.append("    supplierAmount: ").append(toIndentedString(supplierAmount)).append("\n");
    sb.append("    internalAmount: ").append(toIndentedString(internalAmount)).append("\n");
    sb.append("    captureAmount: ").append(toIndentedString(captureAmount)).append("\n");
    sb.append("    sourceAmountRefundModifier: ").append(toIndentedString(sourceAmountRefundModifier)).append("\n");
    sb.append("    displayAmountRefundModifier: ").append(toIndentedString(displayAmountRefundModifier)).append("\n");
    sb.append("    supplierAmountRefundModifier: ").append(toIndentedString(supplierAmountRefundModifier)).append("\n");
    sb.append("    internalAmountRefundModifier: ").append(toIndentedString(internalAmountRefundModifier)).append("\n");
    sb.append("    captureAmountRefundModifier: ").append(toIndentedString(captureAmountRefundModifier)).append("\n");
    sb.append("    netSourceAmount: ").append(toIndentedString(netSourceAmount)).append("\n");
    sb.append("    netDisplayAmount: ").append(toIndentedString(netDisplayAmount)).append("\n");
    sb.append("    netSupplierAmount: ").append(toIndentedString(netSupplierAmount)).append("\n");
    sb.append("    netInternalAmount: ").append(toIndentedString(netInternalAmount)).append("\n");
    sb.append("    netCaptureAmount: ").append(toIndentedString(netCaptureAmount)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    cancellableByTraveler: ").append(toIndentedString(cancellableByTraveler)).append("\n");
    sb.append("    cancellableWithNoCharges: ").append(toIndentedString(cancellableWithNoCharges)).append("\n");
    sb.append("    cancellableWithPotentialCharges: ").append(toIndentedString(cancellableWithPotentialCharges)).append("\n");
    sb.append("    cancellableBySupplierOrAgent: ").append(toIndentedString(cancellableBySupplierOrAgent)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

