/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/engine-client): A single endpoint to retrieve whitelabel + customization information for the booking engine.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Booking Engine API Welcome to the Booking Engine API - A programmer-friendly way to book inventory that was found on our platform. This API lets you:  1. Shopping Cart: Manage shopping cart. 2. Checkout: Move shopping cart items through the reactive workflow. 3. Booking: Move selected inventory through to booking completion. 4. Review: Leave a review after a completed stay.  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.14.5
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.booking.model.BedroomConfigurationBooker;
import travel.wink.sdk.booking.model.CancellationPolicyBooker;
import travel.wink.sdk.booking.model.CustomMonetaryAmount;
import travel.wink.sdk.booking.model.ExtraChargesBooker;
import travel.wink.sdk.booking.model.GuestRoomLightweightBooker;
import travel.wink.sdk.booking.model.PropertyPolicyBooker;
import travel.wink.sdk.booking.model.RoomConfigurationPriceRatePlanBooker;
import travel.wink.sdk.booking.model.StayRateBooker;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * All information about the room that was booked.
 */
@JsonPropertyOrder({
  RoomStayBooker.JSON_PROPERTY_POLICY,
  RoomStayBooker.JSON_PROPERTY_ROOM,
  RoomStayBooker.JSON_PROPERTY_ROOMS,
  RoomStayBooker.JSON_PROPERTY_BEDROOM_CONFIGURATION,
  RoomStayBooker.JSON_PROPERTY_ADULTS,
  RoomStayBooker.JSON_PROPERTY_CHILDREN,
  RoomStayBooker.JSON_PROPERTY_START_DATE,
  RoomStayBooker.JSON_PROPERTY_END_DATE,
  RoomStayBooker.JSON_PROPERTY_PRICE,
  RoomStayBooker.JSON_PROPERTY_ROOM_RATE_IDENTIFIER,
  RoomStayBooker.JSON_PROPERTY_ROOM_RATE_INTERNAL_NAME,
  RoomStayBooker.JSON_PROPERTY_RATE_PLAN,
  RoomStayBooker.JSON_PROPERTY_PERK_TYPES,
  RoomStayBooker.JSON_PROPERTY_EXTRA_CHARGES,
  RoomStayBooker.JSON_PROPERTY_ACTIVE_CANCELLATION_POLICY,
  RoomStayBooker.JSON_PROPERTY_CANCELLABLE_BY_HOTEL,
  RoomStayBooker.JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGE,
  RoomStayBooker.JSON_PROPERTY_CANCELLABLE,
  RoomStayBooker.JSON_PROPERTY_ROOM_NIGHTS,
  RoomStayBooker.JSON_PROPERTY_SOURCE_TOTAL,
  RoomStayBooker.JSON_PROPERTY_INTERNAL_TOTAL,
  RoomStayBooker.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL,
  RoomStayBooker.JSON_PROPERTY_RATE_SOURCE,
  RoomStayBooker.JSON_PROPERTY_GUESTS
})
@JsonTypeName("RoomStay_Booker")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-03-04T20:46:30.066932548+07:00[Asia/Bangkok]")
public class RoomStayBooker {
  public static final String JSON_PROPERTY_POLICY = "policy";
  private PropertyPolicyBooker policy;

  public static final String JSON_PROPERTY_ROOM = "room";
  private GuestRoomLightweightBooker room;

  public static final String JSON_PROPERTY_ROOMS = "rooms";
  private Integer rooms = 1;

  public static final String JSON_PROPERTY_BEDROOM_CONFIGURATION = "bedroomConfiguration";
  private BedroomConfigurationBooker bedroomConfiguration;

  public static final String JSON_PROPERTY_ADULTS = "adults";
  private Integer adults = 2;

  public static final String JSON_PROPERTY_CHILDREN = "children";
  private Integer children = 0;

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  private LocalDate startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  private LocalDate endDate;

  public static final String JSON_PROPERTY_PRICE = "price";
  private StayRateBooker price;

  public static final String JSON_PROPERTY_ROOM_RATE_IDENTIFIER = "roomRateIdentifier";
  private UUID roomRateIdentifier;

  public static final String JSON_PROPERTY_ROOM_RATE_INTERNAL_NAME = "roomRateInternalName";
  private String roomRateInternalName;

  public static final String JSON_PROPERTY_RATE_PLAN = "ratePlan";
  private RoomConfigurationPriceRatePlanBooker ratePlan;

  /**
   * List of perks that came with the master rate
   */
  public enum PerkTypesEnum {
    LOYALTY_POINTS("PERK_LOYALTY_POINTS"),
    
    WINE("PERK_WINE"),
    
    FREE_DRINK_VOUCHER("PERK_FREE_DRINK_VOUCHER"),
    
    FREE_MEAL_TWO_PEOPLE("PERK_FREE_MEAL_TWO_PEOPLE"),
    
    FREE_LUNCH_TWO_PEOPLE("PERK_FREE_LUNCH_TWO_PEOPLE"),
    
    FREE_ONE_HOUR_MASSAGE("PERK_FREE_ONE_HOUR_MASSAGE"),
    
    FREE_ONE_HOUR_MASSAGE_TWO_PAX("PERK_FREE_ONE_HOUR_MASSAGE_TWO_PAX"),
    
    TWENTY_PERCENT_FOOD_BEVERAGE_DISCOUNT("PERK_TWENTY_PERCENT_FOOD_BEVERAGE_DISCOUNT"),
    
    TEN_PERCENT_FOOD_BEVERAGE_DISCOUNT("PERK_TEN_PERCENT_FOOD_BEVERAGE_DISCOUNT"),
    
    TWENTY_PERCENT_SPA_DISCOUNT_VOUCHER("PERK_TWENTY_PERCENT_SPA_DISCOUNT_VOUCHER"),
    
    TEN_PERCENT_SPA_DISCOUNT_VOUCHER("PERK_TEN_PERCENT_SPA_DISCOUNT_VOUCHER"),
    
    GUARANTEED_UPGRADE("PERK_GUARANTEED_UPGRADE"),
    
    EARLY_CHECKIN("PERK_EARLY_CHECKIN"),
    
    ROOM_UPGRADE("PERK_ROOM_UPGRADE"),
    
    LATE_CHECKOUT("PERK_LATE_CHECKOUT"),
    
    AIRPORT_TRANSFER("PERK_AIRPORT_TRANSFER"),
    
    AIRPORT_PICK_UP("PERK_AIRPORT_PICK_UP"),
    
    BOTTLE_CHAMPAGNE_ON_ARRIVAL("PERK_BOTTLE_CHAMPAGNE_ON_ARRIVAL"),
    
    BOTTLE_SPARKLING_WINE_ON_ARRIVAL("PERK_BOTTLE_SPARKLING_WINE_ON_ARRIVAL"),
    
    BOTTLE_WINE_ON_ARRIVAL("PERK_BOTTLE_WINE_ON_ARRIVAL"),
    
    HOTEL_CREDIT_FIVE("PERK_HOTEL_CREDIT_FIVE"),
    
    HOTEL_CREDIT_TEN("PERK_HOTEL_CREDIT_TEN"),
    
    HOTEL_CREDIT_TWELVE("PERK_HOTEL_CREDIT_TWELVE"),
    
    HOTEL_CREDIT_FIFTEEN("PERK_HOTEL_CREDIT_FIFTEEN"),
    
    HOTEL_CREDIT_TWENTY("PERK_HOTEL_CREDIT_TWENTY"),
    
    HOTEL_CREDIT_TWENTY_FIVE("PERK_HOTEL_CREDIT_TWENTY_FIVE"),
    
    SPA_CREDIT_FIVE("PERK_SPA_CREDIT_FIVE"),
    
    SPA_CREDIT_TEN("PERK_SPA_CREDIT_TEN"),
    
    SPA_CREDIT_FIFTEEN("PERK_SPA_CREDIT_FIFTEEN"),
    
    SPA_CREDIT_TWENTY("PERK_SPA_CREDIT_TWENTY"),
    
    SPA_CREDIT_TWENTY_FIVE("PERK_SPA_CREDIT_TWENTY_FIVE"),
    
    AFTERNOON_TEA_SET("PERK_AFTERNOON_TEA_SET"),
    
    MEAL_VOUCHER_FIFTEEN("PERK_MEAL_VOUCHER_FIFTEEN"),
    
    LOUNGE_ACCESS("PERK_LOUNGE_ACCESS"),
    
    SHUTTLE_BUS("PERK_SHUTTLE_BUS");

    private String value;

    PerkTypesEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PerkTypesEnum fromValue(String value) {
      for (PerkTypesEnum b : PerkTypesEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PERK_TYPES = "perkTypes";
  private List<PerkTypesEnum> perkTypes;

  public static final String JSON_PROPERTY_EXTRA_CHARGES = "extraCharges";
  private ExtraChargesBooker extraCharges;

  public static final String JSON_PROPERTY_ACTIVE_CANCELLATION_POLICY = "activeCancellationPolicy";
  private CancellationPolicyBooker activeCancellationPolicy;

  public static final String JSON_PROPERTY_CANCELLABLE_BY_HOTEL = "cancellableByHotel";
  private Boolean cancellableByHotel;

  public static final String JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGE = "cancellableWithPotentialCharge";
  private Boolean cancellableWithPotentialCharge;

  public static final String JSON_PROPERTY_CANCELLABLE = "cancellable";
  private Boolean cancellable;

  public static final String JSON_PROPERTY_ROOM_NIGHTS = "roomNights";
  private Long roomNights;

  public static final String JSON_PROPERTY_SOURCE_TOTAL = "sourceTotal";
  private CustomMonetaryAmount sourceTotal;

  public static final String JSON_PROPERTY_INTERNAL_TOTAL = "internalTotal";
  private CustomMonetaryAmount internalTotal;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL = "userSpecifiedCurrencyTotal";
  private CustomMonetaryAmount userSpecifiedCurrencyTotal;

  public static final String JSON_PROPERTY_RATE_SOURCE = "rateSource";
  private String rateSource;

  public static final String JSON_PROPERTY_GUESTS = "guests";
  private Integer guests;

  public RoomStayBooker() {
  }

  public RoomStayBooker policy(PropertyPolicyBooker policy) {
    
    this.policy = policy;
    return this;
  }

   /**
   * Get policy
   * @return policy
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PropertyPolicyBooker getPolicy() {
    return policy;
  }


  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPolicy(PropertyPolicyBooker policy) {
    this.policy = policy;
  }


  public RoomStayBooker room(GuestRoomLightweightBooker room) {
    
    this.room = room;
    return this;
  }

   /**
   * Get room
   * @return room
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ROOM)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public GuestRoomLightweightBooker getRoom() {
    return room;
  }


  @JsonProperty(JSON_PROPERTY_ROOM)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoom(GuestRoomLightweightBooker room) {
    this.room = room;
  }


  public RoomStayBooker rooms(Integer rooms) {
    
    this.rooms = rooms;
    return this;
  }

   /**
   * Number of rooms. Always 1 since we switched to creating one booking per room.
   * @return rooms
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ROOMS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getRooms() {
    return rooms;
  }


  @JsonProperty(JSON_PROPERTY_ROOMS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRooms(Integer rooms) {
    this.rooms = rooms;
  }


  public RoomStayBooker bedroomConfiguration(BedroomConfigurationBooker bedroomConfiguration) {
    
    this.bedroomConfiguration = bedroomConfiguration;
    return this;
  }

   /**
   * Get bedroomConfiguration
   * @return bedroomConfiguration
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_BEDROOM_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BedroomConfigurationBooker getBedroomConfiguration() {
    return bedroomConfiguration;
  }


  @JsonProperty(JSON_PROPERTY_BEDROOM_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBedroomConfiguration(BedroomConfigurationBooker bedroomConfiguration) {
    this.bedroomConfiguration = bedroomConfiguration;
  }


  public RoomStayBooker adults(Integer adults) {
    
    this.adults = adults;
    return this;
  }

   /**
   * The actual amount of adults as determined by the hotel&#39;s policy.
   * @return adults
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ADULTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getAdults() {
    return adults;
  }


  @JsonProperty(JSON_PROPERTY_ADULTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAdults(Integer adults) {
    this.adults = adults;
  }


  public RoomStayBooker children(Integer children) {
    
    this.children = children;
    return this;
  }

   /**
   * The actual amount of children as determined by the hotel&#39;s policy.
   * @return children
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getChildren() {
    return children;
  }


  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setChildren(Integer children) {
    this.children = children;
  }


  public RoomStayBooker startDate(LocalDate startDate) {
    
    this.startDate = startDate;
    return this;
  }

   /**
   * Stay start date
   * @return startDate
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStartDate(LocalDate startDate) {
    this.startDate = startDate;
  }


  public RoomStayBooker endDate(LocalDate endDate) {
    
    this.endDate = endDate;
    return this;
  }

   /**
   * Stay end date
   * @return endDate
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEndDate(LocalDate endDate) {
    this.endDate = endDate;
  }


  public RoomStayBooker price(StayRateBooker price) {
    
    this.price = price;
    return this;
  }

   /**
   * Get price
   * @return price
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public StayRateBooker getPrice() {
    return price;
  }


  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPrice(StayRateBooker price) {
    this.price = price;
  }


  public RoomStayBooker roomRateIdentifier(UUID roomRateIdentifier) {
    
    this.roomRateIdentifier = roomRateIdentifier;
    return this;
  }

   /**
   * Master rate identifier
   * @return roomRateIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ROOM_RATE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getRoomRateIdentifier() {
    return roomRateIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_RATE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomRateIdentifier(UUID roomRateIdentifier) {
    this.roomRateIdentifier = roomRateIdentifier;
  }


  public RoomStayBooker roomRateInternalName(String roomRateInternalName) {
    
    this.roomRateInternalName = roomRateInternalName;
    return this;
  }

   /**
   * Master rate internal name
   * @return roomRateInternalName
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ROOM_RATE_INTERNAL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRoomRateInternalName() {
    return roomRateInternalName;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_RATE_INTERNAL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomRateInternalName(String roomRateInternalName) {
    this.roomRateInternalName = roomRateInternalName;
  }


  public RoomStayBooker ratePlan(RoomConfigurationPriceRatePlanBooker ratePlan) {
    
    this.ratePlan = ratePlan;
    return this;
  }

   /**
   * Get ratePlan
   * @return ratePlan
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_RATE_PLAN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public RoomConfigurationPriceRatePlanBooker getRatePlan() {
    return ratePlan;
  }


  @JsonProperty(JSON_PROPERTY_RATE_PLAN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRatePlan(RoomConfigurationPriceRatePlanBooker ratePlan) {
    this.ratePlan = ratePlan;
  }


  public RoomStayBooker perkTypes(List<PerkTypesEnum> perkTypes) {
    
    this.perkTypes = perkTypes;
    return this;
  }

  public RoomStayBooker addPerkTypesItem(PerkTypesEnum perkTypesItem) {
    if (this.perkTypes == null) {
      this.perkTypes = new ArrayList<>();
    }
    this.perkTypes.add(perkTypesItem);
    return this;
  }

   /**
   * List of perks that came with the master rate
   * @return perkTypes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PERK_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<PerkTypesEnum> getPerkTypes() {
    return perkTypes;
  }


  @JsonProperty(JSON_PROPERTY_PERK_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPerkTypes(List<PerkTypesEnum> perkTypes) {
    this.perkTypes = perkTypes;
  }


  public RoomStayBooker extraCharges(ExtraChargesBooker extraCharges) {
    
    this.extraCharges = extraCharges;
    return this;
  }

   /**
   * Get extraCharges
   * @return extraCharges
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_EXTRA_CHARGES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ExtraChargesBooker getExtraCharges() {
    return extraCharges;
  }


  @JsonProperty(JSON_PROPERTY_EXTRA_CHARGES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setExtraCharges(ExtraChargesBooker extraCharges) {
    this.extraCharges = extraCharges;
  }


  public RoomStayBooker activeCancellationPolicy(CancellationPolicyBooker activeCancellationPolicy) {
    
    this.activeCancellationPolicy = activeCancellationPolicy;
    return this;
  }

   /**
   * Get activeCancellationPolicy
   * @return activeCancellationPolicy
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ACTIVE_CANCELLATION_POLICY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CancellationPolicyBooker getActiveCancellationPolicy() {
    return activeCancellationPolicy;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVE_CANCELLATION_POLICY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setActiveCancellationPolicy(CancellationPolicyBooker activeCancellationPolicy) {
    this.activeCancellationPolicy = activeCancellationPolicy;
  }


  public RoomStayBooker cancellableByHotel(Boolean cancellableByHotel) {
    
    this.cancellableByHotel = cancellableByHotel;
    return this;
  }

   /**
   * Get cancellableByHotel
   * @return cancellableByHotel
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_HOTEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableByHotel() {
    return cancellableByHotel;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_HOTEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableByHotel(Boolean cancellableByHotel) {
    this.cancellableByHotel = cancellableByHotel;
  }


  public RoomStayBooker cancellableWithPotentialCharge(Boolean cancellableWithPotentialCharge) {
    
    this.cancellableWithPotentialCharge = cancellableWithPotentialCharge;
    return this;
  }

   /**
   * Get cancellableWithPotentialCharge
   * @return cancellableWithPotentialCharge
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableWithPotentialCharge() {
    return cancellableWithPotentialCharge;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableWithPotentialCharge(Boolean cancellableWithPotentialCharge) {
    this.cancellableWithPotentialCharge = cancellableWithPotentialCharge;
  }


  public RoomStayBooker cancellable(Boolean cancellable) {
    
    this.cancellable = cancellable;
    return this;
  }

   /**
   * Get cancellable
   * @return cancellable
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellable() {
    return cancellable;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellable(Boolean cancellable) {
    this.cancellable = cancellable;
  }


  public RoomStayBooker roomNights(Long roomNights) {
    
    this.roomNights = roomNights;
    return this;
  }

   /**
   * Total number of nights the guest stays at the hotel. -1 indicates there is an error.
   * @return roomNights
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getRoomNights() {
    return roomNights;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomNights(Long roomNights) {
    this.roomNights = roomNights;
  }


  public RoomStayBooker sourceTotal(CustomMonetaryAmount sourceTotal) {
    
    this.sourceTotal = sourceTotal;
    return this;
  }

   /**
   * Get sourceTotal
   * @return sourceTotal
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getSourceTotal() {
    return sourceTotal;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceTotal(CustomMonetaryAmount sourceTotal) {
    this.sourceTotal = sourceTotal;
  }


  public RoomStayBooker internalTotal(CustomMonetaryAmount internalTotal) {
    
    this.internalTotal = internalTotal;
    return this;
  }

   /**
   * Get internalTotal
   * @return internalTotal
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getInternalTotal() {
    return internalTotal;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalTotal(CustomMonetaryAmount internalTotal) {
    this.internalTotal = internalTotal;
  }


  public RoomStayBooker userSpecifiedCurrencyTotal(CustomMonetaryAmount userSpecifiedCurrencyTotal) {
    
    this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
    return this;
  }

   /**
   * Get userSpecifiedCurrencyTotal
   * @return userSpecifiedCurrencyTotal
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getUserSpecifiedCurrencyTotal() {
    return userSpecifiedCurrencyTotal;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyTotal(CustomMonetaryAmount userSpecifiedCurrencyTotal) {
    this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
  }


  public RoomStayBooker rateSource(String rateSource) {
    
    this.rateSource = rateSource;
    return this;
  }

   /**
   * Get rateSource
   * @return rateSource
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RATE_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRateSource() {
    return rateSource;
  }


  @JsonProperty(JSON_PROPERTY_RATE_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRateSource(String rateSource) {
    this.rateSource = rateSource;
  }


  public RoomStayBooker guests(Integer guests) {
    
    this.guests = guests;
    return this;
  }

   /**
   * Get guests
   * @return guests
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GUESTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getGuests() {
    return guests;
  }


  @JsonProperty(JSON_PROPERTY_GUESTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGuests(Integer guests) {
    this.guests = guests;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RoomStayBooker roomStayBooker = (RoomStayBooker) o;
    return Objects.equals(this.policy, roomStayBooker.policy) &&
        Objects.equals(this.room, roomStayBooker.room) &&
        Objects.equals(this.rooms, roomStayBooker.rooms) &&
        Objects.equals(this.bedroomConfiguration, roomStayBooker.bedroomConfiguration) &&
        Objects.equals(this.adults, roomStayBooker.adults) &&
        Objects.equals(this.children, roomStayBooker.children) &&
        Objects.equals(this.startDate, roomStayBooker.startDate) &&
        Objects.equals(this.endDate, roomStayBooker.endDate) &&
        Objects.equals(this.price, roomStayBooker.price) &&
        Objects.equals(this.roomRateIdentifier, roomStayBooker.roomRateIdentifier) &&
        Objects.equals(this.roomRateInternalName, roomStayBooker.roomRateInternalName) &&
        Objects.equals(this.ratePlan, roomStayBooker.ratePlan) &&
        Objects.equals(this.perkTypes, roomStayBooker.perkTypes) &&
        Objects.equals(this.extraCharges, roomStayBooker.extraCharges) &&
        Objects.equals(this.activeCancellationPolicy, roomStayBooker.activeCancellationPolicy) &&
        Objects.equals(this.cancellableByHotel, roomStayBooker.cancellableByHotel) &&
        Objects.equals(this.cancellableWithPotentialCharge, roomStayBooker.cancellableWithPotentialCharge) &&
        Objects.equals(this.cancellable, roomStayBooker.cancellable) &&
        Objects.equals(this.roomNights, roomStayBooker.roomNights) &&
        Objects.equals(this.sourceTotal, roomStayBooker.sourceTotal) &&
        Objects.equals(this.internalTotal, roomStayBooker.internalTotal) &&
        Objects.equals(this.userSpecifiedCurrencyTotal, roomStayBooker.userSpecifiedCurrencyTotal) &&
        Objects.equals(this.rateSource, roomStayBooker.rateSource) &&
        Objects.equals(this.guests, roomStayBooker.guests);
  }

  @Override
  public int hashCode() {
    return Objects.hash(policy, room, rooms, bedroomConfiguration, adults, children, startDate, endDate, price, roomRateIdentifier, roomRateInternalName, ratePlan, perkTypes, extraCharges, activeCancellationPolicy, cancellableByHotel, cancellableWithPotentialCharge, cancellable, roomNights, sourceTotal, internalTotal, userSpecifiedCurrencyTotal, rateSource, guests);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RoomStayBooker {\n");
    sb.append("    policy: ").append(toIndentedString(policy)).append("\n");
    sb.append("    room: ").append(toIndentedString(room)).append("\n");
    sb.append("    rooms: ").append(toIndentedString(rooms)).append("\n");
    sb.append("    bedroomConfiguration: ").append(toIndentedString(bedroomConfiguration)).append("\n");
    sb.append("    adults: ").append(toIndentedString(adults)).append("\n");
    sb.append("    children: ").append(toIndentedString(children)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    roomRateIdentifier: ").append(toIndentedString(roomRateIdentifier)).append("\n");
    sb.append("    roomRateInternalName: ").append(toIndentedString(roomRateInternalName)).append("\n");
    sb.append("    ratePlan: ").append(toIndentedString(ratePlan)).append("\n");
    sb.append("    perkTypes: ").append(toIndentedString(perkTypes)).append("\n");
    sb.append("    extraCharges: ").append(toIndentedString(extraCharges)).append("\n");
    sb.append("    activeCancellationPolicy: ").append(toIndentedString(activeCancellationPolicy)).append("\n");
    sb.append("    cancellableByHotel: ").append(toIndentedString(cancellableByHotel)).append("\n");
    sb.append("    cancellableWithPotentialCharge: ").append(toIndentedString(cancellableWithPotentialCharge)).append("\n");
    sb.append("    cancellable: ").append(toIndentedString(cancellable)).append("\n");
    sb.append("    roomNights: ").append(toIndentedString(roomNights)).append("\n");
    sb.append("    sourceTotal: ").append(toIndentedString(sourceTotal)).append("\n");
    sb.append("    internalTotal: ").append(toIndentedString(internalTotal)).append("\n");
    sb.append("    userSpecifiedCurrencyTotal: ").append(toIndentedString(userSpecifiedCurrencyTotal)).append("\n");
    sb.append("    rateSource: ").append(toIndentedString(rateSource)).append("\n");
    sb.append("    guests: ").append(toIndentedString(guests)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

