package travel.wink.sdk.booking.api;

import travel.wink.sdk.booking.invoker.ApiClient;

import travel.wink.sdk.booking.model.CheckoutRequestAuthenticatedEntity;
import travel.wink.sdk.booking.model.CheckoutResponseAuthenticatedEntity;
import travel.wink.sdk.booking.model.CreateCart400Response;
import travel.wink.sdk.booking.model.GenericErrorMessage;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Arrays;
import java.util.stream.Collectors;

import jakarta.validation.constraints.*;
import jakarta.validation.Valid;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:16:53.154776164+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class CheckoutApi {
    private ApiClient apiClient;

    public CheckoutApi() {
        this(new ApiClient());
    }

    @Autowired
    public CheckoutApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    
    /**
     * Prepare reactive
     * Communicates shopping cart to TripPay.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param checkoutRequestAuthenticatedEntity The checkoutRequestAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return CheckoutResponseAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec checkoutRequestCreation(@jakarta.annotation.Nonnull CheckoutRequestAuthenticatedEntity checkoutRequestAuthenticatedEntity, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = checkoutRequestAuthenticatedEntity;
        // verify the required parameter 'checkoutRequestAuthenticatedEntity' is set
        if (checkoutRequestAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'checkoutRequestAuthenticatedEntity' when calling checkout", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CheckoutResponseAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<CheckoutResponseAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/checkout", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Prepare reactive
     * Communicates shopping cart to TripPay.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param checkoutRequestAuthenticatedEntity The checkoutRequestAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return CheckoutResponseAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CheckoutResponseAuthenticatedEntity> checkout(@jakarta.annotation.Nonnull CheckoutRequestAuthenticatedEntity checkoutRequestAuthenticatedEntity, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CheckoutResponseAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<CheckoutResponseAuthenticatedEntity>() {};
        return checkoutRequestCreation(checkoutRequestAuthenticatedEntity, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Prepare reactive
     * Communicates shopping cart to TripPay.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param checkoutRequestAuthenticatedEntity The checkoutRequestAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;CheckoutResponseAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<CheckoutResponseAuthenticatedEntity>> checkoutWithHttpInfo(@jakarta.annotation.Nonnull CheckoutRequestAuthenticatedEntity checkoutRequestAuthenticatedEntity, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CheckoutResponseAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<CheckoutResponseAuthenticatedEntity>() {};
        return checkoutRequestCreation(checkoutRequestAuthenticatedEntity, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Prepare reactive
     * Communicates shopping cart to TripPay.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param checkoutRequestAuthenticatedEntity The checkoutRequestAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec checkoutWithResponseSpec(@jakarta.annotation.Nonnull CheckoutRequestAuthenticatedEntity checkoutRequestAuthenticatedEntity, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return checkoutRequestCreation(checkoutRequestAuthenticatedEntity, winkVersion);
    }
}
