/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/customization-client): A single endpoint to retrieve whitelabel + customization information for the booking customization.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Booking Engine API Welcome to the Booking Engine API - A programmer-friendly way to book inventory that was found on our platform. This API lets you:  1. Shopping Cart: Manage shopping cart. 2. Checkout: Move shopping cart items through the reactive workflow. 3. Booking: Move selected inventory through to booking completion. 4. Review: Leave a review after a completed stay.  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.17.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.booking.model.CustomizationThemeColorsBooker;
import travel.wink.sdk.booking.model.GeoNameLightweightBooker;
import travel.wink.sdk.booking.model.RoomConfigurationBooker;
import travel.wink.sdk.booking.model.SimpleMultimediaBooker;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * CustomizationLightweightBooker
 */
@JsonPropertyOrder({
  CustomizationLightweightBooker.JSON_PROPERTY_IDENTIFIER,
  CustomizationLightweightBooker.JSON_PROPERTY_NAME,
  CustomizationLightweightBooker.JSON_PROPERTY_USER_IDENTIFIER,
  CustomizationLightweightBooker.JSON_PROPERTY_OWNER_IDENTIFIER,
  CustomizationLightweightBooker.JSON_PROPERTY_OWNER_NAME,
  CustomizationLightweightBooker.JSON_PROPERTY_SUB_TYPE,
  CustomizationLightweightBooker.JSON_PROPERTY_DEFAULT_CURRENCY,
  CustomizationLightweightBooker.JSON_PROPERTY_DEFAULT_LANGUAGE,
  CustomizationLightweightBooker.JSON_PROPERTY_DEFAULT_LIFESTYLE,
  CustomizationLightweightBooker.JSON_PROPERTY_LOGOS,
  CustomizationLightweightBooker.JSON_PROPERTY_HOSTED_BOOKING_ENGINE_URL,
  CustomizationLightweightBooker.JSON_PROPERTY_SELF_HOSTED,
  CustomizationLightweightBooker.JSON_PROPERTY_THEME_COLORS,
  CustomizationLightweightBooker.JSON_PROPERTY_CARD_LAYOUT,
  CustomizationLightweightBooker.JSON_PROPERTY_LAYOUT,
  CustomizationLightweightBooker.JSON_PROPERTY_CARD_DESIGN,
  CustomizationLightweightBooker.JSON_PROPERTY_NUMBER_OF_ADVANCE_DAYS,
  CustomizationLightweightBooker.JSON_PROPERTY_NUMBER_OF_STAY_DAYS,
  CustomizationLightweightBooker.JSON_PROPERTY_START_DATE,
  CustomizationLightweightBooker.JSON_PROPERTY_END_DATE,
  CustomizationLightweightBooker.JSON_PROPERTY_ROOM_CONFIGURATIONS,
  CustomizationLightweightBooker.JSON_PROPERTY_USE_DAYS,
  CustomizationLightweightBooker.JSON_PROPERTY_PROMOTIONAL_CODES,
  CustomizationLightweightBooker.JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_PROPERTY,
  CustomizationLightweightBooker.JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_BOOKER,
  CustomizationLightweightBooker.JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_CHANNEL_MANAGER,
  CustomizationLightweightBooker.JSON_PROPERTY_WC_BOOK_CLICK_ACTION,
  CustomizationLightweightBooker.JSON_PROPERTY_CITY,
  CustomizationLightweightBooker.JSON_PROPERTY_SHOW_UNAVAILABLE_CARD,
  CustomizationLightweightBooker.JSON_PROPERTY_SHOW_RANKINGS,
  CustomizationLightweightBooker.JSON_PROPERTY_SHOW_SEARCH
})
@JsonTypeName("CustomizationLightweight_Booker")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:16:53.154776164+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class CustomizationLightweightBooker {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  @jakarta.annotation.Nonnull
  private UUID identifier;

  public static final String JSON_PROPERTY_NAME = "name";
  @jakarta.annotation.Nonnull
  private String name;

  public static final String JSON_PROPERTY_USER_IDENTIFIER = "userIdentifier";
  @jakarta.annotation.Nonnull
  private UUID userIdentifier;

  public static final String JSON_PROPERTY_OWNER_IDENTIFIER = "ownerIdentifier";
  @jakarta.annotation.Nonnull
  private UUID ownerIdentifier;

  public static final String JSON_PROPERTY_OWNER_NAME = "ownerName";
  @jakarta.annotation.Nonnull
  private String ownerName;

  /**
   * Sales channel sub-type.
   */
  public enum SubTypeEnum {
    DIRECT(String.valueOf("DIRECT")),
    
    APPLICATION(String.valueOf("APPLICATION")),
    
    HOTEL(String.valueOf("HOTEL")),
    
    TRAVELIKO(String.valueOf("TRAVELIKO")),
    
    CORPORATE(String.valueOf("CORPORATE")),
    
    TRAVEL_AGENT(String.valueOf("TRAVEL_AGENT")),
    
    INFLUENCER(String.valueOf("INFLUENCER")),
    
    BLOGGER(String.valueOf("BLOGGER")),
    
    DESTINATION(String.valueOf("DESTINATION")),
    
    CHANNEL_MANAGER(String.valueOf("CHANNEL_MANAGER")),
    
    PROPERTY_MANAGEMENT_SYSTEM(String.valueOf("PROPERTY_MANAGEMENT_SYSTEM")),
    
    CENTRAL_RESERVATION_SYSTEM(String.valueOf("CENTRAL_RESERVATION_SYSTEM")),
    
    GOOGLE_HOTEL_API(String.valueOf("GOOGLE_HOTEL_API")),
    
    MANAGEMENT_COMPANY(String.valueOf("MANAGEMENT_COMPANY")),
    
    CHAIN(String.valueOf("CHAIN")),
    
    BRAND(String.valueOf("BRAND")),
    
    EVENT_ORGANIZER(String.valueOf("EVENT_ORGANIZER"));

    private String value;

    SubTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SubTypeEnum fromValue(String value) {
      for (SubTypeEnum b : SubTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SUB_TYPE = "subType";
  @jakarta.annotation.Nonnull
  private SubTypeEnum subType;

  public static final String JSON_PROPERTY_DEFAULT_CURRENCY = "defaultCurrency";
  @jakarta.annotation.Nullable
  private String defaultCurrency = "USD";

  public static final String JSON_PROPERTY_DEFAULT_LANGUAGE = "defaultLanguage";
  @jakarta.annotation.Nullable
  private String defaultLanguage = "en";

  /**
   * Control which lifestyle contextx your users see initially.
   */
  public enum DefaultLifestyleEnum {
    LIFESTYLE_HEALTH_FITNESS(String.valueOf("LIFESTYLE_HEALTH_FITNESS")),
    
    LIFESTYLE_RELAX(String.valueOf("LIFESTYLE_RELAX")),
    
    LIFESTYLE_ADULT_ONLY(String.valueOf("LIFESTYLE_ADULT_ONLY")),
    
    LIFESTYLE_ADVENTURE(String.valueOf("LIFESTYLE_ADVENTURE")),
    
    LIFESTYLE_BUSINESS(String.valueOf("LIFESTYLE_BUSINESS")),
    
    LIFESTYLE_LGBT(String.valueOf("LIFESTYLE_LGBT")),
    
    LIFESTYLE_SINGLE_PARENT(String.valueOf("LIFESTYLE_SINGLE_PARENT")),
    
    LIFESTYLE_SOLO_FEMALE(String.valueOf("LIFESTYLE_SOLO_FEMALE")),
    
    LIFESTYLE_BEAUTY(String.valueOf("LIFESTYLE_BEAUTY")),
    
    LIFESTYLE_FOODIE(String.valueOf("LIFESTYLE_FOODIE")),
    
    LIFESTYLE_FAMILY(String.valueOf("LIFESTYLE_FAMILY")),
    
    LIFESTYLE_ROMANCE(String.valueOf("LIFESTYLE_ROMANCE")),
    
    LIFESTYLE_COUPLE(String.valueOf("LIFESTYLE_COUPLE")),
    
    LIFESTYLE_SOLO(String.valueOf("LIFESTYLE_SOLO")),
    
    LIFESTYLE_BACKPACKER(String.valueOf("LIFESTYLE_BACKPACKER")),
    
    LIFESTYLE_SHOPPING(String.valueOf("LIFESTYLE_SHOPPING")),
    
    LIFESTYLE_SPORTS(String.valueOf("LIFESTYLE_SPORTS")),
    
    LIFESTYLE_MOUNTAIN(String.valueOf("LIFESTYLE_MOUNTAIN")),
    
    LIFESTYLE_BEACH(String.valueOf("LIFESTYLE_BEACH")),
    
    LIFESTYLE_CITY(String.valueOf("LIFESTYLE_CITY")),
    
    LIFESTYLE_COUNTRY(String.valueOf("LIFESTYLE_COUNTRY")),
    
    LIFESTYLE_CULTURE(String.valueOf("LIFESTYLE_CULTURE")),
    
    LIFESTYLE_ECO(String.valueOf("LIFESTYLE_ECO"));

    private String value;

    DefaultLifestyleEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DefaultLifestyleEnum fromValue(String value) {
      for (DefaultLifestyleEnum b : DefaultLifestyleEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_DEFAULT_LIFESTYLE = "defaultLifestyle";
  @jakarta.annotation.Nullable
  private DefaultLifestyleEnum defaultLifestyle;

  public static final String JSON_PROPERTY_LOGOS = "logos";
  @jakarta.annotation.Nullable
  private List<@Valid SimpleMultimediaBooker> logos = new ArrayList<>();

  public static final String JSON_PROPERTY_HOSTED_BOOKING_ENGINE_URL = "hostedBookingEngineUrl";
  @jakarta.annotation.Nullable
  private String hostedBookingEngineUrl = "https://ota.wink.travel";

  public static final String JSON_PROPERTY_SELF_HOSTED = "selfHosted";
  @jakarta.annotation.Nullable
  private Boolean selfHosted = false;

  public static final String JSON_PROPERTY_THEME_COLORS = "themeColors";
  @jakarta.annotation.Nullable
  private CustomizationThemeColorsBooker themeColors;

  /**
   * Choose how you large you want our web component cards to be.
   */
  public enum CardLayoutEnum {
    HORIZONTAL(String.valueOf("HORIZONTAL")),
    
    VERTICAL(String.valueOf("VERTICAL"));

    private String value;

    CardLayoutEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CardLayoutEnum fromValue(String value) {
      for (CardLayoutEnum b : CardLayoutEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CARD_LAYOUT = "cardLayout";
  @jakarta.annotation.Nullable
  private CardLayoutEnum cardLayout = CardLayoutEnum.VERTICAL;

  /**
   * Choose how you want our web component cards laid out.
   */
  public enum LayoutEnum {
    INFORMATIONAL(String.valueOf("INFORMATIONAL")),
    
    TRANSACTIONAL(String.valueOf("TRANSACTIONAL"));

    private String value;

    LayoutEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static LayoutEnum fromValue(String value) {
      for (LayoutEnum b : LayoutEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_LAYOUT = "layout";
  @jakarta.annotation.Nullable
  private LayoutEnum layout = LayoutEnum.INFORMATIONAL;

  /**
   * Choose the card design to use on our web component cards.
   */
  public enum CardDesignEnum {
    DEFAULT(String.valueOf("DEFAULT"));

    private String value;

    CardDesignEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CardDesignEnum fromValue(String value) {
      for (CardDesignEnum b : CardDesignEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CARD_DESIGN = "cardDesign";
  @jakarta.annotation.Nullable
  private CardDesignEnum cardDesign = CardDesignEnum.DEFAULT;

  public static final String JSON_PROPERTY_NUMBER_OF_ADVANCE_DAYS = "numberOfAdvanceDays";
  @jakarta.annotation.Nullable
  private Integer numberOfAdvanceDays;

  public static final String JSON_PROPERTY_NUMBER_OF_STAY_DAYS = "numberOfStayDays";
  @jakarta.annotation.Nullable
  private Integer numberOfStayDays;

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  @jakarta.annotation.Nullable
  private LocalDate startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  @jakarta.annotation.Nullable
  private LocalDate endDate;

  public static final String JSON_PROPERTY_ROOM_CONFIGURATIONS = "roomConfigurations";
  @jakarta.annotation.Nullable
  private List<@Valid RoomConfigurationBooker> roomConfigurations = new ArrayList<>();

  public static final String JSON_PROPERTY_USE_DAYS = "useDays";
  @jakarta.annotation.Nullable
  private Boolean useDays;

  public static final String JSON_PROPERTY_PROMOTIONAL_CODES = "promotionalCodes";
  @jakarta.annotation.Nullable
  private List<String> promotionalCodes = new ArrayList<>();

  public static final String JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_PROPERTY = "sendBookingNotificationEmailsToProperty";
  @jakarta.annotation.Nullable
  private Boolean sendBookingNotificationEmailsToProperty = true;

  public static final String JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_BOOKER = "sendBookingNotificationEmailsToBooker";
  @jakarta.annotation.Nullable
  private Boolean sendBookingNotificationEmailsToBooker = true;

  public static final String JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_CHANNEL_MANAGER = "sendBookingNotificationEmailsToChannelManager";
  @jakarta.annotation.Nullable
  private Boolean sendBookingNotificationEmailsToChannelManager = true;

  /**
   * Action to complete once a user clicks on the CTA button on blocking.
   */
  public enum WcBookClickActionEnum {
    FORWARD_TO_IBE(String.valueOf("FORWARD_TO_IBE")),
    
    IBE_MODAL(String.valueOf("IBE_MODAL"));

    private String value;

    WcBookClickActionEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static WcBookClickActionEnum fromValue(String value) {
      for (WcBookClickActionEnum b : WcBookClickActionEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_WC_BOOK_CLICK_ACTION = "wcBookClickAction";
  @jakarta.annotation.Nullable
  private WcBookClickActionEnum wcBookClickAction;

  public static final String JSON_PROPERTY_CITY = "city";
  @jakarta.annotation.Nullable
  private GeoNameLightweightBooker city;

  public static final String JSON_PROPERTY_SHOW_UNAVAILABLE_CARD = "showUnavailableCard";
  @jakarta.annotation.Nullable
  private Boolean showUnavailableCard;

  public static final String JSON_PROPERTY_SHOW_RANKINGS = "showRankings";
  @jakarta.annotation.Nullable
  private Boolean showRankings;

  public static final String JSON_PROPERTY_SHOW_SEARCH = "showSearch";
  @jakarta.annotation.Nullable
  private Boolean showSearch;

  public CustomizationLightweightBooker() {
  }

  public CustomizationLightweightBooker identifier(@jakarta.annotation.Nonnull UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

  /**
   * Unique customization configuration identifier
   * @return identifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(@jakarta.annotation.Nonnull UUID identifier) {
    this.identifier = identifier;
  }

  public CustomizationLightweightBooker name(@jakarta.annotation.Nonnull String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Engine configuration name
   * @return name
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(@jakarta.annotation.Nonnull String name) {
    this.name = name;
  }

  public CustomizationLightweightBooker userIdentifier(@jakarta.annotation.Nonnull UUID userIdentifier) {
    
    this.userIdentifier = userIdentifier;
    return this;
  }

  /**
   * Authenticated user identifier
   * @return userIdentifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getUserIdentifier() {
    return userIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUserIdentifier(@jakarta.annotation.Nonnull UUID userIdentifier) {
    this.userIdentifier = userIdentifier;
  }

  public CustomizationLightweightBooker ownerIdentifier(@jakarta.annotation.Nonnull UUID ownerIdentifier) {
    
    this.ownerIdentifier = ownerIdentifier;
    return this;
  }

  /**
   * Engine configuration record creator identifier
   * @return ownerIdentifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getOwnerIdentifier() {
    return ownerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOwnerIdentifier(@jakarta.annotation.Nonnull UUID ownerIdentifier) {
    this.ownerIdentifier = ownerIdentifier;
  }

  public CustomizationLightweightBooker ownerName(@jakarta.annotation.Nonnull String ownerName) {
    
    this.ownerName = ownerName;
    return this;
  }

  /**
   * Name of company owner.
   * @return ownerName
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_OWNER_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getOwnerName() {
    return ownerName;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOwnerName(@jakarta.annotation.Nonnull String ownerName) {
    this.ownerName = ownerName;
  }

  public CustomizationLightweightBooker subType(@jakarta.annotation.Nonnull SubTypeEnum subType) {
    
    this.subType = subType;
    return this;
  }

  /**
   * Sales channel sub-type.
   * @return subType
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SUB_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public SubTypeEnum getSubType() {
    return subType;
  }


  @JsonProperty(JSON_PROPERTY_SUB_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSubType(@jakarta.annotation.Nonnull SubTypeEnum subType) {
    this.subType = subType;
  }

  public CustomizationLightweightBooker defaultCurrency(@jakarta.annotation.Nullable String defaultCurrency) {
    
    this.defaultCurrency = defaultCurrency;
    return this;
  }

  /**
   * Control which currency your users see prices in initially.
   * @return defaultCurrency
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DEFAULT_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDefaultCurrency() {
    return defaultCurrency;
  }


  @JsonProperty(JSON_PROPERTY_DEFAULT_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDefaultCurrency(@jakarta.annotation.Nullable String defaultCurrency) {
    this.defaultCurrency = defaultCurrency;
  }

  public CustomizationLightweightBooker defaultLanguage(@jakarta.annotation.Nullable String defaultLanguage) {
    
    this.defaultLanguage = defaultLanguage;
    return this;
  }

  /**
   * Control which language your users see text in initially.
   * @return defaultLanguage
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DEFAULT_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDefaultLanguage() {
    return defaultLanguage;
  }


  @JsonProperty(JSON_PROPERTY_DEFAULT_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDefaultLanguage(@jakarta.annotation.Nullable String defaultLanguage) {
    this.defaultLanguage = defaultLanguage;
  }

  public CustomizationLightweightBooker defaultLifestyle(@jakarta.annotation.Nullable DefaultLifestyleEnum defaultLifestyle) {
    
    this.defaultLifestyle = defaultLifestyle;
    return this;
  }

  /**
   * Control which lifestyle contextx your users see initially.
   * @return defaultLifestyle
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DEFAULT_LIFESTYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DefaultLifestyleEnum getDefaultLifestyle() {
    return defaultLifestyle;
  }


  @JsonProperty(JSON_PROPERTY_DEFAULT_LIFESTYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDefaultLifestyle(@jakarta.annotation.Nullable DefaultLifestyleEnum defaultLifestyle) {
    this.defaultLifestyle = defaultLifestyle;
  }

  public CustomizationLightweightBooker logos(@jakarta.annotation.Nullable List<@Valid SimpleMultimediaBooker> logos) {
    
    this.logos = logos;
    return this;
  }

  public CustomizationLightweightBooker addLogosItem(SimpleMultimediaBooker logosItem) {
    if (this.logos == null) {
      this.logos = new ArrayList<>();
    }
    this.logos.add(logosItem);
    return this;
  }

  /**
   * Customize booking confirmation emails by adding a custom logo to your configuration.
   * @return logos
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LOGOS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<@Valid SimpleMultimediaBooker> getLogos() {
    return logos;
  }


  @JsonProperty(JSON_PROPERTY_LOGOS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLogos(@jakarta.annotation.Nullable List<@Valid SimpleMultimediaBooker> logos) {
    this.logos = logos;
  }

  public CustomizationLightweightBooker hostedBookingEngineUrl(@jakarta.annotation.Nullable String hostedBookingEngineUrl) {
    
    this.hostedBookingEngineUrl = hostedBookingEngineUrl;
    return this;
  }

  /**
   * If you are self-hosting our booking customization, let us know where it is hosted. Note: This url needs to be secured with SSL.
   * @return hostedBookingEngineUrl
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HOSTED_BOOKING_ENGINE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHostedBookingEngineUrl() {
    return hostedBookingEngineUrl;
  }


  @JsonProperty(JSON_PROPERTY_HOSTED_BOOKING_ENGINE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHostedBookingEngineUrl(@jakarta.annotation.Nullable String hostedBookingEngineUrl) {
    this.hostedBookingEngineUrl = hostedBookingEngineUrl;
  }

  public CustomizationLightweightBooker selfHosted(@jakarta.annotation.Nullable Boolean selfHosted) {
    
    this.selfHosted = selfHosted;
    return this;
  }

  /**
   * Flag to indicate you are self-hosting our booking customization and not using our default booking customization url.
   * @return selfHosted
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SELF_HOSTED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSelfHosted() {
    return selfHosted;
  }


  @JsonProperty(JSON_PROPERTY_SELF_HOSTED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSelfHosted(@jakarta.annotation.Nullable Boolean selfHosted) {
    this.selfHosted = selfHosted;
  }

  public CustomizationLightweightBooker themeColors(@jakarta.annotation.Nullable CustomizationThemeColorsBooker themeColors) {
    
    this.themeColors = themeColors;
    return this;
  }

  /**
   * Choose how you want our web components to look and more closely match with your own site style.
   * @return themeColors
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_THEME_COLORS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomizationThemeColorsBooker getThemeColors() {
    return themeColors;
  }


  @JsonProperty(JSON_PROPERTY_THEME_COLORS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThemeColors(@jakarta.annotation.Nullable CustomizationThemeColorsBooker themeColors) {
    this.themeColors = themeColors;
  }

  public CustomizationLightweightBooker cardLayout(@jakarta.annotation.Nullable CardLayoutEnum cardLayout) {
    
    this.cardLayout = cardLayout;
    return this;
  }

  /**
   * Choose how you large you want our web component cards to be.
   * @return cardLayout
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CARD_LAYOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CardLayoutEnum getCardLayout() {
    return cardLayout;
  }


  @JsonProperty(JSON_PROPERTY_CARD_LAYOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCardLayout(@jakarta.annotation.Nullable CardLayoutEnum cardLayout) {
    this.cardLayout = cardLayout;
  }

  public CustomizationLightweightBooker layout(@jakarta.annotation.Nullable LayoutEnum layout) {
    
    this.layout = layout;
    return this;
  }

  /**
   * Choose how you want our web component cards laid out.
   * @return layout
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LAYOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LayoutEnum getLayout() {
    return layout;
  }


  @JsonProperty(JSON_PROPERTY_LAYOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLayout(@jakarta.annotation.Nullable LayoutEnum layout) {
    this.layout = layout;
  }

  public CustomizationLightweightBooker cardDesign(@jakarta.annotation.Nullable CardDesignEnum cardDesign) {
    
    this.cardDesign = cardDesign;
    return this;
  }

  /**
   * Choose the card design to use on our web component cards.
   * @return cardDesign
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CARD_DESIGN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CardDesignEnum getCardDesign() {
    return cardDesign;
  }


  @JsonProperty(JSON_PROPERTY_CARD_DESIGN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCardDesign(@jakarta.annotation.Nullable CardDesignEnum cardDesign) {
    this.cardDesign = cardDesign;
  }

  public CustomizationLightweightBooker numberOfAdvanceDays(@jakarta.annotation.Nullable Integer numberOfAdvanceDays) {
    
    this.numberOfAdvanceDays = numberOfAdvanceDays;
    return this;
  }

  /**
   * You can control the initial itinerary date used to retrieve travel blocking prices. You can do it in one of two ways: 1. Dynamically set the date by indicating how long and how many days in advance (this field), of today&#39;s date, you want to display prices for. 2. Set a fixed date to display prices for. Option 1 is the most shared. Option 2 is for when you want to create a new customization and apply it to a specific event that occurs on a specific date. If you don&#39;t use either of these options, the itinerary will default to today&#39;s date with one night stay. ONLY populate this field if you want to control the itinerary date. Also, leave &#x60;startDate&#x60; and &#x60;endDate&#x60; empty.
   * @return numberOfAdvanceDays
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NUMBER_OF_ADVANCE_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getNumberOfAdvanceDays() {
    return numberOfAdvanceDays;
  }


  @JsonProperty(JSON_PROPERTY_NUMBER_OF_ADVANCE_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumberOfAdvanceDays(@jakarta.annotation.Nullable Integer numberOfAdvanceDays) {
    this.numberOfAdvanceDays = numberOfAdvanceDays;
  }

  public CustomizationLightweightBooker numberOfStayDays(@jakarta.annotation.Nullable Integer numberOfStayDays) {
    
    this.numberOfStayDays = numberOfStayDays;
    return this;
  }

  /**
   * You can control the initial itinerary date used to retrieve travel blocking prices. You can do it in one of two ways: 1. Dynamically set the date by indicating how long (this field) and how many days in advance, of today&#39;s date, you want to display prices for. 2. Set a fixed date to display prices for. Option 1 is the most shared. Option 2 is for when you want to create a new customization and apply it to a specific event that occurs on a specific date. If you don&#39;t use either of these options, the itinerary will default to today&#39;s date with one night stay. ONLY populate this field if you want to control the itinerary date. Also, leave &#x60;startDate&#x60; and &#x60;endDate&#x60; empty.
   * @return numberOfStayDays
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NUMBER_OF_STAY_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getNumberOfStayDays() {
    return numberOfStayDays;
  }


  @JsonProperty(JSON_PROPERTY_NUMBER_OF_STAY_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumberOfStayDays(@jakarta.annotation.Nullable Integer numberOfStayDays) {
    this.numberOfStayDays = numberOfStayDays;
  }

  public CustomizationLightweightBooker startDate(@jakarta.annotation.Nullable LocalDate startDate) {
    
    this.startDate = startDate;
    return this;
  }

  /**
   * Set a fixed itinerary start date. ONLY populate this field if you want to fix the itinerary date. Also, leave &#x60;numberOfAdvanceDays&#x60; and &#x60;numberOfStayDays&#x60; empty.
   * @return startDate
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStartDate(@jakarta.annotation.Nullable LocalDate startDate) {
    this.startDate = startDate;
  }

  public CustomizationLightweightBooker endDate(@jakarta.annotation.Nullable LocalDate endDate) {
    
    this.endDate = endDate;
    return this;
  }

  /**
   * Set a fixed itinerary end date ONLY populate this field if you want to fix the itinerary date. Also, leave &#x60;numberOfAdvanceDays&#x60; and &#x60;numberOfStayDays&#x60; empty.
   * @return endDate
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEndDate(@jakarta.annotation.Nullable LocalDate endDate) {
    this.endDate = endDate;
  }

  public CustomizationLightweightBooker roomConfigurations(@jakarta.annotation.Nullable List<@Valid RoomConfigurationBooker> roomConfigurations) {
    
    this.roomConfigurations = roomConfigurations;
    return this;
  }

  public CustomizationLightweightBooker addRoomConfigurationsItem(RoomConfigurationBooker roomConfigurationsItem) {
    if (this.roomConfigurations == null) {
      this.roomConfigurations = new ArrayList<>();
    }
    this.roomConfigurations.add(roomConfigurationsItem);
    return this;
  }

  /**
   * Control how many adults / children will be staying and how many rooms. Defaults to: One room, two adults.
   * @return roomConfigurations
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ROOM_CONFIGURATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<@Valid RoomConfigurationBooker> getRoomConfigurations() {
    return roomConfigurations;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_CONFIGURATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomConfigurations(@jakarta.annotation.Nullable List<@Valid RoomConfigurationBooker> roomConfigurations) {
    this.roomConfigurations = roomConfigurations;
  }

  public CustomizationLightweightBooker useDays(@jakarta.annotation.Nullable Boolean useDays) {
    
    this.useDays = useDays;
    return this;
  }

  /**
   * if true, we use numberOfAdvanceDays / numberOfStayDays properties - false, we use startDate / endDate
   * @return useDays
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_USE_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getUseDays() {
    return useDays;
  }


  @JsonProperty(JSON_PROPERTY_USE_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUseDays(@jakarta.annotation.Nullable Boolean useDays) {
    this.useDays = useDays;
  }

  public CustomizationLightweightBooker promotionalCodes(@jakarta.annotation.Nullable List<String> promotionalCodes) {
    
    this.promotionalCodes = promotionalCodes;
    return this;
  }

  public CustomizationLightweightBooker addPromotionalCodesItem(String promotionalCodesItem) {
    if (this.promotionalCodes == null) {
      this.promotionalCodes = new ArrayList<>();
    }
    this.promotionalCodes.add(promotionalCodesItem);
    return this;
  }

  /**
   * If you&#39;ve received special promotional codes from suppliers to give to your audience, you can choose to bake these code directly into the price by entering them here.
   * @return promotionalCodes
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPromotionalCodes() {
    return promotionalCodes;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotionalCodes(@jakarta.annotation.Nullable List<String> promotionalCodes) {
    this.promotionalCodes = promotionalCodes;
  }

  public CustomizationLightweightBooker sendBookingNotificationEmailsToProperty(@jakarta.annotation.Nullable Boolean sendBookingNotificationEmailsToProperty) {
    
    this.sendBookingNotificationEmailsToProperty = sendBookingNotificationEmailsToProperty;
    return this;
  }

  /**
   * An integrator can choose to disable outgoing emails to properties because they want to do that themselves.
   * @return sendBookingNotificationEmailsToProperty
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_PROPERTY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSendBookingNotificationEmailsToProperty() {
    return sendBookingNotificationEmailsToProperty;
  }


  @JsonProperty(JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_PROPERTY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSendBookingNotificationEmailsToProperty(@jakarta.annotation.Nullable Boolean sendBookingNotificationEmailsToProperty) {
    this.sendBookingNotificationEmailsToProperty = sendBookingNotificationEmailsToProperty;
  }

  public CustomizationLightweightBooker sendBookingNotificationEmailsToBooker(@jakarta.annotation.Nullable Boolean sendBookingNotificationEmailsToBooker) {
    
    this.sendBookingNotificationEmailsToBooker = sendBookingNotificationEmailsToBooker;
    return this;
  }

  /**
   * An integrator can choose to disable outgoing emails to users because they want to do that themselves.
   * @return sendBookingNotificationEmailsToBooker
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_BOOKER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSendBookingNotificationEmailsToBooker() {
    return sendBookingNotificationEmailsToBooker;
  }


  @JsonProperty(JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_BOOKER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSendBookingNotificationEmailsToBooker(@jakarta.annotation.Nullable Boolean sendBookingNotificationEmailsToBooker) {
    this.sendBookingNotificationEmailsToBooker = sendBookingNotificationEmailsToBooker;
  }

  public CustomizationLightweightBooker sendBookingNotificationEmailsToChannelManager(@jakarta.annotation.Nullable Boolean sendBookingNotificationEmailsToChannelManager) {
    
    this.sendBookingNotificationEmailsToChannelManager = sendBookingNotificationEmailsToChannelManager;
    return this;
  }

  /**
   * An integrator can choose to disable notifying the property&#39;s channel manager. Note: This should ONLY be done for testing.
   * @return sendBookingNotificationEmailsToChannelManager
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_CHANNEL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSendBookingNotificationEmailsToChannelManager() {
    return sendBookingNotificationEmailsToChannelManager;
  }


  @JsonProperty(JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_CHANNEL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSendBookingNotificationEmailsToChannelManager(@jakarta.annotation.Nullable Boolean sendBookingNotificationEmailsToChannelManager) {
    this.sendBookingNotificationEmailsToChannelManager = sendBookingNotificationEmailsToChannelManager;
  }

  public CustomizationLightweightBooker wcBookClickAction(@jakarta.annotation.Nullable WcBookClickActionEnum wcBookClickAction) {
    
    this.wcBookClickAction = wcBookClickAction;
    return this;
  }

  /**
   * Action to complete once a user clicks on the CTA button on blocking.
   * @return wcBookClickAction
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_WC_BOOK_CLICK_ACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public WcBookClickActionEnum getWcBookClickAction() {
    return wcBookClickAction;
  }


  @JsonProperty(JSON_PROPERTY_WC_BOOK_CLICK_ACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWcBookClickAction(@jakarta.annotation.Nullable WcBookClickActionEnum wcBookClickAction) {
    this.wcBookClickAction = wcBookClickAction;
  }

  public CustomizationLightweightBooker city(@jakarta.annotation.Nullable GeoNameLightweightBooker city) {
    
    this.city = city;
    return this;
  }

  /**
   * Get city
   * @return city
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GeoNameLightweightBooker getCity() {
    return city;
  }


  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCity(@jakarta.annotation.Nullable GeoNameLightweightBooker city) {
    this.city = city;
  }

  public CustomizationLightweightBooker showUnavailableCard(@jakarta.annotation.Nullable Boolean showUnavailableCard) {
    
    this.showUnavailableCard = showUnavailableCard;
    return this;
  }

  /**
   * Show unavailable blocking card when blocking not currently for sale. Otherwise, it displays a normal card but without the price.
   * @return showUnavailableCard
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SHOW_UNAVAILABLE_CARD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowUnavailableCard() {
    return showUnavailableCard;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_UNAVAILABLE_CARD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowUnavailableCard(@jakarta.annotation.Nullable Boolean showUnavailableCard) {
    this.showUnavailableCard = showUnavailableCard;
  }

  public CustomizationLightweightBooker showRankings(@jakarta.annotation.Nullable Boolean showRankings) {
    
    this.showRankings = showRankings;
    return this;
  }

  /**
   * Whether to display rankings (lifestyle, eco score and reviews) on hotel landing page.
   * @return showRankings
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SHOW_RANKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowRankings() {
    return showRankings;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_RANKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowRankings(@jakarta.annotation.Nullable Boolean showRankings) {
    this.showRankings = showRankings;
  }

  public CustomizationLightweightBooker showSearch(@jakarta.annotation.Nullable Boolean showSearch) {
    
    this.showSearch = showSearch;
    return this;
  }

  /**
   * This feature flag controls whether to let a user move away from the hotel landing page using search.
   * @return showSearch
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SHOW_SEARCH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowSearch() {
    return showSearch;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_SEARCH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowSearch(@jakarta.annotation.Nullable Boolean showSearch) {
    this.showSearch = showSearch;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CustomizationLightweightBooker customizationLightweightBooker = (CustomizationLightweightBooker) o;
    return Objects.equals(this.identifier, customizationLightweightBooker.identifier) &&
        Objects.equals(this.name, customizationLightweightBooker.name) &&
        Objects.equals(this.userIdentifier, customizationLightweightBooker.userIdentifier) &&
        Objects.equals(this.ownerIdentifier, customizationLightweightBooker.ownerIdentifier) &&
        Objects.equals(this.ownerName, customizationLightweightBooker.ownerName) &&
        Objects.equals(this.subType, customizationLightweightBooker.subType) &&
        Objects.equals(this.defaultCurrency, customizationLightweightBooker.defaultCurrency) &&
        Objects.equals(this.defaultLanguage, customizationLightweightBooker.defaultLanguage) &&
        Objects.equals(this.defaultLifestyle, customizationLightweightBooker.defaultLifestyle) &&
        Objects.equals(this.logos, customizationLightweightBooker.logos) &&
        Objects.equals(this.hostedBookingEngineUrl, customizationLightweightBooker.hostedBookingEngineUrl) &&
        Objects.equals(this.selfHosted, customizationLightweightBooker.selfHosted) &&
        Objects.equals(this.themeColors, customizationLightweightBooker.themeColors) &&
        Objects.equals(this.cardLayout, customizationLightweightBooker.cardLayout) &&
        Objects.equals(this.layout, customizationLightweightBooker.layout) &&
        Objects.equals(this.cardDesign, customizationLightweightBooker.cardDesign) &&
        Objects.equals(this.numberOfAdvanceDays, customizationLightweightBooker.numberOfAdvanceDays) &&
        Objects.equals(this.numberOfStayDays, customizationLightweightBooker.numberOfStayDays) &&
        Objects.equals(this.startDate, customizationLightweightBooker.startDate) &&
        Objects.equals(this.endDate, customizationLightweightBooker.endDate) &&
        Objects.equals(this.roomConfigurations, customizationLightweightBooker.roomConfigurations) &&
        Objects.equals(this.useDays, customizationLightweightBooker.useDays) &&
        Objects.equals(this.promotionalCodes, customizationLightweightBooker.promotionalCodes) &&
        Objects.equals(this.sendBookingNotificationEmailsToProperty, customizationLightweightBooker.sendBookingNotificationEmailsToProperty) &&
        Objects.equals(this.sendBookingNotificationEmailsToBooker, customizationLightweightBooker.sendBookingNotificationEmailsToBooker) &&
        Objects.equals(this.sendBookingNotificationEmailsToChannelManager, customizationLightweightBooker.sendBookingNotificationEmailsToChannelManager) &&
        Objects.equals(this.wcBookClickAction, customizationLightweightBooker.wcBookClickAction) &&
        Objects.equals(this.city, customizationLightweightBooker.city) &&
        Objects.equals(this.showUnavailableCard, customizationLightweightBooker.showUnavailableCard) &&
        Objects.equals(this.showRankings, customizationLightweightBooker.showRankings) &&
        Objects.equals(this.showSearch, customizationLightweightBooker.showSearch);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, name, userIdentifier, ownerIdentifier, ownerName, subType, defaultCurrency, defaultLanguage, defaultLifestyle, logos, hostedBookingEngineUrl, selfHosted, themeColors, cardLayout, layout, cardDesign, numberOfAdvanceDays, numberOfStayDays, startDate, endDate, roomConfigurations, useDays, promotionalCodes, sendBookingNotificationEmailsToProperty, sendBookingNotificationEmailsToBooker, sendBookingNotificationEmailsToChannelManager, wcBookClickAction, city, showUnavailableCard, showRankings, showSearch);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CustomizationLightweightBooker {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    userIdentifier: ").append(toIndentedString(userIdentifier)).append("\n");
    sb.append("    ownerIdentifier: ").append(toIndentedString(ownerIdentifier)).append("\n");
    sb.append("    ownerName: ").append(toIndentedString(ownerName)).append("\n");
    sb.append("    subType: ").append(toIndentedString(subType)).append("\n");
    sb.append("    defaultCurrency: ").append(toIndentedString(defaultCurrency)).append("\n");
    sb.append("    defaultLanguage: ").append(toIndentedString(defaultLanguage)).append("\n");
    sb.append("    defaultLifestyle: ").append(toIndentedString(defaultLifestyle)).append("\n");
    sb.append("    logos: ").append(toIndentedString(logos)).append("\n");
    sb.append("    hostedBookingEngineUrl: ").append(toIndentedString(hostedBookingEngineUrl)).append("\n");
    sb.append("    selfHosted: ").append(toIndentedString(selfHosted)).append("\n");
    sb.append("    themeColors: ").append(toIndentedString(themeColors)).append("\n");
    sb.append("    cardLayout: ").append(toIndentedString(cardLayout)).append("\n");
    sb.append("    layout: ").append(toIndentedString(layout)).append("\n");
    sb.append("    cardDesign: ").append(toIndentedString(cardDesign)).append("\n");
    sb.append("    numberOfAdvanceDays: ").append(toIndentedString(numberOfAdvanceDays)).append("\n");
    sb.append("    numberOfStayDays: ").append(toIndentedString(numberOfStayDays)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    roomConfigurations: ").append(toIndentedString(roomConfigurations)).append("\n");
    sb.append("    useDays: ").append(toIndentedString(useDays)).append("\n");
    sb.append("    promotionalCodes: ").append(toIndentedString(promotionalCodes)).append("\n");
    sb.append("    sendBookingNotificationEmailsToProperty: ").append(toIndentedString(sendBookingNotificationEmailsToProperty)).append("\n");
    sb.append("    sendBookingNotificationEmailsToBooker: ").append(toIndentedString(sendBookingNotificationEmailsToBooker)).append("\n");
    sb.append("    sendBookingNotificationEmailsToChannelManager: ").append(toIndentedString(sendBookingNotificationEmailsToChannelManager)).append("\n");
    sb.append("    wcBookClickAction: ").append(toIndentedString(wcBookClickAction)).append("\n");
    sb.append("    city: ").append(toIndentedString(city)).append("\n");
    sb.append("    showUnavailableCard: ").append(toIndentedString(showUnavailableCard)).append("\n");
    sb.append("    showRankings: ").append(toIndentedString(showRankings)).append("\n");
    sb.append("    showSearch: ").append(toIndentedString(showSearch)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

