/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/customization-client): A single endpoint to retrieve whitelabel + customization information for the booking customization.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Booking Engine API Welcome to the Booking Engine API - A programmer-friendly way to book inventory that was found on our platform. This API lets you:  1. Shopping Cart: Manage shopping cart. 2. Checkout: Move shopping cart items through the reactive workflow. 3. Booking: Move selected inventory through to booking completion. 4. Review: Leave a review after a completed stay.  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.17.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * PersonalBooker
 */
@JsonPropertyOrder({
  PersonalBooker.JSON_PROPERTY_GENDER,
  PersonalBooker.JSON_PROPERTY_BIRTH_DATE,
  PersonalBooker.JSON_PROPERTY_MARITAL_STATUS,
  PersonalBooker.JSON_PROPERTY_CHILD_QUANTITY,
  PersonalBooker.JSON_PROPERTY_CITIZENSHIP,
  PersonalBooker.JSON_PROPERTY_ADDRESS1,
  PersonalBooker.JSON_PROPERTY_ADDRESS2,
  PersonalBooker.JSON_PROPERTY_CITY,
  PersonalBooker.JSON_PROPERTY_STATE,
  PersonalBooker.JSON_PROPERTY_POSTAL_CODE,
  PersonalBooker.JSON_PROPERTY_COUNTRY,
  PersonalBooker.JSON_PROPERTY_PREFERRED_CURRENCY,
  PersonalBooker.JSON_PROPERTY_LANGUAGE,
  PersonalBooker.JSON_PROPERTY_CONTACT_PERSON,
  PersonalBooker.JSON_PROPERTY_PHYS_CHALL_NAME,
  PersonalBooker.JSON_PROPERTY_PET_INFO
})
@JsonTypeName("Personal_Booker")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:16:53.154776164+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class PersonalBooker {
  /**
   * Identifier the gender of the customer.
   */
  public enum GenderEnum {
    MALE(String.valueOf("MALE")),
    
    FEMALE(String.valueOf("FEMALE")),
    
    OTHER(String.valueOf("OTHER"));

    private String value;

    GenderEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static GenderEnum fromValue(String value) {
      for (GenderEnum b : GenderEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_GENDER = "gender";
  @jakarta.annotation.Nullable
  private GenderEnum gender;

  public static final String JSON_PROPERTY_BIRTH_DATE = "birthDate";
  @jakarta.annotation.Nullable
  private LocalDate birthDate;

  /**
   * Marital status of the traveler.
   */
  public enum MaritalStatusEnum {
    ANNULLED(String.valueOf("ANNULLED")),
    
    COHABITATING(String.valueOf("COHABITATING")),
    
    DIVORCED(String.valueOf("DIVORCED")),
    
    ENGAGED(String.valueOf("ENGAGED")),
    
    MARRIED(String.valueOf("MARRIED")),
    
    SEPARATED(String.valueOf("SEPARATED")),
    
    SINGLE(String.valueOf("SINGLE")),
    
    WIDOWED(String.valueOf("WIDOWED")),
    
    UNKNOWN(String.valueOf("UNKNOWN"));

    private String value;

    MaritalStatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static MaritalStatusEnum fromValue(String value) {
      for (MaritalStatusEnum b : MaritalStatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_MARITAL_STATUS = "maritalStatus";
  @jakarta.annotation.Nullable
  private MaritalStatusEnum maritalStatus;

  public static final String JSON_PROPERTY_CHILD_QUANTITY = "childQuantity";
  @jakarta.annotation.Nullable
  private Integer childQuantity;

  public static final String JSON_PROPERTY_CITIZENSHIP = "citizenship";
  @jakarta.annotation.Nullable
  private String citizenship;

  public static final String JSON_PROPERTY_ADDRESS1 = "address1";
  @jakarta.annotation.Nullable
  private String address1;

  public static final String JSON_PROPERTY_ADDRESS2 = "address2";
  @jakarta.annotation.Nullable
  private String address2;

  public static final String JSON_PROPERTY_CITY = "city";
  @jakarta.annotation.Nullable
  private String city;

  public static final String JSON_PROPERTY_STATE = "state";
  @jakarta.annotation.Nullable
  private String state;

  public static final String JSON_PROPERTY_POSTAL_CODE = "postalCode";
  @jakarta.annotation.Nullable
  private String postalCode;

  public static final String JSON_PROPERTY_COUNTRY = "country";
  @jakarta.annotation.Nullable
  private String country;

  public static final String JSON_PROPERTY_PREFERRED_CURRENCY = "preferredCurrency";
  @jakarta.annotation.Nullable
  private String preferredCurrency;

  public static final String JSON_PROPERTY_LANGUAGE = "language";
  @jakarta.annotation.Nullable
  private String language;

  public static final String JSON_PROPERTY_CONTACT_PERSON = "contactPerson";
  @jakarta.annotation.Nullable
  private List<Object> contactPerson = new ArrayList<>();

  public static final String JSON_PROPERTY_PHYS_CHALL_NAME = "physChallName";
  @jakarta.annotation.Nullable
  private List<Object> physChallName = new ArrayList<>();

  public static final String JSON_PROPERTY_PET_INFO = "petInfo";
  @jakarta.annotation.Nullable
  private List<Object> petInfo = new ArrayList<>();

  public PersonalBooker() {
  }

  public PersonalBooker gender(@jakarta.annotation.Nullable GenderEnum gender) {
    
    this.gender = gender;
    return this;
  }

  /**
   * Identifier the gender of the customer.
   * @return gender
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GENDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GenderEnum getGender() {
    return gender;
  }


  @JsonProperty(JSON_PROPERTY_GENDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGender(@jakarta.annotation.Nullable GenderEnum gender) {
    this.gender = gender;
  }

  public PersonalBooker birthDate(@jakarta.annotation.Nullable LocalDate birthDate) {
    
    this.birthDate = birthDate;
    return this;
  }

  /**
   * Indicates the date of birth as indicated in the document, in ISO 8601 prescribed format.
   * @return birthDate
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_BIRTH_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getBirthDate() {
    return birthDate;
  }


  @JsonProperty(JSON_PROPERTY_BIRTH_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBirthDate(@jakarta.annotation.Nullable LocalDate birthDate) {
    this.birthDate = birthDate;
  }

  public PersonalBooker maritalStatus(@jakarta.annotation.Nullable MaritalStatusEnum maritalStatus) {
    
    this.maritalStatus = maritalStatus;
    return this;
  }

  /**
   * Marital status of the traveler.
   * @return maritalStatus
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MARITAL_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MaritalStatusEnum getMaritalStatus() {
    return maritalStatus;
  }


  @JsonProperty(JSON_PROPERTY_MARITAL_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaritalStatus(@jakarta.annotation.Nullable MaritalStatusEnum maritalStatus) {
    this.maritalStatus = maritalStatus;
  }

  public PersonalBooker childQuantity(@jakarta.annotation.Nullable Integer childQuantity) {
    
    this.childQuantity = childQuantity;
    return this;
  }

  /**
   * The number of children of the customer.
   * @return childQuantity
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CHILD_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getChildQuantity() {
    return childQuantity;
  }


  @JsonProperty(JSON_PROPERTY_CHILD_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChildQuantity(@jakarta.annotation.Nullable Integer childQuantity) {
    this.childQuantity = childQuantity;
  }

  public PersonalBooker citizenship(@jakarta.annotation.Nullable String citizenship) {
    
    this.citizenship = citizenship;
    return this;
  }

  /**
   * Name of the (self-professed) country that is clamided for citizenship.
   * @return citizenship
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CITIZENSHIP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCitizenship() {
    return citizenship;
  }


  @JsonProperty(JSON_PROPERTY_CITIZENSHIP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCitizenship(@jakarta.annotation.Nullable String citizenship) {
    this.citizenship = citizenship;
  }

  public PersonalBooker address1(@jakarta.annotation.Nullable String address1) {
    
    this.address1 = address1;
    return this;
  }

  /**
   * Address line 1
   * @return address1
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ADDRESS1)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAddress1() {
    return address1;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS1)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddress1(@jakarta.annotation.Nullable String address1) {
    this.address1 = address1;
  }

  public PersonalBooker address2(@jakarta.annotation.Nullable String address2) {
    
    this.address2 = address2;
    return this;
  }

  /**
   * Address line 2
   * @return address2
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ADDRESS2)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAddress2() {
    return address2;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS2)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddress2(@jakarta.annotation.Nullable String address2) {
    this.address2 = address2;
  }

  public PersonalBooker city(@jakarta.annotation.Nullable String city) {
    
    this.city = city;
    return this;
  }

  /**
   * City
   * @return city
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCity() {
    return city;
  }


  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCity(@jakarta.annotation.Nullable String city) {
    this.city = city;
  }

  public PersonalBooker state(@jakarta.annotation.Nullable String state) {
    
    this.state = state;
    return this;
  }

  /**
   * State
   * @return state
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getState() {
    return state;
  }


  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setState(@jakarta.annotation.Nullable String state) {
    this.state = state;
  }

  public PersonalBooker postalCode(@jakarta.annotation.Nullable String postalCode) {
    
    this.postalCode = postalCode;
    return this;
  }

  /**
   * Postal code
   * @return postalCode
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_POSTAL_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPostalCode() {
    return postalCode;
  }


  @JsonProperty(JSON_PROPERTY_POSTAL_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPostalCode(@jakarta.annotation.Nullable String postalCode) {
    this.postalCode = postalCode;
  }

  public PersonalBooker country(@jakarta.annotation.Nullable String country) {
    
    this.country = country;
    return this;
  }

  /**
   * Country
   * @return country
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountry() {
    return country;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountry(@jakarta.annotation.Nullable String country) {
    this.country = country;
  }

  public PersonalBooker preferredCurrency(@jakarta.annotation.Nullable String preferredCurrency) {
    
    this.preferredCurrency = preferredCurrency;
    return this;
  }

  /**
   * Type of funds preferred for reviewing monetary values, in ISO 4217 codes
   * @return preferredCurrency
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PREFERRED_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPreferredCurrency() {
    return preferredCurrency;
  }


  @JsonProperty(JSON_PROPERTY_PREFERRED_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPreferredCurrency(@jakarta.annotation.Nullable String preferredCurrency) {
    this.preferredCurrency = preferredCurrency;
  }

  public PersonalBooker language(@jakarta.annotation.Nullable String language) {
    
    this.language = language;
    return this;
  }

  /**
   * The primary language of the customer
   * @return language
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLanguage() {
    return language;
  }


  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLanguage(@jakarta.annotation.Nullable String language) {
    this.language = language;
  }

  public PersonalBooker contactPerson(@jakarta.annotation.Nullable List<Object> contactPerson) {
    
    this.contactPerson = contactPerson;
    return this;
  }

  public PersonalBooker addContactPersonItem(Object contactPersonItem) {
    if (this.contactPerson == null) {
      this.contactPerson = new ArrayList<>();
    }
    this.contactPerson.add(contactPersonItem);
    return this;
  }

  /**
   * Get contactPerson
   * @return contactPerson
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CONTACT_PERSON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getContactPerson() {
    return contactPerson;
  }


  @JsonProperty(JSON_PROPERTY_CONTACT_PERSON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContactPerson(@jakarta.annotation.Nullable List<Object> contactPerson) {
    this.contactPerson = contactPerson;
  }

  public PersonalBooker physChallName(@jakarta.annotation.Nullable List<Object> physChallName) {
    
    this.physChallName = physChallName;
    return this;
  }

  public PersonalBooker addPhysChallNameItem(Object physChallNameItem) {
    if (this.physChallName == null) {
      this.physChallName = new ArrayList<>();
    }
    this.physChallName.add(physChallNameItem);
    return this;
  }

  /**
   * Get physChallName
   * @return physChallName
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PHYS_CHALL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getPhysChallName() {
    return physChallName;
  }


  @JsonProperty(JSON_PROPERTY_PHYS_CHALL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPhysChallName(@jakarta.annotation.Nullable List<Object> physChallName) {
    this.physChallName = physChallName;
  }

  public PersonalBooker petInfo(@jakarta.annotation.Nullable List<Object> petInfo) {
    
    this.petInfo = petInfo;
    return this;
  }

  public PersonalBooker addPetInfoItem(Object petInfoItem) {
    if (this.petInfo == null) {
      this.petInfo = new ArrayList<>();
    }
    this.petInfo.add(petInfoItem);
    return this;
  }

  /**
   * Get petInfo
   * @return petInfo
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PET_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getPetInfo() {
    return petInfo;
  }


  @JsonProperty(JSON_PROPERTY_PET_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPetInfo(@jakarta.annotation.Nullable List<Object> petInfo) {
    this.petInfo = petInfo;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PersonalBooker personalBooker = (PersonalBooker) o;
    return Objects.equals(this.gender, personalBooker.gender) &&
        Objects.equals(this.birthDate, personalBooker.birthDate) &&
        Objects.equals(this.maritalStatus, personalBooker.maritalStatus) &&
        Objects.equals(this.childQuantity, personalBooker.childQuantity) &&
        Objects.equals(this.citizenship, personalBooker.citizenship) &&
        Objects.equals(this.address1, personalBooker.address1) &&
        Objects.equals(this.address2, personalBooker.address2) &&
        Objects.equals(this.city, personalBooker.city) &&
        Objects.equals(this.state, personalBooker.state) &&
        Objects.equals(this.postalCode, personalBooker.postalCode) &&
        Objects.equals(this.country, personalBooker.country) &&
        Objects.equals(this.preferredCurrency, personalBooker.preferredCurrency) &&
        Objects.equals(this.language, personalBooker.language) &&
        Objects.equals(this.contactPerson, personalBooker.contactPerson) &&
        Objects.equals(this.physChallName, personalBooker.physChallName) &&
        Objects.equals(this.petInfo, personalBooker.petInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(gender, birthDate, maritalStatus, childQuantity, citizenship, address1, address2, city, state, postalCode, country, preferredCurrency, language, contactPerson, physChallName, petInfo);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PersonalBooker {\n");
    sb.append("    gender: ").append(toIndentedString(gender)).append("\n");
    sb.append("    birthDate: ").append(toIndentedString(birthDate)).append("\n");
    sb.append("    maritalStatus: ").append(toIndentedString(maritalStatus)).append("\n");
    sb.append("    childQuantity: ").append(toIndentedString(childQuantity)).append("\n");
    sb.append("    citizenship: ").append(toIndentedString(citizenship)).append("\n");
    sb.append("    address1: ").append(toIndentedString(address1)).append("\n");
    sb.append("    address2: ").append(toIndentedString(address2)).append("\n");
    sb.append("    city: ").append(toIndentedString(city)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    postalCode: ").append(toIndentedString(postalCode)).append("\n");
    sb.append("    country: ").append(toIndentedString(country)).append("\n");
    sb.append("    preferredCurrency: ").append(toIndentedString(preferredCurrency)).append("\n");
    sb.append("    language: ").append(toIndentedString(language)).append("\n");
    sb.append("    contactPerson: ").append(toIndentedString(contactPerson)).append("\n");
    sb.append("    physChallName: ").append(toIndentedString(physChallName)).append("\n");
    sb.append("    petInfo: ").append(toIndentedString(petInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

