/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/customization-client): A single endpoint to retrieve whitelabel + customization information for the booking customization.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Booking Engine API Welcome to the Booking Engine API - A programmer-friendly way to book inventory that was found on our platform. This API lets you:  1. Shopping Cart: Manage shopping cart. 2. Checkout: Move shopping cart items through the reactive workflow. 3. Booking: Move selected inventory through to booking completion. 4. Review: Leave a review after a completed stay.  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.17.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.booking.model.ContactAuthenticatedEntity;
import travel.wink.sdk.booking.model.GeneralManagerAuthenticatedEntity;
import travel.wink.sdk.booking.model.GeoJsonPointAuthenticatedEntity;
import travel.wink.sdk.booking.model.PropertyPolicyAuthenticatedEntity;
import travel.wink.sdk.booking.model.SimpleAddressAuthenticatedEntity;
import travel.wink.sdk.booking.model.SimpleDescriptionAuthenticatedEntity;
import travel.wink.sdk.booking.model.SimpleMultimediaAuthenticatedEntity;
import travel.wink.sdk.booking.model.SocialAuthenticatedEntity;
import travel.wink.sdk.booking.model.TravelInventoryRecognitionAuthenticatedEntity;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * PropertyAggregateLightweightAuthenticatedEntity
 */
@JsonPropertyOrder({
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_HOTEL_IDENTIFIER,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_NAME,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_LOCAL_NAME,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_CHAIN,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_BRAND,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_URL_NAME,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_STAR_RATING,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_BOOKINGS,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_AGGREGATE_REVIEW_RATING,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_LOCATION,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_DESCRIPTIONS,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_AGGREGATE_GREENDEX_RATING,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_LIFESTYLE_TYPES,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_TOTAL_REVIEWS,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_RESERVATIONS,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_SOCIALS,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_IMAGES,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_VIDEOS,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_POLICY,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_THIRD_PARTY_REVIEWS,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_ATTRACTIONS,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_ACTIVITIES,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_PLACES,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_RESTAURANTS,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_MEETING_ROOMS,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_SPAS,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_ADD_ONS,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_GENERAL_MANAGER,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_LOCATION_CATEGORY,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_SEGMENT_CATEGORY,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_HOTEL_CATEGORY,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_ARCHITECTURAL_STYLE,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_WHEN_BUILT,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_CURRENCY_CODE,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_MEMBERSHIP_RATE_DISCOUNT,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_PRICE_SCORE,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_PERK_SCORE,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_ADD_ON_SCORE,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_LOYALTY_SCORE,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_POPULAR_SCORE,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_EXPERIENCE_SCORE,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_HOTEL_AMENITY_CODES,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_PROPERTY_ACCESSIBILITY_CODES,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_PROPERTY_SECURITY_CODES,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_NUMBER_OF_ROOMS,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_ADDRESS,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_ACTIVE,
  PropertyAggregateLightweightAuthenticatedEntity.JSON_PROPERTY_URL_PARAMETERS
})
@JsonTypeName("PropertyAggregateLightweight_Authenticated_Entity")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:16:53.154776164+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class PropertyAggregateLightweightAuthenticatedEntity {
  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  @jakarta.annotation.Nullable
  private UUID hotelIdentifier;

  public static final String JSON_PROPERTY_NAME = "name";
  @jakarta.annotation.Nullable
  private String name;

  public static final String JSON_PROPERTY_LOCAL_NAME = "localName";
  @jakarta.annotation.Nullable
  private String localName;

  public static final String JSON_PROPERTY_CHAIN = "chain";
  @jakarta.annotation.Nullable
  private String chain;

  public static final String JSON_PROPERTY_BRAND = "brand";
  @jakarta.annotation.Nullable
  private String brand;

  public static final String JSON_PROPERTY_URL_NAME = "urlName";
  @jakarta.annotation.Nullable
  private String urlName;

  public static final String JSON_PROPERTY_STAR_RATING = "starRating";
  @jakarta.annotation.Nullable
  private Integer starRating;

  public static final String JSON_PROPERTY_BOOKINGS = "bookings";
  @jakarta.annotation.Nullable
  private Long bookings = 0l;

  public static final String JSON_PROPERTY_AGGREGATE_REVIEW_RATING = "aggregateReviewRating";
  @jakarta.annotation.Nullable
  private Float aggregateReviewRating = 0.0f;

  public static final String JSON_PROPERTY_LOCATION = "location";
  @jakarta.annotation.Nullable
  private GeoJsonPointAuthenticatedEntity location;

  public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
  @jakarta.annotation.Nullable
  private List<@Valid SimpleDescriptionAuthenticatedEntity> descriptions = new ArrayList<>();

  public static final String JSON_PROPERTY_AGGREGATE_GREENDEX_RATING = "aggregateGreendexRating";
  @jakarta.annotation.Nullable
  private Float aggregateGreendexRating = 0.0f;

  public static final String JSON_PROPERTY_LIFESTYLE_TYPES = "lifestyleTypes";
  @jakarta.annotation.Nullable
  private List<Object> lifestyleTypes = new ArrayList<>();

  public static final String JSON_PROPERTY_TOTAL_REVIEWS = "totalReviews";
  @jakarta.annotation.Nullable
  private Integer totalReviews = 0;

  public static final String JSON_PROPERTY_RESERVATIONS = "reservations";
  @jakarta.annotation.Nullable
  private ContactAuthenticatedEntity reservations;

  public static final String JSON_PROPERTY_SOCIALS = "socials";
  @jakarta.annotation.Nullable
  private List<@Valid SocialAuthenticatedEntity> socials = new ArrayList<>();

  public static final String JSON_PROPERTY_IMAGES = "images";
  @jakarta.annotation.Nullable
  private List<@Valid SimpleMultimediaAuthenticatedEntity> images = new ArrayList<>();

  public static final String JSON_PROPERTY_VIDEOS = "videos";
  @jakarta.annotation.Nullable
  private List<@Valid SimpleMultimediaAuthenticatedEntity> videos = new ArrayList<>();

  public static final String JSON_PROPERTY_POLICY = "policy";
  @jakarta.annotation.Nullable
  private PropertyPolicyAuthenticatedEntity policy;

  public static final String JSON_PROPERTY_THIRD_PARTY_REVIEWS = "thirdPartyReviews";
  @jakarta.annotation.Nullable
  private List<@Valid TravelInventoryRecognitionAuthenticatedEntity> thirdPartyReviews = new ArrayList<>();

  public static final String JSON_PROPERTY_ATTRACTIONS = "attractions";
  @jakarta.annotation.Nullable
  private Integer attractions = 0;

  public static final String JSON_PROPERTY_ACTIVITIES = "activities";
  @jakarta.annotation.Nullable
  private Integer activities = 0;

  public static final String JSON_PROPERTY_PLACES = "places";
  @jakarta.annotation.Nullable
  private Integer places = 0;

  public static final String JSON_PROPERTY_RESTAURANTS = "restaurants";
  @jakarta.annotation.Nullable
  private Integer restaurants = 0;

  public static final String JSON_PROPERTY_MEETING_ROOMS = "meetingRooms";
  @jakarta.annotation.Nullable
  private Integer meetingRooms = 0;

  public static final String JSON_PROPERTY_SPAS = "spas";
  @jakarta.annotation.Nullable
  private Integer spas = 0;

  public static final String JSON_PROPERTY_ADD_ONS = "addOns";
  @jakarta.annotation.Nullable
  private Integer addOns = 0;

  public static final String JSON_PROPERTY_GENERAL_MANAGER = "generalManager";
  @jakarta.annotation.Nullable
  private GeneralManagerAuthenticatedEntity generalManager;

  public static final String JSON_PROPERTY_LOCATION_CATEGORY = "locationCategory";
  @jakarta.annotation.Nullable
  private String locationCategory;

  public static final String JSON_PROPERTY_SEGMENT_CATEGORY = "segmentCategory";
  @jakarta.annotation.Nullable
  private String segmentCategory;

  public static final String JSON_PROPERTY_HOTEL_CATEGORY = "hotelCategory";
  @jakarta.annotation.Nullable
  private String hotelCategory;

  public static final String JSON_PROPERTY_ARCHITECTURAL_STYLE = "architecturalStyle";
  @jakarta.annotation.Nullable
  private String architecturalStyle;

  public static final String JSON_PROPERTY_WHEN_BUILT = "whenBuilt";
  @jakarta.annotation.Nullable
  private String whenBuilt;

  public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
  @jakarta.annotation.Nullable
  private String currencyCode;

  public static final String JSON_PROPERTY_MEMBERSHIP_RATE_DISCOUNT = "membershipRateDiscount";
  @jakarta.annotation.Nullable
  private Float membershipRateDiscount = 0f;

  public static final String JSON_PROPERTY_PRICE_SCORE = "priceScore";
  @jakarta.annotation.Nullable
  private Integer priceScore = 0;

  public static final String JSON_PROPERTY_PERK_SCORE = "perkScore";
  @jakarta.annotation.Nullable
  private Integer perkScore = 0;

  public static final String JSON_PROPERTY_ADD_ON_SCORE = "addOnScore";
  @jakarta.annotation.Nullable
  private Integer addOnScore = 0;

  public static final String JSON_PROPERTY_LOYALTY_SCORE = "loyaltyScore";
  @jakarta.annotation.Nullable
  private Integer loyaltyScore = 0;

  public static final String JSON_PROPERTY_POPULAR_SCORE = "popularScore";
  @jakarta.annotation.Nullable
  private Integer popularScore = 0;

  public static final String JSON_PROPERTY_EXPERIENCE_SCORE = "experienceScore";
  @jakarta.annotation.Nullable
  private Integer experienceScore = 0;

  public static final String JSON_PROPERTY_HOTEL_AMENITY_CODES = "hotelAmenityCodes";
  @jakarta.annotation.Nullable
  private List<String> hotelAmenityCodes = new ArrayList<>();

  public static final String JSON_PROPERTY_PROPERTY_ACCESSIBILITY_CODES = "propertyAccessibilityCodes";
  @jakarta.annotation.Nullable
  private List<String> propertyAccessibilityCodes = new ArrayList<>();

  public static final String JSON_PROPERTY_PROPERTY_SECURITY_CODES = "propertySecurityCodes";
  @jakarta.annotation.Nullable
  private List<String> propertySecurityCodes = new ArrayList<>();

  public static final String JSON_PROPERTY_NUMBER_OF_ROOMS = "numberOfRooms";
  @jakarta.annotation.Nullable
  private Integer numberOfRooms = 0;

  public static final String JSON_PROPERTY_ADDRESS = "address";
  @jakarta.annotation.Nullable
  private SimpleAddressAuthenticatedEntity address;

  public static final String JSON_PROPERTY_ACTIVE = "active";
  @jakarta.annotation.Nullable
  private Boolean active;

  public static final String JSON_PROPERTY_URL_PARAMETERS = "urlParameters";
  @jakarta.annotation.Nullable
  private String urlParameters;

  public PropertyAggregateLightweightAuthenticatedEntity() {
  }

  public PropertyAggregateLightweightAuthenticatedEntity hotelIdentifier(@jakarta.annotation.Nullable UUID hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

  /**
   * Unique hotel record identifier.
   * @return hotelIdentifier
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelIdentifier(@jakarta.annotation.Nullable UUID hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }

  public PropertyAggregateLightweightAuthenticatedEntity name(@jakarta.annotation.Nullable String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Hotel trade name
   * @return name
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(@jakarta.annotation.Nullable String name) {
    this.name = name;
  }

  public PropertyAggregateLightweightAuthenticatedEntity localName(@jakarta.annotation.Nullable String localName) {
    
    this.localName = localName;
    return this;
  }

  /**
   * Hotel local name if different from the trade name or if it is the local language.
   * @return localName
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LOCAL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLocalName() {
    return localName;
  }


  @JsonProperty(JSON_PROPERTY_LOCAL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocalName(@jakarta.annotation.Nullable String localName) {
    this.localName = localName;
  }

  public PropertyAggregateLightweightAuthenticatedEntity chain(@jakarta.annotation.Nullable String chain) {
    
    this.chain = chain;
    return this;
  }

  /**
   * Name of hotel chain if applicable.
   * @return chain
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CHAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getChain() {
    return chain;
  }


  @JsonProperty(JSON_PROPERTY_CHAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChain(@jakarta.annotation.Nullable String chain) {
    this.chain = chain;
  }

  public PropertyAggregateLightweightAuthenticatedEntity brand(@jakarta.annotation.Nullable String brand) {
    
    this.brand = brand;
    return this;
  }

  /**
   * Name of hotel brand
   * @return brand
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BRAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBrand() {
    return brand;
  }


  @JsonProperty(JSON_PROPERTY_BRAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBrand(@jakarta.annotation.Nullable String brand) {
    this.brand = brand;
  }

  public PropertyAggregateLightweightAuthenticatedEntity urlName(@jakarta.annotation.Nullable String urlName) {
    
    this.urlName = urlName;
    return this;
  }

  /**
   * Unique URL-friendly name slug of hotel
   * @return urlName
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUrlName() {
    return urlName;
  }


  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUrlName(@jakarta.annotation.Nullable String urlName) {
    this.urlName = urlName;
  }

  public PropertyAggregateLightweightAuthenticatedEntity starRating(@jakarta.annotation.Nullable Integer starRating) {
    
    this.starRating = starRating;
    return this;
  }

  /**
   * Official or self-designated property star rating. Note that in some regions there are 6-star hotels. They are the same as 5-star hotels everywhere else.
   * minimum: 0
   * maximum: 6
   * @return starRating
   */
  @jakarta.annotation.Nullable
 @Min(0) @Max(6)
  @JsonProperty(JSON_PROPERTY_STAR_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getStarRating() {
    return starRating;
  }


  @JsonProperty(JSON_PROPERTY_STAR_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStarRating(@jakarta.annotation.Nullable Integer starRating) {
    this.starRating = starRating;
  }

  public PropertyAggregateLightweightAuthenticatedEntity bookings(@jakarta.annotation.Nullable Long bookings) {
    
    this.bookings = bookings;
    return this;
  }

  /**
   * Number of bookings for this property on the wink.travel platform.
   * @return bookings
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BOOKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getBookings() {
    return bookings;
  }


  @JsonProperty(JSON_PROPERTY_BOOKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBookings(@jakarta.annotation.Nullable Long bookings) {
    this.bookings = bookings;
  }

  public PropertyAggregateLightweightAuthenticatedEntity aggregateReviewRating(@jakarta.annotation.Nullable Float aggregateReviewRating) {
    
    this.aggregateReviewRating = aggregateReviewRating;
    return this;
  }

  /**
   * Aggregate score based on all current user reviews.
   * @return aggregateReviewRating
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AGGREGATE_REVIEW_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getAggregateReviewRating() {
    return aggregateReviewRating;
  }


  @JsonProperty(JSON_PROPERTY_AGGREGATE_REVIEW_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAggregateReviewRating(@jakarta.annotation.Nullable Float aggregateReviewRating) {
    this.aggregateReviewRating = aggregateReviewRating;
  }

  public PropertyAggregateLightweightAuthenticatedEntity location(@jakarta.annotation.Nullable GeoJsonPointAuthenticatedEntity location) {
    
    this.location = location;
    return this;
  }

  /**
   * Geo-location
   * @return location
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GeoJsonPointAuthenticatedEntity getLocation() {
    return location;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocation(@jakarta.annotation.Nullable GeoJsonPointAuthenticatedEntity location) {
    this.location = location;
  }

  public PropertyAggregateLightweightAuthenticatedEntity descriptions(@jakarta.annotation.Nullable List<@Valid SimpleDescriptionAuthenticatedEntity> descriptions) {
    
    this.descriptions = descriptions;
    return this;
  }

  public PropertyAggregateLightweightAuthenticatedEntity addDescriptionsItem(SimpleDescriptionAuthenticatedEntity descriptionsItem) {
    if (this.descriptions == null) {
      this.descriptions = new ArrayList<>();
    }
    this.descriptions.add(descriptionsItem);
    return this;
  }

  /**
   * Short and long welcome text
   * @return descriptions
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<@Valid SimpleDescriptionAuthenticatedEntity> getDescriptions() {
    return descriptions;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescriptions(@jakarta.annotation.Nullable List<@Valid SimpleDescriptionAuthenticatedEntity> descriptions) {
    this.descriptions = descriptions;
  }

  public PropertyAggregateLightweightAuthenticatedEntity aggregateGreendexRating(@jakarta.annotation.Nullable Float aggregateGreendexRating) {
    
    this.aggregateGreendexRating = aggregateGreendexRating;
    return this;
  }

  /**
   * Aggregate Green Index score if the property has answered our questionnaire available in the Extranet.
   * @return aggregateGreendexRating
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AGGREGATE_GREENDEX_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getAggregateGreendexRating() {
    return aggregateGreendexRating;
  }


  @JsonProperty(JSON_PROPERTY_AGGREGATE_GREENDEX_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAggregateGreendexRating(@jakarta.annotation.Nullable Float aggregateGreendexRating) {
    this.aggregateGreendexRating = aggregateGreendexRating;
  }

  public PropertyAggregateLightweightAuthenticatedEntity lifestyleTypes(@jakarta.annotation.Nullable List<Object> lifestyleTypes) {
    
    this.lifestyleTypes = lifestyleTypes;
    return this;
  }

  public PropertyAggregateLightweightAuthenticatedEntity addLifestyleTypesItem(Object lifestyleTypesItem) {
    if (this.lifestyleTypes == null) {
      this.lifestyleTypes = new ArrayList<>();
    }
    this.lifestyleTypes.add(lifestyleTypesItem);
    return this;
  }

  /**
   * Get lifestyleTypes
   * @return lifestyleTypes
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LIFESTYLE_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getLifestyleTypes() {
    return lifestyleTypes;
  }


  @JsonProperty(JSON_PROPERTY_LIFESTYLE_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLifestyleTypes(@jakarta.annotation.Nullable List<Object> lifestyleTypes) {
    this.lifestyleTypes = lifestyleTypes;
  }

  public PropertyAggregateLightweightAuthenticatedEntity totalReviews(@jakarta.annotation.Nullable Integer totalReviews) {
    
    this.totalReviews = totalReviews;
    return this;
  }

  /**
   * Count of total reviews left by users at this property.
   * @return totalReviews
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_REVIEWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getTotalReviews() {
    return totalReviews;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_REVIEWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalReviews(@jakarta.annotation.Nullable Integer totalReviews) {
    this.totalReviews = totalReviews;
  }

  public PropertyAggregateLightweightAuthenticatedEntity reservations(@jakarta.annotation.Nullable ContactAuthenticatedEntity reservations) {
    
    this.reservations = reservations;
    return this;
  }

  /**
   * Contact details for reservations desk
   * @return reservations
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_RESERVATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ContactAuthenticatedEntity getReservations() {
    return reservations;
  }


  @JsonProperty(JSON_PROPERTY_RESERVATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReservations(@jakarta.annotation.Nullable ContactAuthenticatedEntity reservations) {
    this.reservations = reservations;
  }

  public PropertyAggregateLightweightAuthenticatedEntity socials(@jakarta.annotation.Nullable List<@Valid SocialAuthenticatedEntity> socials) {
    
    this.socials = socials;
    return this;
  }

  public PropertyAggregateLightweightAuthenticatedEntity addSocialsItem(SocialAuthenticatedEntity socialsItem) {
    if (this.socials == null) {
      this.socials = new ArrayList<>();
    }
    this.socials.add(socialsItem);
    return this;
  }

  /**
   * Property&#39;s social network accounts
   * @return socials
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<@Valid SocialAuthenticatedEntity> getSocials() {
    return socials;
  }


  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSocials(@jakarta.annotation.Nullable List<@Valid SocialAuthenticatedEntity> socials) {
    this.socials = socials;
  }

  public PropertyAggregateLightweightAuthenticatedEntity images(@jakarta.annotation.Nullable List<@Valid SimpleMultimediaAuthenticatedEntity> images) {
    
    this.images = images;
    return this;
  }

  public PropertyAggregateLightweightAuthenticatedEntity addImagesItem(SimpleMultimediaAuthenticatedEntity imagesItem) {
    if (this.images == null) {
      this.images = new ArrayList<>();
    }
    this.images.add(imagesItem);
    return this;
  }

  /**
   * Property images.
   * @return images
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_IMAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<@Valid SimpleMultimediaAuthenticatedEntity> getImages() {
    return images;
  }


  @JsonProperty(JSON_PROPERTY_IMAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImages(@jakarta.annotation.Nullable List<@Valid SimpleMultimediaAuthenticatedEntity> images) {
    this.images = images;
  }

  public PropertyAggregateLightweightAuthenticatedEntity videos(@jakarta.annotation.Nullable List<@Valid SimpleMultimediaAuthenticatedEntity> videos) {
    
    this.videos = videos;
    return this;
  }

  public PropertyAggregateLightweightAuthenticatedEntity addVideosItem(SimpleMultimediaAuthenticatedEntity videosItem) {
    if (this.videos == null) {
      this.videos = new ArrayList<>();
    }
    this.videos.add(videosItem);
    return this;
  }

  /**
   * Property videos.
   * @return videos
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_VIDEOS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<@Valid SimpleMultimediaAuthenticatedEntity> getVideos() {
    return videos;
  }


  @JsonProperty(JSON_PROPERTY_VIDEOS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVideos(@jakarta.annotation.Nullable List<@Valid SimpleMultimediaAuthenticatedEntity> videos) {
    this.videos = videos;
  }

  public PropertyAggregateLightweightAuthenticatedEntity policy(@jakarta.annotation.Nullable PropertyPolicyAuthenticatedEntity policy) {
    
    this.policy = policy;
    return this;
  }

  /**
   * Basic property policy record.
   * @return policy
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PropertyPolicyAuthenticatedEntity getPolicy() {
    return policy;
  }


  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPolicy(@jakarta.annotation.Nullable PropertyPolicyAuthenticatedEntity policy) {
    this.policy = policy;
  }

  public PropertyAggregateLightweightAuthenticatedEntity thirdPartyReviews(@jakarta.annotation.Nullable List<@Valid TravelInventoryRecognitionAuthenticatedEntity> thirdPartyReviews) {
    
    this.thirdPartyReviews = thirdPartyReviews;
    return this;
  }

  public PropertyAggregateLightweightAuthenticatedEntity addThirdPartyReviewsItem(TravelInventoryRecognitionAuthenticatedEntity thirdPartyReviewsItem) {
    if (this.thirdPartyReviews == null) {
      this.thirdPartyReviews = new ArrayList<>();
    }
    this.thirdPartyReviews.add(thirdPartyReviewsItem);
    return this;
  }

  /**
   * Array of awards and third party reviews given to property by certified / non-certified providers.
   * @return thirdPartyReviews
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_THIRD_PARTY_REVIEWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<@Valid TravelInventoryRecognitionAuthenticatedEntity> getThirdPartyReviews() {
    return thirdPartyReviews;
  }


  @JsonProperty(JSON_PROPERTY_THIRD_PARTY_REVIEWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThirdPartyReviews(@jakarta.annotation.Nullable List<@Valid TravelInventoryRecognitionAuthenticatedEntity> thirdPartyReviews) {
    this.thirdPartyReviews = thirdPartyReviews;
  }

  public PropertyAggregateLightweightAuthenticatedEntity attractions(@jakarta.annotation.Nullable Integer attractions) {
    
    this.attractions = attractions;
    return this;
  }

  /**
   * Number of attractions property has listed on its profile.
   * @return attractions
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAttractions() {
    return attractions;
  }


  @JsonProperty(JSON_PROPERTY_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttractions(@jakarta.annotation.Nullable Integer attractions) {
    this.attractions = attractions;
  }

  public PropertyAggregateLightweightAuthenticatedEntity activities(@jakarta.annotation.Nullable Integer activities) {
    
    this.activities = activities;
    return this;
  }

  /**
   * Number of activites property has listed on its profile.
   * @return activities
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getActivities() {
    return activities;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActivities(@jakarta.annotation.Nullable Integer activities) {
    this.activities = activities;
  }

  public PropertyAggregateLightweightAuthenticatedEntity places(@jakarta.annotation.Nullable Integer places) {
    
    this.places = places;
    return this;
  }

  /**
   * Number of places property has listed on its profile.
   * @return places
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPlaces() {
    return places;
  }


  @JsonProperty(JSON_PROPERTY_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPlaces(@jakarta.annotation.Nullable Integer places) {
    this.places = places;
  }

  public PropertyAggregateLightweightAuthenticatedEntity restaurants(@jakarta.annotation.Nullable Integer restaurants) {
    
    this.restaurants = restaurants;
    return this;
  }

  /**
   * Number of restaurants property has on its profile.
   * @return restaurants
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRestaurants() {
    return restaurants;
  }


  @JsonProperty(JSON_PROPERTY_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRestaurants(@jakarta.annotation.Nullable Integer restaurants) {
    this.restaurants = restaurants;
  }

  public PropertyAggregateLightweightAuthenticatedEntity meetingRooms(@jakarta.annotation.Nullable Integer meetingRooms) {
    
    this.meetingRooms = meetingRooms;
    return this;
  }

  /**
   * Number of meeting rooms property has on its profile.
   * @return meetingRooms
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMeetingRooms() {
    return meetingRooms;
  }


  @JsonProperty(JSON_PROPERTY_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMeetingRooms(@jakarta.annotation.Nullable Integer meetingRooms) {
    this.meetingRooms = meetingRooms;
  }

  public PropertyAggregateLightweightAuthenticatedEntity spas(@jakarta.annotation.Nullable Integer spas) {
    
    this.spas = spas;
    return this;
  }

  /**
   * Number of spas property has on its profile.
   * @return spas
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSpas() {
    return spas;
  }


  @JsonProperty(JSON_PROPERTY_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSpas(@jakarta.annotation.Nullable Integer spas) {
    this.spas = spas;
  }

  public PropertyAggregateLightweightAuthenticatedEntity addOns(@jakarta.annotation.Nullable Integer addOns) {
    
    this.addOns = addOns;
    return this;
  }

  /**
   * Number of add-ons property has on its profile.
   * @return addOns
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAddOns() {
    return addOns;
  }


  @JsonProperty(JSON_PROPERTY_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddOns(@jakarta.annotation.Nullable Integer addOns) {
    this.addOns = addOns;
  }

  public PropertyAggregateLightweightAuthenticatedEntity generalManager(@jakarta.annotation.Nullable GeneralManagerAuthenticatedEntity generalManager) {
    
    this.generalManager = generalManager;
    return this;
  }

  /**
   * Get generalManager
   * @return generalManager
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_GENERAL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GeneralManagerAuthenticatedEntity getGeneralManager() {
    return generalManager;
  }


  @JsonProperty(JSON_PROPERTY_GENERAL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGeneralManager(@jakarta.annotation.Nullable GeneralManagerAuthenticatedEntity generalManager) {
    this.generalManager = generalManager;
  }

  public PropertyAggregateLightweightAuthenticatedEntity locationCategory(@jakarta.annotation.Nullable String locationCategory) {
    
    this.locationCategory = locationCategory;
    return this;
  }

  /**
   * Supported OTA specification &#x60;LOC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return locationCategory
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LOCATION_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLocationCategory() {
    return locationCategory;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocationCategory(@jakarta.annotation.Nullable String locationCategory) {
    this.locationCategory = locationCategory;
  }

  public PropertyAggregateLightweightAuthenticatedEntity segmentCategory(@jakarta.annotation.Nullable String segmentCategory) {
    
    this.segmentCategory = segmentCategory;
    return this;
  }

  /**
   * Supported OTA specification &#x60;SEG&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return segmentCategory
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SEGMENT_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSegmentCategory() {
    return segmentCategory;
  }


  @JsonProperty(JSON_PROPERTY_SEGMENT_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSegmentCategory(@jakarta.annotation.Nullable String segmentCategory) {
    this.segmentCategory = segmentCategory;
  }

  public PropertyAggregateLightweightAuthenticatedEntity hotelCategory(@jakarta.annotation.Nullable String hotelCategory) {
    
    this.hotelCategory = hotelCategory;
    return this;
  }

  /**
   * Supported OTA specification &#x60;PCT&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return hotelCategory
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HOTEL_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHotelCategory() {
    return hotelCategory;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelCategory(@jakarta.annotation.Nullable String hotelCategory) {
    this.hotelCategory = hotelCategory;
  }

  public PropertyAggregateLightweightAuthenticatedEntity architecturalStyle(@jakarta.annotation.Nullable String architecturalStyle) {
    
    this.architecturalStyle = architecturalStyle;
    return this;
  }

  /**
   * Supported OTA specification &#x60;ARC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return architecturalStyle
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ARCHITECTURAL_STYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getArchitecturalStyle() {
    return architecturalStyle;
  }


  @JsonProperty(JSON_PROPERTY_ARCHITECTURAL_STYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setArchitecturalStyle(@jakarta.annotation.Nullable String architecturalStyle) {
    this.architecturalStyle = architecturalStyle;
  }

  public PropertyAggregateLightweightAuthenticatedEntity whenBuilt(@jakarta.annotation.Nullable String whenBuilt) {
    
    this.whenBuilt = whenBuilt;
    return this;
  }

  /**
   * Year the property was constructed.
   * @return whenBuilt
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_WHEN_BUILT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getWhenBuilt() {
    return whenBuilt;
  }


  @JsonProperty(JSON_PROPERTY_WHEN_BUILT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWhenBuilt(@jakarta.annotation.Nullable String whenBuilt) {
    this.whenBuilt = whenBuilt;
  }

  public PropertyAggregateLightweightAuthenticatedEntity currencyCode(@jakarta.annotation.Nullable String currencyCode) {
    
    this.currencyCode = currencyCode;
    return this;
  }

  /**
   * Currency code for property.
   * @return currencyCode
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrencyCode() {
    return currencyCode;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrencyCode(@jakarta.annotation.Nullable String currencyCode) {
    this.currencyCode = currencyCode;
  }

  public PropertyAggregateLightweightAuthenticatedEntity membershipRateDiscount(@jakarta.annotation.Nullable Float membershipRateDiscount) {
    
    this.membershipRateDiscount = membershipRateDiscount;
    return this;
  }

  /**
   * A property&#39;s price score is based on calculating historical pricing data. Each property receives a unique score. There is no max score; it&#39;s there to compare it against other properties.
   * @return membershipRateDiscount
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MEMBERSHIP_RATE_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getMembershipRateDiscount() {
    return membershipRateDiscount;
  }


  @JsonProperty(JSON_PROPERTY_MEMBERSHIP_RATE_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMembershipRateDiscount(@jakarta.annotation.Nullable Float membershipRateDiscount) {
    this.membershipRateDiscount = membershipRateDiscount;
  }

  public PropertyAggregateLightweightAuthenticatedEntity priceScore(@jakarta.annotation.Nullable Integer priceScore) {
    
    this.priceScore = priceScore;
    return this;
  }

  /**
   * A property&#39;s price score is based on calculating historical pricing data. Each property receives a unique score. There is no max score; it&#39;s there to compare it against other properties.
   * @return priceScore
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PRICE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPriceScore() {
    return priceScore;
  }


  @JsonProperty(JSON_PROPERTY_PRICE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPriceScore(@jakarta.annotation.Nullable Integer priceScore) {
    this.priceScore = priceScore;
  }

  public PropertyAggregateLightweightAuthenticatedEntity perkScore(@jakarta.annotation.Nullable Integer perkScore) {
    
    this.perkScore = perkScore;
    return this;
  }

  /**
   * A property&#39;s perk score is based on the type of perks that is offered to the guests across all master rates. There is no max score; it&#39;s there to compare it against other properties.
   * @return perkScore
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PERK_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPerkScore() {
    return perkScore;
  }


  @JsonProperty(JSON_PROPERTY_PERK_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPerkScore(@jakarta.annotation.Nullable Integer perkScore) {
    this.perkScore = perkScore;
  }

  public PropertyAggregateLightweightAuthenticatedEntity addOnScore(@jakarta.annotation.Nullable Integer addOnScore) {
    
    this.addOnScore = addOnScore;
    return this;
  }

  /**
   * A property&#39;s package score is based on general availability and price for all packages and add-ons offered by the property. There is no max score; it&#39;s there to compare it against other properties.
   * @return addOnScore
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ADD_ON_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAddOnScore() {
    return addOnScore;
  }


  @JsonProperty(JSON_PROPERTY_ADD_ON_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddOnScore(@jakarta.annotation.Nullable Integer addOnScore) {
    this.addOnScore = addOnScore;
  }

  public PropertyAggregateLightweightAuthenticatedEntity loyaltyScore(@jakarta.annotation.Nullable Integer loyaltyScore) {
    
    this.loyaltyScore = loyaltyScore;
    return this;
  }

  /**
   * A property&#39;s loyalty score is based on calculating how many available rate plans honor loyalty points. There is no max score; it&#39;s there to compare it against other properties.
   * @return loyaltyScore
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LOYALTY_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getLoyaltyScore() {
    return loyaltyScore;
  }


  @JsonProperty(JSON_PROPERTY_LOYALTY_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLoyaltyScore(@jakarta.annotation.Nullable Integer loyaltyScore) {
    this.loyaltyScore = loyaltyScore;
  }

  public PropertyAggregateLightweightAuthenticatedEntity popularScore(@jakarta.annotation.Nullable Integer popularScore) {
    
    this.popularScore = popularScore;
    return this;
  }

  /**
   * A property&#39;s popular score is based on calculating number of bookings across room types. There is no max score; it&#39;s there to compare it against other properties.
   * @return popularScore
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_POPULAR_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPopularScore() {
    return popularScore;
  }


  @JsonProperty(JSON_PROPERTY_POPULAR_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPopularScore(@jakarta.annotation.Nullable Integer popularScore) {
    this.popularScore = popularScore;
  }

  public PropertyAggregateLightweightAuthenticatedEntity experienceScore(@jakarta.annotation.Nullable Integer experienceScore) {
    
    this.experienceScore = experienceScore;
    return this;
  }

  /**
   * A property&#39;s experience score is based on how calculating how many types of experiences are available and at what price ranges. There is no max score; it&#39;s there to compare it against other properties.
   * @return experienceScore
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_EXPERIENCE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getExperienceScore() {
    return experienceScore;
  }


  @JsonProperty(JSON_PROPERTY_EXPERIENCE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExperienceScore(@jakarta.annotation.Nullable Integer experienceScore) {
    this.experienceScore = experienceScore;
  }

  public PropertyAggregateLightweightAuthenticatedEntity hotelAmenityCodes(@jakarta.annotation.Nullable List<String> hotelAmenityCodes) {
    
    this.hotelAmenityCodes = hotelAmenityCodes;
    return this;
  }

  public PropertyAggregateLightweightAuthenticatedEntity addHotelAmenityCodesItem(String hotelAmenityCodesItem) {
    if (this.hotelAmenityCodes == null) {
      this.hotelAmenityCodes = new ArrayList<>();
    }
    this.hotelAmenityCodes.add(hotelAmenityCodesItem);
    return this;
  }

  /**
   * Supported OTA specification &#x60;HAC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return hotelAmenityCodes
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HOTEL_AMENITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getHotelAmenityCodes() {
    return hotelAmenityCodes;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_AMENITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelAmenityCodes(@jakarta.annotation.Nullable List<String> hotelAmenityCodes) {
    this.hotelAmenityCodes = hotelAmenityCodes;
  }

  public PropertyAggregateLightweightAuthenticatedEntity propertyAccessibilityCodes(@jakarta.annotation.Nullable List<String> propertyAccessibilityCodes) {
    
    this.propertyAccessibilityCodes = propertyAccessibilityCodes;
    return this;
  }

  public PropertyAggregateLightweightAuthenticatedEntity addPropertyAccessibilityCodesItem(String propertyAccessibilityCodesItem) {
    if (this.propertyAccessibilityCodes == null) {
      this.propertyAccessibilityCodes = new ArrayList<>();
    }
    this.propertyAccessibilityCodes.add(propertyAccessibilityCodesItem);
    return this;
  }

  /**
   * Supported OTA specification &#x60;PHY&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return propertyAccessibilityCodes
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROPERTY_ACCESSIBILITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPropertyAccessibilityCodes() {
    return propertyAccessibilityCodes;
  }


  @JsonProperty(JSON_PROPERTY_PROPERTY_ACCESSIBILITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPropertyAccessibilityCodes(@jakarta.annotation.Nullable List<String> propertyAccessibilityCodes) {
    this.propertyAccessibilityCodes = propertyAccessibilityCodes;
  }

  public PropertyAggregateLightweightAuthenticatedEntity propertySecurityCodes(@jakarta.annotation.Nullable List<String> propertySecurityCodes) {
    
    this.propertySecurityCodes = propertySecurityCodes;
    return this;
  }

  public PropertyAggregateLightweightAuthenticatedEntity addPropertySecurityCodesItem(String propertySecurityCodesItem) {
    if (this.propertySecurityCodes == null) {
      this.propertySecurityCodes = new ArrayList<>();
    }
    this.propertySecurityCodes.add(propertySecurityCodesItem);
    return this;
  }

  /**
   * Supported OTA specification &#x60;SEC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return propertySecurityCodes
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROPERTY_SECURITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPropertySecurityCodes() {
    return propertySecurityCodes;
  }


  @JsonProperty(JSON_PROPERTY_PROPERTY_SECURITY_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPropertySecurityCodes(@jakarta.annotation.Nullable List<String> propertySecurityCodes) {
    this.propertySecurityCodes = propertySecurityCodes;
  }

  public PropertyAggregateLightweightAuthenticatedEntity numberOfRooms(@jakarta.annotation.Nullable Integer numberOfRooms) {
    
    this.numberOfRooms = numberOfRooms;
    return this;
  }

  /**
   * Number of rooms / keys for this property.
   * @return numberOfRooms
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NUMBER_OF_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getNumberOfRooms() {
    return numberOfRooms;
  }


  @JsonProperty(JSON_PROPERTY_NUMBER_OF_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumberOfRooms(@jakarta.annotation.Nullable Integer numberOfRooms) {
    this.numberOfRooms = numberOfRooms;
  }

  public PropertyAggregateLightweightAuthenticatedEntity address(@jakarta.annotation.Nullable SimpleAddressAuthenticatedEntity address) {
    
    this.address = address;
    return this;
  }

  /**
   * Property address.
   * @return address
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SimpleAddressAuthenticatedEntity getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddress(@jakarta.annotation.Nullable SimpleAddressAuthenticatedEntity address) {
    this.address = address;
  }

  public PropertyAggregateLightweightAuthenticatedEntity active(@jakarta.annotation.Nullable Boolean active) {
    
    this.active = active;
    return this;
  }

  /**
   * Whether property is active
   * @return active
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getActive() {
    return active;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActive(@jakarta.annotation.Nullable Boolean active) {
    this.active = active;
  }

  public PropertyAggregateLightweightAuthenticatedEntity urlParameters(@jakarta.annotation.Nullable String urlParameters) {
    
    this.urlParameters = urlParameters;
    return this;
  }

  /**
   * Convenience data point that creates url friendly query parameters of property.
   * @return urlParameters
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_URL_PARAMETERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUrlParameters() {
    return urlParameters;
  }


  @JsonProperty(JSON_PROPERTY_URL_PARAMETERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUrlParameters(@jakarta.annotation.Nullable String urlParameters) {
    this.urlParameters = urlParameters;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PropertyAggregateLightweightAuthenticatedEntity propertyAggregateLightweightAuthenticatedEntity = (PropertyAggregateLightweightAuthenticatedEntity) o;
    return Objects.equals(this.hotelIdentifier, propertyAggregateLightweightAuthenticatedEntity.hotelIdentifier) &&
        Objects.equals(this.name, propertyAggregateLightweightAuthenticatedEntity.name) &&
        Objects.equals(this.localName, propertyAggregateLightweightAuthenticatedEntity.localName) &&
        Objects.equals(this.chain, propertyAggregateLightweightAuthenticatedEntity.chain) &&
        Objects.equals(this.brand, propertyAggregateLightweightAuthenticatedEntity.brand) &&
        Objects.equals(this.urlName, propertyAggregateLightweightAuthenticatedEntity.urlName) &&
        Objects.equals(this.starRating, propertyAggregateLightweightAuthenticatedEntity.starRating) &&
        Objects.equals(this.bookings, propertyAggregateLightweightAuthenticatedEntity.bookings) &&
        Objects.equals(this.aggregateReviewRating, propertyAggregateLightweightAuthenticatedEntity.aggregateReviewRating) &&
        Objects.equals(this.location, propertyAggregateLightweightAuthenticatedEntity.location) &&
        Objects.equals(this.descriptions, propertyAggregateLightweightAuthenticatedEntity.descriptions) &&
        Objects.equals(this.aggregateGreendexRating, propertyAggregateLightweightAuthenticatedEntity.aggregateGreendexRating) &&
        Objects.equals(this.lifestyleTypes, propertyAggregateLightweightAuthenticatedEntity.lifestyleTypes) &&
        Objects.equals(this.totalReviews, propertyAggregateLightweightAuthenticatedEntity.totalReviews) &&
        Objects.equals(this.reservations, propertyAggregateLightweightAuthenticatedEntity.reservations) &&
        Objects.equals(this.socials, propertyAggregateLightweightAuthenticatedEntity.socials) &&
        Objects.equals(this.images, propertyAggregateLightweightAuthenticatedEntity.images) &&
        Objects.equals(this.videos, propertyAggregateLightweightAuthenticatedEntity.videos) &&
        Objects.equals(this.policy, propertyAggregateLightweightAuthenticatedEntity.policy) &&
        Objects.equals(this.thirdPartyReviews, propertyAggregateLightweightAuthenticatedEntity.thirdPartyReviews) &&
        Objects.equals(this.attractions, propertyAggregateLightweightAuthenticatedEntity.attractions) &&
        Objects.equals(this.activities, propertyAggregateLightweightAuthenticatedEntity.activities) &&
        Objects.equals(this.places, propertyAggregateLightweightAuthenticatedEntity.places) &&
        Objects.equals(this.restaurants, propertyAggregateLightweightAuthenticatedEntity.restaurants) &&
        Objects.equals(this.meetingRooms, propertyAggregateLightweightAuthenticatedEntity.meetingRooms) &&
        Objects.equals(this.spas, propertyAggregateLightweightAuthenticatedEntity.spas) &&
        Objects.equals(this.addOns, propertyAggregateLightweightAuthenticatedEntity.addOns) &&
        Objects.equals(this.generalManager, propertyAggregateLightweightAuthenticatedEntity.generalManager) &&
        Objects.equals(this.locationCategory, propertyAggregateLightweightAuthenticatedEntity.locationCategory) &&
        Objects.equals(this.segmentCategory, propertyAggregateLightweightAuthenticatedEntity.segmentCategory) &&
        Objects.equals(this.hotelCategory, propertyAggregateLightweightAuthenticatedEntity.hotelCategory) &&
        Objects.equals(this.architecturalStyle, propertyAggregateLightweightAuthenticatedEntity.architecturalStyle) &&
        Objects.equals(this.whenBuilt, propertyAggregateLightweightAuthenticatedEntity.whenBuilt) &&
        Objects.equals(this.currencyCode, propertyAggregateLightweightAuthenticatedEntity.currencyCode) &&
        Objects.equals(this.membershipRateDiscount, propertyAggregateLightweightAuthenticatedEntity.membershipRateDiscount) &&
        Objects.equals(this.priceScore, propertyAggregateLightweightAuthenticatedEntity.priceScore) &&
        Objects.equals(this.perkScore, propertyAggregateLightweightAuthenticatedEntity.perkScore) &&
        Objects.equals(this.addOnScore, propertyAggregateLightweightAuthenticatedEntity.addOnScore) &&
        Objects.equals(this.loyaltyScore, propertyAggregateLightweightAuthenticatedEntity.loyaltyScore) &&
        Objects.equals(this.popularScore, propertyAggregateLightweightAuthenticatedEntity.popularScore) &&
        Objects.equals(this.experienceScore, propertyAggregateLightweightAuthenticatedEntity.experienceScore) &&
        Objects.equals(this.hotelAmenityCodes, propertyAggregateLightweightAuthenticatedEntity.hotelAmenityCodes) &&
        Objects.equals(this.propertyAccessibilityCodes, propertyAggregateLightweightAuthenticatedEntity.propertyAccessibilityCodes) &&
        Objects.equals(this.propertySecurityCodes, propertyAggregateLightweightAuthenticatedEntity.propertySecurityCodes) &&
        Objects.equals(this.numberOfRooms, propertyAggregateLightweightAuthenticatedEntity.numberOfRooms) &&
        Objects.equals(this.address, propertyAggregateLightweightAuthenticatedEntity.address) &&
        Objects.equals(this.active, propertyAggregateLightweightAuthenticatedEntity.active) &&
        Objects.equals(this.urlParameters, propertyAggregateLightweightAuthenticatedEntity.urlParameters);
  }

  @Override
  public int hashCode() {
    return Objects.hash(hotelIdentifier, name, localName, chain, brand, urlName, starRating, bookings, aggregateReviewRating, location, descriptions, aggregateGreendexRating, lifestyleTypes, totalReviews, reservations, socials, images, videos, policy, thirdPartyReviews, attractions, activities, places, restaurants, meetingRooms, spas, addOns, generalManager, locationCategory, segmentCategory, hotelCategory, architecturalStyle, whenBuilt, currencyCode, membershipRateDiscount, priceScore, perkScore, addOnScore, loyaltyScore, popularScore, experienceScore, hotelAmenityCodes, propertyAccessibilityCodes, propertySecurityCodes, numberOfRooms, address, active, urlParameters);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PropertyAggregateLightweightAuthenticatedEntity {\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    localName: ").append(toIndentedString(localName)).append("\n");
    sb.append("    chain: ").append(toIndentedString(chain)).append("\n");
    sb.append("    brand: ").append(toIndentedString(brand)).append("\n");
    sb.append("    urlName: ").append(toIndentedString(urlName)).append("\n");
    sb.append("    starRating: ").append(toIndentedString(starRating)).append("\n");
    sb.append("    bookings: ").append(toIndentedString(bookings)).append("\n");
    sb.append("    aggregateReviewRating: ").append(toIndentedString(aggregateReviewRating)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    descriptions: ").append(toIndentedString(descriptions)).append("\n");
    sb.append("    aggregateGreendexRating: ").append(toIndentedString(aggregateGreendexRating)).append("\n");
    sb.append("    lifestyleTypes: ").append(toIndentedString(lifestyleTypes)).append("\n");
    sb.append("    totalReviews: ").append(toIndentedString(totalReviews)).append("\n");
    sb.append("    reservations: ").append(toIndentedString(reservations)).append("\n");
    sb.append("    socials: ").append(toIndentedString(socials)).append("\n");
    sb.append("    images: ").append(toIndentedString(images)).append("\n");
    sb.append("    videos: ").append(toIndentedString(videos)).append("\n");
    sb.append("    policy: ").append(toIndentedString(policy)).append("\n");
    sb.append("    thirdPartyReviews: ").append(toIndentedString(thirdPartyReviews)).append("\n");
    sb.append("    attractions: ").append(toIndentedString(attractions)).append("\n");
    sb.append("    activities: ").append(toIndentedString(activities)).append("\n");
    sb.append("    places: ").append(toIndentedString(places)).append("\n");
    sb.append("    restaurants: ").append(toIndentedString(restaurants)).append("\n");
    sb.append("    meetingRooms: ").append(toIndentedString(meetingRooms)).append("\n");
    sb.append("    spas: ").append(toIndentedString(spas)).append("\n");
    sb.append("    addOns: ").append(toIndentedString(addOns)).append("\n");
    sb.append("    generalManager: ").append(toIndentedString(generalManager)).append("\n");
    sb.append("    locationCategory: ").append(toIndentedString(locationCategory)).append("\n");
    sb.append("    segmentCategory: ").append(toIndentedString(segmentCategory)).append("\n");
    sb.append("    hotelCategory: ").append(toIndentedString(hotelCategory)).append("\n");
    sb.append("    architecturalStyle: ").append(toIndentedString(architecturalStyle)).append("\n");
    sb.append("    whenBuilt: ").append(toIndentedString(whenBuilt)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("    membershipRateDiscount: ").append(toIndentedString(membershipRateDiscount)).append("\n");
    sb.append("    priceScore: ").append(toIndentedString(priceScore)).append("\n");
    sb.append("    perkScore: ").append(toIndentedString(perkScore)).append("\n");
    sb.append("    addOnScore: ").append(toIndentedString(addOnScore)).append("\n");
    sb.append("    loyaltyScore: ").append(toIndentedString(loyaltyScore)).append("\n");
    sb.append("    popularScore: ").append(toIndentedString(popularScore)).append("\n");
    sb.append("    experienceScore: ").append(toIndentedString(experienceScore)).append("\n");
    sb.append("    hotelAmenityCodes: ").append(toIndentedString(hotelAmenityCodes)).append("\n");
    sb.append("    propertyAccessibilityCodes: ").append(toIndentedString(propertyAccessibilityCodes)).append("\n");
    sb.append("    propertySecurityCodes: ").append(toIndentedString(propertySecurityCodes)).append("\n");
    sb.append("    numberOfRooms: ").append(toIndentedString(numberOfRooms)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    urlParameters: ").append(toIndentedString(urlParameters)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

