/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/customization-client): A single endpoint to retrieve whitelabel + customization information for the booking customization.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Booking Engine API Welcome to the Booking Engine API - A programmer-friendly way to book inventory that was found on our platform. This API lets you:  1. Shopping Cart: Manage shopping cart. 2. Checkout: Move shopping cart items through the reactive workflow. 3. Booking: Move selected inventory through to booking completion. 4. Review: Leave a review after a completed stay.  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.17.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.booking.model.BedroomConfigurationBooker;
import travel.wink.sdk.booking.model.CancellationPolicyLightweightBooker;
import travel.wink.sdk.booking.model.CustomMonetaryAmount;
import travel.wink.sdk.booking.model.ExtraChargesBooker;
import travel.wink.sdk.booking.model.GuestRoomLightweightBooker;
import travel.wink.sdk.booking.model.PerkLightweightBooker;
import travel.wink.sdk.booking.model.PropertyPolicyBooker;
import travel.wink.sdk.booking.model.RoomConfigurationPriceRatePlanBooker;
import travel.wink.sdk.booking.model.StayRateBooker;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * RoomStayBooker
 */
@JsonPropertyOrder({
  RoomStayBooker.JSON_PROPERTY_POLICY,
  RoomStayBooker.JSON_PROPERTY_ROOM,
  RoomStayBooker.JSON_PROPERTY_ROOMS,
  RoomStayBooker.JSON_PROPERTY_BEDROOM_CONFIGURATION,
  RoomStayBooker.JSON_PROPERTY_ADULTS,
  RoomStayBooker.JSON_PROPERTY_CHILDREN,
  RoomStayBooker.JSON_PROPERTY_START_DATE,
  RoomStayBooker.JSON_PROPERTY_END_DATE,
  RoomStayBooker.JSON_PROPERTY_PRICE,
  RoomStayBooker.JSON_PROPERTY_ROOM_RATE_IDENTIFIER,
  RoomStayBooker.JSON_PROPERTY_ROOM_RATE_INTERNAL_NAME,
  RoomStayBooker.JSON_PROPERTY_RATE_PLAN,
  RoomStayBooker.JSON_PROPERTY_PERK_TYPES,
  RoomStayBooker.JSON_PROPERTY_EXTRA_CHARGES,
  RoomStayBooker.JSON_PROPERTY_ACTIVE_CANCELLATION_POLICY,
  RoomStayBooker.JSON_PROPERTY_CANCELLABLE,
  RoomStayBooker.JSON_PROPERTY_CANCELLABLE_BY_HOTEL,
  RoomStayBooker.JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGE,
  RoomStayBooker.JSON_PROPERTY_ROOM_NIGHTS,
  RoomStayBooker.JSON_PROPERTY_GUESTS,
  RoomStayBooker.JSON_PROPERTY_RATE_SOURCE,
  RoomStayBooker.JSON_PROPERTY_SOURCE_TOTAL,
  RoomStayBooker.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL,
  RoomStayBooker.JSON_PROPERTY_INTERNAL_TOTAL
})
@JsonTypeName("RoomStay_Booker")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:16:53.154776164+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class RoomStayBooker {
  public static final String JSON_PROPERTY_POLICY = "policy";
  @jakarta.annotation.Nonnull
  private PropertyPolicyBooker policy;

  public static final String JSON_PROPERTY_ROOM = "room";
  @jakarta.annotation.Nonnull
  private GuestRoomLightweightBooker room;

  public static final String JSON_PROPERTY_ROOMS = "rooms";
  @jakarta.annotation.Nonnull
  private Integer rooms = 1;

  public static final String JSON_PROPERTY_BEDROOM_CONFIGURATION = "bedroomConfiguration";
  @jakarta.annotation.Nonnull
  private BedroomConfigurationBooker bedroomConfiguration;

  public static final String JSON_PROPERTY_ADULTS = "adults";
  @jakarta.annotation.Nonnull
  private Integer adults = 2;

  public static final String JSON_PROPERTY_CHILDREN = "children";
  @jakarta.annotation.Nonnull
  private Integer children = 0;

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  @jakarta.annotation.Nonnull
  private LocalDate startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  @jakarta.annotation.Nonnull
  private LocalDate endDate;

  public static final String JSON_PROPERTY_PRICE = "price";
  @jakarta.annotation.Nonnull
  private StayRateBooker price;

  public static final String JSON_PROPERTY_ROOM_RATE_IDENTIFIER = "roomRateIdentifier";
  @jakarta.annotation.Nonnull
  private UUID roomRateIdentifier;

  public static final String JSON_PROPERTY_ROOM_RATE_INTERNAL_NAME = "roomRateInternalName";
  @jakarta.annotation.Nonnull
  private String roomRateInternalName;

  public static final String JSON_PROPERTY_RATE_PLAN = "ratePlan";
  @jakarta.annotation.Nonnull
  private RoomConfigurationPriceRatePlanBooker ratePlan;

  public static final String JSON_PROPERTY_PERK_TYPES = "perkTypes";
  @jakarta.annotation.Nullable
  private List<@Valid PerkLightweightBooker> perkTypes = new ArrayList<>();

  public static final String JSON_PROPERTY_EXTRA_CHARGES = "extraCharges";
  @jakarta.annotation.Nonnull
  private ExtraChargesBooker extraCharges;

  public static final String JSON_PROPERTY_ACTIVE_CANCELLATION_POLICY = "activeCancellationPolicy";
  @jakarta.annotation.Nonnull
  private CancellationPolicyLightweightBooker activeCancellationPolicy;

  public static final String JSON_PROPERTY_CANCELLABLE = "cancellable";
  @jakarta.annotation.Nullable
  private Boolean cancellable;

  public static final String JSON_PROPERTY_CANCELLABLE_BY_HOTEL = "cancellableByHotel";
  @jakarta.annotation.Nullable
  private Boolean cancellableByHotel;

  public static final String JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGE = "cancellableWithPotentialCharge";
  @jakarta.annotation.Nullable
  private Boolean cancellableWithPotentialCharge;

  public static final String JSON_PROPERTY_ROOM_NIGHTS = "roomNights";
  @jakarta.annotation.Nullable
  private Long roomNights;

  public static final String JSON_PROPERTY_GUESTS = "guests";
  @jakarta.annotation.Nullable
  private Integer guests;

  public static final String JSON_PROPERTY_RATE_SOURCE = "rateSource";
  @jakarta.annotation.Nullable
  private String rateSource;

  public static final String JSON_PROPERTY_SOURCE_TOTAL = "sourceTotal";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount sourceTotal;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL = "userSpecifiedCurrencyTotal";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount userSpecifiedCurrencyTotal;

  public static final String JSON_PROPERTY_INTERNAL_TOTAL = "internalTotal";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount internalTotal;

  public RoomStayBooker() {
  }

  public RoomStayBooker policy(@jakarta.annotation.Nonnull PropertyPolicyBooker policy) {
    
    this.policy = policy;
    return this;
  }

  /**
   * Property policy information.
   * @return policy
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PropertyPolicyBooker getPolicy() {
    return policy;
  }


  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPolicy(@jakarta.annotation.Nonnull PropertyPolicyBooker policy) {
    this.policy = policy;
  }

  public RoomStayBooker room(@jakarta.annotation.Nonnull GuestRoomLightweightBooker room) {
    
    this.room = room;
    return this;
  }

  /**
   * Guest room details.
   * @return room
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ROOM)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public GuestRoomLightweightBooker getRoom() {
    return room;
  }


  @JsonProperty(JSON_PROPERTY_ROOM)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoom(@jakarta.annotation.Nonnull GuestRoomLightweightBooker room) {
    this.room = room;
  }

  public RoomStayBooker rooms(@jakarta.annotation.Nonnull Integer rooms) {
    
    this.rooms = rooms;
    return this;
  }

  /**
   * Number of rooms. Always 1 since we switched to creating one booking per room.
   * @return rooms
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ROOMS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getRooms() {
    return rooms;
  }


  @JsonProperty(JSON_PROPERTY_ROOMS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRooms(@jakarta.annotation.Nonnull Integer rooms) {
    this.rooms = rooms;
  }

  public RoomStayBooker bedroomConfiguration(@jakarta.annotation.Nonnull BedroomConfigurationBooker bedroomConfiguration) {
    
    this.bedroomConfiguration = bedroomConfiguration;
    return this;
  }

  /**
   * Desired bedroom layout
   * @return bedroomConfiguration
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_BEDROOM_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BedroomConfigurationBooker getBedroomConfiguration() {
    return bedroomConfiguration;
  }


  @JsonProperty(JSON_PROPERTY_BEDROOM_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBedroomConfiguration(@jakarta.annotation.Nonnull BedroomConfigurationBooker bedroomConfiguration) {
    this.bedroomConfiguration = bedroomConfiguration;
  }

  public RoomStayBooker adults(@jakarta.annotation.Nonnull Integer adults) {
    
    this.adults = adults;
    return this;
  }

  /**
   * The actual amount of adults as determined by the hotel&#39;s policy.
   * @return adults
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ADULTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getAdults() {
    return adults;
  }


  @JsonProperty(JSON_PROPERTY_ADULTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAdults(@jakarta.annotation.Nonnull Integer adults) {
    this.adults = adults;
  }

  public RoomStayBooker children(@jakarta.annotation.Nonnull Integer children) {
    
    this.children = children;
    return this;
  }

  /**
   * The actual amount of children as determined by the hotel&#39;s policy.
   * @return children
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getChildren() {
    return children;
  }


  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setChildren(@jakarta.annotation.Nonnull Integer children) {
    this.children = children;
  }

  public RoomStayBooker startDate(@jakarta.annotation.Nonnull LocalDate startDate) {
    
    this.startDate = startDate;
    return this;
  }

  /**
   * Stay start date
   * @return startDate
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStartDate(@jakarta.annotation.Nonnull LocalDate startDate) {
    this.startDate = startDate;
  }

  public RoomStayBooker endDate(@jakarta.annotation.Nonnull LocalDate endDate) {
    
    this.endDate = endDate;
    return this;
  }

  /**
   * Stay end date
   * @return endDate
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEndDate(@jakarta.annotation.Nonnull LocalDate endDate) {
    this.endDate = endDate;
  }

  public RoomStayBooker price(@jakarta.annotation.Nonnull StayRateBooker price) {
    
    this.price = price;
    return this;
  }

  /**
   * Price details
   * @return price
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public StayRateBooker getPrice() {
    return price;
  }


  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPrice(@jakarta.annotation.Nonnull StayRateBooker price) {
    this.price = price;
  }

  public RoomStayBooker roomRateIdentifier(@jakarta.annotation.Nonnull UUID roomRateIdentifier) {
    
    this.roomRateIdentifier = roomRateIdentifier;
    return this;
  }

  /**
   * Master rate identifier
   * @return roomRateIdentifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_ROOM_RATE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getRoomRateIdentifier() {
    return roomRateIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_RATE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomRateIdentifier(@jakarta.annotation.Nonnull UUID roomRateIdentifier) {
    this.roomRateIdentifier = roomRateIdentifier;
  }

  public RoomStayBooker roomRateInternalName(@jakarta.annotation.Nonnull String roomRateInternalName) {
    
    this.roomRateInternalName = roomRateInternalName;
    return this;
  }

  /**
   * Master rate internal name
   * @return roomRateInternalName
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_ROOM_RATE_INTERNAL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRoomRateInternalName() {
    return roomRateInternalName;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_RATE_INTERNAL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomRateInternalName(@jakarta.annotation.Nonnull String roomRateInternalName) {
    this.roomRateInternalName = roomRateInternalName;
  }

  public RoomStayBooker ratePlan(@jakarta.annotation.Nonnull RoomConfigurationPriceRatePlanBooker ratePlan) {
    
    this.ratePlan = ratePlan;
    return this;
  }

  /**
   * Rate plan used for this stay
   * @return ratePlan
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_RATE_PLAN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public RoomConfigurationPriceRatePlanBooker getRatePlan() {
    return ratePlan;
  }


  @JsonProperty(JSON_PROPERTY_RATE_PLAN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRatePlan(@jakarta.annotation.Nonnull RoomConfigurationPriceRatePlanBooker ratePlan) {
    this.ratePlan = ratePlan;
  }

  public RoomStayBooker perkTypes(@jakarta.annotation.Nullable List<@Valid PerkLightweightBooker> perkTypes) {
    
    this.perkTypes = perkTypes;
    return this;
  }

  public RoomStayBooker addPerkTypesItem(PerkLightweightBooker perkTypesItem) {
    if (this.perkTypes == null) {
      this.perkTypes = new ArrayList<>();
    }
    this.perkTypes.add(perkTypesItem);
    return this;
  }

  /**
   * List of perks that came with the master rate
   * @return perkTypes
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PERK_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<@Valid PerkLightweightBooker> getPerkTypes() {
    return perkTypes;
  }


  @JsonProperty(JSON_PROPERTY_PERK_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPerkTypes(@jakarta.annotation.Nullable List<@Valid PerkLightweightBooker> perkTypes) {
    this.perkTypes = perkTypes;
  }

  public RoomStayBooker extraCharges(@jakarta.annotation.Nonnull ExtraChargesBooker extraCharges) {
    
    this.extraCharges = extraCharges;
    return this;
  }

  /**
   * Rate plan-level extra charges
   * @return extraCharges
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_EXTRA_CHARGES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ExtraChargesBooker getExtraCharges() {
    return extraCharges;
  }


  @JsonProperty(JSON_PROPERTY_EXTRA_CHARGES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setExtraCharges(@jakarta.annotation.Nonnull ExtraChargesBooker extraCharges) {
    this.extraCharges = extraCharges;
  }

  public RoomStayBooker activeCancellationPolicy(@jakarta.annotation.Nonnull CancellationPolicyLightweightBooker activeCancellationPolicy) {
    
    this.activeCancellationPolicy = activeCancellationPolicy;
    return this;
  }

  /**
   * Based on the itinerary, the cancellation policy could be taken directly from the rate plan or it could be a policy exception also listed on the rate plan
   * @return activeCancellationPolicy
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ACTIVE_CANCELLATION_POLICY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CancellationPolicyLightweightBooker getActiveCancellationPolicy() {
    return activeCancellationPolicy;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVE_CANCELLATION_POLICY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setActiveCancellationPolicy(@jakarta.annotation.Nonnull CancellationPolicyLightweightBooker activeCancellationPolicy) {
    this.activeCancellationPolicy = activeCancellationPolicy;
  }

  public RoomStayBooker cancellable(@jakarta.annotation.Nullable Boolean cancellable) {
    
    this.cancellable = cancellable;
    return this;
  }

  /**
   * Get cancellable
   * @return cancellable
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellable() {
    return cancellable;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellable(@jakarta.annotation.Nullable Boolean cancellable) {
    this.cancellable = cancellable;
  }

  public RoomStayBooker cancellableByHotel(@jakarta.annotation.Nullable Boolean cancellableByHotel) {
    
    this.cancellableByHotel = cancellableByHotel;
    return this;
  }

  /**
   * Get cancellableByHotel
   * @return cancellableByHotel
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_HOTEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableByHotel() {
    return cancellableByHotel;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_HOTEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableByHotel(@jakarta.annotation.Nullable Boolean cancellableByHotel) {
    this.cancellableByHotel = cancellableByHotel;
  }

  public RoomStayBooker cancellableWithPotentialCharge(@jakarta.annotation.Nullable Boolean cancellableWithPotentialCharge) {
    
    this.cancellableWithPotentialCharge = cancellableWithPotentialCharge;
    return this;
  }

  /**
   * Get cancellableWithPotentialCharge
   * @return cancellableWithPotentialCharge
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableWithPotentialCharge() {
    return cancellableWithPotentialCharge;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableWithPotentialCharge(@jakarta.annotation.Nullable Boolean cancellableWithPotentialCharge) {
    this.cancellableWithPotentialCharge = cancellableWithPotentialCharge;
  }

  public RoomStayBooker roomNights(@jakarta.annotation.Nullable Long roomNights) {
    
    this.roomNights = roomNights;
    return this;
  }

  /**
   * Total number of nights the guest stays at the hotel. -1 indicates there is an error.
   * @return roomNights
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getRoomNights() {
    return roomNights;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomNights(@jakarta.annotation.Nullable Long roomNights) {
    this.roomNights = roomNights;
  }

  public RoomStayBooker guests(@jakarta.annotation.Nullable Integer guests) {
    
    this.guests = guests;
    return this;
  }

  /**
   * Get guests
   * @return guests
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GUESTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getGuests() {
    return guests;
  }


  @JsonProperty(JSON_PROPERTY_GUESTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGuests(@jakarta.annotation.Nullable Integer guests) {
    this.guests = guests;
  }

  public RoomStayBooker rateSource(@jakarta.annotation.Nullable String rateSource) {
    
    this.rateSource = rateSource;
    return this;
  }

  /**
   * Get rateSource
   * @return rateSource
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RATE_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRateSource() {
    return rateSource;
  }


  @JsonProperty(JSON_PROPERTY_RATE_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRateSource(@jakarta.annotation.Nullable String rateSource) {
    this.rateSource = rateSource;
  }

  public RoomStayBooker sourceTotal(@jakarta.annotation.Nullable CustomMonetaryAmount sourceTotal) {
    
    this.sourceTotal = sourceTotal;
    return this;
  }

  /**
   * Get sourceTotal
   * @return sourceTotal
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getSourceTotal() {
    return sourceTotal;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceTotal(@jakarta.annotation.Nullable CustomMonetaryAmount sourceTotal) {
    this.sourceTotal = sourceTotal;
  }

  public RoomStayBooker userSpecifiedCurrencyTotal(@jakarta.annotation.Nullable CustomMonetaryAmount userSpecifiedCurrencyTotal) {
    
    this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
    return this;
  }

  /**
   * Get userSpecifiedCurrencyTotal
   * @return userSpecifiedCurrencyTotal
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getUserSpecifiedCurrencyTotal() {
    return userSpecifiedCurrencyTotal;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyTotal(@jakarta.annotation.Nullable CustomMonetaryAmount userSpecifiedCurrencyTotal) {
    this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
  }

  public RoomStayBooker internalTotal(@jakarta.annotation.Nullable CustomMonetaryAmount internalTotal) {
    
    this.internalTotal = internalTotal;
    return this;
  }

  /**
   * Get internalTotal
   * @return internalTotal
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getInternalTotal() {
    return internalTotal;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalTotal(@jakarta.annotation.Nullable CustomMonetaryAmount internalTotal) {
    this.internalTotal = internalTotal;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RoomStayBooker roomStayBooker = (RoomStayBooker) o;
    return Objects.equals(this.policy, roomStayBooker.policy) &&
        Objects.equals(this.room, roomStayBooker.room) &&
        Objects.equals(this.rooms, roomStayBooker.rooms) &&
        Objects.equals(this.bedroomConfiguration, roomStayBooker.bedroomConfiguration) &&
        Objects.equals(this.adults, roomStayBooker.adults) &&
        Objects.equals(this.children, roomStayBooker.children) &&
        Objects.equals(this.startDate, roomStayBooker.startDate) &&
        Objects.equals(this.endDate, roomStayBooker.endDate) &&
        Objects.equals(this.price, roomStayBooker.price) &&
        Objects.equals(this.roomRateIdentifier, roomStayBooker.roomRateIdentifier) &&
        Objects.equals(this.roomRateInternalName, roomStayBooker.roomRateInternalName) &&
        Objects.equals(this.ratePlan, roomStayBooker.ratePlan) &&
        Objects.equals(this.perkTypes, roomStayBooker.perkTypes) &&
        Objects.equals(this.extraCharges, roomStayBooker.extraCharges) &&
        Objects.equals(this.activeCancellationPolicy, roomStayBooker.activeCancellationPolicy) &&
        Objects.equals(this.cancellable, roomStayBooker.cancellable) &&
        Objects.equals(this.cancellableByHotel, roomStayBooker.cancellableByHotel) &&
        Objects.equals(this.cancellableWithPotentialCharge, roomStayBooker.cancellableWithPotentialCharge) &&
        Objects.equals(this.roomNights, roomStayBooker.roomNights) &&
        Objects.equals(this.guests, roomStayBooker.guests) &&
        Objects.equals(this.rateSource, roomStayBooker.rateSource) &&
        Objects.equals(this.sourceTotal, roomStayBooker.sourceTotal) &&
        Objects.equals(this.userSpecifiedCurrencyTotal, roomStayBooker.userSpecifiedCurrencyTotal) &&
        Objects.equals(this.internalTotal, roomStayBooker.internalTotal);
  }

  @Override
  public int hashCode() {
    return Objects.hash(policy, room, rooms, bedroomConfiguration, adults, children, startDate, endDate, price, roomRateIdentifier, roomRateInternalName, ratePlan, perkTypes, extraCharges, activeCancellationPolicy, cancellable, cancellableByHotel, cancellableWithPotentialCharge, roomNights, guests, rateSource, sourceTotal, userSpecifiedCurrencyTotal, internalTotal);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RoomStayBooker {\n");
    sb.append("    policy: ").append(toIndentedString(policy)).append("\n");
    sb.append("    room: ").append(toIndentedString(room)).append("\n");
    sb.append("    rooms: ").append(toIndentedString(rooms)).append("\n");
    sb.append("    bedroomConfiguration: ").append(toIndentedString(bedroomConfiguration)).append("\n");
    sb.append("    adults: ").append(toIndentedString(adults)).append("\n");
    sb.append("    children: ").append(toIndentedString(children)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    roomRateIdentifier: ").append(toIndentedString(roomRateIdentifier)).append("\n");
    sb.append("    roomRateInternalName: ").append(toIndentedString(roomRateInternalName)).append("\n");
    sb.append("    ratePlan: ").append(toIndentedString(ratePlan)).append("\n");
    sb.append("    perkTypes: ").append(toIndentedString(perkTypes)).append("\n");
    sb.append("    extraCharges: ").append(toIndentedString(extraCharges)).append("\n");
    sb.append("    activeCancellationPolicy: ").append(toIndentedString(activeCancellationPolicy)).append("\n");
    sb.append("    cancellable: ").append(toIndentedString(cancellable)).append("\n");
    sb.append("    cancellableByHotel: ").append(toIndentedString(cancellableByHotel)).append("\n");
    sb.append("    cancellableWithPotentialCharge: ").append(toIndentedString(cancellableWithPotentialCharge)).append("\n");
    sb.append("    roomNights: ").append(toIndentedString(roomNights)).append("\n");
    sb.append("    guests: ").append(toIndentedString(guests)).append("\n");
    sb.append("    rateSource: ").append(toIndentedString(rateSource)).append("\n");
    sb.append("    sourceTotal: ").append(toIndentedString(sourceTotal)).append("\n");
    sb.append("    userSpecifiedCurrencyTotal: ").append(toIndentedString(userSpecifiedCurrencyTotal)).append("\n");
    sb.append("    internalTotal: ").append(toIndentedString(internalTotal)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

